/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.create=exports.SqlServerPool=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_x3_sql_1=require("@sage/xtrem-x3-sql"),mssql=require("mssql"),reader_1=require("./reader"),defaultCollation="Latin1_General_BIN";function fillParameters(e,t){if(!t||0===t.length)return;function processParam(t,r,a){const s=e.parameters[t];if(s)s.value=a;else e.input(t,r,a)}for(let e=0;t&&e<t.length;e+=1)if(t[e]instanceof Buffer)processParam(`p${e}`,{type:mssql.TYPES.Binary},t[e]);else if(t[e]&&t[e].value instanceof Buffer)processParam(`p${e}`,{type:mssql.TYPES.VarBinary},t[e].value);else if(t[e]instanceof Date)processParam(`p${e}`,{type:mssql.TYPES.DateTime},t[e]);else if("number"==typeof t[e])if((0|t[e])===t[e])processParam(`p${e}`,{type:mssql.TYPES.Int},t[e]);else processParam(`p${e}`,{type:mssql.TYPES.Float},t[e]);else processParam(`p${e}`,{type:mssql.TYPES.NVarChar},t[e])}function tdsParam(e){return`@p${e}`}async function tdsQuery(e,t,r,a,s){const n=r?` with ${JSON.stringify(r)}`:"",i=s?.verbose(()=>`[${e}] tds_query: ${t} ${n}`),o=a.transaction?new mssql.Request(a.transaction):new mssql.Request(a.pool);fillParameters(o,r);let l=false;o.on("error",e=>{if(o.removeAllListeners(),i)i?.fail(e.message);l=true});const c=await o.query(t);if(i&&!l)i?.success(`Row count = ${JSON.stringify(c.output)}`);return a.transaction?c.output:c.recordset}function getDecimalFormat(e,t,r){let a,s;if(r=r||{},isNaN(e)||isNaN(t))a=7,s=3;else{if(a=Math.min(e,28),s=t,r.useFloatingPointFormat){if(s>0)a=Math.min(14,a+s);s=Math.min(a-1,28-s)}else a+=Math.max(Math.min(s,28-a-s),0),s+=1;if(a+s>28)s=28-a}return{precision:a+s,scale:s}}const mssqlInstanceRegex=/^(?:([A-Za-z0-9.\-/]+)(?:[,:](\d+))?)(?:(?:\\{1,2}([a-zA-Z_#&][A-Za-z0-9_#&+$-]*))(?:[,:](\d+))?)?$/,validIpAddressRegex=/^(?:(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/,validHostnameRegex=/^[a-zA-Z](([a-zA-Z0-9])|(-)[^-.]|\.[^-.])*[a-zA-Z0-9]$/;function parseHostname(e,t){const r=mssqlInstanceRegex.exec(e);if(!r)throw new Error(`invalid instance ${e}`);const a=r[1],s=parseInt(r[2],10),n=r[3],i=parseInt(r[4],10);if(!validIpAddressRegex.test(a)&&!validHostnameRegex.test(a))throw new Error(`invalid server ${a}`);return{server:a,instanceName:n,port:s||i||t||1433}}function getConfig(e,t){if(e){const r=Math.max(e.poolSize||20,20),a=parseHostname(e.hostname,e.port),s={server:a.server,authentication:{type:"default",options:{userName:e.user||"X3",password:e.password}},pool:{max:r,log:e=>t?.debug(()=>e)},port:a.port,database:e.database,options:{instanceName:a.instanceName,isolationLevel:mssql.ISOLATION_LEVEL.READ_COMMITTED,packetSize:2048,encrypt:!!e.encrypt,trustServerCertificate:!!e.trustServerCertificate,appName:"xtrem-x3",useUTC:true,connectionRetryInterval:e.connectionRetryMillis||15e3,requestTimeout:e.requestTimeout||15e3,cancelTimeout:15e3}};if(/[,:]/.test(s.server))delete s.port;return s}throw new Error("Missing SQL config")}class SqlServerPool extends xtrem_x3_sql_1.Pool{constructor(e,t){super(e,t),this.dialect="mssql",this.nullDate=xtrem_date_time_1.DateValue.make(1753,1,1),this.cfg=getConfig(e,t),this.collation=e.collation||defaultCollation,this.usePool=false}uniqid(e){return`select NEXT VALUE FOR SEQ_${e} As A$RESULT_0`}lockClause0(){return" with (UPDLOCK) "}lockClause1(){return""}hintClause0(e,t){return""}hintClause1(e,t){if(e){if(e.nohint||""===e.name)return"";return" Option (FAST 1)"}if(t)return" Option (FAST 1)";return""}firstClause0(e){return`top ${e}`}firstClause1(e){return""}lengthString(){return"len"}modString(e,t){return`(${e} % ${t})`}subString(e,t,r){return`substring(${e}, ${t}, ${r})`}dateToChar(e,t){return`CONVERT(VARCHAR,${e},${t||"23"})`}charToDate(e,t){return`CONVERT(${t?"DATETIME":"DATE"},${e},${t?127:20})`}toChar(e){return`CONVERT(VARCHAR(max),${e})`}charConcatenator(){return"+"}regexOrLike(e,t,r,a){const s=a.indexOf("i")>=0?"COLLATE Latin1_General_CI_AS":"COLLATE Latin1_General_CS_AS";return`${this.toChar(e)} ${s} LIKE ${this.quote(this.regexToSql(r))} escape '$'`}limitClause(e){return`TOP ${e}`}fetchOnlyClause(e){return""}driverFunctions(e,t){switch(t){case"day":return`FORMAT(${e}, 'yyyy-MM-dd')`;case"month":return`FORMAT(${e}, 'yyyy-MM')`;case"year":return`FORMAT(${e}, 'yyyy')`;default:throw new Error("Unexpected parameter passed")}}emptyBlob(){return"0x"}emptyClob(){return"''"}escape(e){return`"${e}"`}param(e){return tdsParam(e)}rowIdGet(e){return e}rowIdPut(e){return e}async executeWithTransaction(e,t){const r=await this.connectionPool.transaction().begin(),{args:a}=t,s=this.logger?.verbose(()=>`[${this.user}] Execute in transaction ${e}, args=${a?JSON.stringify(a):""}`);try{const n=await tdsQuery(this.user,e,a,{pool:this.connectionPool,transaction:r},this.logger);if(t.rollback)await r.rollback();else await r.commit();return s?.success(),n}catch(t){throw s?.fail(`Failed: ${t.message} on ${e}`),t}}checkConnection(e){return this.connectionPool}async createConnection(){if(this.connectionPool)return this.connectionPool;return this.logger?.debug(()=>`creating mssql pool ${this.cfg.server}...`),this.connectionPool=await mssql.connect(this.cfg),this.logger?.debug(()=>"pool created"),this.connectionPool}async closeConnection(e){}async execute(e,t,r,a){let s,n,i,o;if("string"==typeof e)s=null,n=e,i=t,o=r;else s=e,n=t,i=r,o=a;if(null==s)return this.withConnection(e=>this.execute(e,n,i,o));const l=this.logger?.verbose(()=>`[${this.user}] Execute ${n}, args=${i?JSON.stringify(i):""}`);let c;try{c=await tdsQuery(this.user,n,i,{pool:s},this.logger),l?.success()}catch(e){throw l?.fail(`Failed: ${e.message} on ${n}`),e}return c}createReader(e,t,r,a){return this.logger?.verbose(()=>`[${this.user}] Tedious reader ${t}, ${r?JSON.stringify(r):""}`),(0,reader_1.tediousReader)(e,t,r,{fillParameters,logger:this.logger})}reader(e,t=[]){return new xtrem_core_1.AsyncArrayReader(()=>this.withConnection(r=>this.createReader(r,e,t,{}).readAll()))}isIndexNotFound(e){return this.logger?.error(`ISINDEXNOTFOUND: ${e.code} ${e.message}`),false}isUniqueViolated(e){return"EREQUEST"===e.code&&e.message.startsWith("Cannot insert duplicate key row in object")}isLocked(e){return this.logger?.error(`ISLOCKED: ${e.code} ${e.message}`),false}isNoRecord(e){return this.logger?.error(`ISNORECORD: ${e.code} ${e.message}`),false}isTableNotFound(e){if(this.logger?.error(`ISTABLENOTFOUND: ${e.code} ${e.message}`),/it does not exist/.test(e.message))return true;if(/Invalid object name/.test(e.message))return true;return false}blobType(){return"varbinary(max)"}clobType(){return"varchar(max)"}tinyIntType(){return"tinyint"}shortIntType(){return"smallint"}intType(){return"int"}stringType(e){return`nvarchar(${e})`}dateType(){return"datetime"}datetimeType(){return"datetime"}uuidType(){return"binary(16)"}decimalType(){return"numeric"}floatType(){return"real"}doubleType(){return"float"}async tableExists(e,t){return!!(await this.reader(`SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES\n        WHERE TABLE_SCHEMA = ${this.param(0)}\n        AND TABLE_NAME = ${this.param(1)}`,[t,e]).toArray())[0]}async readTableSchema(e,t,r){const a={schemaName:e,tableName:t};let s,n,i,o="";if(!r.skipColumns||!r.skipSequences){o=`SELECT c.object_id table_id, c.column_id col_id, c.name col_name, c.system_type_id col_type, c.max_length col_max_length, c.is_nullable col_is_nullable, c.precision col_precision, c.scale col_scale, c.default_object_id col_default_object_id, d.definition def_definition, o.schema_id schema_id, t.TYPTYP_0 type_type, t.OPTION_0 type_option, t.LNGTYP_0 type_length, tbl.UPDDATTIM_0 tbl_updateDateTime, z.LONG_0 zone_length, z.OPTION_0 zone_option FROM sys.columns c LEFT JOIN sys.objects o ON c.object_id = o.object_id LEFT JOIN sys.schemas s ON o.schema_id = s.schema_id LEFT JOIN sys.default_constraints d ON d.object_id = c.default_object_id LEFT JOIN ${this.getFullTableName(a.schemaName,"ATABZON")} z ON z.CODFIC_0 = o.name AND c.name LIKE CONCAT(z.CODZONE_0, '[_]%') LEFT JOIN ${this.getFullTableName(a.schemaName,"ATYPE")} t ON z.CODTYP_0 = t.CODTYP_0 LEFT JOIN ${this.getFullTableName(a.schemaName,"ATABLE")} tbl ON z.CODFIC_0 = tbl.CODFIC_0 WHERE o.name='${a.tableName}' AND s.name='${a.schemaName}' AND c.name != 'ROWID' ORDER BY col_name`,this.logger?.verbose(()=>`[${this.user}] READTABLECHEMA sqlQuery1 : ${o}`);try{a.columns=(await this.reader(o).toArray()).map(e=>{if(!s)s=e.table_id,n=e.schema_id,a.lastUpdate=e.tbl_updateDateTime;const t={name:e.col_name,isNullable:e.col_is_nullable};switch(e.col_type){case 48:t.type="byte";break;case 52:t.type="short";break;case 56:t.type="integer";break;case 59:t.type="double";break;case 61:if(t.type="datetime",e.type_type)if(8===e.type_type)t.type="date";break;case 62:t.type="float";break;case 108:{if(t.type="decimal",4!==e.type_type){const r=`${a.tableName}.${t.name}: unexpected TYPTYP value: ${e.type_type}`;this.logger?.warn(`[${this.user}] WARNING : ${r}`)}let r=e.zone_length;if(0===r)r=e.type_length;t.precision=Math.floor(r),t.scale=Math.round(10*(r-t.precision));const s=e.zone_option&&-1!==e.zone_option.indexOf("F")||e.type_option&&-1!==e.type_option.indexOf("F"),n=getDecimalFormat(t.precision,t.scale,{useFloatingPointFormat:s});if(n.precision!==e.col_precision||n.scale!==e.col_scale){const r=`${a.tableName}.${t.name}: inconsistent numeric column type: computed ${n.precision}:${n.scale}, got ${e.col_precision}:${e.col_scale}`;this.logger?.warn(`[${this.user}] WARNING : ${r}`)}t.useFloatingPointFormat=s,t.precision+=t.scale;break}case 165:t.type="binaryStream";break;case 167:t.type="string",t.maxLength=e.col_max_length;break;case 173:if(16===e.col_max_length)t.type="uuid";else t.type="binary",t.maxLength=e.col_max_length;break;case 231:if(-1===e.col_max_length)t.type="textStream";else t.type="string",t.maxLength=e.col_max_length/2;break;default:throw new Error(`unknown column type ${e.col_type} for column ${this.getFullTableDefName(a)}.${e.col_name}`)}if(e.col_default_object_id)t.default=e.def_definition;else t.default=null;return t}),i?.success()}catch(e){i?.fail(`Failed ${e.message}`)}if(!s)throw new Error(`${this.getFullTableName(a.schemaName,a.tableName)}: no columns found in sys.columns (table probably missing too)!`)}if(!r.skipSecurity){o=`SELECT TOP 1 SECURE_0 FROM ${this.getFullTableName(a.schemaName,"ATABLE")} WHERE CODFIC_0 = ${this.param(0)}`;const e=(await this.reader(o,[a.tableName]).toArray())[0];a.isOpenAccess=!e||2===e.SECURE_0}if(!r.skipIndexes){let e,t;o=`SELECT ic.index_id index_id, ic.index_column_id index_column_id, i.is_unique index_unique, i.is_primary_key index_is_pk, c.name column_name, i.name index_name, ic.is_descending_key column_descending FROM sys.index_columns ic LEFT JOIN sys.indexes i ON i.index_id = ic.index_id AND i.object_id = ic.object_id LEFT JOIN sys.columns c ON c.column_id = ic.column_id AND c.object_id = ic.object_id WHERE i.object_id = ${s} AND i.type > 0 AND c.name != 'ROWID' ORDER BY i.name, ic.index_column_id`,a.indexes=[],i=this.logger?.verbose(()=>`[${this.user}] READTABLECHEMA sqlQuery2 : ${o}`);try{(await this.reader(o).toArray()).forEach(r=>{if(r.index_id!==t)t=r.index_id,e={name:r.index_name,isPrimaryKey:r.index_is_pk,isUnique:r.index_unique,columns:[]},a.indexes.push(e);const s={name:r.column_name,ascending:!r.column_descending};e.columns.push(s)}),i?.success()}catch(e){i?.fail(`Failed ${e.message}`)}}if(!r.skipSequences){o=`SELECT TOP 1 CAST(current_value AS int) seq_value  FROM sys.sequences WHERE name = 'SEQ_${a.tableName}' AND schema_id = ${n}`,i=this.logger?.verbose(()=>`[${this.user}] READTABLECHEMA sqlQuery2 : ${o}`);try{(await this.reader(o).toArray()).forEach(e=>{a.sequence=e.seq_value}),i?.success()}catch(e){i?.fail(`Failed ${e.message}`)}this.logger?.debug(()=>`[${this.user}] READTABLECHEMA result : ${JSON.stringify(a)}`)}return a}async readTables(e,t=false){const r=[];let a="SELECT o.name name";if(t)a+="";else a+=", t.CODFIC_0";if(a+=" FROM sys.objects o",e)a+=" LEFT JOIN sys.schemas s ON o.schema_id = s.schema_id";if(t)a+=" WHERE o.type = 'U'";else a+=` LEFT JOIN [${e}].ATABLE t ON t.CODFIC_0 = o.name`,a+=" WHERE o.type = 'U' AND NOT(t.CODFIC_0 IS NULL)";if(e)a+=` AND s.name = '${e}'`;return a+=" ORDER BY o.name",await this.reader(a).forEach(t=>{r.push({schemaName:e,tableName:t.name})}),r}getFullTableDefName(e){return this.getFullTableName(e.schemaName,e.tableName)}getFullTableName(e,t,r){const a=e?`[${e}].[${t}]`:`[${t}]`;return r?`${a} as ${r}`:a}release(){this.counters={...this.initialCounters}}describeQuery(e,t){throw new Error("Not implemented !!!")}backupDatabase(e,t){throw new Error("Not implemented !!!")}restoreDatabase(e,t){throw new Error("Not implemented !!!")}extractYearAndMonthAndDayFromDate(e,t=false){return`convert(datetime, format(${e}, 'YYYY-MM-DD'))`}extractYearAndMonthFromDate(e,t=false){return`convert(datetime, format(${e}, 'YYYY-MM-01'))`}extractYearFromDate(e,t=false){return`convert(datetime, format(${e}, 'YYYY-01-01'))`}}function create(e,t){return new SqlServerPool(e,t)}exports.SqlServerPool=SqlServerPool,exports.create=create;
//# sourceMappingURL=pool.js.map