/** @module @sage/xtrem-x3-tedious */
import { AnyValue, AsyncGenericReader } from '@sage/xtrem-core';
import { DateValue } from '@sage/xtrem-date-time';
import { LoggerInterface } from '@sage/xtrem-shared';
import { Hint, PoolConfig, PoolReaderOptions, SqlColumnInfo, SqlExecuteOptions, SqlReadTableSchemaOptions, TableDefinition, Pool as XtremX3Pool } from '@sage/xtrem-x3-sql';
import * as mssql from 'mssql';
export type Connection = mssql.ConnectionPool;
export declare class SqlServerPool extends XtremX3Pool<Connection> {
    readonly dialect = "mssql";
    readonly nullDate: DateValue;
    cfg: mssql.config;
    counters: {
        alloc: number;
        used: number;
        discarded: number;
        warned: number;
    };
    readonly collation: string;
    constructor(config: PoolConfig, logger?: LoggerInterface);
    uniqid(name: string): string;
    lockClause0(): string;
    lockClause1(): string;
    hintClause0(hnt: Hint, def: boolean): string;
    hintClause1(hnt: Hint, def: boolean): string;
    firstClause0(first: number): string;
    firstClause1(first: number): string;
    lengthString(): string;
    modString(dividend: string, divisor: string): string;
    subString(str: string, begin: string, end: string): string;
    dateToChar(dateColumn: string, format?: string): string;
    charToDate(val: string, dateTime?: boolean): string;
    toChar(val: string): string;
    charConcatenator(): string;
    regexOrLike(column: string, type: string, regex: string, options?: string): string;
    limitClause(limit: number): string;
    fetchOnlyClause(limit: number): string;
    driverFunctions(colName: string, name: 'year' | 'month' | 'day'): string;
    emptyBlob(): string;
    emptyClob(): string;
    escape(name: string): string;
    param(i: number): string;
    rowIdGet(v: string): string;
    rowIdPut(v: string): string;
    executeWithTransaction<T extends AnyValue>(sql: string, options: {
        rollback: boolean;
        args?: any[];
    }): Promise<T>;
    protected checkConnection(_cnx: Connection): Connection | undefined;
    private connectionPool;
    protected createConnection(): Promise<Connection>;
    protected closeConnection(_cnx: Connection): Promise<void>;
    execute<T extends AnyValue>(sql?: string, args?: any[], opts?: SqlExecuteOptions): Promise<T>;
    execute<T extends AnyValue>(cnx?: Connection, sql?: string, args?: any[], opts?: SqlExecuteOptions): Promise<T>;
    createReader<T extends AnyValue>(cnx: Connection, sql: string, args?: any[], opts?: PoolReaderOptions): AsyncGenericReader<T>;
    private reader;
    isIndexNotFound(ex: Error): boolean;
    isUniqueViolated(ex: Error): boolean;
    isLocked(ex: Error): boolean;
    isNoRecord(ex: Error): boolean;
    isTableNotFound(ex: Error): boolean;
    blobType(): string;
    clobType(): string;
    tinyIntType(): string;
    shortIntType(): string;
    intType(): string;
    stringType(len: number): string;
    dateType(): string;
    datetimeType(): string;
    uuidType(): string;
    decimalType(): string;
    floatType(): string;
    doubleType(): string;
    tableExists(tableName: string, schemaName: string): Promise<boolean>;
    readTableSchema(schemaName: string, tableName: string, options?: SqlReadTableSchemaOptions): Promise<TableDefinition>;
    readTables(schemaName: string, retrieveAll?: boolean): Promise<TableDefinition[]>;
    getFullTableDefName(tableDef: TableDefinition): string;
    getFullTableName(schemaName: string, tableName: string, alias?: string): string;
    release(): void;
    describeQuery(qry: string, schema: string): Promise<SqlColumnInfo[]>;
    backupDatabase(dbName: string, filename: string): Promise<void>;
    restoreDatabase(dbName: string, filename: string): Promise<void>;
    /**
     * Returns the SQL clause to extract year, month and day from a date/datetime column (sth like YYYY-MM-DD ou YYYY/MM/DD)
     * @param colName
     * @param forGroupBy whether the clause will be used in the 'groupBy' part of a query
     */
    extractYearAndMonthAndDayFromDate(colName: string, forGroupBy?: boolean): string;
    /**
     * Returns the SQL clause to extract year and month from a date/datetime column (sth like YYYY-MM-01 ou YYYY/MM/01)
     * @param colName
     * @param forGroupBy whether the clause will be used in the 'groupBy' part of a query
     */
    extractYearAndMonthFromDate(colName: string, forGroupBy?: boolean): string;
    /**
     * Returns the SQL clause to extract year from a date/datetime column (sth like YYYY-01-01 ou YYYY/01/01)
     * @param colName
     * @param forGroupBy whether the clause will be used in the 'groupBy' part of a query
     */
    extractYearFromDate(colName: string, forGroupBy?: boolean): string;
}
export declare function create(config: PoolConfig, logger?: LoggerInterface): XtremX3Pool<Connection>;
//# sourceMappingURL=pool.d.ts.map