// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/index.d.ts
declare module '@sage/x3-purchasing-data/index' {
	export * from '@sage/x3-purchasing-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/index.d.ts
declare module '@sage/x3-purchasing-data/lib/index' {
	export * as enums from '@sage/x3-purchasing-data/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-purchasing-data/lib/node-extensions/index';
	export * as nodes from '@sage/x3-purchasing-data/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-purchasing-data/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/service-options/index.d.ts
declare module '@sage/x3-purchasing-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/nodes/transport-lead-time.d.ts
declare module '@sage/x3-purchasing-data/lib/nodes/transport-lead-time' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data/lib/index';
	export class TransportLeadTime extends Node {
	    readonly placeStart: Reference<sageX3MasterData.nodes.TransitArea>;
	    readonly placeArrival: Reference<sageX3MasterData.nodes.TransitArea>;
	    readonly transportMode: Promise<sageX3PurchasingData.enums.TransportMode | null>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly releaseTime: Promise<integer>;
	}
	//# sourceMappingURL=transport-lead-time.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/nodes/shipment-logistical-tracking.d.ts
declare module '@sage/x3-purchasing-data/lib/nodes/shipment-logistical-tracking' {
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, date } from '@sage/xtrem-core';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data/lib/index';
	export class ShipmentLogisticalTracking extends Node {
	    readonly id: Promise<string>;
	    readonly entryType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly trackingSequence: Promise<integer | null>;
	    readonly trackingNumber: Promise<string>;
	    readonly trackingStep: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly trackingDueDate: Promise<date | null>;
	    readonly trackingEndDate: Promise<date | null>;
	    readonly isMandatory: Promise<boolean>;
	    readonly trackingDependency: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly trackingUser: Promise<integer | null>;
	    readonly trackingLineComments: Promise<string>;
	    readonly trackingStepStatus: Promise<sageX3PurchasingData.enums.TrackingStepStatus | null>;
	}
	//# sourceMappingURL=shipment-logistical-tracking.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/nodes/shipment-documents.d.ts
declare module '@sage/x3-purchasing-data/lib/nodes/shipment-documents' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, date } from '@sage/xtrem-core';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data/lib/index';
	export class ShipmentDocuments extends Node {
	    readonly id: Promise<string>;
	    readonly entryType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly shipmentDocumentLine: Promise<integer | null>;
	    readonly shipmentDocumentType: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly shipmentDocumentOrigin: Promise<sageX3PurchasingData.enums.DocumentOrigin | null>;
	    readonly shipmentDocumentDate: Promise<date | null>;
	    readonly shipmentDocumentReference1: Promise<string>;
	    readonly shipmentDocumentReference2: Promise<string>;
	    readonly shipmentDocumentBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly shipmentDocumentFileType: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly shipmentDocumentFileName: Promise<string>;
	    readonly shipmentDocumentComments: Promise<string>;
	}
	//# sourceMappingURL=shipment-documents.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/nodes/purchase-price-reason.d.ts
declare module '@sage/x3-purchasing-data/lib/nodes/purchase-price-reason' {
	import { Node, integer } from '@sage/xtrem-core';
	export class PurchasePriceReason extends Node {
	    readonly code: Promise<integer | null>;
	    readonly localizedDescription: Promise<string>;
	}
	//# sourceMappingURL=purchase-price-reason.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/nodes/purchase-invoice-type.d.ts
declare module '@sage/x3-purchasing-data/lib/nodes/purchase-invoice-type' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class PurchaseInvoiceType extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly purchaseInvoiceCategory: Promise<sageX3MasterData.enums.PurchaseInvoiceCategory>;
	    readonly invoiceCategory: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
	}
	//# sourceMappingURL=purchase-invoice-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/nodes/matching-tolerance.d.ts
declare module '@sage/x3-purchasing-data/lib/nodes/matching-tolerance' {
	import { Node } from '@sage/xtrem-core';
	export class MatchingTolerance extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	}
	//# sourceMappingURL=matching-tolerance.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/nodes/index.d.ts
declare module '@sage/x3-purchasing-data/lib/nodes/index' {
	export * from '@sage/x3-purchasing-data/lib/nodes/delivery-mode';
	export * from '@sage/x3-purchasing-data/lib/nodes/freight-container';
	export * from '@sage/x3-purchasing-data/lib/nodes/freight-cost-structure';
	export * from '@sage/x3-purchasing-data/lib/nodes/matching-tolerance';
	export * from '@sage/x3-purchasing-data/lib/nodes/purchase-invoice-type';
	export * from '@sage/x3-purchasing-data/lib/nodes/purchase-price-reason';
	export * from '@sage/x3-purchasing-data/lib/nodes/shipment-documents';
	export * from '@sage/x3-purchasing-data/lib/nodes/shipment-logistical-tracking';
	export * from '@sage/x3-purchasing-data/lib/nodes/transport-lead-time';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/nodes/freight-cost-structure.d.ts
declare module '@sage/x3-purchasing-data/lib/nodes/freight-cost-structure' {
	import { Node } from '@sage/xtrem-core';
	export class FreightCostStructure extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=freight-cost-structure.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/nodes/freight-container.d.ts
declare module '@sage/x3-purchasing-data/lib/nodes/freight-container' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal } from '@sage/xtrem-core';
	export class FreightContainer extends Node {
	    readonly id: Promise<string>;
	    readonly containerIdentification: Promise<string>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly freightContainer: Reference<sageX3MasterData.nodes.Container>;
	    readonly isFull: Promise<boolean>;
	    readonly totalWeightOfLines: Promise<decimal | null>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly totalVolumeOfLines: Promise<decimal | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly amountOfLinesExcludingTax: Promise<decimal | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly sealNumber1: Promise<string>;
	    readonly sealNumber2: Promise<string>;
	    readonly sealNumber3: Promise<string>;
	    readonly purchaseShipment: Promise<string>;
	    readonly totalWeightOfFreightContainer: Promise<decimal | null>;
	    readonly availableWeight: Promise<decimal | null>;
	    readonly availableVolume: Promise<decimal | null>;
	}
	//# sourceMappingURL=freight-container.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/nodes/delivery-mode.d.ts
declare module '@sage/x3-purchasing-data/lib/nodes/delivery-mode' {
	import { Node } from '@sage/xtrem-core';
	export class DeliveryMode extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=delivery-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/node-extensions/supplier-product-extension.d.ts
declare module '@sage/x3-purchasing-data/lib/node-extensions/supplier-product-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data/lib/index';
	export class SupplierProductExtension extends NodeExtension<sageX3MasterData.nodes.SupplierProduct> {
	    readonly costStructure: Reference<sageX3PurchasingData.nodes.FreightCostStructure | null>;
	    readonly blockingManagementMode: Promise<sageX3PurchasingData.enums.Conflict | null>;
	    readonly matchingTolerance: Reference<sageX3PurchasingData.nodes.MatchingTolerance | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/supplier-product' {
	    interface SupplierProduct extends SupplierProductExtension {
	    }
	}
	//# sourceMappingURL=supplier-product-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/node-extensions/supplier-invoice-header-extension.d.ts
declare module '@sage/x3-purchasing-data/lib/node-extensions/supplier-invoice-header-extension' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data/lib/index';
	export class SupplierInvoiceHeaderExtension extends NodeExtension<sageX3InvoicingData.nodes.SupplierInvoiceHeader> {
	    readonly invoiceType: Reference<sageX3PurchasingData.nodes.PurchaseInvoiceType | null>;
	}
	declare module '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header' {
	    interface SupplierInvoiceHeader extends SupplierInvoiceHeaderExtension {
	    }
	}
	//# sourceMappingURL=supplier-invoice-header-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/node-extensions/supplier-extension.d.ts
declare module '@sage/x3-purchasing-data/lib/node-extensions/supplier-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data/lib/index';
	import { NodeExtension } from '@sage/xtrem-core';
	export class SupplierExtension extends NodeExtension<sageX3MasterData.nodes.Supplier> {
	    readonly supplierType: Promise<sageX3PurchasingData.enums.SupplierType | null>;
	    readonly dueDateOrigin: Promise<sageX3PurchasingData.enums.DueDateCalculationBase | null>;
	    readonly currencyRateDetermination: Promise<sageX3PurchasingData.enums.CurrencyRateSearchDate | null>;
	    readonly disputeStatus: Promise<sageX3PurchasingData.enums.Conflict | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/supplier' {
	    interface Supplier extends SupplierExtension {
	    }
	}
	//# sourceMappingURL=supplier-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/node-extensions/ship-to-customer-address-extension.d.ts
declare module '@sage/x3-purchasing-data/lib/node-extensions/ship-to-customer-address-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data/lib/index';
	export class ShipToCustomerAddressExtension extends NodeExtension<sageX3MasterData.nodes.ShipToCustomerAddress> {
	    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/ship-to-customer-address' {
	    interface ShipToCustomerAddress extends ShipToCustomerAddressExtension {
	    }
	}
	//# sourceMappingURL=ship-to-customer-address-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/node-extensions/product-extension.d.ts
declare module '@sage/x3-purchasing-data/lib/node-extensions/product-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data/lib/index';
	export class ProductExtension extends NodeExtension<sageX3MasterData.nodes.Product> {
	    readonly costStructure: Reference<sageX3PurchasingData.nodes.FreightCostStructure | null>;
	    readonly matchingTolerance: Reference<sageX3PurchasingData.nodes.MatchingTolerance | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product' {
	    interface Product extends ProductExtension {
	    }
	}
	//# sourceMappingURL=product-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/node-extensions/product-category-extension.d.ts
declare module '@sage/x3-purchasing-data/lib/node-extensions/product-category-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data/lib/index';
	export class ProductCategoryExtension extends NodeExtension<sageX3MasterData.nodes.ProductCategory> {
	    readonly costStructure: Reference<sageX3PurchasingData.nodes.FreightCostStructure | null>;
	    readonly matchingTolerance: Reference<sageX3PurchasingData.nodes.MatchingTolerance | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product-category' {
	    interface ProductCategory extends ProductCategoryExtension {
	    }
	}
	//# sourceMappingURL=product-category-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-purchasing-data/lib/node-extensions/index' {
	export * from '@sage/x3-purchasing-data/lib/node-extensions/product-category-extension';
	export * from '@sage/x3-purchasing-data/lib/node-extensions/product-extension';
	export * from '@sage/x3-purchasing-data/lib/node-extensions/ship-to-customer-address-extension';
	export * from '@sage/x3-purchasing-data/lib/node-extensions/supplier-extension';
	export * from '@sage/x3-purchasing-data/lib/node-extensions/supplier-invoice-header-extension';
	export * from '@sage/x3-purchasing-data/lib/node-extensions/supplier-product-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/variance-calculation-source-2403.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/variance-calculation-source-2403' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VarianceCalculationSource2403Enum {
	    standard = 1,
	    order = 2
	}
	export interface VarianceCalculationSource2403$EnumInterface {
	    standard: 1;
	    order: 2;
	}
	export type VarianceCalculationSource2403 = keyof VarianceCalculationSource2403$EnumInterface;
	export const varianceCalculationSource2403Datatype: X3EnumDataType<keyof VarianceCalculationSource2403$EnumInterface, unknown>;
	//# sourceMappingURL=variance-calculation-source-2403.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/user-for-quotation.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/user-for-quotation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UserForQuotationEnum {
	    requester = 1,
	    buyer = 2
	}
	export interface UserForQuotation$EnumInterface {
	    requester: 1;
	    buyer: 2;
	}
	export type UserForQuotation = keyof UserForQuotation$EnumInterface;
	export const userForQuotationDatatype: X3EnumDataType<keyof UserForQuotation$EnumInterface, unknown>;
	//# sourceMappingURL=user-for-quotation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/use-p-req-line-text.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/use-p-req-line-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UsePReqLineTextEnum {
	    no = 1,
	    onOrderLine = 2
	}
	export interface UsePReqLineText$EnumInterface {
	    no: 1;
	    onOrderLine: 2;
	}
	export type UsePReqLineText = keyof UsePReqLineText$EnumInterface;
	export const usePReqLineTextDatatype: X3EnumDataType<keyof UsePReqLineText$EnumInterface, unknown>;
	//# sourceMappingURL=use-p-req-line-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/type-of-document-544.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/type-of-document-544' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfDocument544Enum {
	    order = 1,
	    receipt = 2
	}
	export interface TypeOfDocument544$EnumInterface {
	    order: 1;
	    receipt: 2;
	}
	export type TypeOfDocument544 = keyof TypeOfDocument544$EnumInterface;
	export const typeOfDocument544Datatype: X3EnumDataType<keyof TypeOfDocument544$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-document-544.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/transport-selection.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/transport-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransportSelectionEnum {
	    fromDepartureDate = 1,
	    fromPlannedArrivalDate = 2
	}
	export interface TransportSelection$EnumInterface {
	    fromDepartureDate: 1;
	    fromPlannedArrivalDate: 2;
	}
	export type TransportSelection = keyof TransportSelection$EnumInterface;
	export const transportSelectionDatatype: X3EnumDataType<keyof TransportSelection$EnumInterface, unknown>;
	//# sourceMappingURL=transport-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/transport-mode.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/transport-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransportModeEnum {
	    air = 1,
	    sea = 2,
	    road = 3,
	    rail = 4,
	    multimodal = 5,
	    notDefined = 6
	}
	export interface TransportMode$EnumInterface {
	    air: 1;
	    sea: 2;
	    road: 3;
	    rail: 4;
	    multimodal: 5;
	    notDefined: 6;
	}
	export type TransportMode = keyof TransportMode$EnumInterface;
	export const transportModeDatatype: X3EnumDataType<keyof TransportMode$EnumInterface, unknown>;
	//# sourceMappingURL=transport-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/transfer-of-order-to-invoice.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/transfer-of-order-to-invoice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransferOfOrderToInvoiceEnum {
	    amountProRata = 1,
	    quantityProRata = 2,
	    weightProRata = 3,
	    volumeProRata = 4,
	    firstDocument = 5,
	    allDocuments = 6
	}
	export interface TransferOfOrderToInvoice$EnumInterface {
	    amountProRata: 1;
	    quantityProRata: 2;
	    weightProRata: 3;
	    volumeProRata: 4;
	    firstDocument: 5;
	    allDocuments: 6;
	}
	export type TransferOfOrderToInvoice = keyof TransferOfOrderToInvoice$EnumInterface;
	export const transferOfOrderToInvoiceDatatype: X3EnumDataType<keyof TransferOfOrderToInvoice$EnumInterface, unknown>;
	//# sourceMappingURL=transfer-of-order-to-invoice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/tracking-step-status.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/tracking-step-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TrackingStepStatusEnum {
	    toDo = 1,
	    inProgress = 2,
	    completed = 3
	}
	export interface TrackingStepStatus$EnumInterface {
	    toDo: 1;
	    inProgress: 2;
	    completed: 3;
	}
	export type TrackingStepStatus = keyof TrackingStepStatus$EnumInterface;
	export const trackingStepStatusDatatype: X3EnumDataType<keyof TrackingStepStatus$EnumInterface, unknown>;
	//# sourceMappingURL=tracking-step-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/tracking-of-the-supplier-text.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/tracking-of-the-supplier-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TrackingOfTheSupplierTextEnum {
	    headerText = 1,
	    footerText = 2
	}
	export interface TrackingOfTheSupplierText$EnumInterface {
	    headerText: 1;
	    footerText: 2;
	}
	export type TrackingOfTheSupplierText = keyof TrackingOfTheSupplierText$EnumInterface;
	export const trackingOfTheSupplierTextDatatype: X3EnumDataType<keyof TrackingOfTheSupplierText$EnumInterface, unknown>;
	//# sourceMappingURL=tracking-of-the-supplier-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/tax-rule-538.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/tax-rule-538' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxRule538Enum {
	    productRate = 1,
	    fixedRate = 2
	}
	export interface TaxRule538$EnumInterface {
	    productRate: 1;
	    fixedRate: 2;
	}
	export type TaxRule538 = keyof TaxRule538$EnumInterface;
	export const taxRule538Datatype: X3EnumDataType<keyof TaxRule538$EnumInterface, unknown>;
	//# sourceMappingURL=tax-rule-538.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/tax-code-control.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/tax-code-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxCodeControlEnum {
	    none = 1,
	    notBlocking = 2,
	    blocking = 3
	}
	export interface TaxCodeControl$EnumInterface {
	    none: 1;
	    notBlocking: 2;
	    blocking: 3;
	}
	export type TaxCodeControl = keyof TaxCodeControl$EnumInterface;
	export const taxCodeControlDatatype: X3EnumDataType<keyof TaxCodeControl$EnumInterface, unknown>;
	//# sourceMappingURL=tax-code-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/supplier-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/supplier-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierTypeEnum {
	    normal = 1,
	    prospect = 2,
	    miscellaneous = 3
	}
	export interface SupplierType$EnumInterface {
	    normal: 1;
	    prospect: 2;
	    miscellaneous: 3;
	}
	export type SupplierType = keyof SupplierType$EnumInterface;
	export const supplierTypeDatatype: X3EnumDataType<keyof SupplierType$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/supplier-source.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/supplier-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierSourceEnum {
	    orderSupplier = 1,
	    invoiceSupplier = 2
	}
	export interface SupplierSource$EnumInterface {
	    orderSupplier: 1;
	    invoiceSupplier: 2;
	}
	export type SupplierSource = keyof SupplierSource$EnumInterface;
	export const supplierSourceDatatype: X3EnumDataType<keyof SupplierSource$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/supplier-selection-criterion.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/supplier-selection-criterion' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierSelectionCriterionEnum {
	    primeSupplier = 1,
	    bestPrice = 2,
	    bestLeadTime = 3
	}
	export interface SupplierSelectionCriterion$EnumInterface {
	    primeSupplier: 1;
	    bestPrice: 2;
	    bestLeadTime: 3;
	}
	export type SupplierSelectionCriterion = keyof SupplierSelectionCriterion$EnumInterface;
	export const supplierSelectionCriterionDatatype: X3EnumDataType<keyof SupplierSelectionCriterion$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-selection-criterion.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/supplier-movement-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/supplier-movement-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierMovementTypeEnum {
	    callForTenders = 1,
	    purchaseRequest = 2,
	    order = 3,
	    receipt = 4,
	    return = 5,
	    invoice = 6,
	    payment = 7
	}
	export interface SupplierMovementType$EnumInterface {
	    callForTenders: 1;
	    purchaseRequest: 2;
	    order: 3;
	    receipt: 4;
	    return: 5;
	    invoice: 6;
	    payment: 7;
	}
	export type SupplierMovementType = keyof SupplierMovementType$EnumInterface;
	export const supplierMovementTypeDatatype: X3EnumDataType<keyof SupplierMovementType$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-movement-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/supplier-invoice.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/supplier-invoice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierInvoiceEnum {
	    all = 1,
	    open = 2,
	    withPayments = 3
	}
	export interface SupplierInvoice$EnumInterface {
	    all: 1;
	    open: 2;
	    withPayments: 3;
	}
	export type SupplierInvoice = keyof SupplierInvoice$EnumInterface;
	export const supplierInvoiceDatatype: X3EnumDataType<keyof SupplierInvoice$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-invoice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/supplier-information-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/supplier-information-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierInformationTypeEnum {
	    lastCallForTenders = 1,
	    lastPurchaseRequest = 2,
	    lastOrder = 3,
	    lastReceipt = 4,
	    lastReturn = 5,
	    lastInvoice = 6,
	    lastCreditMemo = 7,
	    lastPayment = 8
	}
	export interface SupplierInformationType$EnumInterface {
	    lastCallForTenders: 1;
	    lastPurchaseRequest: 2;
	    lastOrder: 3;
	    lastReceipt: 4;
	    lastReturn: 5;
	    lastInvoice: 6;
	    lastCreditMemo: 7;
	    lastPayment: 8;
	}
	export type SupplierInformationType = keyof SupplierInformationType$EnumInterface;
	export const supplierInformationTypeDatatype: X3EnumDataType<keyof SupplierInformationType$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-information-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/supplier-grading-scale.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/supplier-grading-scale' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierGradingScaleEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4
	}
	export interface SupplierGradingScale$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	}
	export type SupplierGradingScale = keyof SupplierGradingScale$EnumInterface;
	export const supplierGradingScaleDatatype: X3EnumDataType<keyof SupplierGradingScale$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-grading-scale.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/suggestion-consumption.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/suggestion-consumption' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SuggestionConsumptionEnum {
	    automatic = 1,
	    manual = 2
	}
	export interface SuggestionConsumption$EnumInterface {
	    automatic: 1;
	    manual: 2;
	}
	export type SuggestionConsumption = keyof SuggestionConsumption$EnumInterface;
	export const suggestionConsumptionDatatype: X3EnumDataType<keyof SuggestionConsumption$EnumInterface, unknown>;
	//# sourceMappingURL=suggestion-consumption.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/substitute-signers.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/substitute-signers' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubstituteSignersEnum {
	    signer = 1,
	    substitute = 2
	}
	export interface SubstituteSigners$EnumInterface {
	    signer: 1;
	    substitute: 2;
	}
	export type SubstituteSigners = keyof SubstituteSigners$EnumInterface;
	export const substituteSignersDatatype: X3EnumDataType<keyof SubstituteSigners$EnumInterface, unknown>;
	//# sourceMappingURL=substitute-signers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/subcontract-cost-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/subcontract-cost-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubcontractCostTypeEnum {
	    theoreticalForecast = 1,
	    launchForecast = 2,
	    manufacturingForecast = 3,
	    actualCostPrice = 4,
	    actualCostPriceForPlannedQuantity = 5,
	    manufacturingForecastForAchievedQuantity = 6
	}
	export interface SubcontractCostType$EnumInterface {
	    theoreticalForecast: 1;
	    launchForecast: 2;
	    manufacturingForecast: 3;
	    actualCostPrice: 4;
	    actualCostPriceForPlannedQuantity: 5;
	    manufacturingForecastForAchievedQuantity: 6;
	}
	export type SubcontractCostType = keyof SubcontractCostType$EnumInterface;
	export const subcontractCostTypeDatatype: X3EnumDataType<keyof SubcontractCostType$EnumInterface, unknown>;
	//# sourceMappingURL=subcontract-cost-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/sub-contract-requirements.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/sub-contract-requirements' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubContractRequirementsEnum {
	    subcontractedProduct = 1,
	    service = 2
	}
	export interface SubContractRequirements$EnumInterface {
	    subcontractedProduct: 1;
	    service: 2;
	}
	export type SubContractRequirements = keyof SubContractRequirements$EnumInterface;
	export const subContractRequirementsDatatype: X3EnumDataType<keyof SubContractRequirements$EnumInterface, unknown>;
	//# sourceMappingURL=sub-contract-requirements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/status.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatusEnum {
	    created = 1,
	    inProgress = 2,
	    arrived = 3
	}
	export interface Status$EnumInterface {
	    created: 1;
	    inProgress: 2;
	    arrived: 3;
	}
	export type Status = keyof Status$EnumInterface;
	export const statusDatatype: X3EnumDataType<keyof Status$EnumInterface, unknown>;
	//# sourceMappingURL=status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/start-end-of-line.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/start-end-of-line' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StartEndOfLineEnum {
	    startOfLine = 1,
	    endOfLine = 2,
	    accordingToReferenceProduct = 3
	}
	export interface StartEndOfLine$EnumInterface {
	    startOfLine: 1;
	    endOfLine: 2;
	    accordingToReferenceProduct: 3;
	}
	export type StartEndOfLine = keyof StartEndOfLine$EnumInterface;
	export const startEndOfLineDatatype: X3EnumDataType<keyof StartEndOfLine$EnumInterface, unknown>;
	//# sourceMappingURL=start-end-of-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/sort-order-2410.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/sort-order-2410' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOrder2410Enum {
	    sitePartNumber = 1,
	    siteDate = 2,
	    siteRequestFrom = 3,
	    partNumber = 4,
	    date = 5,
	    requestFrom = 6
	}
	export interface SortOrder2410$EnumInterface {
	    sitePartNumber: 1;
	    siteDate: 2;
	    siteRequestFrom: 3;
	    partNumber: 4;
	    date: 5;
	    requestFrom: 6;
	}
	export type SortOrder2410 = keyof SortOrder2410$EnumInterface;
	export const sortOrder2410Datatype: X3EnumDataType<keyof SortOrder2410$EnumInterface, unknown>;
	//# sourceMappingURL=sort-order-2410.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/sort-order-2409.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/sort-order-2409' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOrder2409Enum {
	    partNumber = 1,
	    date = 2,
	    requestFrom = 3
	}
	export interface SortOrder2409$EnumInterface {
	    partNumber: 1;
	    date: 2;
	    requestFrom: 3;
	}
	export type SortOrder2409 = keyof SortOrder2409$EnumInterface;
	export const sortOrder2409Datatype: X3EnumDataType<keyof SortOrder2409$EnumInterface, unknown>;
	//# sourceMappingURL=sort-order-2409.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/signature-rule-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/signature-rule-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SignatureRuleTypeEnum {
	    purchaseRequest = 1,
	    order = 2,
	    contract = 3
	}
	export interface SignatureRuleType$EnumInterface {
	    purchaseRequest: 1;
	    order: 2;
	    contract: 3;
	}
	export type SignatureRuleType = keyof SignatureRuleType$EnumInterface;
	export const signatureRuleTypeDatatype: X3EnumDataType<keyof SignatureRuleType$EnumInterface, unknown>;
	//# sourceMappingURL=signature-rule-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/signature-531.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/signature-531' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Signature531Enum {
	    no = 1,
	    yesOptional = 2,
	    yesMandatory = 3
	}
	export interface Signature531$EnumInterface {
	    no: 1;
	    yesOptional: 2;
	    yesMandatory: 3;
	}
	export type Signature531 = keyof Signature531$EnumInterface;
	export const signature531Datatype: X3EnumDataType<keyof Signature531$EnumInterface, unknown>;
	//# sourceMappingURL=signature-531.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/shipment-status.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/shipment-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ShipmentStatusEnum {
	    created = 1,
	    shipped = 2,
	    preReceived = 3,
	    received = 4,
	    closed = 5
	}
	export interface ShipmentStatus$EnumInterface {
	    created: 1;
	    shipped: 2;
	    preReceived: 3;
	    received: 4;
	    closed: 5;
	}
	export type ShipmentStatus = keyof ShipmentStatus$EnumInterface;
	export const shipmentStatusDatatype: X3EnumDataType<keyof ShipmentStatus$EnumInterface, unknown>;
	//# sourceMappingURL=shipment-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/shipment-record-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/shipment-record-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ShipmentRecordTypeEnum {
	    shipment = 1,
	    preReceivedOrder = 2
	}
	export interface ShipmentRecordType$EnumInterface {
	    shipment: 1;
	    preReceivedOrder: 2;
	}
	export type ShipmentRecordType = keyof ShipmentRecordType$EnumInterface;
	export const shipmentRecordTypeDatatype: X3EnumDataType<keyof ShipmentRecordType$EnumInterface, unknown>;
	//# sourceMappingURL=shipment-record-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/shipment-management.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/shipment-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ShipmentManagementEnum {
	    orderLine = 1,
	    multipleContainers = 2,
	    singleContainer = 3
	}
	export interface ShipmentManagement$EnumInterface {
	    orderLine: 1;
	    multipleContainers: 2;
	    singleContainer: 3;
	}
	export type ShipmentManagement = keyof ShipmentManagement$EnumInterface;
	export const shipmentManagementDatatype: X3EnumDataType<keyof ShipmentManagement$EnumInterface, unknown>;
	//# sourceMappingURL=shipment-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/selection-of-requirements.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/selection-of-requirements' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionOfRequirementsEnum {
	    onStartDate = 1,
	    onEndDate = 2
	}
	export interface SelectionOfRequirements$EnumInterface {
	    onStartDate: 1;
	    onEndDate: 2;
	}
	export type SelectionOfRequirements = keyof SelectionOfRequirements$EnumInterface;
	export const selectionOfRequirementsDatatype: X3EnumDataType<keyof SelectionOfRequirements$EnumInterface, unknown>;
	//# sourceMappingURL=selection-of-requirements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/rounding-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/rounding-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RoundingTypeEnum {
	    roundingToTheNearestNumber = 1,
	    roundingDownToTheNextDecimal = 2,
	    roundingDownToTheNextInteger = 3,
	    roundingUpToTheNextDecimal = 4,
	    roundingUpToTheNextInteger = 5
	}
	export interface RoundingType$EnumInterface {
	    roundingToTheNearestNumber: 1;
	    roundingDownToTheNextDecimal: 2;
	    roundingDownToTheNextInteger: 3;
	    roundingUpToTheNextDecimal: 4;
	    roundingUpToTheNextInteger: 5;
	}
	export type RoundingType = keyof RoundingType$EnumInterface;
	export const roundingTypeDatatype: X3EnumDataType<keyof RoundingType$EnumInterface, unknown>;
	//# sourceMappingURL=rounding-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/revision-param-menu.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/revision-param-menu' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RevisionParamMenuEnum {
	    notManaged = 1,
	    managedOnDemand = 2,
	    managedAutomatically = 3
	}
	export interface RevisionParamMenu$EnumInterface {
	    notManaged: 1;
	    managedOnDemand: 2;
	    managedAutomatically: 3;
	}
	export type RevisionParamMenu = keyof RevisionParamMenu$EnumInterface;
	export const revisionParamMenuDatatype: X3EnumDataType<keyof RevisionParamMenu$EnumInterface, unknown>;
	//# sourceMappingURL=revision-param-menu.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/return-reason.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/return-reason' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReturnReasonEnum {
	    notConforming = 1,
	    damaged = 2,
	    notOrdered = 3,
	    other = 4
	}
	export interface ReturnReason$EnumInterface {
	    notConforming: 1;
	    damaged: 2;
	    notOrdered: 3;
	    other: 4;
	}
	export type ReturnReason = keyof ReturnReason$EnumInterface;
	export const returnReasonDatatype: X3EnumDataType<keyof ReturnReason$EnumInterface, unknown>;
	//# sourceMappingURL=return-reason.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/requirements-selection.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/requirements-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RequirementsSelectionEnum {
	    withoutDirectOrder = 1,
	    withDirectOrder = 2,
	    directOrderOnly = 3
	}
	export interface RequirementsSelection$EnumInterface {
	    withoutDirectOrder: 1;
	    withDirectOrder: 2;
	    directOrderOnly: 3;
	}
	export type RequirementsSelection = keyof RequirementsSelection$EnumInterface;
	export const requirementsSelectionDatatype: X3EnumDataType<keyof RequirementsSelection$EnumInterface, unknown>;
	//# sourceMappingURL=requirements-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/request-source.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/request-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RequestSourceEnum {
	    purchases = 1,
	    directOrder = 2,
	    receivedDirectOrder = 3,
	    transfer = 4,
	    production = 5
	}
	export interface RequestSource$EnumInterface {
	    purchases: 1;
	    directOrder: 2;
	    receivedDirectOrder: 3;
	    transfer: 4;
	    production: 5;
	}
	export type RequestSource = keyof RequestSource$EnumInterface;
	export const requestSourceDatatype: X3EnumDataType<keyof RequestSource$EnumInterface, unknown>;
	//# sourceMappingURL=request-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/receipt-quantity-conversion.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/receipt-quantity-conversion' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReceiptQuantityConversionEnum {
	    quantityRecalculationInChange = 1,
	    noQuantityRecalculation = 2,
	    recalculationExceptPacPur = 3
	}
	export interface ReceiptQuantityConversion$EnumInterface {
	    quantityRecalculationInChange: 1;
	    noQuantityRecalculation: 2;
	    recalculationExceptPacPur: 3;
	}
	export type ReceiptQuantityConversion = keyof ReceiptQuantityConversion$EnumInterface;
	export const receiptQuantityConversionDatatype: X3EnumDataType<keyof ReceiptQuantityConversion$EnumInterface, unknown>;
	//# sourceMappingURL=receipt-quantity-conversion.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/receipt-on-order-line.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/receipt-on-order-line' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReceiptOnOrderLineEnum {
	    ifRemainingQuantity = 1,
	    completelyReceived = 2
	}
	export interface ReceiptOnOrderLine$EnumInterface {
	    ifRemainingQuantity: 1;
	    completelyReceived: 2;
	}
	export type ReceiptOnOrderLine = keyof ReceiptOnOrderLine$EnumInterface;
	export const receiptOnOrderLineDatatype: X3EnumDataType<keyof ReceiptOnOrderLine$EnumInterface, unknown>;
	//# sourceMappingURL=receipt-on-order-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/re-instatement-on-order.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/re-instatement-on-order' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReInstatementOnOrderEnum {
	    no = 1,
	    yesSameLlne = 2,
	    yesOtherLine = 3,
	    yesOtherOrder = 4
	}
	export interface ReInstatementOnOrder$EnumInterface {
	    no: 1;
	    yesSameLlne: 2;
	    yesOtherLine: 3;
	    yesOtherOrder: 4;
	}
	export type ReInstatementOnOrder = keyof ReInstatementOnOrder$EnumInterface;
	export const reInstatementOnOrderDatatype: X3EnumDataType<keyof ReInstatementOnOrder$EnumInterface, unknown>;
	//# sourceMappingURL=re-instatement-on-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/quantity-status.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/quantity-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QuantityStatusEnum {
	    suspendedDetail = 1,
	    details = 2
	}
	export interface QuantityStatus$EnumInterface {
	    suspendedDetail: 1;
	    details: 2;
	}
	export type QuantityStatus = keyof QuantityStatus$EnumInterface;
	export const quantityStatusDatatype: X3EnumDataType<keyof QuantityStatus$EnumInterface, unknown>;
	//# sourceMappingURL=quantity-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/quantity-entry-mode.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/quantity-entry-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QuantityEntryModeEnum {
	    enteredWithUnit = 1,
	    enteredWithoutUnit = 2,
	    displayed = 3,
	    hidden = 4
	}
	export interface QuantityEntryMode$EnumInterface {
	    enteredWithUnit: 1;
	    enteredWithoutUnit: 2;
	    displayed: 3;
	    hidden: 4;
	}
	export type QuantityEntryMode = keyof QuantityEntryMode$EnumInterface;
	export const quantityEntryModeDatatype: X3EnumDataType<keyof QuantityEntryMode$EnumInterface, unknown>;
	//# sourceMappingURL=quantity-entry-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/quantity-entry-mode-541.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/quantity-entry-mode-541' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QuantityEntryMode541Enum {
	    enteredWithUnit = 1,
	    enteredWithoutUnit = 2
	}
	export interface QuantityEntryMode541$EnumInterface {
	    enteredWithUnit: 1;
	    enteredWithoutUnit: 2;
	}
	export type QuantityEntryMode541 = keyof QuantityEntryMode541$EnumInterface;
	export const quantityEntryMode541Datatype: X3EnumDataType<keyof QuantityEntryMode541$EnumInterface, unknown>;
	//# sourceMappingURL=quantity-entry-mode-541.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/purchase-type-507.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/purchase-type-507' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseType507Enum {
	    commercial = 1,
	    general = 2
	}
	export interface PurchaseType507$EnumInterface {
	    commercial: 1;
	    general: 2;
	}
	export type PurchaseType507 = keyof PurchaseType507$EnumInterface;
	export const purchaseType507Datatype: X3EnumDataType<keyof PurchaseType507$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-type-507.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/purchase-sort-order.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/purchase-sort-order' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseSortOrderEnum {
	    journalNumber = 1,
	    date = 2,
	    supplier = 3
	}
	export interface PurchaseSortOrder$EnumInterface {
	    journalNumber: 1;
	    date: 2;
	    supplier: 3;
	}
	export type PurchaseSortOrder = keyof PurchaseSortOrder$EnumInterface;
	export const purchaseSortOrderDatatype: X3EnumDataType<keyof PurchaseSortOrder$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-sort-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/purchase-sort-order-2502.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/purchase-sort-order-2502' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseSortOrder2502Enum {
	    siteJournalNumber = 1,
	    siteDate = 2,
	    siteSupplier = 3,
	    journalNumber = 4,
	    date = 5,
	    supplier = 6
	}
	export interface PurchaseSortOrder2502$EnumInterface {
	    siteJournalNumber: 1;
	    siteDate: 2;
	    siteSupplier: 3;
	    journalNumber: 4;
	    date: 5;
	    supplier: 6;
	}
	export type PurchaseSortOrder2502 = keyof PurchaseSortOrder2502$EnumInterface;
	export const purchaseSortOrder2502Datatype: X3EnumDataType<keyof PurchaseSortOrder2502$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-sort-order-2502.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/purchase-request-line-value.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/purchase-request-line-value' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseRequestLineValueEnum {
	    standardCost = 1,
	    priceSearch = 2
	}
	export interface PurchaseRequestLineValue$EnumInterface {
	    standardCost: 1;
	    priceSearch: 2;
	}
	export type PurchaseRequestLineValue = keyof PurchaseRequestLineValue$EnumInterface;
	export const purchaseRequestLineValueDatatype: X3EnumDataType<keyof PurchaseRequestLineValue$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-request-line-value.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/purchase-price-reason-enum.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/purchase-price-reason-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchasePriceReasonEnumEnum {
	    standardCost = 1,
	    manual = 2,
	    newCost = 3
	}
	export interface PurchasePriceReasonEnum$EnumInterface {
	    standardCost: 1;
	    manual: 2;
	    newCost: 3;
	}
	export type PurchasePriceReasonEnum = keyof PurchasePriceReasonEnum$EnumInterface;
	export const purchasePriceReasonEnumDatatype: X3EnumDataType<keyof PurchasePriceReasonEnum$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-price-reason-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/purchase-invoice-3-way-match.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/purchase-invoice-3-way-match' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseInvoice3WayMatchEnum {
	    noRestriction = 1,
	    loadFromPoIfNoReceiptExists = 2,
	    loadFromReceiptOnly = 3
	}
	export interface PurchaseInvoice3WayMatch$EnumInterface {
	    noRestriction: 1;
	    loadFromPoIfNoReceiptExists: 2;
	    loadFromReceiptOnly: 3;
	}
	export type PurchaseInvoice3WayMatch = keyof PurchaseInvoice3WayMatch$EnumInterface;
	export const purchaseInvoice3WayMatchDatatype: X3EnumDataType<keyof PurchaseInvoice3WayMatch$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-invoice-3-way-match.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/purchase-document-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/purchase-document-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseDocumentTypeEnum {
	    rfq = 1,
	    purchaseRequest = 2,
	    standardOrder = 3,
	    subcontractOrder = 4,
	    openOrder = 5,
	    receipt = 6,
	    return = 7,
	    invoiceCreditNote = 8,
	    subcontractOrderEo = 9
	}
	export interface PurchaseDocumentType$EnumInterface {
	    rfq: 1;
	    purchaseRequest: 2;
	    standardOrder: 3;
	    subcontractOrder: 4;
	    openOrder: 5;
	    receipt: 6;
	    return: 7;
	    invoiceCreditNote: 8;
	    subcontractOrderEo: 9;
	}
	export type PurchaseDocumentType = keyof PurchaseDocumentType$EnumInterface;
	export const purchaseDocumentTypeDatatype: X3EnumDataType<keyof PurchaseDocumentType$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-document-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/provisional-cost-type-2505.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/provisional-cost-type-2505' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProvisionalCostType2505Enum {
	    theoretical = 1,
	    release = 2,
	    provisional = 3
	}
	export interface ProvisionalCostType2505$EnumInterface {
	    theoretical: 1;
	    release: 2;
	    provisional: 3;
	}
	export type ProvisionalCostType2505 = keyof ProvisionalCostType2505$EnumInterface;
	export const provisionalCostType2505Datatype: X3EnumDataType<keyof ProvisionalCostType2505$EnumInterface, unknown>;
	//# sourceMappingURL=provisional-cost-type-2505.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/products-to-be-processed.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/products-to-be-processed' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductsToBeProcessedEnum {
	    productsManagedInStock = 1,
	    productsNotManaged = 2,
	    allProducts = 3
	}
	export interface ProductsToBeProcessed$EnumInterface {
	    productsManagedInStock: 1;
	    productsNotManaged: 2;
	    allProducts: 3;
	}
	export type ProductsToBeProcessed = keyof ProductsToBeProcessed$EnumInterface;
	export const productsToBeProcessedDatatype: X3EnumDataType<keyof ProductsToBeProcessed$EnumInterface, unknown>;
	//# sourceMappingURL=products-to-be-processed.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/product-supplier-referencing.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/product-supplier-referencing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductSupplierReferencingEnum {
	    mandatory = 1,
	    optional = 2,
	    notUsed = 3
	}
	export interface ProductSupplierReferencing$EnumInterface {
	    mandatory: 1;
	    optional: 2;
	    notUsed: 3;
	}
	export type ProductSupplierReferencing = keyof ProductSupplierReferencing$EnumInterface;
	export const productSupplierReferencingDatatype: X3EnumDataType<keyof ProductSupplierReferencing$EnumInterface, unknown>;
	//# sourceMappingURL=product-supplier-referencing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/product-reference-entry-format.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/product-reference-entry-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductReferenceEntryFormatEnum {
	    ofProduct = 1,
	    ofSupplier = 2
	}
	export interface ProductReferenceEntryFormat$EnumInterface {
	    ofProduct: 1;
	    ofSupplier: 2;
	}
	export type ProductReferenceEntryFormat = keyof ProductReferenceEntryFormat$EnumInterface;
	export const productReferenceEntryFormatDatatype: X3EnumDataType<keyof ProductReferenceEntryFormat$EnumInterface, unknown>;
	//# sourceMappingURL=product-reference-entry-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/process-type-526.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/process-type-526' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessType526Enum {
	    signature = 1,
	    cancellation = 2
	}
	export interface ProcessType526$EnumInterface {
	    signature: 1;
	    cancellation: 2;
	}
	export type ProcessType526 = keyof ProcessType526$EnumInterface;
	export const processType526Datatype: X3EnumDataType<keyof ProcessType526$EnumInterface, unknown>;
	//# sourceMappingURL=process-type-526.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/precommitment-update.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/precommitment-update' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrecommitmentUpdateEnum {
	    uponFirstSignature = 1,
	    uponLastSignature = 2,
	    uponCreation = 3
	}
	export interface PrecommitmentUpdate$EnumInterface {
	    uponFirstSignature: 1;
	    uponLastSignature: 2;
	    uponCreation: 3;
	}
	export type PrecommitmentUpdate = keyof PrecommitmentUpdate$EnumInterface;
	export const precommitmentUpdateDatatype: X3EnumDataType<keyof PrecommitmentUpdate$EnumInterface, unknown>;
	//# sourceMappingURL=precommitment-update.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/ordered-quantity-control.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/ordered-quantity-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderedQuantityControlEnum {
	    blocking = 1,
	    warning = 2,
	    noControl = 3
	}
	export interface OrderedQuantityControl$EnumInterface {
	    blocking: 1;
	    warning: 2;
	    noControl: 3;
	}
	export type OrderedQuantityControl = keyof OrderedQuantityControl$EnumInterface;
	export const orderedQuantityControlDatatype: X3EnumDataType<keyof OrderedQuantityControl$EnumInterface, unknown>;
	//# sourceMappingURL=ordered-quantity-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/order-type-529.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/order-type-529' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderType529Enum {
	    std = 1,
	    ctr = 2,
	    sC = 3
	}
	export interface OrderType529$EnumInterface {
	    std: 1;
	    ctr: 2;
	    sC: 3;
	}
	export type OrderType529 = keyof OrderType529$EnumInterface;
	export const orderType529Datatype: X3EnumDataType<keyof OrderType529$EnumInterface, unknown>;
	//# sourceMappingURL=order-type-529.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/order-transfer-on-invoice.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/order-transfer-on-invoice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderTransferOnInvoiceEnum {
	    first = 1,
	    all = 2
	}
	export interface OrderTransferOnInvoice$EnumInterface {
	    first: 1;
	    all: 2;
	}
	export type OrderTransferOnInvoice = keyof OrderTransferOnInvoice$EnumInterface;
	export const orderTransferOnInvoiceDatatype: X3EnumDataType<keyof OrderTransferOnInvoice$EnumInterface, unknown>;
	//# sourceMappingURL=order-transfer-on-invoice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/order-line-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/order-line-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderLineTypeEnum {
	    normal = 1,
	    parentProductBom = 2,
	    subcontractService = 3,
	    suppliedMaterial = 4
	}
	export interface OrderLineType$EnumInterface {
	    normal: 1;
	    parentProductBom: 2;
	    subcontractService: 3;
	    suppliedMaterial: 4;
	}
	export type OrderLineType = keyof OrderLineType$EnumInterface;
	export const orderLineTypeDatatype: X3EnumDataType<keyof OrderLineType$EnumInterface, unknown>;
	//# sourceMappingURL=order-line-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/none-close-cancellation.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/none-close-cancellation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NoneCloseCancellationEnum {
	    none = 1,
	    close = 2,
	    cancel = 3
	}
	export interface NoneCloseCancellation$EnumInterface {
	    none: 1;
	    close: 2;
	    cancel: 3;
	}
	export type NoneCloseCancellation = keyof NoneCloseCancellation$EnumInterface;
	export const noneCloseCancellationDatatype: X3EnumDataType<keyof NoneCloseCancellation$EnumInterface, unknown>;
	//# sourceMappingURL=none-close-cancellation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/movement-category.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/movement-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MovementCategoryEnum {
	    standard = 1,
	    forSubcontracting = 2
	}
	export interface MovementCategory$EnumInterface {
	    standard: 1;
	    forSubcontracting: 2;
	}
	export type MovementCategory = keyof MovementCategory$EnumInterface;
	export const movementCategoryDatatype: X3EnumDataType<keyof MovementCategory$EnumInterface, unknown>;
	//# sourceMappingURL=movement-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/minimum-receipt-date.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/minimum-receipt-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MinimumReceiptDateEnum {
	    orderDate = 1,
	    orderDateLeadTime = 2
	}
	export interface MinimumReceiptDate$EnumInterface {
	    orderDate: 1;
	    orderDateLeadTime: 2;
	}
	export type MinimumReceiptDate = keyof MinimumReceiptDate$EnumInterface;
	export const minimumReceiptDateDatatype: X3EnumDataType<keyof MinimumReceiptDate$EnumInterface, unknown>;
	//# sourceMappingURL=minimum-receipt-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/journal-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/journal-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum JournalTypeEnum {
	    purchaseRequest = 1,
	    order = 2,
	    contract = 3,
	    all = 4
	}
	export interface JournalType$EnumInterface {
	    purchaseRequest: 1;
	    order: 2;
	    contract: 3;
	    all: 4;
	}
	export type JournalType = keyof JournalType$EnumInterface;
	export const journalTypeDatatype: X3EnumDataType<keyof JournalType$EnumInterface, unknown>;
	//# sourceMappingURL=journal-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/invoicing-element-import.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/invoicing-element-import' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicingElementImportEnum {
	    selfBalancing = 1,
	    control = 2
	}
	export interface InvoicingElementImport$EnumInterface {
	    selfBalancing: 1;
	    control: 2;
	}
	export type InvoicingElementImport = keyof InvoicingElementImport$EnumInterface;
	export const invoicingElementImportDatatype: X3EnumDataType<keyof InvoicingElementImport$EnumInterface, unknown>;
	//# sourceMappingURL=invoicing-element-import.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/invoiceable-quantity.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/invoiceable-quantity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceableQuantityEnum {
	    qtyA = 1,
	    qtyAQ = 2,
	    qtyAQR = 3
	}
	export interface InvoiceableQuantity$EnumInterface {
	    qtyA: 1;
	    qtyAQ: 2;
	    qtyAQR: 3;
	}
	export type InvoiceableQuantity = keyof InvoiceableQuantity$EnumInterface;
	export const invoiceableQuantityDatatype: X3EnumDataType<keyof InvoiceableQuantity$EnumInterface, unknown>;
	//# sourceMappingURL=invoiceable-quantity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/invoice-price-adjustment.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/invoice-price-adjustment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicePriceAdjustmentEnum {
	    withoutApproximationCoefficient = 1,
	    withApproximationCoefficient = 2
	}
	export interface InvoicePriceAdjustment$EnumInterface {
	    withoutApproximationCoefficient: 1;
	    withApproximationCoefficient: 2;
	}
	export type InvoicePriceAdjustment = keyof InvoicePriceAdjustment$EnumInterface;
	export const invoicePriceAdjustmentDatatype: X3EnumDataType<keyof InvoicePriceAdjustment$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-price-adjustment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/invoice-price-adjustment-586.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/invoice-price-adjustment-586' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicePriceAdjustment586Enum {
	    withoutLandedCosts = 1,
	    withLandedCosts = 2
	}
	export interface InvoicePriceAdjustment586$EnumInterface {
	    withoutLandedCosts: 1;
	    withLandedCosts: 2;
	}
	export type InvoicePriceAdjustment586 = keyof InvoicePriceAdjustment586$EnumInterface;
	export const invoicePriceAdjustment586Datatype: X3EnumDataType<keyof InvoicePriceAdjustment586$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-price-adjustment-586.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/invoice-decommitment-date.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/invoice-decommitment-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceDecommitmentDateEnum {
	    commitmentDate = 1,
	    invoiceDate = 2
	}
	export interface InvoiceDecommitmentDate$EnumInterface {
	    commitmentDate: 1;
	    invoiceDate: 2;
	}
	export type InvoiceDecommitmentDate = keyof InvoiceDecommitmentDate$EnumInterface;
	export const invoiceDecommitmentDateDatatype: X3EnumDataType<keyof InvoiceDecommitmentDate$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-decommitment-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/invoice-currency-rate-date.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/invoice-currency-rate-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceCurrencyRateDateEnum {
	    accountingDate = 1,
	    supplierDate = 2
	}
	export interface InvoiceCurrencyRateDate$EnumInterface {
	    accountingDate: 1;
	    supplierDate: 2;
	}
	export type InvoiceCurrencyRateDate = keyof InvoiceCurrencyRateDate$EnumInterface;
	export const invoiceCurrencyRateDateDatatype: X3EnumDataType<keyof InvoiceCurrencyRateDate$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-currency-rate-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/inter-site-requirements.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/inter-site-requirements' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InterSiteRequirementsEnum {
	    byDefaultOnContracts1 = 1,
	    byDefaultOnContracts = 2
	}
	export interface InterSiteRequirements$EnumInterface {
	    byDefaultOnContracts1: 1;
	    byDefaultOnContracts: 2;
	}
	export type InterSiteRequirements = keyof InterSiteRequirements$EnumInterface;
	export const interSiteRequirementsDatatype: X3EnumDataType<keyof InterSiteRequirements$EnumInterface, unknown>;
	//# sourceMappingURL=inter-site-requirements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/index.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/index' {
	export * from '@sage/x3-purchasing-data/lib/enums/action-543';
	export * from '@sage/x3-purchasing-data/lib/enums/action';
	export * from '@sage/x3-purchasing-data/lib/enums/allocation-545';
	export * from '@sage/x3-purchasing-data/lib/enums/allocation-enum';
	export * from '@sage/x3-purchasing-data/lib/enums/amount-type-2504';
	export * from '@sage/x3-purchasing-data/lib/enums/bid-type';
	export * from '@sage/x3-purchasing-data/lib/enums/bid';
	export * from '@sage/x3-purchasing-data/lib/enums/calculation-base';
	export * from '@sage/x3-purchasing-data/lib/enums/calculation-of-taxes';
	export * from '@sage/x3-purchasing-data/lib/enums/choice';
	export * from '@sage/x3-purchasing-data/lib/enums/close-order-line';
	export * from '@sage/x3-purchasing-data/lib/enums/closed-not-closed-all';
	export * from '@sage/x3-purchasing-data/lib/enums/commitment-date';
	export * from '@sage/x3-purchasing-data/lib/enums/commitment-type';
	export * from '@sage/x3-purchasing-data/lib/enums/conflict';
	export * from '@sage/x3-purchasing-data/lib/enums/contract-product-selection';
	export * from '@sage/x3-purchasing-data/lib/enums/control-of-invoices-to-be-received';
	export * from '@sage/x3-purchasing-data/lib/enums/control-type-549';
	export * from '@sage/x3-purchasing-data/lib/enums/control';
	export * from '@sage/x3-purchasing-data/lib/enums/cost-loading-order-rcpt';
	export * from '@sage/x3-purchasing-data/lib/enums/crystal-reports-purchasing';
	export * from '@sage/x3-purchasing-data/lib/enums/currency-rate-search-date';
	export * from '@sage/x3-purchasing-data/lib/enums/customer-product-referencing';
	export * from '@sage/x3-purchasing-data/lib/enums/document-origin';
	export * from '@sage/x3-purchasing-data/lib/enums/document-type-for-seq-number';
	export * from '@sage/x3-purchasing-data/lib/enums/due-date-calculation-base';
	export * from '@sage/x3-purchasing-data/lib/enums/eo-estimated-cost-calc';
	export * from '@sage/x3-purchasing-data/lib/enums/eo-management-mode';
	export * from '@sage/x3-purchasing-data/lib/enums/eomupd-selection';
	export * from '@sage/x3-purchasing-data/lib/enums/gap-calculation-source';
	export * from '@sage/x3-purchasing-data/lib/enums/generation-type';
	export * from '@sage/x3-purchasing-data/lib/enums/inter-site-requirements';
	export * from '@sage/x3-purchasing-data/lib/enums/invoice-currency-rate-date';
	export * from '@sage/x3-purchasing-data/lib/enums/invoice-decommitment-date';
	export * from '@sage/x3-purchasing-data/lib/enums/invoice-price-adjustment-586';
	export * from '@sage/x3-purchasing-data/lib/enums/invoice-price-adjustment';
	export * from '@sage/x3-purchasing-data/lib/enums/invoiceable-quantity';
	export * from '@sage/x3-purchasing-data/lib/enums/invoicing-element-import';
	export * from '@sage/x3-purchasing-data/lib/enums/journal-type';
	export * from '@sage/x3-purchasing-data/lib/enums/minimum-receipt-date';
	export * from '@sage/x3-purchasing-data/lib/enums/movement-category';
	export * from '@sage/x3-purchasing-data/lib/enums/none-close-cancellation';
	export * from '@sage/x3-purchasing-data/lib/enums/order-line-type';
	export * from '@sage/x3-purchasing-data/lib/enums/order-transfer-on-invoice';
	export * from '@sage/x3-purchasing-data/lib/enums/order-type-529';
	export * from '@sage/x3-purchasing-data/lib/enums/ordered-quantity-control';
	export * from '@sage/x3-purchasing-data/lib/enums/precommitment-update';
	export * from '@sage/x3-purchasing-data/lib/enums/process-type-526';
	export * from '@sage/x3-purchasing-data/lib/enums/product-reference-entry-format';
	export * from '@sage/x3-purchasing-data/lib/enums/product-supplier-referencing';
	export * from '@sage/x3-purchasing-data/lib/enums/products-to-be-processed';
	export * from '@sage/x3-purchasing-data/lib/enums/provisional-cost-type-2505';
	export * from '@sage/x3-purchasing-data/lib/enums/purchase-document-type';
	export * from '@sage/x3-purchasing-data/lib/enums/purchase-invoice-3-way-match';
	export * from '@sage/x3-purchasing-data/lib/enums/purchase-price-reason-enum';
	export * from '@sage/x3-purchasing-data/lib/enums/purchase-request-line-value';
	export * from '@sage/x3-purchasing-data/lib/enums/purchase-sort-order-2502';
	export * from '@sage/x3-purchasing-data/lib/enums/purchase-sort-order';
	export * from '@sage/x3-purchasing-data/lib/enums/purchase-type-507';
	export * from '@sage/x3-purchasing-data/lib/enums/quantity-entry-mode-541';
	export * from '@sage/x3-purchasing-data/lib/enums/quantity-entry-mode';
	export * from '@sage/x3-purchasing-data/lib/enums/quantity-status';
	export * from '@sage/x3-purchasing-data/lib/enums/re-instatement-on-order';
	export * from '@sage/x3-purchasing-data/lib/enums/receipt-on-order-line';
	export * from '@sage/x3-purchasing-data/lib/enums/receipt-quantity-conversion';
	export * from '@sage/x3-purchasing-data/lib/enums/request-source';
	export * from '@sage/x3-purchasing-data/lib/enums/requirements-selection';
	export * from '@sage/x3-purchasing-data/lib/enums/return-reason';
	export * from '@sage/x3-purchasing-data/lib/enums/revision-param-menu';
	export * from '@sage/x3-purchasing-data/lib/enums/rounding-type';
	export * from '@sage/x3-purchasing-data/lib/enums/selection-of-requirements';
	export * from '@sage/x3-purchasing-data/lib/enums/shipment-management';
	export * from '@sage/x3-purchasing-data/lib/enums/shipment-record-type';
	export * from '@sage/x3-purchasing-data/lib/enums/shipment-status';
	export * from '@sage/x3-purchasing-data/lib/enums/signature-531';
	export * from '@sage/x3-purchasing-data/lib/enums/signature-rule-type';
	export * from '@sage/x3-purchasing-data/lib/enums/sort-order-2409';
	export * from '@sage/x3-purchasing-data/lib/enums/sort-order-2410';
	export * from '@sage/x3-purchasing-data/lib/enums/start-end-of-line';
	export * from '@sage/x3-purchasing-data/lib/enums/status';
	export * from '@sage/x3-purchasing-data/lib/enums/sub-contract-requirements';
	export * from '@sage/x3-purchasing-data/lib/enums/subcontract-cost-type';
	export * from '@sage/x3-purchasing-data/lib/enums/substitute-signers';
	export * from '@sage/x3-purchasing-data/lib/enums/suggestion-consumption';
	export * from '@sage/x3-purchasing-data/lib/enums/supplier-grading-scale';
	export * from '@sage/x3-purchasing-data/lib/enums/supplier-information-type';
	export * from '@sage/x3-purchasing-data/lib/enums/supplier-invoice';
	export * from '@sage/x3-purchasing-data/lib/enums/supplier-movement-type';
	export * from '@sage/x3-purchasing-data/lib/enums/supplier-selection-criterion';
	export * from '@sage/x3-purchasing-data/lib/enums/supplier-source';
	export * from '@sage/x3-purchasing-data/lib/enums/supplier-type';
	export * from '@sage/x3-purchasing-data/lib/enums/tax-code-control';
	export * from '@sage/x3-purchasing-data/lib/enums/tax-rule-538';
	export * from '@sage/x3-purchasing-data/lib/enums/tracking-of-the-supplier-text';
	export * from '@sage/x3-purchasing-data/lib/enums/tracking-step-status';
	export * from '@sage/x3-purchasing-data/lib/enums/transfer-of-order-to-invoice';
	export * from '@sage/x3-purchasing-data/lib/enums/transport-mode';
	export * from '@sage/x3-purchasing-data/lib/enums/transport-selection';
	export * from '@sage/x3-purchasing-data/lib/enums/type-of-document-544';
	export * from '@sage/x3-purchasing-data/lib/enums/use-p-req-line-text';
	export * from '@sage/x3-purchasing-data/lib/enums/user-for-quotation';
	export * from '@sage/x3-purchasing-data/lib/enums/variance-calculation-source-2403';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/generation-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/generation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GenerationTypeEnum {
	    actual = 1,
	    simulation = 2
	}
	export interface GenerationType$EnumInterface {
	    actual: 1;
	    simulation: 2;
	}
	export type GenerationType = keyof GenerationType$EnumInterface;
	export const generationTypeDatatype: X3EnumDataType<keyof GenerationType$EnumInterface, unknown>;
	//# sourceMappingURL=generation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/gap-calculation-source.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/gap-calculation-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GapCalculationSourceEnum {
	    standardData = 1,
	    osData = 2
	}
	export interface GapCalculationSource$EnumInterface {
	    standardData: 1;
	    osData: 2;
	}
	export type GapCalculationSource = keyof GapCalculationSource$EnumInterface;
	export const gapCalculationSourceDatatype: X3EnumDataType<keyof GapCalculationSource$EnumInterface, unknown>;
	//# sourceMappingURL=gap-calculation-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/eomupd-selection.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/eomupd-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EomupdSelectionEnum {
	    noUpdate = 1,
	    service = 2,
	    bom = 3,
	    serviceAndBom = 4
	}
	export interface EomupdSelection$EnumInterface {
	    noUpdate: 1;
	    service: 2;
	    bom: 3;
	    serviceAndBom: 4;
	}
	export type EomupdSelection = keyof EomupdSelection$EnumInterface;
	export const eomupdSelectionDatatype: X3EnumDataType<keyof EomupdSelection$EnumInterface, unknown>;
	//# sourceMappingURL=eomupd-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/eo-management-mode.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/eo-management-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EoManagementModeEnum {
	    noModification = 1,
	    materialModification = 2,
	    serviceModification = 3,
	    materialAndServiceModification = 4
	}
	export interface EoManagementMode$EnumInterface {
	    noModification: 1;
	    materialModification: 2;
	    serviceModification: 3;
	    materialAndServiceModification: 4;
	}
	export type EoManagementMode = keyof EoManagementMode$EnumInterface;
	export const eoManagementModeDatatype: X3EnumDataType<keyof EoManagementMode$EnumInterface, unknown>;
	//# sourceMappingURL=eo-management-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/eo-estimated-cost-calc.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/eo-estimated-cost-calc' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EoEstimatedCostCalcEnum {
	    no = 1,
	    inEoCreation = 2,
	    inEoCreationAndModification = 3
	}
	export interface EoEstimatedCostCalc$EnumInterface {
	    no: 1;
	    inEoCreation: 2;
	    inEoCreationAndModification: 3;
	}
	export type EoEstimatedCostCalc = keyof EoEstimatedCostCalc$EnumInterface;
	export const eoEstimatedCostCalcDatatype: X3EnumDataType<keyof EoEstimatedCostCalc$EnumInterface, unknown>;
	//# sourceMappingURL=eo-estimated-cost-calc.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/due-date-calculation-base.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/due-date-calculation-base' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DueDateCalculationBaseEnum {
	    receiptDate = 1,
	    invoiceDate = 2
	}
	export interface DueDateCalculationBase$EnumInterface {
	    receiptDate: 1;
	    invoiceDate: 2;
	}
	export type DueDateCalculationBase = keyof DueDateCalculationBase$EnumInterface;
	export const dueDateCalculationBaseDatatype: X3EnumDataType<keyof DueDateCalculationBase$EnumInterface, unknown>;
	//# sourceMappingURL=due-date-calculation-base.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/document-type-for-seq-number.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/document-type-for-seq-number' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentTypeForSeqNumberEnum {
	    rfq = 1,
	    purchaseRequest = 2,
	    standardOrder = 3,
	    subcontractedOrder = 4,
	    contract = 5,
	    receipt = 6,
	    return = 7,
	    invoice = 8,
	    additionalInvoice = 9,
	    creditNote = 10,
	    creditNoteOnReturn = 11,
	    priceRecord = 12,
	    intersiteReceipt = 13,
	    intersiteReturn = 14,
	    subcontractOrder = 15,
	    container = 16,
	    transport = 17,
	    shipment = 18
	}
	export interface DocumentTypeForSeqNumber$EnumInterface {
	    rfq: 1;
	    purchaseRequest: 2;
	    standardOrder: 3;
	    subcontractedOrder: 4;
	    contract: 5;
	    receipt: 6;
	    return: 7;
	    invoice: 8;
	    additionalInvoice: 9;
	    creditNote: 10;
	    creditNoteOnReturn: 11;
	    priceRecord: 12;
	    intersiteReceipt: 13;
	    intersiteReturn: 14;
	    subcontractOrder: 15;
	    container: 16;
	    transport: 17;
	    shipment: 18;
	}
	export type DocumentTypeForSeqNumber = keyof DocumentTypeForSeqNumber$EnumInterface;
	export const documentTypeForSeqNumberDatatype: X3EnumDataType<keyof DocumentTypeForSeqNumber$EnumInterface, unknown>;
	//# sourceMappingURL=document-type-for-seq-number.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/document-origin.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/document-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentOriginEnum {
	    notApplicable = 1,
	    air = 2,
	    sea = 3,
	    road = 4,
	    rail = 5
	}
	export interface DocumentOrigin$EnumInterface {
	    notApplicable: 1;
	    air: 2;
	    sea: 3;
	    road: 4;
	    rail: 5;
	}
	export type DocumentOrigin = keyof DocumentOrigin$EnumInterface;
	export const documentOriginDatatype: X3EnumDataType<keyof DocumentOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=document-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/customer-product-referencing.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/customer-product-referencing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomerProductReferencingEnum {
	    mandatory = 1,
	    optional = 2,
	    useless = 3
	}
	export interface CustomerProductReferencing$EnumInterface {
	    mandatory: 1;
	    optional: 2;
	    useless: 3;
	}
	export type CustomerProductReferencing = keyof CustomerProductReferencing$EnumInterface;
	export const customerProductReferencingDatatype: X3EnumDataType<keyof CustomerProductReferencing$EnumInterface, unknown>;
	//# sourceMappingURL=customer-product-referencing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/currency-rate-search-date.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/currency-rate-search-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CurrencyRateSearchDateEnum {
	    orderDate = 1,
	    receiptDate = 2,
	    invoiceDate = 3
	}
	export interface CurrencyRateSearchDate$EnumInterface {
	    orderDate: 1;
	    receiptDate: 2;
	    invoiceDate: 3;
	}
	export type CurrencyRateSearchDate = keyof CurrencyRateSearchDate$EnumInterface;
	export const currencyRateSearchDateDatatype: X3EnumDataType<keyof CurrencyRateSearchDate$EnumInterface, unknown>;
	//# sourceMappingURL=currency-rate-search-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/crystal-reports-purchasing.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/crystal-reports-purchasing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportsPurchasingEnum {
	    upTo = 1,
	    startingFrom = 2,
	    from = 3,
	    to = 4,
	    price = 5,
	    quantity = 6,
	    purchaseOrder = 7,
	    supplier = 8,
	    receivingSite9 = 9,
	    addressCode10 = 10,
	    supplierReference = 11,
	    description = 12,
	    receiptDate = 13,
	    orderedQuantity = 14,
	    shipmentMode = 15,
	    paymentTerm = 16,
	    netPrice = 17,
	    taxExcludedAmount = 18,
	    consumptionPoint = 19,
	    returnNote = 20,
	    authorizationNumber = 21,
	    returnedQuantity = 22,
	    supplierLot = 23,
	    serialNumber = 24,
	    pendingCreditMemo = 25,
	    blanketOrder = 26,
	    validityDate = 27,
	    validityEnd = 28,
	    currency = 29,
	    payment = 30,
	    supplierProduct = 31,
	    receivingSite = 32,
	    addressCode = 33,
	    purQuantity = 34,
	    site = 35,
	    address = 36,
	    productTaxExcluded = 37,
	    totalTaxExcluded = 38,
	    totalTax = 39,
	    netToPay = 40,
	    vatBasis = 41,
	    rate = 42,
	    taxAmount = 43,
	    totalTaxInc = 44,
	    toDateTheFollowingCallsForTendersAboutWhichYouHaveBeenConsulted = 45,
	    didNotLeadToAnyCommercialPropositionOnYourBehalf = 46,
	    weHopeWeWillBeReceivingYourOfferAsSoonAsPossible = 47,
	    purchasingDepartment = 48,
	    theFollowingItemsThoughTheyShouldHaveArrivedAtTheMentionedDatesHaveNotBeenDeliveredYet = 49,
	    weHopeThatYouWillSendUsTheseItemsAsSoonAsPossible = 50,
	    callForTender = 51,
	    leadTime = 52,
	    responseEndDate = 53,
	    deliveryCallOff = 54,
	    requestForProposalReminder = 55,
	    receipt = 56,
	    expectedQuantity = 57,
	    reminder = 58,
	    startingSerialNumber = 59,
	    qty = 60
	}
	export interface CrystalReportsPurchasing$EnumInterface {
	    upTo: 1;
	    startingFrom: 2;
	    from: 3;
	    to: 4;
	    price: 5;
	    quantity: 6;
	    purchaseOrder: 7;
	    supplier: 8;
	    receivingSite9: 9;
	    addressCode10: 10;
	    supplierReference: 11;
	    description: 12;
	    receiptDate: 13;
	    orderedQuantity: 14;
	    shipmentMode: 15;
	    paymentTerm: 16;
	    netPrice: 17;
	    taxExcludedAmount: 18;
	    consumptionPoint: 19;
	    returnNote: 20;
	    authorizationNumber: 21;
	    returnedQuantity: 22;
	    supplierLot: 23;
	    serialNumber: 24;
	    pendingCreditMemo: 25;
	    blanketOrder: 26;
	    validityDate: 27;
	    validityEnd: 28;
	    currency: 29;
	    payment: 30;
	    supplierProduct: 31;
	    receivingSite: 32;
	    addressCode: 33;
	    purQuantity: 34;
	    site: 35;
	    address: 36;
	    productTaxExcluded: 37;
	    totalTaxExcluded: 38;
	    totalTax: 39;
	    netToPay: 40;
	    vatBasis: 41;
	    rate: 42;
	    taxAmount: 43;
	    totalTaxInc: 44;
	    toDateTheFollowingCallsForTendersAboutWhichYouHaveBeenConsulted: 45;
	    didNotLeadToAnyCommercialPropositionOnYourBehalf: 46;
	    weHopeWeWillBeReceivingYourOfferAsSoonAsPossible: 47;
	    purchasingDepartment: 48;
	    theFollowingItemsThoughTheyShouldHaveArrivedAtTheMentionedDatesHaveNotBeenDeliveredYet: 49;
	    weHopeThatYouWillSendUsTheseItemsAsSoonAsPossible: 50;
	    callForTender: 51;
	    leadTime: 52;
	    responseEndDate: 53;
	    deliveryCallOff: 54;
	    requestForProposalReminder: 55;
	    receipt: 56;
	    expectedQuantity: 57;
	    reminder: 58;
	    startingSerialNumber: 59;
	    qty: 60;
	}
	export type CrystalReportsPurchasing = keyof CrystalReportsPurchasing$EnumInterface;
	export const crystalReportsPurchasingDatatype: X3EnumDataType<keyof CrystalReportsPurchasing$EnumInterface, unknown>;
	//# sourceMappingURL=crystal-reports-purchasing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/cost-loading-order-rcpt.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/cost-loading-order-rcpt' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostLoadingOrderRcptEnum {
	    basedOnCalculation = 1,
	    basedOnProRata = 2
	}
	export interface CostLoadingOrderRcpt$EnumInterface {
	    basedOnCalculation: 1;
	    basedOnProRata: 2;
	}
	export type CostLoadingOrderRcpt = keyof CostLoadingOrderRcpt$EnumInterface;
	export const costLoadingOrderRcptDatatype: X3EnumDataType<keyof CostLoadingOrderRcpt$EnumInterface, unknown>;
	//# sourceMappingURL=cost-loading-order-rcpt.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/control.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlEnum {
	    control = 1,
	    noControl = 2
	}
	export interface Control$EnumInterface {
	    control: 1;
	    noControl: 2;
	}
	export type Control = keyof Control$EnumInterface;
	export const controlDatatype: X3EnumDataType<keyof Control$EnumInterface, unknown>;
	//# sourceMappingURL=control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/control-type-549.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/control-type-549' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlType549Enum {
	    notBlocking = 1,
	    blocking = 2
	}
	export interface ControlType549$EnumInterface {
	    notBlocking: 1;
	    blocking: 2;
	}
	export type ControlType549 = keyof ControlType549$EnumInterface;
	export const controlType549Datatype: X3EnumDataType<keyof ControlType549$EnumInterface, unknown>;
	//# sourceMappingURL=control-type-549.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/control-of-invoices-to-be-received.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/control-of-invoices-to-be-received' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlOfInvoicesToBeReceivedEnum {
	    blockingByPeriod = 1,
	    blockingByFiscalYear = 2,
	    nonBlocking = 3
	}
	export interface ControlOfInvoicesToBeReceived$EnumInterface {
	    blockingByPeriod: 1;
	    blockingByFiscalYear: 2;
	    nonBlocking: 3;
	}
	export type ControlOfInvoicesToBeReceived = keyof ControlOfInvoicesToBeReceived$EnumInterface;
	export const controlOfInvoicesToBeReceivedDatatype: X3EnumDataType<keyof ControlOfInvoicesToBeReceived$EnumInterface, unknown>;
	//# sourceMappingURL=control-of-invoices-to-be-received.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/contract-product-selection.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/contract-product-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContractProductSelectionEnum {
	    next = 1,
	    previous = 2,
	    first = 3,
	    last = 4,
	    addLine = 5,
	    cancelLine = 6
	}
	export interface ContractProductSelection$EnumInterface {
	    next: 1;
	    previous: 2;
	    first: 3;
	    last: 4;
	    addLine: 5;
	    cancelLine: 6;
	}
	export type ContractProductSelection = keyof ContractProductSelection$EnumInterface;
	export const contractProductSelectionDatatype: X3EnumDataType<keyof ContractProductSelection$EnumInterface, unknown>;
	//# sourceMappingURL=contract-product-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/conflict.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/conflict' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConflictEnum {
	    no = 1,
	    warning = 2,
	    hold = 3
	}
	export interface Conflict$EnumInterface {
	    no: 1;
	    warning: 2;
	    hold: 3;
	}
	export type Conflict = keyof Conflict$EnumInterface;
	export const conflictDatatype: X3EnumDataType<keyof Conflict$EnumInterface, unknown>;
	//# sourceMappingURL=conflict.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/commitment-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/commitment-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CommitmentTypeEnum {
	    taxExclAmount = 1,
	    taxExclAmountNonDeductibleVat = 2
	}
	export interface CommitmentType$EnumInterface {
	    taxExclAmount: 1;
	    taxExclAmountNonDeductibleVat: 2;
	}
	export type CommitmentType = keyof CommitmentType$EnumInterface;
	export const commitmentTypeDatatype: X3EnumDataType<keyof CommitmentType$EnumInterface, unknown>;
	//# sourceMappingURL=commitment-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/commitment-date.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/commitment-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CommitmentDateEnum {
	    orderDate = 1,
	    requestedDeliveryDate = 2
	}
	export interface CommitmentDate$EnumInterface {
	    orderDate: 1;
	    requestedDeliveryDate: 2;
	}
	export type CommitmentDate = keyof CommitmentDate$EnumInterface;
	export const commitmentDateDatatype: X3EnumDataType<keyof CommitmentDate$EnumInterface, unknown>;
	//# sourceMappingURL=commitment-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/closed-not-closed-all.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/closed-not-closed-all' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ClosedNotClosedAllEnum {
	    open = 1,
	    closed = 2,
	    all = 3
	}
	export interface ClosedNotClosedAll$EnumInterface {
	    open: 1;
	    closed: 2;
	    all: 3;
	}
	export type ClosedNotClosedAll = keyof ClosedNotClosedAll$EnumInterface;
	export const closedNotClosedAllDatatype: X3EnumDataType<keyof ClosedNotClosedAll$EnumInterface, unknown>;
	//# sourceMappingURL=closed-not-closed-all.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/close-order-line.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/close-order-line' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CloseOrderLineEnum {
	    ifEqualOrGreaterThan = 1,
	    perRequest = 2,
	    never = 3,
	    byTolerance = 4,
	    byToleranceAndOnRequest = 5
	}
	export interface CloseOrderLine$EnumInterface {
	    ifEqualOrGreaterThan: 1;
	    perRequest: 2;
	    never: 3;
	    byTolerance: 4;
	    byToleranceAndOnRequest: 5;
	}
	export type CloseOrderLine = keyof CloseOrderLine$EnumInterface;
	export const closeOrderLineDatatype: X3EnumDataType<keyof CloseOrderLine$EnumInterface, unknown>;
	//# sourceMappingURL=close-order-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/choice.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/choice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChoiceEnum {
	    no = 1,
	    yes = 2,
	    all = 3
	}
	export interface Choice$EnumInterface {
	    no: 1;
	    yes: 2;
	    all: 3;
	}
	export type Choice = keyof Choice$EnumInterface;
	export const choiceDatatype: X3EnumDataType<keyof Choice$EnumInterface, unknown>;
	//# sourceMappingURL=choice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/calculation-of-taxes.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/calculation-of-taxes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalculationOfTaxesEnum {
	    lineOnly = 1,
	    taxBasis = 2
	}
	export interface CalculationOfTaxes$EnumInterface {
	    lineOnly: 1;
	    taxBasis: 2;
	}
	export type CalculationOfTaxes = keyof CalculationOfTaxes$EnumInterface;
	export const calculationOfTaxesDatatype: X3EnumDataType<keyof CalculationOfTaxes$EnumInterface, unknown>;
	//# sourceMappingURL=calculation-of-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/calculation-base.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/calculation-base' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalculationBaseEnum {
	    none = 1,
	    excludeTaxAmount = 2,
	    includeTaxAmount = 3,
	    action = 4
	}
	export interface CalculationBase$EnumInterface {
	    none: 1;
	    excludeTaxAmount: 2;
	    includeTaxAmount: 3;
	    action: 4;
	}
	export type CalculationBase = keyof CalculationBase$EnumInterface;
	export const calculationBaseDatatype: X3EnumDataType<keyof CalculationBase$EnumInterface, unknown>;
	//# sourceMappingURL=calculation-base.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/bid.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/bid' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BidEnum {
	    bidEnd = 1,
	    hierarchy = 2,
	    parallel = 3
	}
	export interface Bid$EnumInterface {
	    bidEnd: 1;
	    hierarchy: 2;
	    parallel: 3;
	}
	export type Bid = keyof Bid$EnumInterface;
	export const bidDatatype: X3EnumDataType<keyof Bid$EnumInterface, unknown>;
	//# sourceMappingURL=bid.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/bid-type.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/bid-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BidTypeEnum {
	    mixed = 1,
	    hierarchy = 2,
	    parallel = 3
	}
	export interface BidType$EnumInterface {
	    mixed: 1;
	    hierarchy: 2;
	    parallel: 3;
	}
	export type BidType = keyof BidType$EnumInterface;
	export const bidTypeDatatype: X3EnumDataType<keyof BidType$EnumInterface, unknown>;
	//# sourceMappingURL=bid-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/amount-type-2504.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/amount-type-2504' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AmountType2504Enum {
	    adjusted = 1,
	    calculated = 2
	}
	export interface AmountType2504$EnumInterface {
	    adjusted: 1;
	    calculated: 2;
	}
	export type AmountType2504 = keyof AmountType2504$EnumInterface;
	export const amountType2504Datatype: X3EnumDataType<keyof AmountType2504$EnumInterface, unknown>;
	//# sourceMappingURL=amount-type-2504.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/allocation-enum.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/allocation-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationEnumEnum {
	    no = 1,
	    quantityProRata = 2,
	    amountProRata = 3,
	    weightProRata = 4,
	    volumeProRata = 5
	}
	export interface AllocationEnum$EnumInterface {
	    no: 1;
	    quantityProRata: 2;
	    amountProRata: 3;
	    weightProRata: 4;
	    volumeProRata: 5;
	}
	export type AllocationEnum = keyof AllocationEnum$EnumInterface;
	export const allocationEnumDatatype: X3EnumDataType<keyof AllocationEnum$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/allocation-545.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/allocation-545' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Allocation545Enum {
	    quantityProRata = 1,
	    amountProRata = 2,
	    weightProRata = 3,
	    volumeProRata = 4
	}
	export interface Allocation545$EnumInterface {
	    quantityProRata: 1;
	    amountProRata: 2;
	    weightProRata: 3;
	    volumeProRata: 4;
	}
	export type Allocation545 = keyof Allocation545$EnumInterface;
	export const allocation545Datatype: X3EnumDataType<keyof Allocation545$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-545.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/action.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/action' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionEnum {
	    none = 1,
	    signature = 2,
	    refusal = 3,
	    totalRefusal = 4
	}
	export interface Action$EnumInterface {
	    none: 1;
	    signature: 2;
	    refusal: 3;
	    totalRefusal: 4;
	}
	export type Action = keyof Action$EnumInterface;
	export const actionDatatype: X3EnumDataType<keyof Action$EnumInterface, unknown>;
	//# sourceMappingURL=action.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-purchasing-data/build/lib/enums/action-543.d.ts
declare module '@sage/x3-purchasing-data/lib/enums/action-543' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Action543Enum {
	    takeIntoAccount = 1,
	    cancel = 2
	}
	export interface Action543$EnumInterface {
	    takeIntoAccount: 1;
	    cancel: 2;
	}
	export type Action543 = keyof Action543$EnumInterface;
	export const action543Datatype: X3EnumDataType<keyof Action543$EnumInterface, unknown>;
	//# sourceMappingURL=action-543.d.ts.map
}
declare module '@sage/x3-purchasing-data' {
	export * from '@sage/x3-purchasing-data/index';
}
