"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransportLeadTime = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3PurchasingData = require("..");
const joins = {
    referenceJoins: {
        placeStart: {
            code: 'placeStart',
        },
        placeArrival: {
            code: 'placeArrival',
        },
        carrier: {
            code: 'carrier',
        },
    },
};
let TransportLeadTime = class TransportLeadTime extends xtrem_core_1.Node {
};
exports.TransportLeadTime = TransportLeadTime;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DPETPC',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.TransitArea,
    })
], TransportLeadTime.prototype, "placeStart", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ARVTPC',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.TransitArea,
    })
], TransportLeadTime.prototype, "placeArrival", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRNTPC',
        dataType: () => sageX3PurchasingData.enums.transportModeDatatype,
    })
], TransportLeadTime.prototype, "transportMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPTNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], TransportLeadTime.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LTITPC',
    })
], TransportLeadTime.prototype, "releaseTime", void 0);
exports.TransportLeadTime = TransportLeadTime = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'TABPLACETIME',
        keyPropertyNames: ['placeStart', 'placeArrival', 'transportMode', 'carrier'],
        indexes: [
            {
                orderBy: {
                    placeStart: 1,
                    placeArrival: 1,
                    transportMode: 1,
                    carrier: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['transportMode', 'carrier'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], TransportLeadTime);
//# sourceMappingURL=transport-lead-time.js.map