/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_config_1=require("@sage/xtrem-config"),xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),lib_1=require("../../../lib"),sql_query_1=require("../../../lib/sql-mapper/sql-query"),nodes_1=require("../../fixtures/nodes"),denormalized_with_reference_1=require("../../fixtures/nodes/denormalized-with-reference"),document_1=require("../../fixtures/nodes/document"),document_line_with_enum_ref_1=require("../../fixtures/nodes/document-line-with-enum-ref"),test_syracuse_method_1=require("../../fixtures/nodes/test-syracuse-method"),setup_1=require("../../fixtures/setup");function test(A,T,_,C,N,E){it(`${A} - ${_}`,async()=>{const A={response:{locals:{config:{x3:{sql:{driver:_,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com"}}}}}};await xtrem_core_1.Test.withContext(A=>{xtrem_config_1.ConfigManager.current.x3.sql.driver=_;const O=A.application.getFactoryByConstructor(N),D=new sql_query_1.SqlQuery(A,O,{filters:[T],singleResultRequest:E?.singleResultRequest,orderBy:E?.orderBy,selector:E?.selector},"REPOSX3").getSqlQuery();chai_1.assert.equal(D.trim(),C.trim())},{config:A})})}describe("SQL Tests",()=>{before(setup_1.setupTest),["oracle","tedious"].forEach(A=>{describe(`SQL Query Generation - ${A}`,()=>{test("full table query",{},A,"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE 1=1    ",nodes_1.TestDatatypes)}),describe("sql computed property",()=>{test("computed property logical test",{_or:[{computed:11},{computed:12}]},A,"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE ((t0.ID_0 * t0.CVAL_0) = 11 OR (t0.ID_0 * t0.CVAL_0) = 12)    ",nodes_1.TestDatatypes),test("computed property where clause",{computed:1},A,"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (t0.ID_0 * t0.CVAL_0) = 1    ",nodes_1.TestDatatypes),it(`can order by computed property - ${A}`,async()=>{const T={response:{locals:{config:{x3:{sql:{driver:A,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com"}}}}}};await xtrem_core_1.Test.withContext(T=>{const _=T.application.getFactoryByConstructor(nodes_1.TestDatatypes),C=new sql_query_1.SqlQuery(T,_,{orderBy:{computed:-1},filters:[]},"REPOSX3").getSqlQuery();chai_1.assert.equal(C.trim(),"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, (t0.ID_0 * t0.CVAL_0) AS THIS_COMPUTED FROM REPOSX3.TESTDAT t0 WHERE 1=1  ORDER BY THIS_COMPUTED DESC"+("oracle"===A?" NULLS LAST":""))},{config:T})})}),describe("convert null value to one space string in joins with function",()=>{test("can convert a null value to a single space string in joins with function",{reference:{code:1}},A,"SELECT  t0.COD_0 AS T_0_COD_0, t0.REF_0 AS T_0_REF_0, t0.REFNOJOIN_0 AS T_0_REFNOJOIN_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REF_0 AND t1.DES3AEX_0 = ' ' WHERE t1.COD_0 = '1'",nodes_1.TestReferencing)}),describe("reference property without a join provide",()=>{test("can have a reference with an omitted join, provided that the target node has only one key property",{referenceNoJoin:{code:1}},A,"SELECT  t0.COD_0 AS T_0_COD_0, t0.REF_0 AS T_0_REF_0, t0.REFNOJOIN_0 AS T_0_REFNOJOIN_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REFNOJOIN_0 WHERE t1.COD_0 = '1'",nodes_1.TestReferencing)}),describe("sql predicate regex",()=>{test("regex (not anchored)",{stringVal:/ring/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'ring','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%ring%' escape '$'    ",nodes_1.TestDatatypes),test("regex with i option",{stringVal:{_regex:"Ring",_options:"i"}},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'Ring','i')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CI_AS LIKE '%Ring%' escape '$'    ",nodes_1.TestDatatypes),test("regex without i option",{stringVal:{_regex:"Ring"}},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'Ring','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%Ring%' escape '$'    ",nodes_1.TestDatatypes),test("regex (anchored at start, matching)",{stringVal:/^string/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'^string','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE 'string%' escape '$'    ",nodes_1.TestDatatypes),test("regex (anchored at start, not matching)",{stringVal:/^ring/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'^ring','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE 'ring%' escape '$'    ",nodes_1.TestDatatypes),test("regex (anchored at end, not matching)",{stringVal:/1$/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'1$','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%1' escape '$'    ",nodes_1.TestDatatypes),test("regex . pattern (matching)",{stringVal:/tr..g/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'tr..g','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%tr__g%' escape '$'    ",nodes_1.TestDatatypes),test("regex . pattern (not matching)",{stringVal:/t..g/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'t..g','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%t__g%' escape '$'    ",nodes_1.TestDatatypes),test("regex .* pattern (matching multiple)",{stringVal:/t.*g/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'t.*g','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%t%g%' escape '$'    ",nodes_1.TestDatatypes),test("regex .* pattern (matching 1)",{stringVal:/tri.*g/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'tri.*g','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%tri%g%' escape '$'    ",nodes_1.TestDatatypes),test("regex .* pattern (matching empty)",{stringVal:/trin.*g/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'trin.*g','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%trin%g%' escape '$'    ",nodes_1.TestDatatypes),test("regex .* pattern (anchored and matching at start)",{stringVal:/^.*trin/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'^.*trin','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%trin%' escape '$'    ",nodes_1.TestDatatypes),test("regex .* pattern (not anchored and matching at start)",{stringVal:/.*trin/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'.*trin','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%%trin%' escape '$'    ",nodes_1.TestDatatypes),test("regex .* pattern (anchored and matching at end)",{stringVal:/tring...1.*$/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'tring...1.*$','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%tring___1%' escape '$'    ",nodes_1.TestDatatypes),test("regex .* pattern (not anchored and matching at end)",{stringVal:/tring...1.*/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'tring...1.*','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%tring___1%%' escape '$'    ",nodes_1.TestDatatypes),test("regex containing % (matching)",{stringVal:/tring%/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'tring%','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%tring$%%' escape '$'    ",nodes_1.TestDatatypes),test("regex containing % (not matching)",{stringVal:/t%g/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'t%g','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%t$%g%' escape '$'    ",nodes_1.TestDatatypes),test("regex containing _ (matching)",{stringVal:/tring._/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'tring._','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%tring_$_%' escape '$'    ",nodes_1.TestDatatypes),test("regex containing _ (not matching)",{stringVal:/tr_ng/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'tr_ng','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%tr$_ng%' escape '$'    ",nodes_1.TestDatatypes),test("regex containing $ (matching)",{stringVal:/tring..\$/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'tring..\\$','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%tring__$$%' escape '$'    ",nodes_1.TestDatatypes),test("regex containing $ (not matching)",{stringVal:/tr\$ng/},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),'tr\\$ng','')    ":"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE '%tr$$ng%' escape '$'    ",nodes_1.TestDatatypes),after(()=>{})}),describe("Collections and references",()=>{test("Query reference",{enumValRef:{code:"ENUMCODE"}},A,"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.ENUMVAL_0 AS T_0_ENUMVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.ENUMREF t1 ON t1.COD_0 = t0.ENUMVAL_0 AND t1.ENUMVAL_0 = 1 WHERE t1.COD_0 = 'ENUMCODE'",document_line_with_enum_ref_1.TestDocumentLineWithEnumRef),test("Query reference",{document:{parentDocument:{code:"DOCA"}}},A,"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE t2.COD_0 = 'DOCA'",nodes_1.TestDocumentLine),test("Query composite reference",{document:{parentDocument:{grandparentDocument:{code:"DOCA"}}}},A,"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t2.MAINDOC_0 INNER JOIN REPOSX3.TABDOC t4 ON t4.COD_0 = t3.MAINDOC_0 WHERE t4.COD_0 = 'DOCA'",nodes_1.TestDocumentLine),test("Query collection",{lines:{_every:true,lineNumber:1}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((SELECT COUNT(*) FROM REPOSX3.TABDOCLIN t9 WHERE  t9.DOC_0 = t0.COD_0 AND NOT(t9.NUMLIG_0 = 1)) = 0)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((SELECT COUNT(*) FROM REPOSX3.TABDOCLIN t9 WHERE  t9.DOC_0 = t0.COD_0 AND NOT(t9.NUMLIG_0 = 1)) = 0)",document_1.TestDocument),test("Query composite collection",{grandparentLines:{_every:true,lineNumber:1}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((SELECT COUNT(*) FROM REPOSX3.TABDOCLIN t9 WHERE  t9.DOC_0 = t6.COD_0 AND NOT(t9.NUMLIG_0 = 1)) = 0)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((SELECT COUNT(*) FROM REPOSX3.TABDOCLIN t9 WHERE  t9.DOC_0 = t6.COD_0 AND NOT(t9.NUMLIG_0 = 1)) = 0)",document_1.TestDocument),test("Denormailzed node with localized property",{id:1},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t1.IDENT1_0 = TO_CHAR(t0.ID_0) AND t1.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t2.IDENT1_0 = TO_CHAR(t0.ID_0) AND t2.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t3.IDENT1_0 = TO_CHAR(t0.ID_0) AND t3.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t4.IDENT1_0 = TO_CHAR(t0.ID_0) AND t4.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t5.IDENT1_0 = TO_CHAR(t0.ID_0) AND t5.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t6.IDENT1_0 = TO_CHAR(t0.ID_0) AND t6.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t7.IDENT1_0 = TO_CHAR(t0.ID_0) AND t7.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t8.IDENT1_0 = TO_CHAR(t0.ID_0) AND t8.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t9.IDENT1_0 = TO_CHAR(t0.ID_0) AND t9.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t10.IDENT1_0 = TO_CHAR(t0.ID_0) AND t10.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE t0.ID_0 = 1  ORDER BY T_0_ID_0 ASC NULLS FIRST":"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t1.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t1.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t2.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t2.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t3.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t3.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t4.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t4.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t5.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t6.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t7.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t8.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t9.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t10.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE t0.ID_0 = 1  ORDER BY T_0_ID_0 ASC",nodes_1.TestDenormalized),test("Denormailzed node with filter",{denormalized:"VALUE"},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t1.IDENT1_0 = TO_CHAR(t0.ID_0) AND t1.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t2.IDENT1_0 = TO_CHAR(t0.ID_0) AND t2.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t3.IDENT1_0 = TO_CHAR(t0.ID_0) AND t3.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t4.IDENT1_0 = TO_CHAR(t0.ID_0) AND t4.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t5.IDENT1_0 = TO_CHAR(t0.ID_0) AND t5.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t6.IDENT1_0 = TO_CHAR(t0.ID_0) AND t6.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t7.IDENT1_0 = TO_CHAR(t0.ID_0) AND t7.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t8.IDENT1_0 = TO_CHAR(t0.ID_0) AND t8.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t9.IDENT1_0 = TO_CHAR(t0.ID_0) AND t9.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t10.IDENT1_0 = TO_CHAR(t0.ID_0) AND t10.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE (t0.DIM_0 = 'VALUE' OR t0.DIM_1 = 'VALUE' OR t0.DIM_2 = 'VALUE' OR t0.DIM_3 = 'VALUE' OR t0.DIM_4 = 'VALUE')  ORDER BY T_0_ID_0 ASC NULLS FIRST":"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t1.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t1.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t2.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t2.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t3.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t3.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t4.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t4.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t5.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t6.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t7.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t8.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t9.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t10.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE (t0.DIM_0 = 'VALUE' OR t0.DIM_1 = 'VALUE' OR t0.DIM_2 = 'VALUE' OR t0.DIM_3 = 'VALUE' OR t0.DIM_4 = 'VALUE')  ORDER BY T_0_ID_0 ASC",nodes_1.TestDenormalized),test("Denormailzed node with _ne filter",{denormalized:{_ne:"VALUE"}},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t1.IDENT1_0 = TO_CHAR(t0.ID_0) AND t1.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t2.IDENT1_0 = TO_CHAR(t0.ID_0) AND t2.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t3.IDENT1_0 = TO_CHAR(t0.ID_0) AND t3.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t4.IDENT1_0 = TO_CHAR(t0.ID_0) AND t4.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t5.IDENT1_0 = TO_CHAR(t0.ID_0) AND t5.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t6.IDENT1_0 = TO_CHAR(t0.ID_0) AND t6.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t7.IDENT1_0 = TO_CHAR(t0.ID_0) AND t7.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t8.IDENT1_0 = TO_CHAR(t0.ID_0) AND t8.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t9.IDENT1_0 = TO_CHAR(t0.ID_0) AND t9.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t10.IDENT1_0 = TO_CHAR(t0.ID_0) AND t10.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE ((t0.DIM_0 != 'VALUE') OR (t0.DIM_1 != 'VALUE') OR (t0.DIM_2 != 'VALUE') OR (t0.DIM_3 != 'VALUE') OR (t0.DIM_4 != 'VALUE'))  ORDER BY T_0_ID_0 ASC NULLS FIRST":"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t1.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t1.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT('DIMLOC(',1),')') AND t2.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t2.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t3.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t3.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT('DIMLOC(',2),')') AND t4.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t4.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t5.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT('DIMLOC(',3),')') AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t6.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t7.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT('DIMLOC(',4),')') AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t8.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t9.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT('DIMLOC(',5),')') AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t10.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE ((t0.DIM_0 != 'VALUE') OR (t0.DIM_1 != 'VALUE') OR (t0.DIM_2 != 'VALUE') OR (t0.DIM_3 != 'VALUE') OR (t0.DIM_4 != 'VALUE'))  ORDER BY T_0_ID_0 ASC",nodes_1.TestDenormalized),test("Denormailzed node with reference filter",{document:{parentDocument:{code:"VALUE"}}},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DOC_0 AS T_0_DOC_0, t0.DOC_1 AS T_0_DOC_1, t0.DOC_2 AS T_0_DOC_2, t0.DOC_3 AS T_0_DOC_3, t0.DOC_4 AS T_0_DOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 IN (t0.DOC_0,t0.DOC_1,t0.DOC_2,t0.DOC_3,t0.DOC_4) INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE t2.COD_0 = 'VALUE'  ORDER BY T_0_ID_0 ASC NULLS FIRST":"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DOC_0 AS T_0_DOC_0, t0.DOC_1 AS T_0_DOC_1, t0.DOC_2 AS T_0_DOC_2, t0.DOC_3 AS T_0_DOC_3, t0.DOC_4 AS T_0_DOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 IN (t0.DOC_0,t0.DOC_1,t0.DOC_2,t0.DOC_3,t0.DOC_4) INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE t2.COD_0 = 'VALUE'  ORDER BY T_0_ID_0 ASC",denormalized_with_reference_1.TestDenormalizedWithReference),test("Nested filter on denormalized collection",{denormalized:{_atLeast:1,denormalized:"VALUE"}},A,"SELECT  t0.ID_0 AS T_0_ID_0, t0.DIM_3 AS T_0_DIM_3, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.DENORMALIZEDPARENT t0 WHERE ((SELECT COUNT(*) FROM REPOSX3.DENORMALIZEDPARENT t1 WHERE  t1.ID_0 = t0.ID_0 AND (t1.DIM_0 = 'VALUE' OR t1.DIM_1 = 'VALUE' OR t1.DIM_2 = 'VALUE' OR t1.DIM_3 = 'VALUE' OR t1.DIM_4 = 'VALUE')) >= 1)",nodes_1.TestDenormalizedParent),test("Query reference with empty value",{document:{parentDocument:{code:{_in:["DOCA",null]}}}},A,"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE ((CASE WHEN (t2.COD_0 = ' ' OR t2.COD_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t2.COD_0 IN ('DOCA')))",nodes_1.TestDocumentLine),test("Query reference with empty null reference",{document:{parentDocument:{code:{_in:["DOCA",null]}}}},A,"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE ((CASE WHEN (t2.COD_0 = ' ' OR t2.COD_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t2.COD_0 IN ('DOCA')))",nodes_1.TestDocumentLine)}),describe("Localized properties",()=>{test("Filter by localized string property",{description:{_regex:"Ring"}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE REGEXP_LIKE(TO_CHAR((CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END)),'Ring','')":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE CONVERT(VARCHAR(max),(CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END)) COLLATE Latin1_General_CS_AS LIKE '%Ring%' escape '$'",document_1.TestDocument),test("Filter by localized composite string property",{parentDescription:{_regex:"Ring"}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE REGEXP_LIKE(TO_CHAR((CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END)),'Ring','')":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE CONVERT(VARCHAR(max),(CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END)) COLLATE Latin1_General_CS_AS LIKE '%Ring%' escape '$'",document_1.TestDocument)}),describe("Boolean properties",()=>{test("Filter boolean property to true",{booleanVal:true},A,"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1",nodes_1.TestDatatypes),test("Filter boolean property to false",{booleanVal:false},A,"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 0",nodes_1.TestDatatypes),test("Filter boolean property to null",{booleanVal:null},A,"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) IS NULL) THEN 1 ELSE 0 END)=1",nodes_1.TestDatatypes),test("Filter boolean getValue with ===",{eqBooleanGetValue:true},A,"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1)",nodes_1.TestDatatypes),test("Filter boolean getValue with !==",{neBooleanGetValue:false},A,"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (NOT (((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) != 1)))",nodes_1.TestDatatypes),test("Filter boolean getValue with ternary that returns true or null",{nullBooleanGetValue:null},A,"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN ((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN 1 ELSE null END) IS NULL) THEN 1 ELSE 0 END)=1",nodes_1.TestDatatypes)}),describe("Composite keys",()=>{test("Filter by _id (read)",{_id:"ART_TITRE|SITEA"},A,"oracle"===A?"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE t0.ITMREF_0 = 'ART_TITRE' AND t0.STOFCY_0 = 'SITEA'":"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE t0.ITMREF_0 = 'ART_TITRE' AND t0.STOFCY_0 = 'SITEA'",nodes_1.TestProductSite),test("Filter by _id (read) starting with #",{_id:`${lib_1.X3StorageManager.hashtagPlaceholder}ART_TITRE|${lib_1.X3StorageManager.hashtagPlaceholder}SITEA`},A,"oracle"===A?"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE t0.ITMREF_0 = '#ART_TITRE' AND t0.STOFCY_0 = '#SITEA'":"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE t0.ITMREF_0 = '#ART_TITRE' AND t0.STOFCY_0 = '#SITEA'",nodes_1.TestProductSite),test("Filter by _id (query with _in)",{_id:{_in:["ART_TITRE|SITEA","ART_TITRE2|SITEA2"]}},A,"oracle"===A?"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE (CONCAT(TO_CHAR(t0.ITMREF_0),CONCAT('|',TO_CHAR(t0.STOFCY_0))) IN ('ART_TITRE|SITEA','ART_TITRE2|SITEA2'))":"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE (CONCAT(CONVERT(VARCHAR(max),t0.ITMREF_0),CONCAT('|',CONVERT(VARCHAR(max),t0.STOFCY_0))) IN ('ART_TITRE|SITEA','ART_TITRE2|SITEA2'))",nodes_1.TestProductSite),test("Filter by _id (query with _in)  starting with #",{_id:{_in:[`${lib_1.X3StorageManager.hashtagPlaceholder}ART_TITRE|SITEA`,`ART_TITRE2|${lib_1.X3StorageManager.hashtagPlaceholder}SITEA2`]}},A,"oracle"===A?"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE (CONCAT(TO_CHAR(t0.ITMREF_0),CONCAT('|',TO_CHAR(t0.STOFCY_0))) IN ('#ART_TITRE|SITEA','ART_TITRE2|#SITEA2'))":"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE (CONCAT(CONVERT(VARCHAR(max),t0.ITMREF_0),CONCAT('|',CONVERT(VARCHAR(max),t0.STOFCY_0))) IN ('#ART_TITRE|SITEA','ART_TITRE2|#SITEA2'))",nodes_1.TestProductSite),test("Filter by _id (query with regex)",{_id:{_regex:"SITEA",_options:"i"}},A,"oracle"===A?"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE REGEXP_LIKE(TO_CHAR(CONCAT(TO_CHAR(t0.ITMREF_0),CONCAT('|',TO_CHAR(t0.STOFCY_0)))),'SITEA','i')":"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE CONVERT(VARCHAR(max),CONCAT(CONVERT(VARCHAR(max),t0.ITMREF_0),CONCAT('|',CONVERT(VARCHAR(max),t0.STOFCY_0)))) COLLATE Latin1_General_CI_AS LIKE '%SITEA%' escape '$'",nodes_1.TestProductSite),test("Filter by _id (query with _ne)",{_id:{_ne:"ART_TITRE|SITEA"}},A,"oracle"===A?"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ((t0.ITMREF_0 != 'ART_TITRE') AND (t0.STOFCY_0 != 'SITEA'))":"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ((t0.ITMREF_0 != 'ART_TITRE') AND (t0.STOFCY_0 != 'SITEA'))",nodes_1.TestProductSite),test("Filter by _id (query with _gte)",{_id:{_gte:"ART_TITRE|SITEA"}},A,"oracle"===A?"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ((t0.ITMREF_0 >= 'ART_TITRE') AND (t0.STOFCY_0 >= 'SITEA'))":"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ((t0.ITMREF_0 >= 'ART_TITRE') AND (t0.STOFCY_0 >= 'SITEA'))",nodes_1.TestProductSite)}),describe("Aggregates",()=>{it(`can aggregate - ${A}`,async()=>{const T={response:{locals:{config:{x3:{sql:{driver:A,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com"}}}}}};await xtrem_core_1.Test.withContext(T=>{const _=T.application.getFactoryByConstructor(nodes_1.TestProductSite),C=new sql_query_1.SqlQuery(T,_,{first:21,aggregate:{groups:[{path:["product","code"],groupedBy:"value"}],values:[{path:["stockSite"],operator:"distinctCount"}]},filters:[]},"REPOSX3").getSqlQuery();chai_1.assert.equal(C.trim(),"oracle"===A?"SELECT  COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, t1.ITMREF_0 AS T_1_ITMREF_0_VALUE FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 WHERE 1=1 GROUP BY t1.ITMREF_0 ORDER BY T_1_ITMREF_0_VALUE ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY":"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, t1.ITMREF_0 AS T_1_ITMREF_0_VALUE FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 WHERE 1=1 GROUP BY t1.ITMREF_0 ORDER BY T_1_ITMREF_0_VALUE ASC")},{config:T})}),it(`can aggregate with order by- ${A}`,async()=>{const T={response:{locals:{config:{x3:{sql:{driver:A,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com"}}}}}};await xtrem_core_1.Test.withContext(T=>{const _=T.application.getFactoryByConstructor(nodes_1.TestProductSite),C=new sql_query_1.SqlQuery(T,_,{first:21,aggregate:{groups:[{path:["product","code"],groupedBy:"value"}],values:[{path:["stockSite"],operator:"distinctCount"}]},filters:[],orderBy:{product:{code:1}}},"REPOSX3").getSqlQuery();chai_1.assert.equal(C.trim(),"oracle"===A?"SELECT  COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, t1.ITMREF_0 AS T_1_ITMREF_0_VALUE FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 WHERE 1=1 GROUP BY t1.ITMREF_0 ORDER BY T_1_ITMREF_0_VALUE ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY":"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, t1.ITMREF_0 AS T_1_ITMREF_0_VALUE FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 WHERE 1=1 GROUP BY t1.ITMREF_0 ORDER BY T_1_ITMREF_0_VALUE ASC")},{config:T})}),it(`can aggregate by _id - ${A}`,async()=>{const T={response:{locals:{config:{x3:{sql:{driver:A,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com"}}}}}};await xtrem_core_1.Test.withContext(T=>{const _=T.application.getFactoryByConstructor(nodes_1.TestProductSite),C=new sql_query_1.SqlQuery(T,_,{first:21,aggregate:{groups:[{path:["_id"],groupedBy:"value"}],values:[{path:["stockSite"],operator:"distinctCount"}]},filters:[]},"REPOSX3").getSqlQuery();chai_1.assert.equal(C.trim(),"oracle"===A?"SELECT  COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, CONCAT(TO_CHAR(t0.ITMREF_0),CONCAT('|',TO_CHAR(t0.STOFCY_0))) AS T_0_ID_0_VALUE FROM REPOSX3.ITMFACILIT t0 WHERE 1=1 GROUP BY CONCAT(TO_CHAR(t0.ITMREF_0),CONCAT('|',TO_CHAR(t0.STOFCY_0))) ORDER BY T_0_ID_0_VALUE ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY":"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, CONCAT(CONVERT(VARCHAR(max),t0.ITMREF_0),CONCAT('|',CONVERT(VARCHAR(max),t0.STOFCY_0))) AS T_0_ID_0_VALUE FROM REPOSX3.ITMFACILIT t0 WHERE 1=1 GROUP BY CONCAT(CONVERT(VARCHAR(max),t0.ITMREF_0),CONCAT('|',CONVERT(VARCHAR(max),t0.STOFCY_0))) ORDER BY T_0_ID_0_VALUE ASC")},{config:T})}),it(`can aggregate with order by using composite reference- ${A}`,async()=>{const T={response:{locals:{config:{x3:{sql:{driver:A,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com"}}}}}};await xtrem_core_1.Test.withContext(T=>{const _=T.application.getFactoryByConstructor(document_1.TestDocument),C=new sql_query_1.SqlQuery(T,_,{first:21,aggregate:{groups:[{path:["parentCode"],groupedBy:"value"}],values:[{path:["parentDescription"],operator:"distinctCount"}]},filters:[],orderBy:{parentCode:1}},"REPOSX3").getSqlQuery();chai_1.assert.equal(C.trim(),"oracle"===A?"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, t1.COD_0 AS T_1_COD_0_VALUE FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t3.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY t1.COD_0 ORDER BY T_1_COD_0_VALUE ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY":"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, t1.COD_0 AS T_1_COD_0_VALUE FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t1.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t1.DAT_0,112)))) AND t3.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY t1.COD_0 ORDER BY T_1_COD_0_VALUE ASC")},{config:T})}),it(`can aggregate with order by using values part- ${A}`,async()=>{const T={response:{locals:{config:{x3:{sql:{driver:A,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com"}}}}}};await xtrem_core_1.Test.withContext(T=>{const _=T.application.getFactoryByConstructor(document_1.TestDocument),C=new sql_query_1.SqlQuery(T,_,{first:21,aggregate:{groups:[{path:["parentCode"],groupedBy:"value"}],values:[{path:["parentDescription"],operator:"distinctCount"}]},filters:[],orderBy:{parentDescription:1}},"REPOSX3").getSqlQuery();chai_1.assert.equal(C.trim(),"oracle"===A?"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, t1.COD_0 AS T_1_COD_0_VALUE FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t3.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY t1.COD_0 ORDER BY T_1_DES_0_DISTINCT_COUNT ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY":"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, t1.COD_0 AS T_1_COD_0_VALUE FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t1.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t1.DAT_0,112)))) AND t3.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY t1.COD_0 ORDER BY T_1_DES_0_DISTINCT_COUNT ASC")},{config:T})}),it(`can group by date - ${A}`,async()=>{const T={response:{locals:{config:{x3:{sql:{driver:A,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com"}}}}}};await xtrem_core_1.Test.withContext(T=>{const _=T.application.getFactoryByConstructor(document_1.TestDocument),testGroupBy=(A,C)=>{const N=new sql_query_1.SqlQuery(T,_,{first:21,aggregate:{groups:[{path:["date"],groupedBy:A}],values:[{path:["parentDescription"],operator:"distinctCount"}]},filters:[],orderBy:{parentDescription:1}},"REPOSX3").getSqlQuery();chai_1.assert.strictEqual(N.trim(),C)};testGroupBy("year","oracle"===A?"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, to_char((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'YYYY') AS T_0_DAT_0_YEAR FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t3.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY to_char((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'YYYY') ORDER BY T_1_DES_0_DISTINCT_COUNT ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY":"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, FORMAT((CASE WHEN (t0.DAT_0 = CONVERT(DATE,'1753-01-01',20) OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'yyyy') AS T_0_DAT_0_YEAR FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t1.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t1.DAT_0,112)))) AND t3.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY FORMAT((CASE WHEN (t0.DAT_0 = CONVERT(DATE,'1753-01-01',20) OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'yyyy') ORDER BY T_1_DES_0_DISTINCT_COUNT ASC"),testGroupBy("month","oracle"===A?"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, to_char((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'YYYY-MM') AS T_0_DAT_0_MONTH FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t3.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY to_char((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'YYYY-MM') ORDER BY T_1_DES_0_DISTINCT_COUNT ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY":"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, FORMAT((CASE WHEN (t0.DAT_0 = CONVERT(DATE,'1753-01-01',20) OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'yyyy-MM') AS T_0_DAT_0_MONTH FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t1.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t1.DAT_0,112)))) AND t3.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY FORMAT((CASE WHEN (t0.DAT_0 = CONVERT(DATE,'1753-01-01',20) OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'yyyy-MM') ORDER BY T_1_DES_0_DISTINCT_COUNT ASC"),testGroupBy("day","oracle"===A?"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, to_char((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'YYYY-MM-DD') AS T_0_DAT_0_DAY FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t3.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY to_char((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'YYYY-MM-DD') ORDER BY T_1_DES_0_DISTINCT_COUNT ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY":"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, FORMAT((CASE WHEN (t0.DAT_0 = CONVERT(DATE,'1753-01-01',20) OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'yyyy-MM-dd') AS T_0_DAT_0_DAY FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t1.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t1.DAT_0,112)))) AND t3.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY FORMAT((CASE WHEN (t0.DAT_0 = CONVERT(DATE,'1753-01-01',20) OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END), 'yyyy-MM-dd') ORDER BY T_1_DES_0_DISTINCT_COUNT ASC")},{config:T})}),it(`reject with order by a column not in group clause- ${A}`,async()=>{const T={response:{locals:{config:{x3:{sql:{driver:A,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com"}}}}}};await xtrem_core_1.Test.withContext(A=>{const T=A.application.getFactoryByConstructor(document_1.TestDocument),_=new sql_query_1.SqlQuery(A,T,{first:21,aggregate:{groups:[{path:["parentCode"],groupedBy:"value"}],values:[{path:["date"],operator:"distinctCount"}]},filters:[],orderBy:{parentDescription:1}},"REPOSX3");chai_1.assert.Throw(()=>_.getSqlQuery(),"parentDescription not contained in either an aggregate function or the GROUP BY clause")},{config:T})})}),describe("Service Options",()=>{test("Will only select columns of active service options",{},A,"oracle"===A?"SELECT  t0.CODMET_0 AS T_0_CODMET_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_INTMET_0, t0.PRFXTD_0 AS T_0_PRFXTD_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.AMETUTI t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'AMETUTI' AND t1.ZONE_0 = 'INTMET' AND t1.IDENT1_0 = TO_CHAR(t0.CODMET_0) AND t1.IDENT2_0 = ' ' AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'AMETUTI' AND t2.ZONE_0 = 'INTMET' AND t2.IDENT1_0 = TO_CHAR(t0.CODMET_0) AND t2.IDENT2_0 = ' ' AND t2.LANGUE_0 = 'FRA' WHERE 1=1":"SELECT  t0.CODMET_0 AS T_0_CODMET_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_INTMET_0, t0.PRFXTD_0 AS T_0_PRFXTD_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.AMETUTI t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'AMETUTI' AND t1.ZONE_0 = 'INTMET' AND t1.IDENT1_0 = CONVERT(VARCHAR(max),t0.CODMET_0) AND t1.IDENT2_0 = ' ' AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'AMETUTI' AND t2.ZONE_0 = 'INTMET' AND t2.IDENT1_0 = CONVERT(VARCHAR(max),t0.CODMET_0) AND t2.IDENT2_0 = ' ' AND t2.LANGUE_0 = 'FRA' WHERE 1=1",test_syracuse_method_1.TestSyracusMethod)}),describe("Fallback joins",()=>{test("will generate correct query for node fallback join property - simulating a read",{code:"FOO",legislation:"FRA"},A,"oracle"===A?"SELECT  t0.VACBPR_0 AS T_0_VACBPR_0, t0.LEG_0 AS T_0_LEG_0, t0.DESAXX_0 AS T_0_DESAXX_0, t0.SHOAXX_0 AS T_0_SHOAXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABVACBPR t0 WHERE t0.VACBPR_0 = 'FOO' AND ((CASE WHEN (t0.LEG_0 = ' ' OR t0.LEG_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t0.LEG_0 IN ('FRA')))  ORDER BY T_0_LEG_0 DESC NULLS LAST FETCH NEXT 1 ROWS ONLY":"SELECT TOP 1 t0.VACBPR_0 AS T_0_VACBPR_0, t0.LEG_0 AS T_0_LEG_0, t0.DESAXX_0 AS T_0_DESAXX_0, t0.SHOAXX_0 AS T_0_SHOAXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABVACBPR t0 WHERE t0.VACBPR_0 = 'FOO' AND ((CASE WHEN (t0.LEG_0 = ' ' OR t0.LEG_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t0.LEG_0 IN ('FRA')))  ORDER BY T_0_LEG_0 DESC",nodes_1.TestTaxRule,{singleResultRequest:true}),test("will generate correct query for node fallback join property - simulating a query where fallback is on reference node but not included in reference join",{taxRule:{code:"FOO"}},A,"oracle"===A?"SELECT  t0.BPCNUM_0 AS T_0_BPCNUM_0, t0.BPCNAM_0 AS T_0_BPCNAM_0, t0.BPCSHO_0 AS T_0_BPCSHO_0, t0.BCGCOD_0 AS T_0_BCGCOD_0, t0.BPCTYP_0 AS T_0_BPCTYP_0, t0.BPCINV_0 AS T_0_BPCINV_0, t0.BPCGRU_0 AS T_0_BPCGRU_0, t0.BPCRSK_0 AS T_0_BPCRSK_0, (CASE WHEN t0.BPCSTA_0 = 2 THEN 1 WHEN t0.BPCSTA_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BPCSTA_0, (CASE WHEN t0.PPTFLG_0 = 2 THEN 1 WHEN t0.PPTFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PPTFLG_0, t0.CUR_0 AS T_0_CUR_0, t0.VACBPR_0 AS T_0_VACBPR_0, t0.CDTISRDAT_0 AS T_0_CDTISRDAT_0, (CASE WHEN t0.MTCFLG_0 = 2 THEN 1 WHEN t0.MTCFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_MTCFLG_0, (CASE WHEN t0.LNDAUZ_0 = 2 THEN 1 WHEN t0.LNDAUZ_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LNDAUZ_0, (CASE WHEN t0.OCNFLG_0 = 2 THEN 1 WHEN t0.OCNFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_OCNFLG_0, (CASE WHEN t0.ORDCLE_0 = 2 THEN 1 WHEN t0.ORDCLE_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ORDCLE_0, (CASE WHEN t0.ODL_0 = 2 THEN 1 WHEN t0.ODL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ODL_0, t0.BUS_0 AS T_0_BUS_0, t0.ORIPPT_0 AS T_0_ORIPPT_0, t0.PITCDT_0 AS T_0_PITCDT_0, t0.PITCPT_0 AS T_0_PITCPT_0, t0.TOTPIT_0 AS T_0_TOTPIT_0, t0.COTPITRQD_0 AS T_0_COTPITRQD_0, t0.CNTFIRDAT_0 AS T_0_CNTFIRDAT_0, t0.ORDFIRDAT_0 AS T_0_ORDFIRDAT_0, t0.QUOLASDAT_0 AS T_0_QUOLASDAT_0, t0.CNTLASDAT_0 AS T_0_CNTLASDAT_0, t0.CNTNEXDAT_0 AS T_0_CNTNEXDAT_0, (CASE WHEN t0.BELVATSUB_0 = 2 THEN 1 WHEN t0.BELVATSUB_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BELVATSUB_0, t0.BPCSNCDAT_0 AS T_0_BPCSNCDAT_0, (CASE WHEN t0.ELECTINV_0 = 2 THEN 1 WHEN t0.ELECTINV_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ELECTINV_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t1.VACBPR_0 AS T_1_VACBPR_0 FROM REPOSX3.BPCUSTOMER t0 LEFT JOIN REPOSX3.TABVACBPR t1 ON t1.VACBPR_0 = t0.VACBPR_0 AND EXISTS(SELECT  * FROM REPOSX3.TABVACBPR r0 WHERE r0.VACBPR_0 = t0.VACBPR_0 AND t1.VACBPR_0 = r0.VACBPR_0 AND t1.LEG_0 = r0.LEG_0 ORDER BY r0.LEG_0 ASC NULLS FIRST FETCH NEXT 1 ROWS ONLY) WHERE t1.VACBPR_0 = 'FOO'  ORDER BY T_1_VACBPR_0 ASC NULLS FIRST":"SELECT  t0.BPCNUM_0 AS T_0_BPCNUM_0, t0.BPCNAM_0 AS T_0_BPCNAM_0, t0.BPCSHO_0 AS T_0_BPCSHO_0, t0.BCGCOD_0 AS T_0_BCGCOD_0, t0.BPCTYP_0 AS T_0_BPCTYP_0, t0.BPCINV_0 AS T_0_BPCINV_0, t0.BPCGRU_0 AS T_0_BPCGRU_0, t0.BPCRSK_0 AS T_0_BPCRSK_0, (CASE WHEN t0.BPCSTA_0 = 2 THEN 1 WHEN t0.BPCSTA_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BPCSTA_0, (CASE WHEN t0.PPTFLG_0 = 2 THEN 1 WHEN t0.PPTFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PPTFLG_0, t0.CUR_0 AS T_0_CUR_0, t0.VACBPR_0 AS T_0_VACBPR_0, t0.CDTISRDAT_0 AS T_0_CDTISRDAT_0, (CASE WHEN t0.MTCFLG_0 = 2 THEN 1 WHEN t0.MTCFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_MTCFLG_0, (CASE WHEN t0.LNDAUZ_0 = 2 THEN 1 WHEN t0.LNDAUZ_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LNDAUZ_0, (CASE WHEN t0.OCNFLG_0 = 2 THEN 1 WHEN t0.OCNFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_OCNFLG_0, (CASE WHEN t0.ORDCLE_0 = 2 THEN 1 WHEN t0.ORDCLE_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ORDCLE_0, (CASE WHEN t0.ODL_0 = 2 THEN 1 WHEN t0.ODL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ODL_0, t0.BUS_0 AS T_0_BUS_0, t0.ORIPPT_0 AS T_0_ORIPPT_0, t0.PITCDT_0 AS T_0_PITCDT_0, t0.PITCPT_0 AS T_0_PITCPT_0, t0.TOTPIT_0 AS T_0_TOTPIT_0, t0.COTPITRQD_0 AS T_0_COTPITRQD_0, t0.CNTFIRDAT_0 AS T_0_CNTFIRDAT_0, t0.ORDFIRDAT_0 AS T_0_ORDFIRDAT_0, t0.QUOLASDAT_0 AS T_0_QUOLASDAT_0, t0.CNTLASDAT_0 AS T_0_CNTLASDAT_0, t0.CNTNEXDAT_0 AS T_0_CNTNEXDAT_0, (CASE WHEN t0.BELVATSUB_0 = 2 THEN 1 WHEN t0.BELVATSUB_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BELVATSUB_0, t0.BPCSNCDAT_0 AS T_0_BPCSNCDAT_0, (CASE WHEN t0.ELECTINV_0 = 2 THEN 1 WHEN t0.ELECTINV_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ELECTINV_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t1.VACBPR_0 AS T_1_VACBPR_0 FROM REPOSX3.BPCUSTOMER t0 LEFT JOIN REPOSX3.TABVACBPR t1 ON t1.VACBPR_0 = t0.VACBPR_0 AND EXISTS(SELECT TOP 1 * FROM REPOSX3.TABVACBPR r0 WHERE r0.VACBPR_0 = t0.VACBPR_0 AND t1.VACBPR_0 = r0.VACBPR_0 AND t1.LEG_0 = r0.LEG_0 ORDER BY r0.LEG_0 ASC ) WHERE t1.VACBPR_0 = 'FOO'  ORDER BY T_1_VACBPR_0 ASC",nodes_1.TestCustomer,{orderBy:{taxRule:{code:1}}}),test("will generate correct query for node fallback join property - simulating a query where fallback is on reference node and included in reference join (with multi-level join)",{taxRule:{code:"FOO"}},A,"oracle"===A?"SELECT  t0.POHNUM_0 AS T_0_POHNUM_0, t0.POHFCY_0 AS T_0_POHFCY_0, t0.ORDREF_0 AS T_0_ORDREF_0, t0.BPSNUM_0 AS T_0_BPSNUM_0, (CASE WHEN t0.CLEFLG_0 = 2 THEN 1 WHEN t0.CLEFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_CLEFLG_0, t0.RCPFCY_0 AS T_0_RCPFCY_0, (CASE WHEN t0.BETFCY_0 = 2 THEN 1 WHEN t0.BETFCY_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BETFCY_0, t0.VACBPR_0 AS T_0_VACBPR_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t1.VACBPR_0 AS T_1_VACBPR_0 FROM REPOSX3.PORDER t0 INNER JOIN REPOSX3.FACILITY t2 ON t2.FCY_0 = t0.POHFCY_0 INNER JOIN REPOSX3.COMPANY t3 ON t3.CPY_0 = t2.LEGCPY_0 INNER JOIN REPOSX3.ATABDIV t4 ON t4.NUMTAB_0 = 909 AND t4.CODE_0 = t3.LEG_0 LEFT JOIN REPOSX3.TABVACBPR t1 ON t1.VACBPR_0 = t0.VACBPR_0 AND EXISTS(SELECT  * FROM REPOSX3.TABVACBPR r0 WHERE r0.VACBPR_0 = t0.VACBPR_0 AND (r0.LEG_0 = ' ' OR r0.LEG_0 = t4.CODE_0) AND t1.VACBPR_0 = r0.VACBPR_0 AND t1.LEG_0 = r0.LEG_0 ORDER BY r0.LEG_0 DESC NULLS LAST FETCH NEXT 1 ROWS ONLY) WHERE t1.VACBPR_0 = 'FOO'  ORDER BY T_1_VACBPR_0 ASC NULLS FIRST":"SELECT  t0.POHNUM_0 AS T_0_POHNUM_0, t0.POHFCY_0 AS T_0_POHFCY_0, t0.ORDREF_0 AS T_0_ORDREF_0, t0.BPSNUM_0 AS T_0_BPSNUM_0, (CASE WHEN t0.CLEFLG_0 = 2 THEN 1 WHEN t0.CLEFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_CLEFLG_0, t0.RCPFCY_0 AS T_0_RCPFCY_0, (CASE WHEN t0.BETFCY_0 = 2 THEN 1 WHEN t0.BETFCY_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BETFCY_0, t0.VACBPR_0 AS T_0_VACBPR_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t1.VACBPR_0 AS T_1_VACBPR_0 FROM REPOSX3.PORDER t0 INNER JOIN REPOSX3.FACILITY t2 ON t2.FCY_0 = t0.POHFCY_0 INNER JOIN REPOSX3.COMPANY t3 ON t3.CPY_0 = t2.LEGCPY_0 INNER JOIN REPOSX3.ATABDIV t4 ON t4.NUMTAB_0 = 909 AND t4.CODE_0 = t3.LEG_0 LEFT JOIN REPOSX3.TABVACBPR t1 ON t1.VACBPR_0 = t0.VACBPR_0 AND EXISTS(SELECT TOP 1 * FROM REPOSX3.TABVACBPR r0 WHERE r0.VACBPR_0 = t0.VACBPR_0 AND (r0.LEG_0 = ' ' OR r0.LEG_0 = t4.CODE_0) AND t1.VACBPR_0 = r0.VACBPR_0 AND t1.LEG_0 = r0.LEG_0 ORDER BY r0.LEG_0 DESC ) WHERE t1.VACBPR_0 = 'FOO'  ORDER BY T_1_VACBPR_0 ASC",nodes_1.TestPurchaseOrder,{orderBy:{taxRule:{code:1}}})}),describe("Selector queries",()=>{test("select when selector is true",{},A,"oracle"===A?"SELECT  TO_CHAR(t0.ID_0) AS T_0__ID_0 FROM REPOSX3.TESTDAT t0 WHERE 1=1":"SELECT  CONVERT(VARCHAR(max),t0.ID_0) AS T_0__ID_0 FROM REPOSX3.TESTDAT t0 WHERE 1=1",nodes_1.TestDatatypes,{selector:true}),test("select when selector has simple properties",{},A,"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0 FROM REPOSX3.TESTDAT t0 WHERE 1=1",nodes_1.TestDatatypes,{selector:{id:true,booleanVal:true}}),test("select when selector has complex properties",{},A,"SELECT  t0.COD_0 AS T_0_COD_0, t0.REF_0 AS T_0_REF_0, t1.COD_0 AS T_1_COD_0 FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REF_0 AND t1.DES3AEX_0 = ' ' WHERE 1=1",nodes_1.TestReferencing,{selector:{code:true,reference:{code:true}}}),test("select denormalized",{},A,"oracle"===A?"SELECT  t0.ID_0 AS T_0_ID_0, CONCAT(TO_CHAR(t0.ID_0),CONCAT('|','1')) AS T_0__ID_0, CONCAT(TO_CHAR(t0.ID_0),CONCAT('|','2')) AS T_0__ID_1, CONCAT(TO_CHAR(t0.ID_0),CONCAT('|','3')) AS T_0__ID_2, CONCAT(TO_CHAR(t0.ID_0),CONCAT('|','4')) AS T_0__ID_3, CONCAT(TO_CHAR(t0.ID_0),CONCAT('|','5')) AS T_0__ID_4, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, 1 AS T_0_DENORMALIZED_INDEX_0, 2 AS T_0_DENORMALIZED_INDEX_1, 3 AS T_0_DENORMALIZED_INDEX_2, 4 AS T_0_DENORMALIZED_INDEX_3, 5 AS T_0_DENORMALIZED_INDEX_4 FROM REPOSX3.DENORMALIZEDPARENT t0 WHERE 1=1  ORDER BY T_0_ID_0 ASC NULLS FIRST":"SELECT  t0.ID_0 AS T_0_ID_0, CONCAT(CONVERT(VARCHAR(max),t0.ID_0),CONCAT('|','1')) AS T_0__ID_0, CONCAT(CONVERT(VARCHAR(max),t0.ID_0),CONCAT('|','2')) AS T_0__ID_1, CONCAT(CONVERT(VARCHAR(max),t0.ID_0),CONCAT('|','3')) AS T_0__ID_2, CONCAT(CONVERT(VARCHAR(max),t0.ID_0),CONCAT('|','4')) AS T_0__ID_3, CONCAT(CONVERT(VARCHAR(max),t0.ID_0),CONCAT('|','5')) AS T_0__ID_4, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, 1 AS T_0_DENORMALIZED_INDEX_0, 2 AS T_0_DENORMALIZED_INDEX_1, 3 AS T_0_DENORMALIZED_INDEX_2, 4 AS T_0_DENORMALIZED_INDEX_3, 5 AS T_0_DENORMALIZED_INDEX_4 FROM REPOSX3.DENORMALIZEDPARENT t0 WHERE 1=1  ORDER BY T_0_ID_0 ASC",nodes_1.TestDenormalized,{selector:{_id:true,id:true,denormalized:true,denormalizedIndex:true}})}),describe("can filter with date functions",()=>{test("date.year",{date:{year:2018}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE EXTRACT(YEAR FROM t0.DAT_0) = 2018":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEPART(yy FROM t0.DAT_0) = 2018",document_1.TestDocument),test("date.month",{date:{month:4}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE EXTRACT(MONTH FROM t0.DAT_0) = 4":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEPART(mm FROM t0.DAT_0) = 4",document_1.TestDocument),test("date.day",{date:{day:15}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE EXTRACT(DAY FROM t0.DAT_0) = 15":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEPART(dd FROM t0.DAT_0) = 15",document_1.TestDocument),test("date.week",{date:{week:24}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE TO_NUMBER(TO_CHAR(t0.DAT_0, 'WW')) = 24":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEPART(isowk FROM t0.DAT_0) = 24",document_1.TestDocument),test("date.weekDay",{date:{weekDay:1}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (CASE to_char(t0.DAT_0,'fmDY','nls_date_language=English') WHEN 'SUN' THEN 0 WHEN 'MON' THEN 1 WHEN 'TUE' THEN 2 WHEN 'WED' THEN 3 WHEN 'THU' THEN 4 WHEN 'FRI' THEN 5 WHEN 'SAT' THEN 6 END) = 1":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((DATEPART(dw FROM t0.DAT_0) + @@DATEFIRST + 6) % 7 ) = 1",document_1.TestDocument),test("date.yearDay",{date:{yearDay:46}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE TO_NUMBER(TO_CHAR(t0.DAT_0, 'DDD')) = 46":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEPART(dy FROM t0.DAT_0) = 46",document_1.TestDocument),test("date.value",{date:{value:20180215}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(YEAR FROM t0.DAT_0) * 10000 + EXTRACT(MONTH FROM t0.DAT_0) * 100 + EXTRACT(DAY FROM t0.DAT_0)) = 20180215":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(yy FROM t0.DAT_0) * 10000 + DATEPART(mm FROM t0.DAT_0) * 100 + DATEPART(dd FROM t0.DAT_0)) = 20180215",document_1.TestDocument),test("date.epoch",{date:{epoch:1518652800}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 - TO_DATE('1970-01-01', 'YYYY-MM-DD')) * 86400) = 1518652800":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEDIFF(SECOND, '1970-01-01', t0.DAT_0) = 1518652800",document_1.TestDocument)}),describe("can filter with date functions using _fn",()=>{test("date._fn.year",{_fn:"this.date.year === 2018"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(YEAR FROM t0.DAT_0) = 2018)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(yy FROM t0.DAT_0) = 2018)",document_1.TestDocument),test("date._fn.month",{_fn:"this.date.month === 4"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(MONTH FROM t0.DAT_0) = 4)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(mm FROM t0.DAT_0) = 4)",document_1.TestDocument),test("date._fn.day",{_fn:"this.date.day === 15"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(DAY FROM t0.DAT_0) = 15)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(dd FROM t0.DAT_0) = 15)",document_1.TestDocument),test("date._fn.week",{_fn:"this.date.week === 24"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TO_NUMBER(TO_CHAR(t0.DAT_0, 'WW')) = 24)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(isowk FROM t0.DAT_0) = 24)",document_1.TestDocument),test("date._fn.weekDay",{_fn:"this.date.weekDay === 1"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((CASE to_char(t0.DAT_0,'fmDY','nls_date_language=English') WHEN 'SUN' THEN 0 WHEN 'MON' THEN 1 WHEN 'TUE' THEN 2 WHEN 'WED' THEN 3 WHEN 'THU' THEN 4 WHEN 'FRI' THEN 5 WHEN 'SAT' THEN 6 END) = 1)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (((DATEPART(dw FROM t0.DAT_0) + @@DATEFIRST + 6) % 7 ) = 1)",document_1.TestDocument),test("date._fn.yearDay",{_fn:"this.date.yearDay === 46"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TO_NUMBER(TO_CHAR(t0.DAT_0, 'DDD')) = 46)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(dy FROM t0.DAT_0) = 46)",document_1.TestDocument),test("date._fn.value",{_fn:"this.date.value === 20180215"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((EXTRACT(YEAR FROM t0.DAT_0) * 10000 + EXTRACT(MONTH FROM t0.DAT_0) * 100 + EXTRACT(DAY FROM t0.DAT_0)) = 20180215)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((DATEPART(yy FROM t0.DAT_0) * 10000 + DATEPART(mm FROM t0.DAT_0) * 100 + DATEPART(dd FROM t0.DAT_0)) = 20180215)",document_1.TestDocument),test("date._fn.epoch",{_fn:"this.date.epoch === 1518652800"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (((t0.DAT_0 - TO_DATE('1970-01-01', 'YYYY-MM-DD')) * 86400) = 1518652800)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEDIFF(SECOND, '1970-01-01', t0.DAT_0) = 1518652800)",document_1.TestDocument)}),describe("can filter date methods with _fn",()=>{test("date._fn.compare && date._fn.parse",{_fn:'this.date.compare(date.parse("2018-01-15")) < 0'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 - TO_DATE('2018-01-15', 'YYYY-MM-DD')) < 0)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 - CAST('2018-01-15' AS DATE)) < 0)",document_1.TestDocument),test("date._fn.compare && date._fn.parse multi-level",{_fn:'this.parentDocument.date.compare(date.parse("2018-01-15")) < 0'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t3.DAT_0 - TO_DATE('2018-01-15', 'YYYY-MM-DD')) < 0)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t3.DAT_0 - CAST('2018-01-15' AS DATE)) < 0)",document_1.TestDocument),test("date._fn.equals && date._fn.parse",{_fn:'this.date.equals(date.parse("2018-01-15"))'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t0.DAT_0 = TO_DATE('2018-01-15', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t0.DAT_0 = CAST('2018-01-15' AS DATE))",document_1.TestDocument),test("date._fn.equals && date._fn.parse multi-level",{_fn:'this.parentDocument.date.equals(date.parse("2018-01-15"))'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t3.DAT_0 = TO_DATE('2018-01-15', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t3.DAT_0 = CAST('2018-01-15' AS DATE))",document_1.TestDocument),test("date._fn.isBetween && date._fn.parse multi-level",{_fn:'this.date.isBetween(date.parse("2018-01-15"), date.parse("2018-03-15"))'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t0.DAT_0 BETWEEN TO_DATE('2018-01-15', 'YYYY-MM-DD') AND  TO_DATE('2018-03-15', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t0.DAT_0 BETWEEN CAST('2018-01-15' AS DATE) AND  CAST('2018-03-15' AS DATE))",document_1.TestDocument),test("date._fn.addYears",{_fn:'this.date.addYears(1) === date.parse("2018-05-15")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (ADD_MONTHS(t0.DAT_0, 1 * 12) = TO_DATE('2018-05-15', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(year, 1, t0.DAT_0) = CAST('2018-05-15' AS DATE))",document_1.TestDocument),test("date._fn.addYears -1",{_fn:'this.date.addYears(-1) === date.parse("2018-05-15")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (ADD_MONTHS(t0.DAT_0, (- CAST(1 AS INTEGER)) * 12) = TO_DATE('2018-05-15', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(year, (- CAST(1 AS INTEGER)), t0.DAT_0) = CAST('2018-05-15' AS DATE))",document_1.TestDocument),test("date._fn.addMonths",{_fn:'this.date.addMonths(4) === date.parse("2018-05-15")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (ADD_MONTHS(t0.DAT_0, 4) = TO_DATE('2018-05-15', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(month, 4, t0.DAT_0) = CAST('2018-05-15' AS DATE))",document_1.TestDocument),test("date._fn.addDays",{_fn:'this.date.addDays(3) === date.parse("2018-05-15")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t0.DAT_0 + 3 = TO_DATE('2018-05-15', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t0.DAT_0 + 3 = CAST('2018-05-15' AS DATE))",document_1.TestDocument),test("date._fn.addWeeks",{_fn:'this.date.addWeeks(4) === date.parse("2018-05-15")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0+(4*7)) = TO_DATE('2018-05-15', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(week, 4, t0.DAT_0) = CAST('2018-05-15' AS DATE))",document_1.TestDocument),test("date._fn.addWeeks.addDays",{_fn:'this.date.addWeeks(4).addDays(1) === date.parse("2018-05-15")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0+(4*7)) + 1 = TO_DATE('2018-05-15', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(week, 4, t0.DAT_0) + 1 = CAST('2018-05-15' AS DATE))",document_1.TestDocument),test("date._fn.isLeapYear",{_fn:"this.date.isLeapYear()"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ADD_MONTHS(TRUNC(t0.DAT_0,'YEAR'),12)-TRUNC(t0.DAT_0,'YEAR')=366":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((DATEPART(yy FROM t0.DAT_0) % 4 = 0 AND DATEPART(yy FROM t0.DAT_0) % 100 <> 0) OR DATEPART(yy FROM t0.DAT_0) % 400 = 0)",document_1.TestDocument),test("date._fn.weekDay",{_fn:"this.date.weekDay===0"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((CASE to_char(t0.DAT_0,'fmDY','nls_date_language=English') WHEN 'SUN' THEN 0 WHEN 'MON' THEN 1 WHEN 'TUE' THEN 2 WHEN 'WED' THEN 3 WHEN 'THU' THEN 4 WHEN 'FRI' THEN 5 WHEN 'SAT' THEN 6 END) = 0)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (((DATEPART(dw FROM t0.DAT_0) + @@DATEFIRST + 6) % 7 ) = 0)",document_1.TestDocument),test("date._fn.isWorkDay",{_fn:"this.date.isWorkDay()"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((CASE to_char(t0.DAT_0,'fmDY','nls_date_language=English') WHEN 'SUN' THEN 0 WHEN 'MON' THEN 1 WHEN 'TUE' THEN 2 WHEN 'WED' THEN 3 WHEN 'THU' THEN 4 WHEN 'FRI' THEN 5 WHEN 'SAT' THEN 6 END) NOT IN (0, 6))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (((DATEPART(dw FROM t0.DAT_0) + @@DATEFIRST + 6) % 7 ) NOT IN (0, 6))",document_1.TestDocument),test("date._fn.daysInMonth",{_fn:"this.date.daysInMonth() === 30"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (1+TRUNC(LAST_DAY(t0.DAT_0))-TRUNC(t0.DAT_0,'MM') = 30)":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DAY(DATEADD(DD,-1,DATEADD(MM,DATEDIFF(MM,-1,t0.DAT_0),0))) = 30)",document_1.TestDocument),test("date._fn.begOfYear",{_fn:'this.date.begOfYear() === date.parse("2018-01-01")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TRUNC(t0.DAT_0,'YEAR') = TO_DATE('2018-01-01', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(YEAR, DATEDIFF(YEAR, 0, t0.DAT_0), 0) = CAST('2018-01-01' AS DATE))",document_1.TestDocument),test("date._fn.begOfQuarter",{_fn:'this.date.begOfQuarter() === date.parse("2018-01-01")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TRUNC(t0.DAT_0,'Q') = TO_DATE('2018-01-01', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(QUARTER, DATEDIFF(QUARTER, 0, t0.DAT_0), 0) = CAST('2018-01-01' AS DATE))",document_1.TestDocument),test("date._fn.begOfMonth",{_fn:'this.date.begOfMonth() === date.parse("2018-01-01")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TRUNC(t0.DAT_0,'MONTH') = TO_DATE('2018-01-01', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(MONTH, DATEDIFF(MONTH, 0, t0.DAT_0), 0) = CAST('2018-01-01' AS DATE))",document_1.TestDocument),test("date._fn.begOfWeek",{_fn:'this.date.begOfWeek() === date.parse("2018-01-01")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TRUNC(t0.DAT_0,'IW') = TO_DATE('2018-01-01', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(WEEK, DATEDIFF(WEEK, 0, t0.DAT_0), 0) = CAST('2018-01-01' AS DATE))",document_1.TestDocument),test("date._fn.endOfYear",{_fn:'this.date.endOfYear() === date.parse("2018-01-01")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (ADD_MONTHS(TRUNC(t0.DAT_0, 'Y'), 12) - 1 = TO_DATE('2018-01-01', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(YEAR, DATEDIFF(YEAR, 0, t0.DAT_0) + 1, -1) = CAST('2018-01-01' AS DATE))",document_1.TestDocument),test("date._fn.endOfQuarter",{_fn:'this.date.endOfQuarter() === date.parse("2018-01-01")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (ADD_MONTHS(TRUNC(t0.DAT_0,'Q'),3)-1 = TO_DATE('2018-01-01', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(QUARTER, DATEDIFF(QUARTER, 0, t0.DAT_0) + 1, -1) = CAST('2018-01-01' AS DATE))",document_1.TestDocument),test("date._fn.endOfMonth",{_fn:'this.date.endOfMonth() === date.parse("2018-01-01")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (LAST_DAY(t0.DAT_0) = TO_DATE('2018-01-01', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(MONTH, DATEDIFF(MONTH, 0, t0.DAT_0) + 1, -1) = CAST('2018-01-01' AS DATE))",document_1.TestDocument),test("date._fn.endOfWeek",{_fn:'this.date.endOfWeek() === date.parse("2018-01-01")'},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TRUNC(t0.DAT_0,'IW')+6 = TO_DATE('2018-01-01', 'YYYY-MM-DD'))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(WEEK, DATEDIFF(WEEK, 0, t0.DAT_0) + 1, -1) = CAST('2018-01-01' AS DATE))",document_1.TestDocument),test("complex date filter with _fn",{_fn:"this.date.year === this.date.month + 2014"},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(YEAR FROM t0.DAT_0) = (EXTRACT(MONTH FROM t0.DAT_0) + 2014))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(yy FROM t0.DAT_0) = (DATEPART(mm FROM t0.DAT_0) + 2014))",document_1.TestDocument),test("nested _fn in filter",{parentDocument:{_fn:"this.date.year === this.date.month + 2014"}},A,"oracle"===A?"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(YEAR FROM t3.DAT_0) = (EXTRACT(MONTH FROM t3.DAT_0) + 2014))":"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t0.DAT_0,112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t3.DAT_0,112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,t6.DAT_0,112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(yy FROM t3.DAT_0) = (DATEPART(mm FROM t3.DAT_0) + 2014))",document_1.TestDocument)})})});
//# sourceMappingURL=sql-test.js.map