/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),x3_storage_soap_web_service_helper_1=require("../../../lib/storage/x3-storage-soap-web-service-helper"),nodes_1=require("../../fixtures/nodes"),setup_1=require("../../fixtures/setup");describe("SOAP testing",()=>{before(setup_1.setupTest),it("can execute a mutation",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.create(nodes_1.TestProduct,{code:"XTREM",description1:"Xtrem item",description2:"Xtrem item",productStatus:1,productCategory:"RAWMA",stockUnit:"EA",accountingCode:"FINPRODUCT",taxLevel:"NOR"});await t.$.save(),chai_1.assert.instanceOf(t,nodes_1.TestProduct),chai_1.assert.equal(await t.productCategory,"RAWMA"),chai_1.assert.equal(await t.description1,"Xtrem item")},{mocks:["axios"],directory:__dirname,scenario:"create-product"})),it.skip("PJM Project create",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.query(nodes_1.TestProject,{first:1,forUpdate:true}).at(0);await(t?.$.set({externalIdentifier:"FOO"})),await(t?.$.save())},{directory:__dirname,scenario:"project-update",mocks:["axios"]})),it("can execute a mutation, transient value removed from payload and X3 sends back generated value",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.create(nodes_1.TestProduct,{description1:"Xtrem item",description2:"Xtrem item",productStatus:1,productCategory:"RAWMA",stockUnit:"EA",accountingCode:"FINPRODUCT",taxLevel:"NOR"});chai_1.assert.equal(await t.code,"-1000000001");const r=e.application.getFactoryByConstructor(nodes_1.TestProduct);if(!r)throw new Error("Missing factory for TestProduct");const a=await x3_storage_soap_web_service_helper_1.X3StorageSoapWebServiceHelper.getWebServicePayload(r,t,{removeTransients:true});chai_1.assert.equal(JSON.stringify(a),JSON.stringify({description1:"Xtrem item",description2:"Xtrem item",description3:"",localizedDescription1:"",localizedDescription2:"",localizedDescription3:"",upc:"",productStatus:1,stockUnit:"EA",weightUnit:"",purchaseUnit:"",volumeUnit:"",productCategory:"RAWMA",accountingCode:"FINPRODUCT",taxLevel:"NOR",productWeight:"0",productVolume:"0",lotManagementMode:null}))})),it("can add web service messages to diagnoses",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.create(nodes_1.TestProduct,{code:"XTREM",description1:"Xtrem item",description2:"Xtrem item",productStatus:1,productCategory:"RAWMA",stockUnit:"EA",accountingCode:"FINPRODUCT",taxLevel:"NOR"});await t.$.save(),chai_1.assert.deepEqual(e.diagnoses,[{severity:1,path:[],message:"The Product was created with the reference RAW046"},{severity:1,path:[],message:"|Creation of RAW046"},{severity:1,path:[],message:"[[ITMREF:RAW046]]"}])},{mocks:["axios"],directory:__dirname,scenario:"create-product"})),it("should have error diagnoses when trySave and there is pool errors",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.create(nodes_1.TestProduct,{code:"XTREM",description1:"Xtrem item",description2:"Xtrem item",productStatus:1,productCategory:"SCRAP",stockUnit:"EA",accountingCode:"FINPRODUCT",taxLevel:"NOR"});try{await t.$.trySave()}catch(e){}chai_1.assert.deepEqual(e.diagnoses,[{severity:3,path:[],message:'{"description":"No Pool: WSP"}'}])},{mocks:["axios"],directory:__dirname,scenario:"create-product-error"})),it("should have error diagnoses when trySave and there is normal save errors",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.create(nodes_1.TestProduct,{code:"XTREM",description1:"Xtrem item",description2:"Xtrem item",productStatus:1,productCategory:"SCRAP",stockUnit:"EA",accountingCode:"FINPRODUCT",taxLevel:"NOR"});try{await t.$.trySave()}catch(e){}chai_1.assert.deepEqual(e.diagnoses,[{message:'{"description":"Field TCLCOD : Product category : SCRAP Record does not exist <XTREM>"}',path:[],severity:3},{message:"Caution: The stock management code has been modified. Check that the item-site is coherent",path:[],severity:1},{message:"[[ITMREF:XTREM]]",path:[],severity:1}])},{mocks:["axios"],directory:__dirname,scenario:"create-product-error2"})),it("can have the web service as a function",()=>xtrem_core_1.Test.withContext(async e=>{await chai_1.assert.isRejected(e.delete(nodes_1.TestProduct,{code:"XTREM"}),"No delete service for TestProduct")})),it.skip("will return correct payload for composite reference related properties",()=>xtrem_core_1.Test.withContext(async e=>{const t=xtrem_core_1.date.make(2022,1,1),r=await e.create(nodes_1.TestDocument,{code:"CHILD",parentDocument:"PARENT",parentCode:"PARENT",description:"Child description",parentDescription:"Parent description",date:t,parentDate:t}),a=await r.$.payload({propertyNames:{parentDocument:{code:true},parentCode:true,parentDescription:true,parentDate:true}});chai_1.assert.deepEqual(a,{parentCode:"PARENT",parentDate:t,parentDescription:"Parent description",parentDocument:{code:"PARENT"}})}))});
//# sourceMappingURL=soap-test.js.map