import { Node, Reference } from '@sage/xtrem-core';
import { TestSyracusMethod } from './test-syracuse-method';
import { TestUserFunctionProfile } from './test-user-function-profile';
/** 4GL columnName: AUTILIS */
export declare class TestUser extends Node {
    /** 4GL columnName: ENAFLG */
    readonly activeInSelec: Promise<boolean | null>;
    /** 4GL columnName: NOMUSR */
    readonly name: Promise<string>;
    /** 4GL columnName: INTUSR */
    readonly nameDescription: Promise<string>;
    /** 4GL columnName: USR */
    readonly code: Promise<string>;
    /** 4GL columnName: ALLACS */
    readonly allAccessCodes: Promise<boolean | null>;
    /** 4GL columnName: USREXT */
    readonly externalUser: Promise<boolean | null>;
    /** 4GL columnName: USRCONNECT */
    readonly x3Connection: Promise<boolean | null>;
    /** 4GL columnName: USRCONXTD */
    readonly webServicesConnection: Promise<boolean | null>;
    /** 4GL columnName: CODRIBDFT */
    readonly defaultBankId: Promise<string>;
    /** 4GL columnName: BIDNUM */
    readonly bankIdNumber: Promise<string>;
    /** 4GL columnName: USRPRT */
    readonly userModel: Reference<TestUser | null>;
    /** 4GL columnName: FNCCOD */
    readonly functions: Promise<string>;
    /** 4GL columnName: BPRNUM */
    readonly bpNumber: Promise<string>;
    readonly accountingCode: Promise<string>;
    /** 4GL columnName: WRH */
    readonly warehouse: Promise<string>;
    /** 4GL columnName: CODMET */
    readonly profession: Reference<TestSyracusMethod | null>;
    /** 4GL columnName: PRFFCT */
    readonly functionProfile: Reference<TestUserFunctionProfile | null>;
    /** 4GL columnName: ADDEML */
    readonly email: Promise<string>;
    /** 4GL columnName: LOGIN */
    readonly login: Promise<string>;
    /** 4GL columnName: ARCPRF */
    readonly profile: Promise<string>;
}
//# sourceMappingURL=test-user.d.ts.map