import { Collection, date, integer, Node, Reference } from '@sage/xtrem-core';
import { TestCurrency } from './test-currency';
import { TestMiscellaneousTable } from './test-miscellaneous-table';
import { TestPjmProjectDimension } from './test-pjm-project-dimension';
import { TestProject } from './test-project';
import { TestSite } from './test-site';
/** 4GL code: OPPORPJM */
export declare class TestPjmProject extends Node {
    /** 4GL code: OPPNUM */
    readonly project: Reference<TestProject>;
    /** 4GL code: OPPINT */
    readonly isInternal: Promise<boolean>;
    /** 4GL code: OPPFRT */
    readonly isProvisional: Promise<boolean>;
    /** 4GL code: OPPDATTH */
    readonly suspensionDate: Promise<date | null>;
    /** 4GL code: OPPDATLV */
    readonly deliveryDate: Promise<date | null>;
    /** 4GL code: OPPDATLA */
    readonly launchingDate: Promise<date | null>;
    /** 4GL code: OPPDATS */
    readonly closingDate: Promise<date | null>;
    /** 4GL code: OPPPROACTIV */
    readonly isIndirectCostCalculated: Promise<boolean>;
    /** 4GL code: CUROPP */
    readonly overviewCurrency: Reference<TestCurrency>;
    /** 4GL code: OPPIMPT */
    readonly isIntermediateLevelBudgetingAllowed: Promise<boolean>;
    /** 4GL code: OPEDEFFCY */
    readonly operatingSite: Reference<TestSite>;
    /** 4GL code: OPPMOD */
    readonly isTemplate: Promise<boolean>;
    /** 4GL code: ORIOPP */
    readonly source: Reference<TestProject | null>;
    /** 4GL code: STRDAT */
    readonly startDate: Promise<date | null>;
    /** 4GL code: ENDDAT */
    readonly endDate: Promise<date | null>;
    /** 4GL code: DUEDAT */
    readonly dueDate: Promise<date | null>;
    /** 4GL code: OPPDUR */
    readonly duration: Promise<integer>;
    /** 4GL code: EREVDAT */
    readonly revenueEstimationDate: Promise<date | null>;
    /** 4GL code: PRCCPLADI */
    readonly progressRange: Reference<TestMiscellaneousTable | null>;
    /** 4GL code: PRCCPLDAT */
    readonly progressEstimationDate: Promise<date | null>;
    readonly dimensions: Collection<TestPjmProjectDimension>;
    /** 4GL code: TASBUDAUT */
    readonly isBudgetCreatedAutomatically: Promise<boolean>;
}
//# sourceMappingURL=test-pjm-project.d.ts.map