import { Node, Reference } from '@sage/xtrem-core';
import { TestReferenced } from './test-referenced';
import { TestReferencing } from './test-referencing';
/**
 * Invalid reference passed to compositeReferences
 */
export declare class TestComopositeInvalidReference extends Node {
    readonly code: Promise<string>;
    readonly reference: Reference<TestReferenced>;
}
/**
 * Invalid local property passed to compositeReferences
 */
export declare class TestComopositeInvalidLocalProperty extends Node {
    readonly code: Promise<string>;
    readonly reference: Reference<TestReferenced>;
}
/**
 * Invalid target property passed to compositeReferences
 */
export declare class TestComopositeInvalidTargetProperty extends Node {
    readonly code: Promise<string>;
    readonly reference: Reference<TestReferenced>;
}
/**
 * Property that is not stored mapped on compositeReferences
 */
export declare class TestComopositeInvalidStoredProperty extends Node {
    readonly code: Promise<string>;
    readonly stringCode: Promise<string>;
    readonly reference: Reference<TestReferenced>;
}
/**
 * Property that is not stored mapped on compositeReferences
 */
export declare class TestComopositeInvalidPropertyType extends Node {
    readonly code: Promise<string>;
    readonly integerCode: Promise<string>;
    readonly reference: Reference<TestReferenced>;
}
/**
 * Property that is not stored mapped on compositeReferences
 */
export declare class TestComopositeInvalidReferenceNode extends Node {
    readonly code: Promise<string>;
    readonly mappedReference: Reference<TestReferencing>;
    readonly reference: Reference<TestReferencing>;
}
/**
 * Property that is not stored mapped on compositeReferences
 */
export declare class TestComopositeInvalidVitalReferenceNode extends Node {
    readonly code: Promise<string>;
    readonly mappedReference: Reference<TestComopositeInvalidVitalReferenceChildNode>;
    readonly reference: Reference<TestReferencing>;
}
export declare class TestComopositeInvalidVitalReferenceChildNode extends Node {
    readonly reference: Reference<TestComopositeInvalidVitalReferenceNode>;
}
//# sourceMappingURL=bad-composite-nodes.d.ts.map