import { AnyRecord, AnyRecordWithId, Extend, Node, NodeFactory, NodePayloadData, ValidationContext } from '@sage/xtrem-core';
import * as x3SoapGateway from '../soap';
import { WebServiceType } from './storage-types';
import { X3StorageManager } from './x3-storage-manager';
export declare class X3StorageSoapWebServiceHelper {
    private static readonly logger;
    /**
     * Manage the messages in the context diagnoses. The messages return from the web services are added to the context diagnoses
     * @param node Current node
     */
    private static manageWebServiceValidationMessages;
    /**
     * Execute the specified SOAP web service
     * @param storageManager
     * @param node
     * @param webService
     * @param cx
     * @param payload
     * @returns
     */
    static executeWebService<T extends Node>(storageManager: X3StorageManager<T>, node: Extend<T>, webServiceType: WebServiceType<T>, cx: ValidationContext, options?: {
        removeTransients?: boolean;
    }): Promise<x3SoapGateway.interfaces.ResultInterface>;
    /**
     * Resolve web service to a WebService instance
     * @param webServiceType
     * @param node
     * @returns
     */
    private static resolveWebService;
    /**
     * Get the payload of the node, with the transient key values removed
     * @param node
     * @param options
     * @returns
     */
    static getWebServicePayload<T extends Node>(factory: NodeFactory, node: T, options?: {
        removeTransients?: boolean;
    }): Promise<NodePayloadData<Extend<T>>>;
    static insert<T extends Node>(storageManager: X3StorageManager<T>, node: Extend<T>, cx: ValidationContext): Promise<AnyRecordWithId>;
    static update<T extends Node>(storageManager: X3StorageManager<T>, node: Extend<T>, cx: ValidationContext): Promise<AnyRecord[]>;
    static delete<T extends Node>(storageManager: X3StorageManager<T>, node: Extend<T>, cx: ValidationContext): Promise<number>;
}
//# sourceMappingURL=x3-storage-soap-web-service-helper.d.ts.map