/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlResolver=exports.systemColumns=exports.systemProperties=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_ts_to_sql_1=require("@sage/xtrem-ts-to-sql"),xtrem_x3_sql_manager_1=require("@sage/xtrem-x3-sql-manager"),crypto_1=require("crypto"),lodash_1=require("lodash"),logger=xtrem_core_1.Logger.getLogger(__filename,"sql-mapper");exports.systemProperties={_createStamp:{name:"_createStamp",type:"datetime",isStored:true,columnName:"CREDATTIM",serviceOptions:[]},_updateStamp:{name:"_updateStamp",type:"datetime",isStored:true,columnName:"UPDDATTIM",serviceOptions:[]},_updateTick:{name:"_updateTick",type:"integer",isStored:true,columnName:"UPDTICK",serviceOptions:[]},_createUser:{name:"_createUser",type:"string",isStored:true,columnName:"CREUSR",columnType:"string",serviceOptions:[]},_updateUser:{name:"_updateUser",type:"string",isStored:true,columnType:"string",columnName:"UPDUSR",serviceOptions:[]}},exports.systemColumns=Object.values(exports.systemProperties).map(e=>e.columnName);const constructorProperty={name:"_constructor",columnName:"_constructor",isStored:true,type:"string"};class SqlResolver{static getX3Pool(e){return xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e)}static getNumericAggregateValueType(e,t){switch(e){case"short":case"integer":return"sum"===t?"integer":"double";case"float":case"double":return"double";case"decimal":return"decimal";default:throw new xtrem_shared_1.LogicError(`invalid type for ${t} operator: ${e}`)}}static getAggregateValueType(e,t){switch(t){case"min":case"max":case"year":case"month":case"day":case"value":return e;case"sum":case"avg":return SqlResolver.getNumericAggregateValueType(e,t);case"distinctCount":return"integer";case"hasNull":return"boolean";default:throw new xtrem_shared_1.LogicError(`invalid aggregate operator: ${t}`)}}static checkDateOrDatetimeType(e,t){if("date"!==e&&"datetime"!==e&&"dateRange"!==e&&"datetimeRange"!==e)throw new Error(`Only date/datetime/dateRange properties can be grouped by '${t}`)}static castIfBoolean(e,t){return"boolean"===t?`(CAST(${e} as INTEGER))`:e}static nullValue(e,t){switch(t){case"string":return(0,xtrem_ts_to_sql_1.quote)(" ");case"decimal":case"integer":case"enum":case"boolean":return"0";case"datetime":case"date":{const t=(0,xtrem_ts_to_sql_1.quote)(String(SqlResolver.getX3Pool(e).nullDate));return SqlResolver.getX3Pool(e).charToDate(t)}default:throw new Error(`unsupported type ${t}`)}}static placeholderValue(e,t){switch(t){case"string":return(0,xtrem_ts_to_sql_1.quote)("PLACEHOLDER");case"enum":case"boolean":case"decimal":case"integer":return"1";case"datetime":case"date":{const t=(0,xtrem_ts_to_sql_1.quote)(String(xtrem_date_time_1.date.today()));return SqlResolver.getX3Pool(e).charToDate(t)}default:throw new Error(`unsupported type ${t}`)}}static getType(e){let t="reference"===e.type?e.property?.columnType:e.type;if(!t)if(t="string",e.property?.name&&!["_updateUser","_createUser"].includes(e.property?.name))logger.warn(`${e.path}: missing property type`);return t}static getPropertyType(e){let t="reference"===e.type?e.columnType:e.type;if(!t)if(t="string",!["_updateUser","_createUser"].includes(e.name))logger.warn(`${e.name}: missing property type`);return t}static orderByDirections(e){const t="oracle"===(e?.response?.locals?.config?.x3??xtrem_config_1.ConfigManager.current.x3).sql.driver;return{asc:t?"ASC NULLS FIRST":"ASC",desc:t?"DESC NULLS LAST":"DESC"}}static convertToConversionPair(e,t,r,s){switch(r){case"string":case"enum":case"datetime":case"date":return`(CASE WHEN (${t} = ${SqlResolver.nullValue(e,r)} OR ${t} IS NULL) THEN ${s[0]} ELSE ${s[1]} END)`;default:return`(CASE WHEN (${t} IS NULL) THEN ${s[0]} ELSE ${s[1]} END)`}}static aggregateSql(e,t,r){const s=this.getType(t);switch(r){case"value":return t.sql;case"year":case"month":case"day":{SqlResolver.checkDateOrDatetimeType(s,r);const a=SqlResolver.convertToConversionPair(e,t.sql,s,["NULL",t.sql]);return SqlResolver.getX3Pool(e).driverFunctions(a,r)}case"distinctCount":{const r=SqlResolver.castIfBoolean(t.sql,s);return`COUNT(DISTINCT ${SqlResolver.convertToConversionPair(e,r,s,["NULL",r])})`}case"hasNull":return`MAX(${SqlResolver.convertToConversionPair(e,t.sql,s,["1","0"])})`;default:return`${r}(${SqlResolver.castIfBoolean(t.sql,s)})`}}static resolveAggregate(e,t,r){const s=this.getType(t),a=SqlResolver.aggregateSql(e,t,r);return{...t,aggregationOperator:r,type:SqlResolver.getAggregateValueType(s,r),sql:a,columnAlias:SqlResolver.makeColumnAlias(`${t.columnAlias}_${r}`)}}static makeName30(e){if(e.length<=30)return e;const t=e.substring(0,5),r=e.substring(e.length-10,e.length);return`${t}${(0,crypto_1.createHash)("sha256").update(e).digest("hex").replace(/\s/g,"").substring(0,15)}${r}`.toUpperCase()}static makeColumnAlias(e,t){return this.makeName30((t??e).split("._").map(e=>(0,lodash_1.snakeCase)(e)).join("__").toUpperCase())}static resolveJson(e,t){const r=`${e.sql}->'${t}'`;return{...e,type:"json",sql:r,columnAlias:SqlResolver.makeColumnAlias(`${r}.${t}`)}}static resolveRange(e,t,r){let s;switch(t){case"start":s=`lower(${e.sql})`;break;case"end":s=`upper(${e.sql})`;break;default:throw new Error(`${e.path}.${t}: invalid range property`)}return{...e,type:r,sql:s,columnAlias:SqlResolver.makeColumnAlias(s)}}static resolveDate(e,t,r){const s=e.convertDatePropertyResult(t,r);return{...s,columnAlias:this.makeColumnAlias(s.sql)}}static isSystemOrTechnicalColumn(e){switch(e){case"_id":case"_sourceId":case"_extensionData":case"_constructor":case"_updateTick":case"_createUser":case"_updateUser":case"_createStamp":case"_updateStamp":return true;default:return false}}static findProperty(e,t){const r=exports.systemProperties[t];if(r){let s=xtrem_core_1.SystemProperties.getSystemProperty(e,t);if(!s)s=e.findProperty(t);return s._columnName=r.columnName,s._columnType=r.columnType,s}return e.findProperty(t)}static resolve(e,t,r,s){if("jsonReference"===r.type)return SqlResolver.resolveJson(r,s);if("json"===r.property?.type)return SqlResolver.resolveJson(r,s);if("date"===r.property?.type)return SqlResolver.resolveDate(e,r,s);if("dateRange"===r.property?.type)return SqlResolver.resolveRange(r,s,"date");if("datetimeRange"===r.property?.type)return SqlResolver.resolveRange(r,s,"datetime");const a=r.factory;if(!a)throw new Error("internal error: no factory");let o;if("_constructor"===s)o=constructorProperty,o.isInherited=!!a.baseFactory;else o=this.findProperty(a,s);const n=a.externalStorageManager;if(!o)throw new Error(`Property not found ${a.name}.${s}`);if(n.getInactiveProperties(t).includes(o))throw new Error(`Property inactive ${a.name}.${s}`);const l=n.isReverseReferenceProperty(o.name);if(!o.columnName&&o.isStored&&!l)throw new Error(`${a.name}.${s}: ColumnName is missing`);const i=r.path?`${r.path}.${s}`:s,c=o.isForeignNodeProperty()?o.targetFactory:a;if(!c)throw new Error(`target factory not found for ${a.name}.${s}`);const u={...r,path:i,type:o.type,isNullable:o.isNullable,isInherited:o.isInherited,property:o,factory:c,sql:"",columnAlias:"",denormalizeChildSlots:[]};if(o.getValue&&!o.isStored)try{const{getValue:t}=o;u.sql=e.withThisResultScope(r,()=>e.convertFunction(t).sql),u.columnAlias=SqlResolver.makeColumnAlias(i)}catch(e){throw new xtrem_shared_1.SystemError(`${a.name}.${this.name}: 'NYI: resolving computed property to SQL'`)}else if(l&&!o.columnName)u.sql=this.placeholderValue(t,o.columnType),u.columnAlias=SqlResolver.makeColumnAlias(i);else if("collection"===o.type);else{const e=SqlResolver.getFieldName(t,a,r.alias||"",o,r.childDenormalizedIndex??0);if(1===e.sqlColumns.length){const[t]=e.sqlColumns,[r]=e.aliases;u.sql=t,u.columnAlias=r}else u.denormalizeChildSlots=e.sqlColumns.map((t,a)=>{const o=e.aliases[a];return{...u,sql:t,columnAlias:o,childDenormalizedIndex:a+1,path:`${r.path}.${a}.${s}`}})}if(o.isCollectionProperty())u.reverseReferenceName="";return u}static propertyColumnSql(e,t,r){return`${e}.${t.columnName?.toUpperCase()}_${r}`}static constructSql(e,t,r){const s=this.getPropertyType(t);let a=this.propertyColumnSql(e,t,r);if("boolean"===s)a=`(CASE WHEN ${a} = 2 THEN 1 WHEN ${a} IS NULL THEN NULL ELSE 0 END)`;return a}static getFieldName(e,t,r,s,a){let o="",n="";const l=t.externalStorageManager;if("_id"===s.name)s.columnName="_ID";if(l.isDenormalized&&"denormalizedIndex"===s.name){if(s.columnName="DENORMALIZED_INDEX",a>0)return o=`${a}`,n=this.propertyColumnSql(r,s,""+(a-1)),{sqlColumns:[`${a}`],aliases:[this.makeColumnAlias(o,n)]};const t=l.getMaxRepeat(e),i=[],c=[];for(let e=0;e<t;e+=1)o=`${e+1}`,n=this.propertyColumnSql(r,s,String(e)),i.push(o),c.push(this.makeColumnAlias(o,n));return{sqlColumns:i,aliases:c}}if(l.isDenormalized&&!t.keyProperties.find(e=>e.name===s.name)&&!SqlResolver.isSystemOrTechnicalColumn(s.name)){if(a>0){const e=""+(a-1);return o=this.constructSql(r,s,e),n=this.propertyColumnSql(r,s,e),{sqlColumns:[o],aliases:[this.makeColumnAlias(o,n)]}}const t=l.getMaxRepeat(e),i=[],c=[];for(let e=0;e<t;e+=1)o=this.constructSql(r,s,String(e)),n=this.propertyColumnSql(r,s,String(e)),i.push(o),c.push(this.makeColumnAlias(o,n));return{sqlColumns:i,aliases:c}}const i=String(l.getDenormalizedPropertyColumnSuffix(s.name)??0);return o=this.constructSql(r,s,i),n=this.propertyColumnSql(r,s,i),{sqlColumns:[o],aliases:[this.makeColumnAlias(o,n)]}}}exports.SqlResolver=SqlResolver;
//# sourceMappingURL=sql-resolver.js.map