/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlConverter=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_ts_to_sql_1=require("@sage/xtrem-ts-to-sql"),lodash_1=require("lodash"),storage_1=require("../storage"),sql_resolver_1=require("./sql-resolver"),sql_value_converter_1=require("./sql-value-converter"),binaryOps={_eq:(e,t,r,o,n)=>`(${o} = ${n}${t?` AND (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=0)`:""})`,_ne:(e,t,r,o,n)=>`(${o} != ${n}${t?` OR (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`:""})`,_gt:(e,t,r,o,n)=>`(${o} > ${n}${t?` AND (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=0)`:""})`,_gte:(e,t,r,o,n)=>`(${o} >= ${n}${t?` AND (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=0)`:""})`,_lt:(e,t,r,o,n)=>`(${o} < ${n}${t?` OR (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`:""})`,_lte:(e,t,r,o,n)=>`(${o} <= ${n}${t?` OR (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`:""})`,_contains:(e,t,r,o,n)=>`(${o} @> ${n}${t?` OR (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`:""})`,_containedBy:(e,t,r,o,n)=>`(${o} <@ ${n}${t?` OR (${sql_resolver_1.SqlResolver.convertToConversionPair(e,o,r,["1","0"])}=1)`:""})`};function isFilterObject(e){return!!e&&(0,xtrem_core_1.isCompound)(e)}(0,xtrem_ts_to_sql_1.setLogger)(xtrem_core_1.Logger.getLogger(__filename,"sql-mapper"));class SqlConverter extends xtrem_ts_to_sql_1.Converter{constructor(e,t,r){let o;switch(sql_resolver_1.SqlResolver.getX3Pool(e).dialect){case"oracle":o="oracle";break;case"postgres":o="postgres";break;default:o="sqlServer"}super(e,r,{resolveColumnName:(e,t,r)=>sql_resolver_1.SqlResolver.resolve(this,e,t,r),resolveTableName:e=>{const r=e.tableName||e.name;if(/SELECT.* FROM/.test(r))return r;return`${t}.${r.toUpperCase()}`},resolveLiteral:e=>SqlConverter.resolveLiteral(e)},{dialect:o,maxSubQueryDepth:xtrem_core_1.ConfigManager.current.storage?.sql?.maxSubQueryDepth}),this.context=e,this.schemaName=t,this.rootFactory=r,this.args=[],this.localizedStringLanguage="ENG"}static resolveLiteral(e){let t;if("string"==typeof e)t=(0,xtrem_ts_to_sql_1.quote)(""===e?" ":e);else if("boolean"==typeof e)t=""+(e?1:0);else if(e instanceof xtrem_date_time_1.DateValue)t=`'${e}'`;else if(e instanceof xtrem_date_time_1.Datetime)t=`'${e}'`;else t=`${e}`;return t}static isSystemOrTechnicalColumn(e){return sql_resolver_1.SqlResolver.isSystemOrTechnicalColumn(e)}static getQuantifier(e,t){if(!t||"object"!=typeof t)throw new Error(`${e.path}: invalid collection filter - not an object`);const r=Object.keys(t).filter(e=>/^_(atMost|atLeast|every|none)$/.test(e));if(0===r.length)throw new Error(`${e.path}: missing _atLeast/_atMost/_every/_none quantifier on nested filter`);if(r.length>1)throw new Error(`${e.path}: only ONE _atLeast/_atMost/_every/_none quantifier on nested filter can be defined but found ${r}`);return r[0]}static checkQuantifierValue(e,t,r){if("_atMost"===r||"_atLeast"===r){if("number"!=typeof t[r])throw new Error(`${e.path}.${r}: value must be a number`)}else if(true!==t[r])throw new Error(`${e.path}.${r}: value must be true`)}convertCollectionFilter(e,t){const r=SqlConverter.getQuantifier(e,t);SqlConverter.checkQuantifierValue(e,t,r);const o=e.compositePath&&e.compositePath.length>0?this.convertOutputPath(e.compositePath):{...e,joinCondition:""},n=(0,lodash_1.omit)(t,[r]),s=this.withSubQueryScope(()=>({innerFilterSql:this.convertFilterObject(o,n)})),l="_every"===r?`NOT(${s.innerFilterSql})`:s.innerFilterSql,i=`(SELECT COUNT(*) FROM ${s.aliases.trim()} WHERE  ${SqlConverter.and([s.joinCondition,l])})`;switch(r){case"_atLeast":return`(${i} >= ${t[r]})`;case"_atMost":return`(${i} <= ${t[r]})`;case"_none":case"_every":return`(${i} = 0)`;default:throw new Error(`invalid quantifier: ${r}`)}}convertIdValue(e,t){if(null==t||""===t)return null;const r=e.property&&sql_resolver_1.SqlResolver.getPropertyType(e.property);let o=t;if(["boolean","integer","short"].includes(r||"string"))o=parseInt(t,10);if("enum"===r){const r=e.property?.dataType;o=r.numberValue(t)}return sql_value_converter_1.SqlValueConverter.fromSql(this.context,e,o)}convertIdFilter(e,t){if("number"==typeof t&&t<0)return"1=1";if(null==t)return"1=2";if("string"==typeof t&&t.startsWith("#"))return this.convertIdFilter(e,t.substring(1));const{parent:r}=e;if(!r)throw new Error(`${e.path}: missing parent.`);const o=String(t).split("|"),n=e.factory?.keyProperties.reduce((e,t,n)=>{const s=this.withThisResultScope(r,()=>this.convertOutputPath([t.name]));return e[t.name]=this.convertIdValue(s,o[n]),e},{});return this.convertFilterObject(r,n)}convertPropertyFilter(e,t,r){const o=this.walk(e,r),n=t[r];if("_id"===o.property?.name&&!isFilterObject(n))return this.convertIdFilter(o,n);if("collection"===o.type)return this.convertCollectionFilter(o,n);return this.convertAnyFilter(o,n)}static typeDefaultValue(e,t){if(t.isNullable)return null;switch(t.type||t.property?.columnType){case"string":return"";case"float":case"double":case"integer":case"short":case"enum":return 0;case"decimal":return xtrem_decimal_1.Decimal.make(0);case"boolean":return false;case"date":return sql_resolver_1.SqlResolver.getX3Pool(e).nullDate;case"datetime":{const{nullDate:t}=sql_resolver_1.SqlResolver.getX3Pool(e);return xtrem_date_time_1.Datetime.makeUtc(t.year,t.month,t.day)}case"uuid":return xtrem_core_1.Uuid.generate();case"binaryStream":return xtrem_core_1.BinaryStream.fromBuffer(Buffer.alloc(0));case"textStream":return xtrem_core_1.TextStream.fromString("");default:throw new Error(`unsupported type ${t.type}`)}}booleanSqlValue(e){return e?"1":"0"}jsonReferenceSqlValue(e){return"string"==typeof e?(0,xtrem_ts_to_sql_1.quote)(e):e}enumSqlValue(e,t,r,o){if(!o)return SqlConverter.typeDefaultValue(this.context,{property:e,type:t,isNullable:r.isNullable});if(!Number.isFinite(Number(o))){const t=e.dataType;return(0,xtrem_ts_to_sql_1.sqlNumber)(r,t.numberValue(o))}return(0,xtrem_ts_to_sql_1.sqlNumber)(r,o)}sqlValue(e,t){const{property:r}=e;if(!r?.type&&!e.type)throw new Error(`${e.path}: cannot establish type`);const o=sql_resolver_1.SqlResolver.getType(e);if(null==t)return SqlConverter.typeDefaultValue(this.context,{property:r,type:o,isNullable:e.isNullable});switch(o){case"boolean":return this.booleanSqlValue(t);case"enum":if(!r)throw new Error(`${e.path}: enum property not set`);return this.enumSqlValue(r,o,e,t);case"string":return(0,xtrem_ts_to_sql_1.quote)(String(t||" ").replaceAll(storage_1.X3StorageManager.hashtagPlaceholder,"#"));case"decimal":case"time":case"textStream":return(0,xtrem_ts_to_sql_1.quote)(String(t));case"short":case"float":case"double":case"integer":return(0,xtrem_ts_to_sql_1.sqlNumber)(e,t);case"date":return sql_resolver_1.SqlResolver.getX3Pool(this.context).charToDate((0,xtrem_ts_to_sql_1.quote)(String(t)));case"datetime":return sql_resolver_1.SqlResolver.getX3Pool(this.context).charToDate((0,xtrem_ts_to_sql_1.quote)(String(t)),true);case"json":case"jsonReference":return this.jsonReferenceSqlValue(t);default:throw new Error(`${e.path}: cannot convert type ${o} to SQL`)}}static convertRegExpOps(e,t,r){const o=(0,xtrem_ts_to_sql_1.quote)(r._options||""),n=sql_resolver_1.SqlResolver.getType(t);return sql_resolver_1.SqlResolver.getX3Pool(e).regexOrLike(t.sql,n,String(r._regex),o)}static jsonCast(e,t){throw new Error("NYI: JSON Conversion")}convertValue(e,t){const r=sql_resolver_1.SqlResolver.getType(e),getExpression=(t,r)=>{if("boolean"===e.property?.type&&e.property?.getValue)return"1"===r?t:`(NOT (${t}))`;return`${t} = ${r}`};if(null===t)return`${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,e.sql,r||"string",["1","0"])}=1`;if(("_id"===e.property?.name||"reference"===e.type)&&"string"==typeof t&&"#"===t[0]){if(!e.factory)throw new Error(`${e.path}: missing target factory`);const r=e.factory.parseNodeId(t);return this.convertFilterObject(e,r)}const o=this.sqlValue(e,t),n="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,o):e.sql;if(e.denormalizeChildSlots&&e.denormalizeChildSlots.length>0){const t=e.denormalizeChildSlots.map(e=>{const t="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,o):e.sql;return getExpression(t,o)});return SqlConverter.or(t)}return getExpression(n,o)}static checkArray(e,t){if(!Array.isArray(t))throw new Error(`${e.path}: values is not an array`)}convertXinFilter(e,t,r){const o=sql_resolver_1.SqlResolver.getType(e),n=t[r];if(SqlConverter.checkArray(e,n),0===n.length)return"_in"===r?"1=0":"1=1";const s=n.indexOf(null);if(s>=0){const t=n.slice();if(t.splice(s,1),0===t.length)return this.convertFilterObject(e,"_in"===r?{_eq:null}:{_ne:null});if("_in"===r)return this.convertFilterObject(e,{_or:[{_eq:null},{_in:t}]});return this.convertFilterObject(e,{_ne:null,_nin:t})}const l=`(${n.map(t=>this.sqlValue(e,t)).join(",")})`;return"_in"===r?`(${e.sql} IN ${l})`:`(${e.sql} NOT IN ${l} OR ${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,e.sql,o,["1","0"])}=1)`}convertAndFilter(e,t){SqlConverter.checkArray(e,t);const r=t.map(t=>this.convertFilterObject(e,t));return SqlConverter.and(r)}convertOrFilter(e,t){SqlConverter.checkArray(e,t);const r=t.map(t=>this.convertAnyFilter(e,t));return SqlConverter.or(r)}convertModFilter(e,t){if(SqlConverter.checkArray(e,t),2!==t.length)throw new Error(`${e.path}: expected 2 values in array, got ${t.length}`);const r=t.map(t=>this.sqlValue(e,t));return`(${e.sql} % ${r[0]} = ${r[1]})`}convertNotFilter(e,t){return`(NOT (${this.convertFilterObject(e,t)}))`}convertBinaryOpFilter(e,t,r){const{property:o}=e;if(!o)throw new Error(`${e.path}: Property not set on slot`);const n=sql_resolver_1.SqlResolver.getType(e),s=binaryOps[r];let l=t[r];const i=e.parent||e,getNullValue=()=>{let t=1;if("_ne"===r)t=0;if(e.denormalizeChildSlots&&e.denormalizeChildSlots.length>0)return SqlConverter.or(e.denormalizeChildSlots.map(e=>`${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,e.sql,n,["1","0"])}=${t}`));return`${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,e.sql,n,["1","0"])}=${t}`};if("_id"===o.name){const t=String(l).split("|"),o=e.factory?.keyProperties.map((e,o)=>{const n=this.withThisResultScope(i,()=>this.convertOutputPath([e.name]));return this.convertBinaryOpFilter(n,{[r]:this.convertIdValue(n,t[o])},r)}).join(" AND ");if(!o)return getNullValue();return`(${o})`}if(null==l){if(e.isNullable||e.path&&e.path.split(".").length>2)return getNullValue();l=SqlConverter.typeDefaultValue(this.context,{property:o,type:n,isNullable:e.isNullable})}const a=this.sqlValue(e,l),getOpSql=e=>{const t="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,l):e.sql;return s(this.context,!!e.isNullable,n,t,a)};if(e.denormalizeChildSlots&&e.denormalizeChildSlots.length>0)return SqlConverter.or(e.denormalizeChildSlots.map(getOpSql));return getOpSql(e)}convertOperatorFilter(e,t,r){if(binaryOps[r])return this.convertBinaryOpFilter(e,t,r);const o=t[r];switch(r){case"_in":case"_nin":return this.convertXinFilter(e,t,r);case"_and":return this.convertAndFilter(e,o);case"_or":return this.convertOrFilter(e,o);case"_nor":return SqlConverter.checkArray(e,o),this.convertFilterObject(e,{_and:o.map(e=>({_not:e}))});case"_mod":return this.convertModFilter(e,o);case"_not":return this.convertNotFilter(e,o);case"_regex":return SqlConverter.convertRegExpOps(this.context,e,t);case"_options":if(!t._regex)throw new Error(`${e.path}: _options without _regex`);return"";case"_fn":if("string"!=typeof o)throw new Error(`${e.path}: _fn value is not a string`);return this.convertFunctionBody(e,o).sql;default:throw new Error(`${e.path}: invalid operator: ${r}`)}}convertFilterObject(e,t){const r=Object.keys(t);if(0===r.length||1===r.length&&"denormalizedIndex"===r[0]){if(e.parent&&(!e.path||!this.results.get(e.path)))this.makeAliasAndJoin(e);return"1=1"}const{factory:o}=e;if(!o)throw new Error(`${e.path}: missing target factory`);const n=r.filter(e=>"denormalizedIndex"!==e).map(r=>{if("_"===r[0]&&!SqlConverter.isSystemOrTechnicalColumn(r))return this.convertOperatorFilter(e,t,r);return this.convertPropertyFilter(e,t,r)}).filter(e=>!!e);return SqlConverter.and(n)}convertFunctionValue(e,t){const r=this.convertFunction(t).sql,o="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,r):e.sql,n=`${o} = ${r}`;return e.isNullable?`(${n} OR (${o} IS NULL AND ${r} is NULL))`:n}convertLiteral(e){if("string"==typeof e)return super.convertLiteral(e.replaceAll(storage_1.X3StorageManager.hashtagPlaceholder,"#"));return super.convertLiteral(e)}convertJoinLiteralValue(e,t){const r=this.convertLiteral(t.value).sql,o="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,r):e.sql,n=`${o} = ${r}`;return e.isNullable?`(${n} OR (${o} IS NULL AND ${r} is NULL))`:n}convertAnyFilter(e,t){if(t instanceof RegExp)return this.convertAnyFilter(e,{_regex:t.source,_options:t.flags});if(t instanceof xtrem_core_1.Node)return this.convertFilterObject(e,{_id:t._id});if("function"==typeof t)return this.convertFunctionValue(e,t);if(t instanceof xtrem_core_1.JoinLiteralValue)return this.convertJoinLiteralValue(e,t);if(isFilterObject(t))return this.convertFilterObject(e,t);return this.convertValue(e,t)}convertFilter(e){if("string"==typeof e)return e;if("function"==typeof e)return super.convertFunction(e).sql;if(!(e&&"object"==typeof e))throw new Error(`filter is not an object: ${e&&typeof e}`);const t={factory:this.rootFactory,type:"reference",sql:"t0",path:"this",alias:"t0"};return this.convertFilterObject(t,e)}convertOrderBy(e){const t=[],convertOne=(e,r,o)=>{Object.keys(o).forEach(n=>{const s=[...r,n],l=this.withThisResultScope(e,()=>this.walk(e,n)),i=o[n];if(i&&"object"==typeof i)convertOne(l,s,i);else if(-1===i||1===i){if(!l.property)throw new Error(`${s}: 'Missing property in result.`);t.push({property:l.property,path:s,direction:i,sql:"denormalizedIndex"!==l.property?.name?l.sql:"1",columnAlias:l.columnAlias||`${l.property?.name.toUpperCase()}_0`})}else throw new Error(`${s}: invalid value: ${i})`)})},r=super.convertThisExpression();return convertOne(r,[],e),t}convertOutputPath(e){let t=super.convertThisExpression();return e.forEach(e=>{t=this.walk(t,e)}),{...t,payloadPath:e}}convertOutputPaths(e){return e.map(e=>this.convertOutputPath(e))}convertAggregateGroups(e){return e.map(e=>sql_resolver_1.SqlResolver.resolveAggregate(this.context,this.convertOutputPath(e.path),e.groupedBy||"value"))}convertAggregate(e){if(!e)return{};return{groups:e.groups.map(e=>sql_resolver_1.SqlResolver.resolveAggregate(this.context,this.convertOutputPath(e.path),e.groupedBy||"value")),values:e.values.map(e=>sql_resolver_1.SqlResolver.resolveAggregate(this.context,this.convertOutputPath(e.path),e.operator||"distinctCount"))}}withSubQueryScope(e){const t=super.withSubQueryScope(e);return{...t,aliases:t.aliases.replace(/ AS /g," ").trim(),joinCondition:t.joinCondition}}static getLanguageFromLocale(e){if(!xtrem_core_1.Context.localizationManager.getLanguageFromLocale||true===e.globals.localizationManagerBusy)return"ENG";return e.currentLanguageCode}static getDefaultFolderLanguage(e){if(!xtrem_core_1.Context.localizationManager.getFolderDefaultLanguage||true===e.globals.localizationManagerBusy)return"FRA";return e.defaultLanguageCode}resolveColumnName(e,t){return this.resolver.resolveColumnName(this.context,e,t)}resolveTableName(e){return this.resolver.resolveTableName(e)}static and(e){return SqlConverter.joinThis(e," AND ","1=1")}static or(e){const t=SqlConverter.joinThis(e," OR ","1=0");return e.length>1?`(${t})`:t}static joinThis(e,t,r){const o=e.filter(e=>!!e);if(o.length>1)return`${o.join(t)}`;if(1===o.length&&o[0])return o[0];return r}static convertCompositePath(e,t){const{factory:r}=e,o=r?.externalStorageManager,{compositeReferencePaths:n}=o;if(n[t])return n[t];return[t]}resolveJoinElement(e,t,r,o){if("string"==typeof r){const o=this.resolveColumnName(e,r);if(t.childDenormalizedIndex&&t.childDenormalizedIndex>0&&o.denormalizeChildSlots&&o.denormalizeChildSlots.length>=t.childDenormalizedIndex)return o.denormalizeChildSlots[t.childDenormalizedIndex-1].sql;return o.sql}if("function"==typeof r){let n=this.withThisResultScope(e,()=>this.convertFunction(r).sql);if("null"===n){const e=t.factory.findProperty(o,{includeSystemProperties:true});return sql_value_converter_1.SqlValueConverter.toSql(this.context,t.factory,e,null)}const s=this.resolveColumnName(t,o);if("enum"===s.property?.type&&"string"==typeof n){const e=s.property?.dataType,t=n.replace(/^[`']|[`']$/g,"");if(e.numberValue(t)>=0)n=e.numberValue(t).toString()}return n}if(r instanceof xtrem_core_1.JoinLiteralValue)return this.convertJoinLiteralValue(t,r);throw new Error(`Join of ${t.property?.name} cannot be resolved. ${o}`)}constructJoin(e,t,r){const o=[],n={alias:t.join?.left.alias,sqls:[]},s={alias:t.join?.right.alias,sqls:[]},l=t.property?.join||{};return Object.keys(l).filter(e=>!r?.joinsToExclude||!r.joinsToExclude.includes(e)).forEach(r=>{const i=this.resolveColumnName(t,r),a=i.sql;n.sqls.push(a);const getJoinSql=t=>{let o=this.resolveJoinElement(e,t,l[r],r);if("enum"===t.property?.type&&"string"==typeof o){const e=i.property?.dataType;if(o=o.replace(/^[`']|[`']$/g,""),e.numberValue(o)>=0)o=e.numberValue(o).toString()}return o};if(t.denormalizeChildSlots&&t.denormalizeChildSlots.length>0){const e=t.denormalizeChildSlots.map(getJoinSql).join(",");s.sqls.push(e);const r=`${a} IN (${e})`;o.push(r)}else{const e=getJoinSql(t);s.sqls.push(e||"");const r=`${a} = ${e}`;o.push(r)}}),{...t.join||{isNullable:true},condition:SqlConverter.and(o),left:n,right:s}}manageReferenceJoinFallbackProperties(e,t){const{factory:r}=t,o=t.property?.join||{},n=r.externalStorageManager.joinFallbackProperties,s="r0",l={...t,alias:s};t.join=this.constructJoin(e,t,{joinsToExclude:n});const i=[this.constructJoin(e,l,{joinsToExclude:n}).condition],a=[];n.forEach(t=>{const n=this.resolveColumnName(l,t).sql,s=sql_resolver_1.SqlResolver.orderByDirections(this.context),c=r.findProperty(t,{includeSystemProperties:true}),u=sql_resolver_1.SqlResolver.getPropertyType(c),h=sql_resolver_1.SqlResolver.nullValue(this.context,u),p=[];let v=s.desc;if(void 0!==o[t]){const r=this.resolveJoinElement(e,l,o[t],t);if(p.push(`${n} = ${h}`),r!==h&&"null"!==r)p.push(`${n} = ${r}`)}else v=s.asc;if(a.push(`${n} ${v}`),p.length>0)i.push(SqlConverter.or(p))});const c=sql_resolver_1.SqlResolver.getX3Pool(this.context).limitClause(1),u=sql_resolver_1.SqlResolver.getX3Pool(this.context).fetchOnlyClause(1);if(!r.tableName)throw new Error(`${t.path}: target factory tableName not set.`);const h=this.resolveTableName(r);r.keyProperties.filter(e=>"denormalizedIndex"!==e.name).forEach(e=>{const r=this.resolveColumnName(t,e.name).sql,o=this.resolveColumnName({...t,alias:s},e.name).sql;i.push(`${r} = ${o}`)});const p=`SELECT ${c} * FROM ${h} ${s} WHERE ${SqlConverter.and(i)} ORDER BY ${a.join()} ${u}`,v=SqlConverter.and([t.join.condition,`EXISTS(${p})`]);t.join={...t.join,condition:v,left:{...t.join.left,sqls:[]},right:{...t.join.right,sqls:[]}}}convertReferenceProperty(e,t){const{factory:r}=t,o=r?.externalStorageManager,{joinFallbackProperties:n}=o;if(n&&n.length>0)this.manageReferenceJoinFallbackProperties(e,t);else t.join=this.constructJoin(e,t);return t}convertForeignNodeProperty(e,t){if("reference"===t.property?.type)return this.convertReferenceProperty(e,t);return t.join=this.constructJoin(e,t),t}convertId(e){const{parent:t}=e;if(!t)throw new Error(`${e.path}: parent not set.`);const r=t.factory;if(!r)throw new Error(`${e.path}: parent factory not set.`);const{keyProperties:o}=r,n=o.map(e=>this.resolveColumnName(t,e.name)),s=r.externalStorageManager,getIdSql=e=>this.concat(n.map(t=>{if("date"===t.type)return sql_resolver_1.SqlResolver.getX3Pool(this.context).dateToChar(t.sql);if("denormalizedIndex"===t.property?.name)return`'${e+1}'`;return sql_resolver_1.SqlResolver.getX3Pool(this.context).toChar(t.sql)}).map((e,t)=>{if(0===t)return e;return this.concat([(0,xtrem_ts_to_sql_1.quote)("|"),e])}));if(e.sql=getIdSql(0),e.columnAlias=sql_resolver_1.SqlResolver.makeColumnAlias(`${e.alias}._ID_0`),s.isDenormalized){e.sql="",e.columnAlias="",e.denormalizeChildSlots=[];const t=s.getMaxRepeat(this.context);for(let r=0;r<t;r+=1){const t=`${e.alias}._ID_${r}`;e.denormalizeChildSlots.push({...e,sql:getIdSql(r),columnAlias:sql_resolver_1.SqlResolver.makeColumnAlias(t),childDenormalizedIndex:r+1,path:`${e.path}.${r+1}`})}}}createReferenceJoin(e){if("string"===e.parent?.property?.type&&e.parent?.property?.isLocalized)return void(e.join=this.createLocalizedJoin(e,this.localizedStringLanguage));const{parent:t}=e;if(!t)throw new Error(`${e.path}: parent not set.`);const{join:r}=this.convertForeignNodeProperty(t,e);e.join={left:{alias:t.alias||"",sqls:[t.sql]},right:{alias:e.alias||"",sqls:[e.sql]},condition:r?.condition||"1=1",isNullable:!!e.property?.isNullable||!!t.join?.isNullable}}createCollectionJoin(e){const{parent:t}=e;if(!t)throw new Error(`${e.path}: parent not set.`);this.scopeAlias={tableName:this.resolver.resolveTableName(e.factory),alias:e.alias||"",join:this.constructJoin(t,e)}}mapLocalizedKey(e,t,r){const o=e.factory,n=o?.externalStorageManager,s=sql_resolver_1.SqlResolver.getX3Pool(this.context);return this.withThisResultScope(e,()=>t.map(t=>{if("function"==typeof t)return this.convertFunction(t).sql;if("string"==typeof t){if("denormalizedIndex"===t)return`${r}`;const l=this.resolveColumnName(e,t);let{sql:i}=l;if(n.isDenormalized&&!o?.keyProperties.find(e=>e.name===t)&&!SqlConverter.isSystemOrTechnicalColumn(t))i=`${l.alias}.${l.property?.columnName}_${r}`;if("date"===l.type||"reference"===l.type&&"date"===l.property?.columnType){const e="mssql"===s.dialect?"112":"YYYYMMDD";return s.dateToChar(i,e)}return i}return(0,xtrem_ts_to_sql_1.quote)(" ")}))}convertLocalizedStringKeyValue(e,t){if(0===e.length)return(0,xtrem_ts_to_sql_1.quote)(" ");const r=sql_resolver_1.SqlResolver.getX3Pool(this.context);return this.concat(e.map((e,o)=>{if(0===o)return r.toChar(e);return this.concat([(0,xtrem_ts_to_sql_1.quote)(t),r.toChar(e)])}))}createLocalizedJoin(e,t){const r=[],o={alias:e.alias,sqls:[]},n=e.parent;if(!n)throw new Error(`${e.path}: missing parent.`);const s=super.convertThisExpression();s.childDenormalizedIndex=n.childDenormalizedIndex;const l=n.parent??s;if(!l)throw new Error(`${e.path}: Missing node parent.`);const i={alias:l.alias,sqls:[]},a=n.factory,c=a.externalStorageManager,u=n.property?.name||"",h=c.getLocalization(u),p=h?h.tableName:a.tableName,v=h?h.columnName:n.property?.columnName,_=" ";let m=[],q=[];const f=l.childDenormalizedIndex?l.childDenormalizedIndex-1:0;if(h){if(!h.key1||!h.key1.length)throw new Error(`${a.name}.${u}: localization attribute key1 details not supplied for property.`);if(m=this.mapLocalizedKey(l,h.key1??[],f),h.key2&&h.key2.length)q=this.mapLocalizedKey(l,h.key2??[],f)}else{if(a.keyProperties.length>2)throw new Error(`${a.name}.${u}: localization details not supplied for property and key properties are more than 2.`);if(m=this.mapLocalizedKey(l,[a.keyProperties[0].name],f),a.keyProperties.length>=2)q=this.mapLocalizedKey(l,a.keyProperties.slice(1).map(e=>e.name),f)}const addJoin=(t,n)=>{o.sqls.push(`${e.alias}.${t}`),i.sqls.push(n),r.push(`${e.alias}.${t} = ${n}`)};addJoin("CODFIC_0","function"==typeof p?this.withThisResultScope(l,()=>this.convertFunction(p).sql):(0,xtrem_ts_to_sql_1.quote)(p?.toUpperCase()??_));addJoin("ZONE_0","function"==typeof v?this.withThisResultScope(l,()=>this.convertFunction(v).sql):(0,xtrem_ts_to_sql_1.quote)(v?.toUpperCase()??_));const d=h&&h.concatenator?h.concatenator:"~";addJoin("IDENT1_0",this.convertLocalizedStringKeyValue(m,d));return addJoin("IDENT2_0",this.convertLocalizedStringKeyValue(q,d)),addJoin("LANGUE_0",(0,xtrem_ts_to_sql_1.quote)(t)),{condition:SqlConverter.and(r),left:i,right:o,isNullable:true}}withLocalizedStringScope(e,t){this.localizedStringLanguage=e;try{return t()}finally{this.localizedStringLanguage=e}}createLocalizedStringAliasAndJoin(e,t){const r={parent:e,factory:{tableName:"ATEXTRA"},path:`${e.path}.${t}`,sql:""};return this.withLocalizedStringScope(t,()=>this.makeAliasAndJoin(r)),r}getLocalizedStringSql(e,t,r){const o=`${this.createLocalizedStringAliasAndJoin(e,t).alias}.TEXTE_0`;if(t===r)return o;return`(CASE WHEN (${o} IS NOT NULL) THEN ${o} ELSE ${`${this.createLocalizedStringAliasAndJoin(e,r).alias}.TEXTE_0`} END)`}convertLocalizedString(e){const{path:t}=e;if(!t)throw new Error("cannot convert localized string property: no path");if(this.results.get(t))return;const r=SqlConverter.getDefaultFolderLanguage(this.context),o=SqlConverter.getLanguageFromLocale(this.context);if(e.denormalizeChildSlots&&e.denormalizeChildSlots.length>0)e.sql="",e.columnAlias="",e.denormalizeChildSlots.forEach(e=>{if(this.results.get(e.path))return;e.sql=this.getLocalizedStringSql(e,o,r),this.results.set(e.path,e)});else e.sql=this.getLocalizedStringSql(e,o,r);this.results.set(t,e)}convertBinaryExpression(e){const t=this.convertExpression(e.left),r=this.convertExpression(e.right),o=e.operator;if("boolean"===(t.property&&sql_resolver_1.SqlResolver.getPropertyType(t.property))&&"Literal"===e.right.type&&["===","!=="].includes(o)){const e="==="===o?"=":"!=";return xtrem_ts_to_sql_1.Converter.booleanResult(`(${t.sql} ${e} ${this.cast(r,t.type).sql})`)}return super.convertBinaryExpression(e)}walk(e,t){const r=SqlConverter.convertCompositePath(e,t);if(r.length>1)return this.withThisResultScope(e,()=>this.convertOutputPath(r));const o=super.walk(e,t);if(o.property?.isLocalized)this.convertLocalizedString(o);if("_id"===o.property?.name)this.convertId(o);return o}concat(e){if(0===e.length)return"";if(1===e.length)return e[0];const t=e.slice(),r=t.pop();return`CONCAT(${this.concat(t)},${r})`}}exports.SqlConverter=SqlConverter;
//# sourceMappingURL=sql-converter.js.map