import { AccessRightsManager, Context, NodeFactory, Property } from '@sage/xtrem-core';
import { GenericConversionResult } from '@sage/xtrem-ts-to-sql';
export interface ConversionResult extends GenericConversionResult<NodeFactory, Property> {
    compositePath?: string[];
    childDenormalizedIndex?: number;
    denormalizeChildSlots?: ConversionResult[];
}
export interface UserAccessCode {
    accessCode: string;
    modification: boolean;
    execution: boolean;
    inquiry: boolean;
}
export interface X3AccessRightsManager extends AccessRightsManager {
    (context: Context): Promise<UserAccessCode[] | null>;
    getUserAccessCodes(context: Context): Promise<UserAccessCode[] | null>;
}
export interface OutputColumn extends ConversionResult {
    payloadPath?: string[];
}
export interface AggregateResult {
    joinConditions?: string;
    groups?: ConversionResult[];
    values?: ConversionResult[];
}
//# sourceMappingURL=sql-converter.d.ts.map