/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.WebServiceHelper=void 0;const xtrem_core_1=require("@sage/xtrem-core"),web_service_call_1=require("./web-service-call"),logger=xtrem_core_1.Logger.getLogger(__filename,"web-service");class WebServiceHelper{static async importWebServiceCall(e,a,t,r,s,o,i){logger.info("This script is working only for single properties result that have been sent with the following format [[property:value]]");const n=await web_service_call_1.WebServiceCall.connectTo(e,"AOWSIMPORT",{validationContext:i}),c=await n.createWithImport(s,a,r);if(n.manageWebServiceResponseMessages(c,n.mapping,n.soapPayload),c.messages?.errors?.length)return c;if(!c.messages?.info?.length)throw new Error("The result of your request is not sent back. Please check your import processing script in X3");return logger.verbose(()=>`RESPONSE=${JSON.stringify(c)}`),c.output={},o.forEach(e=>{const a=c.messages&&c.messages.info&&c.messages.info.find(a=>a.match(`\\[\\[${e}:(.*)\\]\\]`));if(a){const t=a.split(" "),r=`${e}:${t.length?t[t.length-1]:""}`;let s=a.match(`\\[\\[${e}:(.*)\\]\\]`);if(!s)s=r.match(`${e}:(.*)`);if(s)c.output[e]=s[1]}else throw new Error(`the value of ${e} is not returned by the web service`)}),c}static async objectWebServiceCall(e,a,t,r,s,o,i){const n={forceMappingRegeneration:false},c=await web_service_call_1.WebServiceCall.connectTo(e,s,{validationContext:o});let l;switch(t){case xtrem_core_1.NodeStatus.added:l=await c.doCreate(r,a,n);break;case xtrem_core_1.NodeStatus.modified:l=await c.doUpdate(r,a,n);break;default:throw new Error(`invalid action: ${r}`)}if(c.manageWebServiceResponseMessages(l,c.mapping,c.soapPayload),!i?.returnRawResult)l.results=c.getXtremCompatibleResponse(l,c.mapping);return l}static async subProgramWebServiceCall(e,a,t,r,s,o){const i={forceMappingRegeneration:false},n=await web_service_call_1.WebServiceCall.connectTo(e,r,{validationContext:s}),c=await n.runSubProgram(t,a,i);if(n.manageWebServiceResponseMessages(c,n.mapping,n.soapPayload),!o?.returnRawResult)c.results=n.getXtremCompatibleResponse(c,n.mapping);return c}static{this.objectWebServiceCallWithRawXmlPayload=async(e,a,t,r,s,o)=>{const i=await web_service_call_1.WebServiceCall.connectTo(e,t,{validationContext:o});let n={statusCode:0,results:{}};switch(a){case xtrem_core_1.NodeStatus.added:n=await i.createWithRawXmlPayload(r);break;case xtrem_core_1.NodeStatus.modified:if(s)n=await i.updateWithRawXmlPayload(r);break;default:throw new Error(`invalid action: ${a}`)}return i.manageWebServiceResponseMessages(n,i.mapping,i.soapPayload),n}}static async subProgramWebServiceCallWithRawXmlPayload(e,a,t,r){const s=await web_service_call_1.WebServiceCall.connectTo(e,a,{validationContext:r}),o=await s.runSubProgramWithPayload(t);return s.manageWebServiceResponseMessages(o,s.mapping,s.soapPayload),o}static async objectWebServiceCallWithJsonPayload(e,a,t,r,s,o){const i=await web_service_call_1.WebServiceCall.connectTo(e,t,{validationContext:o});let n={statusCode:0,results:{}};switch(a){case xtrem_core_1.NodeStatus.added:n=await i.createWithPayload(r);break;case xtrem_core_1.NodeStatus.modified:if(s)n=await i.updateWithPayload(s,r);break;default:throw new Error(`invalid action: ${a}`)}return i.manageWebServiceResponseMessages(n,i.mapping,i.soapPayload),n}static{this.subProgramWebServiceCallWithJsonPayload=async(e,a,t,r)=>{const s=await web_service_call_1.WebServiceCall.connectTo(e,a,{validationContext:r}),o=await s.runSubProgramWithPayload(t);return s.manageWebServiceResponseMessages(o,s.mapping,s.soapPayload),o}}}exports.WebServiceHelper=WebServiceHelper;
//# sourceMappingURL=web-service-helper.js.map