import { Context, NodeFactory, NodeStatus, ValidationContext } from '@sage/xtrem-core';
import { ResultInterface } from '../interfaces/result-interface';
import { WebServiceInputsParameters } from '../interfaces/web-service-inputs-parameters-interface';
import { WebServiceKeysParameters } from '../interfaces/web-service-keys-parameters-interface';
export declare class WebServiceHelper {
    static importWebServiceCall(nodeContext: Context, factory: NodeFactory, nodeStatus: NodeStatus, graphqlPayload: any, importModelName: string, outputNames: string[], validationContext?: ValidationContext): Promise<ResultInterface>;
    static objectWebServiceCall(nodeContext: Context, factory: NodeFactory, nodeStatus: NodeStatus, graphqlPayload: any, webServiceName: string, validationContext?: ValidationContext, options?: {
        returnRawResult?: boolean;
    }): Promise<ResultInterface>;
    static subProgramWebServiceCall(nodeContext: Context, factory: NodeFactory, graphqlPayload: any, webServiceName: string, validationContext?: ValidationContext, options?: {
        returnRawResult?: boolean;
    }): Promise<ResultInterface>;
    static objectWebServiceCallWithRawXmlPayload: (nodeContext: Context, nodeStatus: NodeStatus, webServiceName: string, payload: string, keys?: string, validationContext?: ValidationContext) => Promise<ResultInterface>;
    static subProgramWebServiceCallWithRawXmlPayload(nodeContext: Context, webServiceName: string, payload: WebServiceInputsParameters<string>, validationContext?: ValidationContext): Promise<ResultInterface>;
    static objectWebServiceCallWithJsonPayload(nodeContext: Context, nodeStatus: NodeStatus, webServiceName: string, payload: WebServiceInputsParameters<string>, keys?: WebServiceKeysParameters<string>, validationContext?: ValidationContext): Promise<ResultInterface>;
    static subProgramWebServiceCallWithJsonPayload: (nodeContext: Context, webServiceName: string, payload: WebServiceInputsParameters<string>, validationContext?: ValidationContext) => Promise<ResultInterface>;
}
//# sourceMappingURL=web-service-helper.d.ts.map