import { interfaces } from '../index';
/**
 * Parse Graph Payload to Import Web Service Payload I_FILE
 */
export declare class GraphqlPayloadToLegacyImportProcessing {
    private readonly _importMapping;
    private readonly _collections;
    private readonly _fields;
    private readonly _delimiter;
    eol: string;
    private static instance;
    private constructor();
    static processing(importMapping: interfaces.ImportOptionsInterface): GraphqlPayloadToLegacyImportProcessing;
    /**
     * parse Graphql Payload to import data
     * @param graphqlPayload
     */
    parseGraphqlPayload(graphqlPayload: any): string;
    /**
     * remove the arrays from the Object
     * @param payload
     */
    getArrayLessObject(payload: any): any;
    /**
     * Transform each element of an array of the collection to an object
     * The transformation merges the parent record into the collection record and returns an array of objects
     * Example:
     *  payload = { foo: 'x', collection: [{bar:'1'},{bar:'2'}] }
     *  result => [{foo: 'x',collection:{bar:'1'}}{foo: 'x',collection:{bar:'2'}}]
     * This method will be called for every collection listed in the web service mapping definition and will flatten the data for
     * all collections.
     * @param payload
     * @param path
     */
    static processGraphqlPayloadCollection(payload: any[], path: string): any[];
    /**
     * map over all the import model collection
     * @param payload
     */
    processGraphqlPayload(payload: any[]): any[];
    /**
     * map over all the import field
     * @param processedPayload
     */
    graphqlPayloadToLegacyImportPayloadLines(processedPayload: any[]): any[];
    get importMapping(): interfaces.ImportOptionsInterface;
}
//# sourceMappingURL=graphql-payload-to-legacy-import-processing.d.ts.map