/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ApiHelper=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),crypto=require("crypto"),fs=require("fs"),_=require("lodash"),fsp=require("path"),sql_resolver_1=require("../sql-mapper/sql-resolver"),folder_manager_1=require("../storage/folder-manager"),x3_storage_manager_1=require("../storage/x3-storage-manager"),logger=xtrem_core_1.Logger.getLogger(__filename,"api-helper");class ApiHelper{static getConfig(e){let t,r,a,n;const i=folder_manager_1.FolderManager.getFolderName({context:e}),s=xtrem_config_1.ConfigManager.current;try{t=e.getContextValue("token"),r=e.getContextValue("apiUrl"),a=e.getContextValue("session"),n=e.getContextValue("x3Cookies")}catch(e){t=void 0,r=void 0,a=void 0}const o=1e3*(s.graphql?.timeLimitInSeconds??60);if(r||t){let e;if(!t)throw e="Token is mandatory",new Error(e);if(!r)throw e="URL is mandatory",new Error(e);if(!i)throw e="Folder name is mandatory",new Error(e);return{folderName:i,apiUrl:r,token:t,session:a,requestTimeout:o,cookies:n}}const c=s.x3;if("development"===s.deploymentMode&&c.development&&c.development.api){const e=c.development.api;if(!c.development.folderName)throw new Error("Folder name missing from the web service config");if(!e.url)throw new Error("URL is missing from web service config");if(!e.userCredentials||!e.userCredentials.userName||!e.userCredentials.password)throw new Error("User credential is missing from web service config");return{folderName:c.development.folderName,apiUrl:e.url,userCredentials:e.userCredentials,requestTimeout:o}}throw new Error("Failed to load API config")}static makeParameter(e){if("string"==typeof e)return{type:e};return e}static parseScalarReturnValue(e,t,r,a){switch(r){case"boolean":return 2===a;case"decimal":return xtrem_decimal_1.Decimal.make(a);case"date":return xtrem_date_time_1.DateValue.parse(a);case"integer":case"string":return a;case"dateRange":return xtrem_date_time_1.DateRange.parse(a);case"datetimeRange":return xtrem_date_time_1.DatetimeRange.parse(a);case"time":return xtrem_date_time_1.Time.parse(a);case"datetime":return xtrem_date_time_1.Datetime.parse(a);case"binaryStream":return xtrem_core_1.BinaryStream.fromBuffer(Buffer.from(a));case"textStream":return xtrem_core_1.TextStream.fromString(a);default:throw new Error(`${e}.${t}: invalid return type ${r}:${a}`)}}static parsePropertyReturnValue(e,t,r,a){if(null==a)return null;const n=sql_resolver_1.SqlResolver.getPropertyType(r);switch(n){case"boolean":case"decimal":case"date":case"integer":case"string":case"dateRange":case"datetimeRange":case"time":case"datetime":case"binaryStream":case"textStream":return this.parseScalarReturnValue(e,t,n,a);case"enum":if(Number.isFinite(Number(a))){const n=r.dataType;if(!n)throw new Error(`${e}.${t}: dataType missing on return enum`);return n.stringValue(a)}throw new Error(`${e}.${t}: invalid enum return value`);default:throw new Error(`${e}.${t}: invalid return type ${n}:${a}`)}}static parseOperationReturnValue(e,t,r,a,n){if(null==n)return null;const i=this.makeParameter(a);switch(i.type){case"boolean":case"decimal":case"date":case"integer":case"string":case"dateRange":case"datetimeRange":case"time":case"datetime":case"binaryStream":case"textStream":return this.parseScalarReturnValue(t.name,r,i.type,n);case"enum":if(Number.isFinite(Number(n))){const e=i.dataType?i.dataType():void 0;if(!e)throw new Error(`${t.name}.${r}: dataType missing on return enum`);return e.stringValue(n)}throw new Error(`${t.name}.${r}: invalid enum return value`);case"object":if("object"!=typeof n)throw new Error(`${t.name}.${r}: invalid value for object return value. ${n}`);if(i.properties)return Object.keys(n).reduce((a,s)=>{const o=i.properties[s];if(!o)return a;const c=n[s];return a[s]=this.parseOperationReturnValue(e,t,r,o,c),a},{});return n;case"array":if(!Array.isArray(n))throw new Error(`${t.name}.${r}: invalid array return value`);if(i.item){const a=i.item;return n.map(n=>this.parseOperationReturnValue(e,t,r,a,n))}return n;case"instance":{const t=e.application.getFactoryByConstructor(i.node()),a=this.parseNodeOutputData(e,t.name,r,n);return e.tryRead(t.nodeConstructor,a)}default:throw new Error(`${t.name}.${r}: invalid return type ${i.type}:${n}`)}}static parseNodeOutputData(e,t,r,a){if("delete"===r)return a;return e.application.getFactoryByName(t).keyProperties.reduce((e,n)=>(e[n.name]=this.parsePropertyReturnValue(t,r,n,a[n.name]),e),{})}static parseOutputData(e,t,r,a){const n=e.application.getFactoryByName(t),i=[...n.queries,...n.mutations].find(e=>e.name===r);if(!i){if(["create","update","delete"].includes(r)){if("delete"===r)return a;return this.parseNodeOutputData(e,t,r,a)}throw new Error(`${t}.${r}: missing operation`)}return this.parseOperationReturnValue(e,n,i.name,i.return,a)}static processResponse(e,t,r,a,n){const i=a.data,s=[];if(i.$diagnoses&&i.$diagnoses.length)i.$diagnoses.forEach(t=>{let r=xtrem_core_1.ValidationSeverity.info;if("error"===t.$severity)r=xtrem_core_1.ValidationSeverity.error,s.push(t.$message);if("warning"===t.$severity)r=xtrem_core_1.ValidationSeverity.warn;if(n)n.addDiagnose(r,t.$message);else e.addDiagnoseAtPath(r,[],t.$message)});if(s.length>0)throw new xtrem_core_1.BusinessRuleError(s.join("\n"));return i.$payloadxtrem?this.parseOutputData(e,t,r,i.$payloadxtrem[0]):null}static writeAxiosMockData(e,t,r,a){if(e.headers?.Authorization)delete e.headers.Authorization;let n;if(!fs.existsSync(fsp.join(r,"axios")))fs.mkdirSync(fsp.join(r,"axios"));if(!fs.existsSync(fsp.join(r,"axios",`${a}.json`)))n=[];else n=JSON.parse(fs.readFileSync(fsp.join(r,"axios",`${a}.json`),"utf8").toString());n.push({request:e,response:{...t,headers:{isMock:true}}}),fs.writeFileSync(fsp.join(r,"axios",`${a}.json`),JSON.stringify(n,null,4))}static getNodeKeyValue(e){const{factory:t}=e.$;if(!t.naturalKey)throw t.logicError("no natural key");const r=t.naturalKey.filter(e=>"_sortValue"!==e).reduce((t,r)=>(t[r]=e.$.getRawPropertyValue(r),t),{});if(t.propertiesByName.denormalizedIndex)r.denormalizedIndex=e.$.getRawPropertyValue("denormalizedIndex");return r}static async parseCollectionInputData(e,t,r,a,n){const i=await x3_storage_manager_1.X3StorageManager.tryGet(r,t.name),s=t.targetFactory.externalStorageManager,o=[],c=n?.nodeMap??{};let u=[];if(i)if(u=await i.map(async r=>{c[a]=true;const i=await this.parseNodeInputData(e,t.targetFactory,r,{...n,nodeMap:c});return o.push(String(r._id)),i}).toArray(),r.$.status!==xtrem_core_1.NodeStatus.added&&!s.isDenormalized){const a=await x3_storage_manager_1.X3StorageManager.tryGet(await r.$.old,t.name);if(null!=a)await a.filter(e=>!o.includes(String(e._id))).forEach(e=>{const t=this.getNodeKeyValue(e);t._nodeStatus="D",u.push(t)});const n=t.targetFactory.indexes?.find(e=>e.isNaturalKey);if(u.length>0&&n)u=await xtrem_core_1.RecordPaging.applyOrderBy(e,t.targetFactory,u,n.orderBy,(e,t,r)=>r[t.name]),u=u.sort((e,t)=>{if("C"===e._nodeStatus)return 1;if("C"===t._nodeStatus)return-1;return 0})}return u}static async getPropertiesOldValue(e,t){return e.$.status!==xtrem_core_1.NodeStatus.added?(await e.$.old).$.getRawPropertyValue(t.name):void 0}static getNodeOperationName(e,t){let r=t;if(e.$.status===xtrem_core_1.NodeStatus.added)r="create";if(e.$.status===xtrem_core_1.NodeStatus.modified)r="update";return r}static async parseNodeInputData(e,t,r,a){const n={},i=a?.nodeMap??{},s=`${t.name}~${r._id}`;if(i[s])return t.keyPropertyNames.reduce((e,t)=>(e[t]=r.$.getRawPropertyValue(t),e),{});switch(await(0,xtrem_core_1.asyncArray)(t.properties).forEach(async t=>{if(!await t.isAuthorized(e))return;if(t.isReferenceProperty())if(t.isMutable){let o=await x3_storage_manager_1.X3StorageManager.tryGet(r,t.name);if(!o)o=r.$.getRawPropertyValue(t.name);if(null==o){const i=await ApiHelper.getPropertiesOldValue(r,t);let s=a?.operationName;if(r.$.status===xtrem_core_1.NodeStatus.added)s="create";if(r.$.status===xtrem_core_1.NodeStatus.modified)s="update";n[t.name]=this.parseScalarInputValue(e,t,null,{...a,operationName:s,oldValue:i})}else i[s]=true,n[t.name]=await this.parseNodeInputData(e,t.targetFactory,o,{...a,nodeMap:i})}else if(null==r.$.getRawPropertyValue(t.name)){const i=await ApiHelper.getPropertiesOldValue(r,t),s=ApiHelper.getNodeOperationName(r,a?.operationName??"");n[t.name]=this.parseScalarInputValue(e,t,null,{...a,operationName:s,oldValue:i})}else{const i=await ApiHelper.getPropertiesOldValue(r,t),s=ApiHelper.getNodeOperationName(r,a?.operationName??"");n[t.name]=this.parseScalarInputValue(e,t,r.$.getRawPropertyValue(t.name),{...a,oldValue:i,operationName:s})}else if(t.isMutable&&t.isReferenceArrayProperty()){let o=await x3_storage_manager_1.X3StorageManager.tryGet(r,t.name);if(!o)o=r.$.getRawPropertyValue(t.name);if(null==o)n[t.name]=[];else n[t.name]=await(0,xtrem_core_1.asyncArray)(o).map(r=>(i[s]=true,this.parseNodeInputData(e,t.targetFactory,r,{...a,nodeMap:i}))).toArray();n[t.name]=r.$.getRawPropertyValue(t.name)}else if(t.isMutable&&t.isCollectionProperty())n[t.name]=await this.parseCollectionInputData(e,t,r,s,{...a,nodeMap:i});else if(void 0!==r.$.getRawPropertyValue(t.name)||t.computeValue||t.getValue){let i=await x3_storage_manager_1.X3StorageManager.tryGet(r,t.name);if(!i)i=r.$.getRawPropertyValue(t.name);const s=ApiHelper.getNodeOperationName(r,a?.operationName??""),o=await ApiHelper.getPropertiesOldValue(r,t);n[t.name]=this.parseScalarInputValue(e,t,i??null,{...a,oldValue:o,operationName:s})}else{const i=await ApiHelper.getPropertiesOldValue(r,t),s=ApiHelper.getNodeOperationName(r,a?.operationName??"");n[t.name]=this.parseScalarInputValue(e,t,null,{...a,oldValue:i,operationName:s})}}),r.$.status){case"added":n._nodeStatus="C";break;case"unchanged":n._nodeStatus="R";break;case"modified":n._nodeStatus="U";break;case"deleted":n._nodeStatus="D"}return delete i[s],x3_storage_manager_1.X3StorageManager.removeTransientKeyValues(t,n)}static isLocalizedValue(e,t){return e instanceof xtrem_core_1.Property&&e.isLocalized&&"object"==typeof t}static parseScalarInputDateValue(e,t,r){switch(t){case"update":if(null===e&&null!==r)return"0000-00-00";if(e instanceof xtrem_date_time_1.DateValue)return e.toString();if(null===e)return null;return String(e);case"create":if(e instanceof xtrem_date_time_1.DateValue&&"1000-01-01"===e.toString())return null;if(null===e)return"0000-00-00";return e instanceof xtrem_date_time_1.DateValue?e.toString():String(e);default:if(null===e)return null;return e instanceof xtrem_date_time_1.DateValue?e.toString():String(e)}}static parseScalarInputValue(e,t,r,a){const n=t instanceof xtrem_core_1.Property?sql_resolver_1.SqlResolver.getPropertyType(t):t.type;if(null==r&&"date"!==n)return null;switch(n){case"boolean":return r?2:1;case"integer":return r;case"string":if(this.isLocalizedValue(t,r))return r[e.currentLocale];return String(r).replaceAll(x3_storage_manager_1.X3StorageManager.hashtagPlaceholder,"#");case"decimal":return r instanceof xtrem_decimal_1.Decimal?r.toString():String(r);case"date":return ApiHelper.parseScalarInputDateValue(r,a?.operationName,a?.oldValue);case"dateRange":return r instanceof xtrem_date_time_1.DateRange?r.toString():String(r);case"datetimeRange":return r instanceof xtrem_date_time_1.DatetimeRange?r.toString():String(r);case"time":return r instanceof xtrem_date_time_1.Time?r.toString():String(r);case"datetime":return r instanceof xtrem_date_time_1.Datetime?r.toString():String(r);case"binaryStream":return r instanceof xtrem_core_1.BinaryStream?r.toString():r;case"textStream":return r instanceof xtrem_core_1.TextStream?r.toString():r;case"enum":{const e="enum"===t.type?t.dataType:void 0;if(e){const t=e.numberValue(r);return-1===t?0:t}throw new Error(`${t.name}: missing enum datatype`)}default:throw new Error(`${n}: invalid parameter type`)}}static parseParameterInputValue(e,t,r){if(null==r)return this.parseScalarInputValue(e,t,null);switch(t.type){case"instance":case"reference":{const a=e.application.getFactoryByConstructor(t.node());return this.parseNodeInputData(e,a,r)}case"enum":if("number"==typeof r)return r;if(!t.dataType)throw new Error(`${t.name}: enum property missing dataType`);if("string"==typeof r)return t.dataType().numberValue(r);throw new Error(`${t.name}: invalid enum value ${r}`);default:return this.parseScalarInputValue(e,t,r)}}static parseParameterValue(e,t,r,a,n){switch(a.type){case"boolean":case"integer":case"string":case"decimal":case"date":case"dateRange":case"datetimeRange":case"time":case"datetime":case"binaryStream":case"textStream":case"instance":case"reference":case"enum":return this.parseParameterInputValue(e,a,n);case"object":{if(null==n)return null;if("object"!=typeof n)throw new Error(`${t.name}.${r.name}.${a.name}: invalid value for object`);const i=n;return(0,xtrem_core_1.asyncArray)(Object.keys(n)).reduce(async(n,s)=>{const o=a.properties[s],c=await i[s];return n[s]=await this.parseParameterValue(e,t,r,this.makeParameter(o),c),n},{})}case"array":if(null==n)return null;if(!Array.isArray(n))throw new Error(`${t.name}.${r.name}.${a.name}: invalid array value`);return(0,xtrem_core_1.asyncArray)(n).map(n=>this.parseParameterValue(e,t,r,this.makeParameter(a.item),n)).toArray();default:throw new Error(`${t.name}.${r.name}: invalid parameter type`)}}static parseOperationInputData(e,t,r,a){const{parameters:n}=r,i=n[0];if("object"===i.type&&"parameters"===i.name)return(0,xtrem_core_1.asyncArray)(Object.keys(i.properties)).reduce(async(n,s)=>{if(!a)return n;const o=this.makeParameter(i.properties[s]),c=await a[s];return n[s]=await this.parseParameterValue(e,t,r,o,c),n},{});throw new Error(`${t}.${r.name}: invalid operation parameters defintion, root parameter must an object with the name 'parameters'.`)}static parseInputData(e,t,r,a,n){const i=e.application.getFactoryByName(t);switch(a){case"SCRIPT":{const a=[...i.queries,...i.mutations].find(e=>e.name===r);if(!a)throw new Error(`${t}.${r}: invalid script operation`);return this.parseOperationInputData(e,i,a,n)}case"CRUD":case"IMPORT":if(n instanceof xtrem_core_1.Node)return this.parseNodeInputData(e,i,n,{nodeName:t,operationName:r});throw new Error(`${t}.${r}: input is not an instance of node`);default:throw new Error(`${t}.${r}: invalid operation method ${a}`)}}static encrypt(e){const t=this.getSecret();if(!t)return e;const r=crypto.createHash("sha256").update(t).digest("base64").substr(0,32),a=crypto.randomBytes(16),n=crypto.createCipheriv("aes-256-cbc",Buffer.from(r),a);let i=n.update("string"==typeof e?e:JSON.stringify(e));return i=Buffer.concat([i,n.final()]),{iv:a.toString("hex"),encrypted:i.toString("hex")}}static getSecret(){const{security:e,deploymentMode:t,x3:r}=xtrem_config_1.ConfigManager.current||{},{syracuse:a}=e||{};if(!a?.secret){if("development"===t&&r.development.api.secret)return r.development.api.secret;throw new Error("xtrem.security.secret config value must be set")}return a.secret}static getXtremContextHeader(e,t){if(e.testMode)return Buffer.from(JSON.stringify(t)).toString("base64");return Buffer.from(JSON.stringify(this.encrypt(t))).toString("base64")}static async sendRequest(e,t,r,a,n,i){const s=this.getConfig(e),{apiUrl:o,token:c,userCredentials:u,session:l,cookies:m}=s;let p="";if(c)p=`Bearer ${c}`;else{p=`Basic ${Buffer.from(`${u?.userName||""}:${u?.password}`).toString("base64")}`}const d={session:l,service:i,params:{name:t,operationName:["create","update","delete"].includes(t)?"":a,node:r}},g={"Content-Type":"text/plain",Authorization:p,Connection:"Keep-Alive","accept-language":"base"===e.currentLocale?"en-US":e.currentLocale,"x-xtrem-context":this.getXtremContextHeader(e,d)};if(m)g.Cookie=m;logger.verbose(()=>`API Request ${t}/${r}.${a}: context header ${JSON.stringify(d)}`);const f=xtrem_core_1.Mocker.get("axios",require),y={method:"post",url:o,headers:g,data:n,timeout:s.requestTimeout};logger.verbose(()=>`API Request ${t}/${r}.${a}: ${JSON.stringify(y)}`);const w=await f(y);if(logger.verbose(()=>`Raw API response \n ${JSON.stringify(w.data)}`),e.testMode&&e.testConfig){const{directory:t,testAttributes:r,mocks:a,scenario:n}=e.testConfig;if(r?.createMockData){if(!t||!n)throw new Error("Cannot generate axios mock data, both directory and scenario must be specified for test");if(a?.includes("axios"))throw new Error("Cannot generate axios mock data, while mocking axios");this.writeAxiosMockData(y,_.omit(w,["request"]),t,n)}}return w}static async sendOperation(e,t,r,a,n,i){const s=await this.sendRequest(e,t,r,a,n),o=this.processResponse(e,r,a,s,i);return logger.verbose(()=>`API response \n ${JSON.stringify(o)}`),o}static async executeOperation(e,t,r,a,n,i,s){const o=await this.parseInputData(e,a,n,r,i);return this.sendOperation(e,t,a,n,o,s)}static async refreshNodeState(e,t){e.$.clearCaches();const{factory:r}=e.$,{keyPropertyNames:a}=r,n=_.pick(t,a);if(Object.keys(n).length===a.length){const i=(await(0,xtrem_core_1.asyncArray)(r.properties).filter(async t=>{const r=await t.isEnabledByServiceOptions(e.$.context);return t.isStored&&!a.includes(t.name)&&r}).toArray()).reduce((e,t)=>(e[t.name]=true,e),{}),s=await e.$.context.select(e.$.factory.nodeConstructor,i,{filter:n});if(s.length>0)_.merge(t,s[0])}}static async insert(e,t,r){const a=await ApiHelper.executeOperation(t.$.context,"create","CRUD",e.factory.name,"create",t,r);return a._id=e.getId(t.$.context,{...t.$.getRawPropertyValues(),...a}),await this.refreshNodeState(t,a),a}static async update(e,t,r){const a={...await ApiHelper.executeOperation(t.$.context,"update","CRUD",e.factory.name,"update",t,r),_id:String(t._id)};return await this.refreshNodeState(t,a),[_.omit(a,["_id"])]}static async delete(e,t,r){return await ApiHelper.executeOperation(t.$.context,"delete","CRUD",e.factory.name,"delete",t,r),1}}exports.ApiHelper=ApiHelper;
//# sourceMappingURL=api-helper.js.map