import { AnyRecord, AnyRecordWithId, Context, Dict, Extend, ForeignNodeProperty, Node, Parameter, Property, TypeName, ValidationContext } from '@sage/xtrem-core';
import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
import { ApiMethod, ApiType } from '../storage/storage-types';
import { X3StorageManager } from '../storage/x3-storage-manager';
export interface ApiConfig {
    folderName: string;
    apiUrl: string;
    token?: string;
    session?: string;
    userCredentials?: {
        userName: string;
        password: string;
    };
    requestTimeout: number;
    cookies?: string;
}
export interface ApiResultInterface {
    $payloadxtrem: any[];
    $diagnoses: {
        $message: string;
        $severity: string;
    }[];
}
export interface XtremContextHeader {
    service?: string;
    session?: string;
    params: Dict<string>;
}
export declare class ApiHelper {
    /**
     * Get the API configuration from the xtrem config and context values passed from Syracuse
     * @param context
     * @returns
     */
    private static getConfig;
    static makeParameter(parameterOrTypeName: Parameter | TypeName): Parameter;
    /**
     * Parse the value returned on the API response to the format on the operation decorator `return` attribute of a custom operation
     * @param factory
     * @param operation
     * @param operationReturn
     * @param value
     * @returns
     */
    private static parseScalarReturnValue;
    /**
     * Parse the value returned on the API response to the format on the operation decorator `return` attribute of a custom operation
     * @param factory
     * @param operation
     * @param operationReturn
     * @param value
     * @returns
     */
    private static parsePropertyReturnValue;
    /**
     * Parse the value returned on the API response to the format on the operation decorator `return` attribute of a custom operation
     * @param factory
     * @param operation
     * @param operationReturn
     * @param value
     * @returns
     */
    private static parseOperationReturnValue;
    /** Parse the value returned from Syracuse to  */
    private static parseNodeOutputData;
    /**
     * Parse the data from the API response
     * @param context
     * @param nodeName
     * @param operationName
     * @param outputData
     * @returns
     */
    private static parseOutputData;
    /** Parse the API response diagnoses and data */
    private static processResponse;
    /**
     * Write mock data for axios
     * @param request
     * @param response
     * @param directory
     * @param filename
     */
    private static writeAxiosMockData;
    static getNodeKeyValue(node: Node): Dict<AnyValue>;
    static parseCollectionInputData(context: Context, property: ForeignNodeProperty, node: Node, key: string, options?: {
        nodeMap?: Dict<true>;
        nodeName?: string;
        operationName?: string;
    }): Promise<Dict<AnyValue>[]>;
    static getPropertiesOldValue(node: Node, property: Property): Promise<AnyValue>;
    static getNodeOperationName(node: Node, operationName: string): string;
    private static isLocalizedValue;
    private static parseScalarInputDateValue;
    private static parseScalarInputValue;
    /**
     * Parse parameter input value to X3 expected value
     * @param type
     * @param value
     * @returns
     */
    private static parseParameterInputValue;
    /**
     * Parse the value passed to an operation parameter, to match the expected X3 input
     * @param factory
     * @param operation
     * @param parameter
     * @param value
     * @returns
     */
    private static parseParameterValue;
    /** parse the input parameters of a node query/mutation */
    private static parseOperationInputData;
    /**
     * Parse the API input data
     * @param context
     * @param nodeName
     * @param operationName
     * @param inputData
     * @returns
     */
    private static parseInputData;
    /**
     * encrypt using shared secret
     * @param data
     * @returns
     */
    private static encrypt;
    /**
     * Get X3 secret
     * @returns
     */
    private static getSecret;
    /**
     * Get the encrypted base64 value for the header 'x-xtrem-context'
     */
    private static getXtremContextHeader;
    /**
     * Send request to X3 xtrem API
     * @param context
     * @param type
     * @param nodeName
     * @param operationName
     * @param requestData
     * @param service
     * @returns
     */
    private static sendRequest;
    /**
     * Send operation request to X3
     * @param context
     * @param type
     * @param nodeName
     * @param operationName
     * @param requestData
     * @returns
     */
    private static sendOperation;
    /**
     * Execute node operation.
     * @param context
     * @param type
     * @param nodeName
     * @param operationName
     * @param inputData
     * @returns
     */
    static executeOperation<ReturnT = AnyRecord>(context: Context, type: ApiType, method: ApiMethod, nodeName: string, operationName: string, inputData: Dict<AsyncResponse<AnyValue>> | Node, cx?: ValidationContext): Promise<ReturnT>;
    /**
     * Clean the nodes of cached references and collections, and reset the values of the root node state
     * by filling the returned values from a select statement.
     * @param node
     * @param result
     */
    static refreshNodeState(node: Node, result: AnyRecordWithId): Promise<void>;
    static insert<T extends Node>(storageManager: X3StorageManager<T>, node: Extend<T>, cx: ValidationContext): Promise<AnyRecordWithId>;
    static update<T extends Node>(storageManager: X3StorageManager<T>, node: Extend<T>, cx: ValidationContext): Promise<AnyRecord[]>;
    static delete<T extends Node>(storageManager: X3StorageManager<T>, node: Extend<T>, cx: ValidationContext): Promise<number>;
}
//# sourceMappingURL=api-helper.d.ts.map