// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/index.d.ts
declare module '@sage/x3-sales/index' {
	export * from '@sage/x3-sales/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/index.d.ts
declare module '@sage/x3-sales/lib/index' {
	export * as enums from '@sage/x3-sales/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-sales/lib/node-extensions/index';
	export * as nodes from '@sage/x3-sales/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-sales/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/service-options/index.d.ts
declare module '@sage/x3-sales/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/service-contract-template.d.ts
declare module '@sage/x3-sales/lib/nodes/service-contract-template' {
	import { Node } from '@sage/xtrem-core';
	export class ServiceContractTemplate extends Node {
	    readonly id: Promise<string>;
	    readonly description: Promise<string>;
	}
	//# sourceMappingURL=service-contract-template.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-return.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-return' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesReturn extends Node {
	    readonly id: Promise<string>;
	    readonly receivingSite: Reference<sageX3System.nodes.Site>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly expirationDate: Promise<date | null>;
	    readonly authorizedUser: Reference<sageX3System.nodes.User | null>;
	    readonly expectedReturnDate: Promise<date | null>;
	    readonly returnDate: Promise<date | null>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly shipToCustomerPostalCode: Promise<string>;
	    readonly shipToCustomerCity: Promise<string>;
	    readonly shipToCustomerState: Promise<string>;
	    readonly shipToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly shipToCustomerCountryName: Promise<string>;
	    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly deliveryDate: Promise<date | null>;
	    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly salesSite: Reference<sageX3System.nodes.Site | null>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly intrastatTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
	    readonly intrastatStatisticalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly intrastatTransportMode: Promise<sageX3MasterData.enums.IntrastatTransportMode | null>;
	    readonly intrastatProcessingNumber: Promise<integer | null>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly incotermTown: Promise<string>;
	    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly billToCustomerEuropeanUnionVatNumber: Promise<string>;
	    readonly loanReturn: Promise<boolean>;
	    readonly subcontractMaterialReturn: Promise<boolean>;
	    readonly loanSalesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
	    readonly returnHeaderTextKey: Promise<string>;
	    readonly returnFooterTextKey: Promise<string>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly language: Reference<sageX3System.nodes.Language | null>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly dockLocation: Reference<sageX3StockData.nodes.Location | null>;
	    readonly isIntersite: Promise<boolean>;
	    readonly isIntercompany: Promise<boolean>;
	    readonly sourceSite: Reference<sageX3System.nodes.Site | null>;
	    readonly priceStructure: Reference<sageX3InvoicingData.nodes.PriceStructure | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly returnType: Reference<sageX3SalesData.nodes.SalesReturnType | null>;
	    readonly returnNumber: Reference<sageX3Sales.nodes.SalesReturn | null>;
	    readonly category: Promise<sageX3SalesData.enums.ReturnCategory | null>;
	    readonly arrivalDate: Promise<date | null>;
	    readonly departureDate: Promise<date | null>;
	    readonly departureTime: Promise<string>;
	    readonly arrivalTime: Promise<string>;
	    readonly vehicleLicensePlate: Promise<string>;
	    readonly trailerLicensePlate: Promise<string>;
	    readonly salesReturnLines: Collection<sageX3Sales.nodes.SalesReturnLine>;
	    readonly returnHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly returnFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly returnFooterText: Promise<TextStream>;
	    readonly returnHeaderText: Promise<TextStream>;
	    readonly dimensions: Collection<sageX3Sales.nodes.SalesReturnDimensions>;
	    readonly shipToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesReturnShipToCustomerAddressLines>;
	    readonly shipToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesReturnShipToCustomerCompanyNames>;
	}
	//# sourceMappingURL=sales-return.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-return-ship-to-customer-company-names.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-return-ship-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesReturnShipToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesReturn>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=sales-return-ship-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-return-ship-to-customer-address-lines.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-return-ship-to-customer-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesReturnShipToCustomerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesReturn>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=sales-return-ship-to-customer-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-return-line.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-return-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, date, TextStream } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesReturnLine extends Node {
	    readonly salesReturn: Reference<sageX3Sales.nodes.SalesReturn>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescriptionInUserLanguage: Promise<string>;
	    readonly productDescriptionInCustomerLanguage: Promise<string>;
	    readonly salesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
	    readonly salesDeliveryLineNumber: Reference<sageX3Sales.nodes.SalesDeliveryLine | null>;
	    readonly quantityInSalesUnitDelivered: Promise<decimal | null>;
	    readonly expectedReturnQuantity: Promise<decimal | null>;
	    readonly expectedReturnQuantityInStockUnit: Promise<decimal | null>;
	    readonly quantityInSalesUnitReturned: Promise<decimal | null>;
	    readonly quantityInStockUnitReturned: Promise<decimal | null>;
	    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly netPrice: Promise<decimal | null>;
	    readonly netPriceExcludingTax: Promise<decimal | null>;
	    readonly netPriceIncludingTax: Promise<decimal | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly returnReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly returnDate: Promise<date | null>;
	    readonly actualStockReturn: Promise<boolean>;
	    readonly returnDeductedFromTheInvoice: Promise<boolean>;
	    readonly isToBeLinkedToCreditMemo: Promise<boolean>;
	    readonly reactivatedOrder: Promise<boolean>;
	    readonly creditMemo: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly creditMemoLineNumber: Reference<sageX3Sales.nodes.SalesInvoiceLine | null>;
	    readonly creditMemoToBeIssued: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly creditMemoLineNumberToBeIssued: Reference<sageX3Sales.nodes.SalesInvoiceLine | null>;
	    readonly reversalDocumentDate: Promise<date | null>;
	    readonly receivingSite: Reference<sageX3System.nodes.Site>;
	    readonly returnLineTextKey: Promise<string>;
	    readonly orderPrice: Promise<decimal | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly category: Promise<sageX3SalesData.enums.ReturnCategory | null>;
	    readonly returnLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly returnLineText: Promise<TextStream>;
	}
	//# sourceMappingURL=sales-return-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-return-dimensions.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-return-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesReturnDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesReturn>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=sales-return-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, decimal, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuote extends Node {
	    readonly id: Promise<string>;
	    readonly quoteType: Reference<sageX3SalesData.nodes.SalesQuoteType>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly salesSite: Reference<sageX3System.nodes.Site>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly customerQuoteReference: Promise<string>;
	    readonly quoteDate: Promise<date>;
	    readonly validityDate: Promise<date | null>;
	    readonly deliveryLeadTime: Promise<integer | null>;
	    readonly salesOrderType: Reference<sageX3SalesData.nodes.SalesOrderType | null>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly soldToCustomerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly soldToCustomerPostalCode: Promise<string>;
	    readonly soldToCustomerCity: Promise<string>;
	    readonly soldToCustomerState: Promise<string>;
	    readonly soldToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly soldToCustomerCountryName: Promise<string>;
	    readonly soldToCustomerContact: Reference<sageX3MasterData.nodes.BusinessPartnerContact | null>;
	    readonly shipToCustomerPostalCode: Promise<string>;
	    readonly shipToCustomerCity: Promise<string>;
	    readonly shipToCustomerState: Promise<string>;
	    readonly shipToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly shipToCustomerCountryName: Promise<string>;
	    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.BusinessPartnerContact | null>;
	    readonly billToCustomerEuropeanUnionVatNumber: Promise<string>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly currencyRateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly currencyRate: Promise<decimal | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly soldToCustomerLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
	    readonly entityUseCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site>;
	    readonly priceIncludingOrExcludingTax: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly linesAmountExcludingTax: Promise<decimal | null>;
	    readonly linesAmountIncludingTax: Promise<decimal | null>;
	    readonly linesAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly linesAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountExcludingTax: Promise<decimal | null>;
	    readonly totalAmountIncludingTax: Promise<decimal | null>;
	    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalMargin: Promise<decimal | null>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
	    readonly probabilityPercentage: Promise<integer | null>;
	    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder | null>;
	    readonly orderDate: Promise<date | null>;
	    readonly numberOfOrders: Promise<integer | null>;
	    readonly numberOfValidatedLines: Promise<integer | null>;
	    readonly numberOfLines: Promise<integer | null>;
	    readonly quoteStatus: Promise<sageX3SalesData.enums.QuoteStatus | null>;
	    readonly signatureStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
	    readonly isQuotePrinted: Promise<boolean>;
	    readonly numberOfQuoteCopies: Promise<integer | null>;
	    readonly quoteHeaderTextKey: Promise<string>;
	    readonly quoteFooterTextKey: Promise<string>;
	    readonly salesProforma: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly incotermTown: Promise<string>;
	    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly geographicCode: Promise<string>;
	    readonly insideCityLimits: Promise<string>;
	    readonly vertexTransactionType: Promise<string>;
	    readonly taxAmount: Promise<decimal | null>;
	    readonly taxableAmount: Promise<decimal | null>;
	    readonly priceStructure: Reference<sageX3InvoicingData.nodes.PriceStructure | null>;
	    readonly totalQuantityDistributedOnLines: Promise<decimal | null>;
	    readonly totalWeightDistributedOnLines: Promise<decimal | null>;
	    readonly totalVolumeDistributedOnLines: Promise<decimal | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly isValidatedAddress: Promise<boolean>;
	    readonly revisionNumber: Promise<integer | null>;
	    readonly hasElectronicSignature: Promise<boolean>;
	    readonly finalNumber: Promise<string>;
	    readonly validationDate: Promise<date | null>;
	    readonly salesQuoteLines: Collection<sageX3Sales.nodes.SalesQuoteLine>;
	    readonly quoteHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly quoteFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly quoteFooterText: Promise<TextStream>;
	    readonly quoteHeaderText: Promise<TextStream>;
	    readonly dimensions: Collection<sageX3Sales.nodes.SalesQuoteDimensions>;
	    readonly discountOrChargeCalculationRules: Collection<sageX3Sales.nodes.SalesQuoteDiscountOrChargeCalculationRules>;
	    readonly invoicingElements: Collection<sageX3Sales.nodes.SalesQuoteInvoicingElements>;
	    readonly salesReps: Collection<sageX3Sales.nodes.SalesQuoteSalesReps>;
	    readonly shipToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesQuoteShipToCustomerAddressLines>;
	    readonly shipToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesQuoteShipToCustomerCompanyNames>;
	    readonly soldToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesQuoteSoldToCustomerAddressLines>;
	    readonly soldToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesQuoteSoldToCustomerCompanyNames>;
	}
	//# sourceMappingURL=sales-quote.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-sold-to-customer-company-names.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-sold-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteSoldToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesQuote>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=sales-quote-sold-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-sold-to-customer-address-lines.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-sold-to-customer-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteSoldToCustomerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesQuote>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=sales-quote-sold-to-customer-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-ship-to-customer-company-names.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-ship-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteShipToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesQuote>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=sales-quote-ship-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-ship-to-customer-address-lines.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-ship-to-customer-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteShipToCustomerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesQuote>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=sales-quote-ship-to-customer-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-sales-reps.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-sales-reps' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteSalesReps extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesQuote>;
	    readonly salesRep: Reference<sageX3MasterData.nodes.SalesRep | null>;
	}
	//# sourceMappingURL=sales-quote-sales-reps.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-line.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, TextStream, Collection } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteLine extends Node {
	    readonly salesQuote: Reference<sageX3Sales.nodes.SalesQuote>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly salesSite: Reference<sageX3System.nodes.Site>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly quoteDate: Promise<date>;
	    readonly deliveryLeadTime: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorProductVersion: Reference<sageX3MasterData.nodes.ProductVersion | null>;
	    readonly productDescriptionInUserLanguage: Promise<string>;
	    readonly productDescriptionInCustomerLanguage: Promise<string>;
	    readonly salesRep1: Reference<sageX3MasterData.nodes.SalesRep | null>;
	    readonly salesRep1CommissionRate: Promise<decimal | null>;
	    readonly salesRep2: Reference<sageX3MasterData.nodes.SalesRep | null>;
	    readonly salesRep2CommissionRate: Promise<decimal | null>;
	    readonly salesRepCommissionFactor: Promise<decimal | null>;
	    readonly grossPrice: Promise<decimal | null>;
	    readonly priceReason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly netPrice: Promise<decimal | null>;
	    readonly margin: Promise<decimal | null>;
	    readonly netPriceExcludingTax: Promise<decimal | null>;
	    readonly netPriceIncludingTax: Promise<decimal | null>;
	    readonly costPrice: Promise<decimal | null>;
	    readonly discountOrCharge1: Promise<decimal | null>;
	    readonly discountOrCharge2: Promise<decimal | null>;
	    readonly discountOrCharge3: Promise<decimal | null>;
	    readonly discountOrCharge4: Promise<decimal | null>;
	    readonly discountOrCharge5: Promise<decimal | null>;
	    readonly discountOrCharge6: Promise<decimal | null>;
	    readonly discountOrCharge7: Promise<decimal | null>;
	    readonly discountOrCharge8: Promise<decimal | null>;
	    readonly discountOrCharge9: Promise<decimal | null>;
	    readonly discountOrCharge1Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge2Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge3Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge4Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge5Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge6Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge7Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge8Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge9Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly calculatedTaxableBase1: Promise<decimal | null>;
	    readonly calculatedTaxableBase2: Promise<decimal | null>;
	    readonly isLineWithDistributedInvoicingElement: Promise<boolean>;
	    readonly quoteQuantity: Promise<decimal>;
	    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site>;
	    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly lineType: Promise<sageX3SalesData.enums.LineType | null>;
	    readonly freeProduct: Promise<sageX3SalesData.enums.Free | null>;
	    readonly freeProductLineSource: Promise<integer | null>;
	    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder | null>;
	    readonly salesOrderLine: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
	    readonly isOrdered: Promise<boolean>;
	    readonly orderedQuantity: Promise<decimal | null>;
	    readonly quoteLineTextKey: Promise<string>;
	    readonly geographicCode: Promise<string>;
	    readonly insideCityLimits: Promise<string>;
	    readonly isTaxedGeographically: Promise<string>;
	    readonly isTaxable: Promise<boolean>;
	    readonly isRecordedTax: Promise<boolean>;
	    readonly taxRate: Promise<decimal | null>;
	    readonly taxableAmount: Promise<decimal | null>;
	    readonly isComponentPrintedOnAcknowledgement: Promise<boolean>;
	    readonly isComponentPrintedOnPackingSlip: Promise<boolean>;
	    readonly isComponentPrintedOnInvoice: Promise<boolean>;
	    readonly weightDistributedOnLine: Promise<decimal | null>;
	    readonly volumeDistributedOnLine: Promise<decimal | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly importLineNumber: Promise<integer | null>;
	    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly isDeliverable: Promise<boolean>;
	    readonly lineRevisionNumber: Promise<integer | null>;
	    readonly quoteLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly quoteLineText: Promise<TextStream>;
	    readonly distributedInvoicingElements: Collection<sageX3Sales.nodes.SalesQuoteLineDistributedInvoicingElements>;
	    readonly taxes: Collection<sageX3Sales.nodes.SalesQuoteLineTaxes>;
	}
	//# sourceMappingURL=sales-quote-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-line-taxes.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-line-taxes' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteLineTaxes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesQuote: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesQuoteLine>;
	    readonly taxLevel: Reference<sageX3InvoicingData.nodes.TaxLevel | null>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=sales-quote-line-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-line-distributed-invoicing-elements.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-line-distributed-invoicing-elements' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteLineDistributedInvoicingElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesQuote: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesQuoteLine>;
	    readonly distributedLineInvoicingElementNumber: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	    readonly distributedLineInvoicingElementAmount: Promise<decimal | null>;
	}
	//# sourceMappingURL=sales-quote-line-distributed-invoicing-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-invoicing-elements.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-invoicing-elements' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteInvoicingElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesQuote>;
	    readonly percentageOrAmount: Promise<decimal | null>;
	    readonly valueType: Promise<sageX3MasterData.enums.ValueType | null>;
	    readonly distributionKey: Reference<sageX3FinanceData.nodes.DistributionKey | null>;
	    readonly invoicingElement: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=sales-quote-invoicing-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-discount-or-charge-calculation-rules.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-discount-or-charge-calculation-rules' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteDiscountOrChargeCalculationRules extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesQuote>;
	    readonly type: Promise<sageX3MasterData.enums.DiscountCalculationRules | null>;
	    readonly invoicingElement: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	}
	//# sourceMappingURL=sales-quote-discount-or-charge-calculation-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-quote-dimensions.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-quote-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesQuoteDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesQuote>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=sales-quote-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, decimal, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrder extends Node {
	    readonly id: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly salesOrderType: Reference<sageX3SalesData.nodes.SalesOrderType | null>;
	    readonly category: Promise<sageX3SalesData.enums.OrderCategory | null>;
	    readonly salesSite: Reference<sageX3System.nodes.Site>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly payByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly payByBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly groupCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
	    readonly customerOrderReference: Promise<string>;
	    readonly additionnalReference: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly orderDate: Promise<date>;
	    readonly shipmentDate: Promise<date | null>;
	    readonly requestedDeliveryDate: Promise<date | null>;
	    readonly loanReturnDate: Promise<date | null>;
	    readonly deliveryLeadTime: Promise<integer | null>;
	    readonly soldToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly soldToCustomerPostalCode: Promise<string>;
	    readonly soldToCustomerCity: Promise<string>;
	    readonly soldToCustomerState: Promise<string>;
	    readonly soldToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly soldToCustomerCountryName: Promise<string>;
	    readonly soldToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly billToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly billToCustomerPostalCode: Promise<string>;
	    readonly billToCustomerCity: Promise<string>;
	    readonly billToCustomerState: Promise<string>;
	    readonly billToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly billToCustomerCountryName: Promise<string>;
	    readonly billToCustomerEuropeanUnionVatNumber: Promise<string>;
	    readonly billToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly shipToCustomerPostalCode: Promise<string>;
	    readonly shipToCustomerCity: Promise<string>;
	    readonly shipToCustomerState: Promise<string>;
	    readonly shipToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly shipToCustomerCountryName: Promise<string>;
	    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly currencyRateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly currencyRate: Promise<decimal | null>;
	    readonly soldToCustomerLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
	    readonly entityUseCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly routeNumber: Promise<sageX3SalesData.enums.RouteCode | null>;
	    readonly deliveryPriority: Promise<sageX3SalesData.enums.DeliveryPriority | null>;
	    readonly isOrderClosingAllowed: Promise<boolean>;
	    readonly mustContainOneOrderPerDelivery: Promise<boolean>;
	    readonly partialDelivery: Promise<sageX3SalesData.enums.PartialDelivery | null>;
	    readonly invoicingMode: Promise<sageX3SalesData.enums.InvoicingMode | null>;
	    readonly mustPrintAcknowledgment: Promise<boolean>;
	    readonly isAcknowledgmentPrinted: Promise<boolean>;
	    readonly numberOfAcknowledgmentCopies: Promise<integer | null>;
	    readonly orderHeaderTextKey: Promise<string>;
	    readonly orderFooterTextKey: Promise<string>;
	    readonly salesQuote: Reference<sageX3Sales.nodes.SalesQuote | null>;
	    readonly isIntersite: Promise<boolean>;
	    readonly isIntercompany: Promise<boolean>;
	    readonly sourceSite: Reference<sageX3System.nodes.Site | null>;
	    readonly salesProforma: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly lastSalesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
	    readonly lastSalesDeliveryDate: Promise<date | null>;
	    readonly lastSalesInvoice: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly lastSalesInvoiceDate: Promise<date | null>;
	    readonly priceIncludingOrExcludingTax: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly linesAmountExcludingTax: Promise<decimal | null>;
	    readonly linesAmountIncludingTax: Promise<decimal | null>;
	    readonly linesAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly linesAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountExcludingTax: Promise<decimal | null>;
	    readonly totalAmountIncludingTax: Promise<decimal | null>;
	    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly linesAmountRemainingToDeliverExcludingTax: Promise<decimal | null>;
	    readonly linesAmountRemainingToDeliverIncludingTax: Promise<decimal | null>;
	    readonly totalMargin: Promise<decimal | null>;
	    readonly allocationType: Promise<sageX3MasterData.enums.AllocationType | null>;
	    readonly isUnlocked: Promise<boolean>;
	    readonly numberOfLines: Promise<integer | null>;
	    readonly numberOfClosedLines: Promise<integer | null>;
	    readonly numberOfLinesToAllocate: Promise<integer | null>;
	    readonly numberOfDeliveredLines: Promise<integer | null>;
	    readonly numberOfInvoicedLines: Promise<integer | null>;
	    readonly orderStatus: Promise<sageX3SalesData.enums.OrderStatus | null>;
	    readonly allocationStatus: Promise<sageX3MasterData.enums.AllocationStatus | null>;
	    readonly deliveryStatus: Promise<sageX3Sales.enums.SalesDeliveryStatus | null>;
	    readonly invoicedStatus: Promise<sageX3Sales.enums.SalesInvoiceStatus | null>;
	    readonly creditLevelStatus: Promise<sageX3SalesData.enums.CreditStatus | null>;
	    readonly signatureStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
	    readonly revisionNumber: Promise<integer | null>;
	    readonly shipperOrReceiverCode: Promise<string>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly incotermTown: Promise<string>;
	    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly geographicCode: Promise<string>;
	    readonly insideCityLimits: Promise<string>;
	    readonly vertexTransactionType: Promise<string>;
	    readonly taxAmount: Promise<decimal | null>;
	    readonly taxableAmount: Promise<decimal | null>;
	    readonly closingReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly marketingOperationType: Promise<string>;
	    readonly priceStructure: Reference<sageX3InvoicingData.nodes.PriceStructure | null>;
	    readonly totalQuantityDistributedOnLines: Promise<decimal | null>;
	    readonly totalWeightDistributedOnLines: Promise<decimal | null>;
	    readonly totalVolumeDistributedOnLines: Promise<decimal | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly deliveryType: Reference<sageX3SalesData.nodes.SalesDeliveryType | null>;
	    readonly manualHoldStatus: Promise<sageX3SalesData.enums.HoldStatus | null>;
	    readonly manualHoldReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly manualHoldOrReleaseUser: Reference<sageX3System.nodes.User | null>;
	    readonly manualHoldOrReleaseDate: Promise<date | null>;
	    readonly manualHoldOrReleaseTime: Promise<string>;
	    readonly previousManualHoldReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly previousManualHoldOrReleaseUser: Reference<sageX3System.nodes.User | null>;
	    readonly previousManualHoldOrReleaseDate: Promise<date | null>;
	    readonly previousManualHoldOrReleaseTime: Promise<string>;
	    readonly previousCreditLevelStatus: Promise<sageX3SalesData.enums.CreditStatus | null>;
	    readonly isValidatedAddress: Promise<boolean>;
	    readonly requestedDeliveryTime: Promise<string>;
	    readonly invoicingTerm: Reference<sageX3InvoicingData.nodes.InvoicingTerm | null>;
	    readonly scheduledInvoiceStartDueDate: Promise<date | null>;
	    readonly linesAmountRemainingToInvoiceExcludingTax: Promise<decimal | null>;
	    readonly linesAmountRemainingToInvoiceIncludingTax: Promise<decimal | null>;
	    readonly linesAmountExcludingTaxforScheduledInvoicesRemainingToInvoice: Promise<decimal | null>;
	    readonly linesAmountIncludingTaxforScheduledInvoicesRemainingToInvoice: Promise<decimal | null>;
	    readonly draftStatus: Promise<integer | null>;
	    readonly isRejectedDraft: Promise<boolean>;
	    readonly rejectedDraftReason: Promise<string>;
	    readonly hasElectronicSignature: Promise<boolean>;
	    readonly finalNumber: Promise<string>;
	    readonly validationDate: Promise<date | null>;
	    readonly salesOrderLines: Collection<sageX3Sales.nodes.SalesOrderLine>;
	    readonly orderHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly orderFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly orderFooterText: Promise<TextStream>;
	    readonly orderHeaderText: Promise<TextStream>;
	    readonly _x3Transaction: Promise<string>;
	    readonly billToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesOrderBillToCustomerAddressLines>;
	    readonly billToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesOrderBillToCustomerCompanyNames>;
	    readonly customerStatisticalGroups: Collection<sageX3Sales.nodes.SalesOrderCustomerStatisticalGroups>;
	    readonly dimensions: Collection<sageX3Sales.nodes.SalesOrderDimensions>;
	    readonly discountOrChargeCalculationRules: Collection<sageX3Sales.nodes.SalesOrderDiscountOrChargeCalculationRules>;
	    readonly invoicingElements: Collection<sageX3Sales.nodes.SalesOrderInvoicingElements>;
	    readonly salesReps: Collection<sageX3Sales.nodes.SalesOrderSalesReps>;
	    readonly shipToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesOrderShipToCustomerAddressLines>;
	    readonly shipToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesOrderShipToCustomerCompanyNames>;
	    readonly soldToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesOrderSoldToCustomerAddressLines>;
	    readonly soldToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesOrderSoldToCustomerCompanyNames>;
	}
	//# sourceMappingURL=sales-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-sold-to-customer-company-names.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-sold-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderSoldToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=sales-order-sold-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-sold-to-customer-address-lines.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-sold-to-customer-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderSoldToCustomerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=sales-order-sold-to-customer-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-ship-to-customer-company-names.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-ship-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderShipToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=sales-order-ship-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-ship-to-customer-address-lines.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-ship-to-customer-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderShipToCustomerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=sales-order-ship-to-customer-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-sales-reps.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-sales-reps' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderSalesReps extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly salesRep: Reference<sageX3MasterData.nodes.SalesRep | null>;
	}
	//# sourceMappingURL=sales-order-sales-reps.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-quantity-line.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-quantity-line' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderQuantityLine extends Node {
	    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly sequenceNumber: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly category: Promise<sageX3SalesData.enums.OrderCategory>;
	    readonly salesSite: Reference<sageX3System.nodes.Site>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorProductVersion: Promise<string>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site>;
	    readonly locationReference: Promise<string>;
	    readonly orderDate: Promise<date | null>;
	    readonly requestedDeliveryDate: Promise<date | null>;
	    readonly requestedDeliveryTime: Promise<string>;
	    readonly latestDeliveryTime: Promise<string>;
	    readonly latestDeliveryDate: Promise<date | null>;
	    readonly requestedDeliveryReference: Promise<string>;
	    readonly importLineNumber: Promise<integer | null>;
	    readonly shipmentDate: Promise<date | null>;
	    readonly shipmentTime: Promise<string>;
	    readonly expectedDeliveryDate: Promise<date | null>;
	    readonly lineStatus: Promise<sageX3MasterData.enums.LineStatus | null>;
	    readonly isInvoiced: Promise<boolean>;
	    readonly workInProgressStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
	    readonly workInProgressOrderNumber: Promise<string>;
	    readonly productStockManagement: Promise<sageX3MasterData.enums.StockManagement | null>;
	    readonly exclusiveLotFilter: Promise<string>;
	    readonly exclusiveStockStatusFilter: Promise<string>;
	    readonly preferentialStockLocationFilter: Reference<sageX3StockData.nodes.Location | null>;
	    readonly allocationType: Promise<sageX3MasterData.enums.AllocationType | null>;
	    readonly isLineWithDistributedInvoicingElement: Promise<boolean>;
	    readonly quantityInSalesUnitInitiallyOrdered: Promise<decimal | null>;
	    readonly quantityInSalesUnitOrdered: Promise<decimal>;
	    readonly quantityInSalesUnitShortage: Promise<decimal | null>;
	    readonly quantityInSalesUnitAllocated: Promise<decimal | null>;
	    readonly quantityInSalesUnitOnDeliveryOrScheduledInvoice: Promise<decimal | null>;
	    readonly quantityInSalesUnitDelivered: Promise<decimal | null>;
	    readonly quantityInSalesUnitInvoiced: Promise<decimal | null>;
	    readonly quantityInSalesUnitToDeliverForProductsNotManagedInStock: Promise<decimal | null>;
	    readonly quantityInSalesUnitOnPickList: Promise<decimal | null>;
	    readonly quantityInSalesUnitInPreparation: Promise<decimal | null>;
	    readonly quantityInSalesUnitPrepared: Promise<decimal | null>;
	    readonly quantityInStockUnitOrdered: Promise<decimal>;
	    readonly quantityInStockUnitShortage: Promise<decimal | null>;
	    readonly quantityInStockUnitAllocated: Promise<decimal | null>;
	    readonly quantityInStockUnitOnDeliveryOrScheduledInvoice: Promise<decimal | null>;
	    readonly quantityInStockUnitDelivered: Promise<decimal | null>;
	    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
	    readonly quantityInStockUnitToDeliverForProductsNotManagedInStock: Promise<decimal | null>;
	    readonly quantityInStockUnitOnPickList: Promise<decimal | null>;
	    readonly quantityInStockUnitInPreparation: Promise<decimal | null>;
	    readonly quantityInStockUnitPrepared: Promise<decimal | null>;
	    readonly preparationCode: Promise<string>;
	    readonly routeNumber: Promise<sageX3SalesData.enums.RouteCode | null>;
	    readonly deliveryPriority: Promise<sageX3SalesData.enums.DeliveryPriority | null>;
	    readonly completeDeliveryPriority: Promise<integer | null>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
	    readonly deliveryLeadTime: Promise<integer | null>;
	    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
	    readonly packagingCapacity: Promise<decimal | null>;
	    readonly orderLineTextKey: Promise<string>;
	    readonly salesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
	    readonly salesDeliveryLineNumber: Reference<sageX3Sales.nodes.SalesDeliveryLine | null>;
	    readonly productSource: Promise<sageX3SalesData.enums.SourceOfShipment | null>;
	    readonly backToBackOrderNumber: Promise<string>;
	    readonly backToBackOrderLineNumber: Promise<integer | null>;
	    readonly backToBackOrderSequenceNumber: Promise<integer | null>;
	    readonly geographicCode: Promise<string>;
	    readonly insideCityLimits: Promise<string>;
	    readonly isTaxedGeographically: Promise<string>;
	    readonly isTaxable: Promise<boolean>;
	    readonly isRecordedTax: Promise<boolean>;
	    readonly taxRate: Promise<decimal | null>;
	    readonly taxableAmount: Promise<decimal | null>;
	    readonly isComponentPrintedOnAcknowledgement: Promise<boolean>;
	    readonly isComponentPrintedOnPackingSlip: Promise<boolean>;
	    readonly isComponentPrintedOnInvoice: Promise<boolean>;
	    readonly closingReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly tokenManagement: Promise<decimal | null>;
	    readonly weightDistributedOnLine: Promise<decimal | null>;
	    readonly volumeDistributedOnLine: Promise<decimal | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly isDeliverable: Promise<boolean>;
	    readonly invoicedAmount: Promise<decimal | null>;
	    readonly distributedInvoicingElements: Collection<sageX3Sales.nodes.SalesOrderQuantityLineDistributedInvoicingElements>;
	}
	//# sourceMappingURL=sales-order-quantity-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-quantity-line-distributed-invoicing-elements.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-quantity-line-distributed-invoicing-elements' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderQuantityLineDistributedInvoicingElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesOrder: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly sequenceNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrderQuantityLine>;
	    readonly distributedLineInvoicingElementNumber: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	    readonly distributedLineInvoicingElementAmount: Promise<decimal | null>;
	}
	//# sourceMappingURL=sales-order-quantity-line-distributed-invoicing-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-line.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-line' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, date, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderLine extends Node {
	    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly sequenceNumber: Promise<integer | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly category: Promise<sageX3SalesData.enums.OrderCategory>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
	    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site>;
	    readonly salesSite: Reference<sageX3System.nodes.Site>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescriptionInUserLanguage: Promise<string>;
	    readonly productDescriptionInCustomerLanguage: Promise<string>;
	    readonly customerProduct: Promise<string>;
	    readonly salesRep1: Reference<sageX3MasterData.nodes.SalesRep | null>;
	    readonly salesRep2: Reference<sageX3MasterData.nodes.SalesRep | null>;
	    readonly salesRep1CommissionRate: Promise<decimal | null>;
	    readonly salesRep2CommissionRate: Promise<decimal | null>;
	    readonly salesRepCommissionFactor: Promise<decimal | null>;
	    readonly grossPrice: Promise<decimal | null>;
	    readonly priceReason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly netPrice: Promise<decimal | null>;
	    readonly netPriceExcludingTax: Promise<decimal | null>;
	    readonly netPriceIncludingTax: Promise<decimal | null>;
	    readonly margin: Promise<decimal | null>;
	    readonly costPrice: Promise<decimal | null>;
	    readonly discountOrCharge1: Promise<decimal | null>;
	    readonly discountOrCharge2: Promise<decimal | null>;
	    readonly discountOrCharge3: Promise<decimal | null>;
	    readonly discountOrCharge4: Promise<decimal | null>;
	    readonly discountOrCharge5: Promise<decimal | null>;
	    readonly discountOrCharge6: Promise<decimal | null>;
	    readonly discountOrCharge7: Promise<decimal | null>;
	    readonly discountOrCharge8: Promise<decimal | null>;
	    readonly discountOrCharge9: Promise<decimal | null>;
	    readonly discountOrCharge1Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge2Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge3Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge4Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge5Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge6Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge7Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge8Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge9Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly calculatedTaxableBase1: Promise<decimal | null>;
	    readonly calculatedTaxableBase2: Promise<decimal | null>;
	    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly lineStatus: Promise<sageX3MasterData.enums.LineStatus>;
	    readonly lineType: Promise<sageX3SalesData.enums.LineType | null>;
	    readonly freeProduct: Promise<sageX3SalesData.enums.Free | null>;
	    readonly freeProductLineSource: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
	    readonly salesQuote: Reference<sageX3Sales.nodes.SalesQuote | null>;
	    readonly salesQuoteLineNumber: Reference<sageX3Sales.nodes.SalesQuoteLine | null>;
	    readonly lineRevisionNumber: Promise<integer | null>;
	    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly consumerSalesPrice: Promise<decimal | null>;
	    readonly invoicingTerm: Reference<sageX3InvoicingData.nodes.InvoicingTerm | null>;
	    readonly salesOrderQuantityLine: Reference<sageX3Sales.nodes.SalesOrderQuantityLine>;
	    readonly orderLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly salesOrderLineDimension: Reference<sageX3Sales.nodes.SalesOrderLineDimension>;
	    readonly allocationType: Promise<sageX3MasterData.enums.AllocationType | null>;
	    readonly backToBackOrderLineNumber: Promise<integer | null>;
	    readonly backToBackOrderNumber: Promise<string>;
	    readonly backToBackOrderSequenceNumber: Promise<integer | null>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly closingReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly completeDeliveryPriority: Promise<integer | null>;
	    readonly deliveryLeadTime: Promise<integer | null>;
	    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
	    readonly deliveryPriority: Promise<sageX3SalesData.enums.DeliveryPriority | null>;
	    readonly dimensions: Collection<sageX3Sales.nodes.SalesOrderLineDimensionDimensions>;
	    readonly distributedInvoicingElements: Collection<sageX3Sales.nodes.SalesOrderQuantityLineDistributedInvoicingElements>;
	    readonly exclusiveLotFilter: Promise<string>;
	    readonly exclusiveStockStatusFilter: Promise<string>;
	    readonly expectedDeliveryDate: Promise<date | null>;
	    readonly geographicCode: Promise<string>;
	    readonly importLineNumber: Promise<integer | null>;
	    readonly insideCityLimits: Promise<string>;
	    readonly invoicedAmount: Promise<decimal | null>;
	    readonly isComponentPrintedOnAcknowledgement: Promise<boolean>;
	    readonly isComponentPrintedOnInvoice: Promise<boolean>;
	    readonly isComponentPrintedOnPackingSlip: Promise<boolean>;
	    readonly isDeliverable: Promise<boolean>;
	    readonly isInvoiced: Promise<boolean>;
	    readonly isLineWithDistributedInvoicingElement: Promise<boolean>;
	    readonly isRecordedTax: Promise<boolean>;
	    readonly isTaxable: Promise<boolean>;
	    readonly isTaxedGeographically: Promise<string>;
	    readonly latestDeliveryDate: Promise<date | null>;
	    readonly latestDeliveryTime: Promise<string>;
	    readonly locationReference: Promise<string>;
	    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorProductVersion: Promise<string>;
	    readonly orderDate: Promise<date | null>;
	    readonly orderLineText: Promise<TextStream>;
	    readonly orderLineTextKey: Promise<string>;
	    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
	    readonly packagingCapacity: Promise<decimal | null>;
	    readonly preferentialStockLocationFilter: Reference<sageX3StockData.nodes.Location | null>;
	    readonly preparationCode: Promise<string>;
	    readonly productSource: Promise<sageX3SalesData.enums.SourceOfShipment | null>;
	    readonly productStockManagement: Promise<sageX3MasterData.enums.StockManagement | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly quantityInSalesUnitAllocated: Promise<decimal | null>;
	    readonly quantityInSalesUnitDelivered: Promise<decimal | null>;
	    readonly quantityInSalesUnitInPreparation: Promise<decimal | null>;
	    readonly quantityInSalesUnitInitiallyOrdered: Promise<decimal | null>;
	    readonly quantityInSalesUnitInvoiced: Promise<decimal | null>;
	    readonly quantityInSalesUnitOnDeliveryOrScheduledInvoice: Promise<decimal | null>;
	    readonly quantityInSalesUnitOnPickList: Promise<decimal | null>;
	    readonly quantityInSalesUnitOrdered: Promise<decimal>;
	    readonly quantityInSalesUnitPrepared: Promise<decimal | null>;
	    readonly quantityInSalesUnitShortage: Promise<decimal | null>;
	    readonly quantityInSalesUnitToDeliverForProductsNotManagedInStock: Promise<decimal | null>;
	    readonly quantityInStockUnitAllocated: Promise<decimal | null>;
	    readonly quantityInStockUnitDelivered: Promise<decimal | null>;
	    readonly quantityInStockUnitInPreparation: Promise<decimal | null>;
	    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
	    readonly quantityInStockUnitOnDeliveryOrScheduledInvoice: Promise<decimal | null>;
	    readonly quantityInStockUnitOnPickList: Promise<decimal | null>;
	    readonly quantityInStockUnitOrdered: Promise<decimal>;
	    readonly quantityInStockUnitPrepared: Promise<decimal | null>;
	    readonly quantityInStockUnitShortage: Promise<decimal | null>;
	    readonly quantityInStockUnitToDeliverForProductsNotManagedInStock: Promise<decimal | null>;
	    readonly requestedDeliveryDate: Promise<date | null>;
	    readonly requestedDeliveryReference: Promise<string>;
	    readonly requestedDeliveryTime: Promise<string>;
	    readonly routeNumber: Promise<sageX3SalesData.enums.RouteCode | null>;
	    readonly salesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
	    readonly salesDeliveryLineNumber: Reference<sageX3Sales.nodes.SalesDeliveryLine | null>;
	    readonly shipmentDate: Promise<date | null>;
	    readonly shipmentTime: Promise<string>;
	    readonly taxRate: Promise<decimal | null>;
	    readonly taxableAmount: Promise<decimal | null>;
	    readonly tokenManagement: Promise<decimal | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly volumeDistributedOnLine: Promise<decimal | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly weightDistributedOnLine: Promise<decimal | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly workInProgressOrderNumber: Promise<string>;
	    readonly workInProgressStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
	    readonly productStatisticalGroups: Collection<sageX3Sales.nodes.SalesOrderLineProductStatisticalGroups>;
	    readonly taxes: Collection<sageX3Sales.nodes.SalesOrderLineTaxes>;
	}
	//# sourceMappingURL=sales-order-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-line-taxes.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-line-taxes' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderLineTaxes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesOrder: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly sequenceNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrderLine>;
	    readonly taxLevel: Reference<sageX3InvoicingData.nodes.TaxLevel | null>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=sales-order-line-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-line-product-statistical-groups.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-line-product-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderLineProductStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesOrder: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly sequenceNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrderLine>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=sales-order-line-product-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-line-dimension.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-line-dimension' {
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, Reference, integer, Collection } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderLineDimension extends Node {
	    readonly abbreviation: Promise<string>;
	    readonly typ: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly salesOrderLine: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
	    readonly sequenceNumber: Promise<integer | null>;
	    readonly keyComplement: Promise<string>;
	    readonly sortValue: Promise<integer | null>;
	    readonly dimensions: Collection<sageX3Sales.nodes.SalesOrderLineDimensionDimensions>;
	}
	//# sourceMappingURL=sales-order-line-dimension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-line-dimension-dimensions.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-line-dimension-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderLineDimensionDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly abbreviation: Promise<string>;
	    readonly typ: Promise<sageX3StockData.enums.EntryTypeEnum>;
	    readonly salesOrder: Promise<string>;
	    readonly salesOrderLine: Promise<integer>;
	    readonly sequenceNumber: Promise<integer>;
	    readonly keyComplement: Promise<string>;
	    readonly sortValue: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrderLineDimension>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=sales-order-line-dimension-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-invoicing-elements.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-invoicing-elements' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderInvoicingElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly percentageOrAmount: Promise<decimal | null>;
	    readonly valueType: Promise<sageX3MasterData.enums.ValueType | null>;
	    readonly distributionKey: Reference<sageX3FinanceData.nodes.DistributionKey | null>;
	    readonly invoicingElement: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=sales-order-invoicing-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-discount-or-charge-calculation-rules.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-discount-or-charge-calculation-rules' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderDiscountOrChargeCalculationRules extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly type: Promise<sageX3MasterData.enums.DiscountCalculationRules | null>;
	    readonly invoicingElement: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	}
	//# sourceMappingURL=sales-order-discount-or-charge-calculation-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-dimensions.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=sales-order-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-customer-statistical-groups.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-customer-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderCustomerStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=sales-order-customer-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-bill-to-customer-company-names.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-bill-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderBillToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=sales-order-bill-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-order-bill-to-customer-address-lines.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-order-bill-to-customer-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesOrderBillToCustomerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=sales-order-bill-to-customer-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, decimal, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoice extends Node {
	    readonly id: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly salesSite: Reference<sageX3System.nodes.Site>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly groupCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress | null>;
	    readonly billToCustomerEuropeanUnionVatNumber: Promise<string>;
	    readonly billToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly shipToCustomerPostalCode: Promise<string>;
	    readonly shipToCustomerCity: Promise<string>;
	    readonly shipToCustomerState: Promise<string>;
	    readonly shipToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly shipToCustomerCountryName: Promise<string>;
	    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly payByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly factor: Reference<sageX3FinanceData.nodes.Factor | null>;
	    readonly invoiceType: Reference<sageX3SalesData.nodes.SalesInvoiceType | null>;
	    readonly category: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
	    readonly sourceDocumentCategory: Promise<sageX3Sales.enums.SalesInvoiceSource | null>;
	    readonly sourceDocumentNumber: Promise<string>;
	    readonly sourceDocumentDate: Promise<date | null>;
	    readonly invoiceDate: Promise<date | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly status: Promise<sageX3MasterData.enums.InvoiceStatus | null>;
	    readonly isOnCreditMemo: Promise<boolean>;
	    readonly hasStockTransaction: Promise<boolean>;
	    readonly internalReference: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly priceIncludingOrExcludingTax: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly creditMemoReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly billToCustomerLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly invoiceHeaderTextKey: Promise<string>;
	    readonly invoiceFooterTextKey: Promise<string>;
	    readonly isIntersite: Promise<boolean>;
	    readonly isIntercompany: Promise<boolean>;
	    readonly sourceSite: Reference<sageX3System.nodes.Site | null>;
	    readonly numberOfLines: Promise<integer | null>;
	    readonly numberOfInvoiceCopies: Promise<integer | null>;
	    readonly numberOfCreditMemoCopies: Promise<integer | null>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly dockLocation: Reference<sageX3StockData.nodes.Location | null>;
	    readonly intrastatTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
	    readonly intrastatAdjustmentTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
	    readonly intrastatStatisticalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
	    readonly intrastatAdjustmentStatisticalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly intrastatTransportMode: Promise<sageX3MasterData.enums.IntrastatTransportMode | null>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly incotermTown: Promise<string>;
	    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly geographicCode: Promise<string>;
	    readonly insideCityLimits: Promise<string>;
	    readonly marketingCampaign: Promise<string>;
	    readonly priceStructure: Reference<sageX3InvoicingData.nodes.PriceStructure | null>;
	    readonly totalQuantityDistributedOnLines: Promise<decimal | null>;
	    readonly totalWeightDistributedOnLines: Promise<decimal | null>;
	    readonly totalVolumeDistributedOnLines: Promise<decimal | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly isPrinted: Promise<boolean>;
	    readonly isValidatedAddress: Promise<boolean>;
	    readonly departureDate: Promise<date | null>;
	    readonly arrivalDate: Promise<date | null>;
	    readonly departureTime: Promise<string>;
	    readonly arrivalTime: Promise<string>;
	    readonly vehicleLicensePlate: Promise<string>;
	    readonly trailerLicensePlate: Promise<string>;
	    readonly sourceDocumentType: Promise<sageX3SalesData.enums.SalesDocumentType | null>;
	    readonly finalSequenceNumber: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly hasElectronicSignature: Promise<boolean>;
	    readonly salesInvoiceLines: Collection<sageX3Sales.nodes.SalesInvoiceLine>;
	    readonly customerInvoiceHeader: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader>;
	    readonly invoiceHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly invoiceFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly accountingDate: Promise<date | null>;
	    readonly billToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly billToCustomerAddressLines: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderBillToCustomerAddressLines>;
	    readonly billToCustomerCity: Promise<string>;
	    readonly billToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly billToCustomerCountryName: Promise<string>;
	    readonly billToCustomerPostalCode: Promise<string>;
	    readonly billToCustomerState: Promise<string>;
	    readonly businessProcessType: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly cancellationStatus: Promise<integer | null>;
	    readonly cashVatTaxRule: Promise<boolean>;
	    readonly comments: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderComments>;
	    readonly control: Promise<string>;
	    readonly correctionMethod: Promise<sageX3InvoicingData.enums.CorrectionMethod | null>;
	    readonly creditMemoReferenceEndDate: Promise<date | null>;
	    readonly creditMemoReferenceStartDate: Promise<date | null>;
	    readonly currencyRates: Collection<sageX3FinanceData.nodes.CustomerInvoiceHeaderCurrencyRates>;
	    readonly customerSourceDocument: Promise<string>;
	    readonly customerSourceDocumentDate: Promise<date | null>;
	    readonly debitOrCredit: Promise<integer | null>;
	    readonly derCode: Promise<string>;
	    readonly dimensions: Collection<sageX3FinanceData.nodes.CustomerInvoiceHeaderDimensions>;
	    readonly dueDateCalculationStartDate: Promise<date | null>;
	    readonly earlyDiscountOrLateChargeBasis: Promise<decimal | null>;
	    readonly earlyDiscountOrLateChargeRate: Promise<decimal | null>;
	    readonly entityUserCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly entryType: Reference<sageX3FinanceData.nodes.EntryType | null>;
	    readonly field40Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly field41Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly fiscalYear: Promise<integer | null>;
	    readonly inPaymentSlipWithReferenceNumber: Promise<string>;
	    readonly internalNumber: Promise<integer | null>;
	    readonly intrastatProcessingNumber: Promise<integer | null>;
	    readonly invoiceFooterText: Promise<TextStream>;
	    readonly invoiceHeaderText: Promise<TextStream>;
	    readonly isDirectInvoice: Promise<boolean>;
	    readonly isExternalDocument: Promise<boolean>;
	    readonly journal: Reference<sageX3FinanceData.nodes.Journal | null>;
	    readonly lastServiceAccountedDate: Promise<date | null>;
	    readonly mandate: Reference<sageX3InvoicingData.nodes.Mandate | null>;
	    readonly numberOfTaxes: Promise<integer | null>;
	    readonly originalDocumentNumber: Promise<string>;
	    readonly originalInvoiceNumber: Promise<string>;
	    readonly payByBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly payByBusinessPartnerAddressLines: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
	    readonly payByBusinessPartnerCity: Promise<string>;
	    readonly payByBusinessPartnerCompanyNames: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
	    readonly payByBusinessPartnerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly payByBusinessPartnerCountryName: Promise<string>;
	    readonly payByBusinessPartnerPostalCode: Promise<string>;
	    readonly payByBusinessPartnerState: Promise<string>;
	    readonly paymentBank: Reference<sageX3FinanceData.nodes.BankAccount | null>;
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
	    readonly period: Promise<integer | null>;
	    readonly rateDate: Promise<date | null>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly serviceEndDate: Promise<date | null>;
	    readonly serviceStartDate: Promise<date | null>;
	    readonly siteIdentificationNumber: Promise<string>;
	    readonly sourceModule: Promise<sageX3System.enums.ModuleTable | null>;
	    readonly spanishInvoiceType: Promise<sageX3MasterData.enums.SpanishInvoiceType | null>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly taxReferenceDate: Promise<date | null>;
	    readonly taxes: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderTaxes>;
	    readonly totalAmountExcludingTax: Promise<decimal | null>;
	    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountIncludingTax: Promise<decimal | null>;
	    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly vatDeclarationNumber: Promise<string>;
	    readonly versionControlSystemNumber: Promise<string>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly billToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesInvoiceBillToCustomerCompanyNames>;
	    readonly customerStatisticalGroups: Collection<sageX3Sales.nodes.SalesInvoiceCustomerStatisticalGroups>;
	    readonly discountOrChargeCalculationRules: Collection<sageX3Sales.nodes.SalesInvoiceDiscountOrChargeCalculationRules>;
	    readonly invoicingElements: Collection<sageX3Sales.nodes.SalesInvoiceInvoicingElements>;
	    readonly salesOrderOfPrepayments: Collection<sageX3Sales.nodes.SalesInvoiceSalesOrderOfPrepayments>;
	    readonly salesReps: Collection<sageX3Sales.nodes.SalesInvoiceSalesReps>;
	    readonly shipToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesInvoiceShipToCustomerAddressLines>;
	    readonly shipToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesInvoiceShipToCustomerCompanyNames>;
	}
	//# sourceMappingURL=sales-invoice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-ship-to-customer-company-names.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-ship-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceShipToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoice>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=sales-invoice-ship-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-ship-to-customer-address-lines.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-ship-to-customer-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceShipToCustomerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoice>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=sales-invoice-ship-to-customer-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-sales-reps.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-sales-reps' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceSalesReps extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoice>;
	    readonly salesRep: Reference<sageX3MasterData.nodes.SalesRep | null>;
	}
	//# sourceMappingURL=sales-invoice-sales-reps.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-sales-order-of-prepayments.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-sales-order-of-prepayments' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceSalesOrderOfPrepayments extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoice>;
	    readonly paymentMethodOfPrepayments: Reference<sageX3InvoicingData.nodes.PaymentMethod | null>;
	    readonly prepaymentAmountIncludingTax: Promise<decimal | null>;
	    readonly salesOrderOfPrepayment: Promise<string>;
	    readonly salesOrderLineNumberOfPrepayment: Reference<sageX3FinanceData.nodes.OpenItem | null>;
	}
	//# sourceMappingURL=sales-invoice-sales-order-of-prepayments.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-line.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-line' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, date, TextStream, Collection } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceLine extends Node {
	    readonly salesInvoice: Reference<sageX3Sales.nodes.SalesInvoice>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly salesOrderNumber: Reference<sageX3Sales.nodes.SalesOrder | null>;
	    readonly salesOrderLineNumber: Promise<integer | null>;
	    readonly salesOrderLine: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
	    readonly salesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
	    readonly salesDeliveryLine: Reference<sageX3Sales.nodes.SalesDeliveryLine | null>;
	    readonly sourceSalesInvoice: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly sourceSalesInvoiceLine: Reference<sageX3Sales.nodes.SalesInvoiceLine | null>;
	    readonly salesReturn: Reference<sageX3Sales.nodes.SalesReturn | null>;
	    readonly salesReturnLine: Reference<sageX3Sales.nodes.SalesReturnLine | null>;
	    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorProductVersion: Promise<string>;
	    readonly productDescriptionInUserLanguage: Promise<string>;
	    readonly productDescriptionInCustomerLanguage: Promise<string>;
	    readonly salesRep1: Reference<sageX3MasterData.nodes.SalesRep | null>;
	    readonly salesRep2: Reference<sageX3MasterData.nodes.SalesRep | null>;
	    readonly salesRep1CommissionRate: Promise<decimal | null>;
	    readonly salesRep2CommissionRate: Promise<decimal | null>;
	    readonly salesRep1CommissionBase: Promise<decimal | null>;
	    readonly salesRep2CommissionBase: Promise<decimal | null>;
	    readonly salesRep1CommissionAmount: Promise<decimal | null>;
	    readonly salesRep2CommissionAmount: Promise<decimal | null>;
	    readonly salesRepCommissionFactor: Promise<decimal | null>;
	    readonly grossPrice: Promise<decimal | null>;
	    readonly priceReason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly netPrice: Promise<decimal | null>;
	    readonly netPriceExcludingTax: Promise<decimal | null>;
	    readonly netPriceIncludingTax: Promise<decimal | null>;
	    readonly margin: Promise<decimal | null>;
	    readonly costPrice: Promise<decimal | null>;
	    readonly discountOrCharge1: Promise<decimal | null>;
	    readonly discountOrCharge2: Promise<decimal | null>;
	    readonly discountOrCharge3: Promise<decimal | null>;
	    readonly discountOrCharge4: Promise<decimal | null>;
	    readonly discountOrCharge5: Promise<decimal | null>;
	    readonly discountOrCharge6: Promise<decimal | null>;
	    readonly discountOrCharge7: Promise<decimal | null>;
	    readonly discountOrCharge8: Promise<decimal | null>;
	    readonly discountOrCharge9: Promise<decimal | null>;
	    readonly discountOrCharge1Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge2Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge3Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge4Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge5Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge6Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge7Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge8Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge9Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly lineAmountEnteredManually: Promise<decimal | null>;
	    readonly lineAmountExcludingTax: Promise<decimal | null>;
	    readonly discountLineAmount: Promise<decimal | null>;
	    readonly calculatedTaxableBase1: Promise<decimal | null>;
	    readonly calculatedTaxableBase2: Promise<decimal | null>;
	    readonly taxRate: Promise<decimal | null>;
	    readonly lineAmountIncludingTax: Promise<decimal | null>;
	    readonly isLineWithDistributedInvoicingElement: Promise<boolean>;
	    readonly quantityInSalesUnitInvoiced: Promise<decimal>;
	    readonly quantityInStockUnitInvoiced: Promise<decimal>;
	    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly productStockManagement: Promise<sageX3MasterData.enums.StockManagement | null>;
	    readonly exclusiveLotFilter: Promise<string>;
	    readonly exclusiveStockStatusFilter: Promise<string>;
	    readonly preferentialStockLocationFilter: Reference<sageX3StockData.nodes.Location | null>;
	    readonly stockPriceInCreditMemoWithStockMovement: Promise<decimal | null>;
	    readonly allocationType: Promise<sageX3MasterData.enums.TypeOfAllocation | null>;
	    readonly salesSite: Reference<sageX3System.nodes.Site>;
	    readonly invoiceDate: Promise<date>;
	    readonly lineType: Promise<sageX3SalesData.enums.LineType | null>;
	    readonly freeProduct: Promise<sageX3SalesData.enums.Free | null>;
	    readonly freeProductLineSource: Reference<sageX3Sales.nodes.SalesInvoiceLine | null>;
	    readonly invoiceLineTextKey: Promise<string>;
	    readonly isExtractedIntrastatLine: Promise<boolean>;
	    readonly isIntrastatPhysicalFlow: Promise<boolean>;
	    readonly geographicCode: Promise<string>;
	    readonly insideCityLimits: Promise<string>;
	    readonly isTaxedGeographically: Promise<string>;
	    readonly isTaxable: Promise<boolean>;
	    readonly isRecordedTax: Promise<boolean>;
	    readonly isPrintedOnInvoice: Promise<boolean>;
	    readonly serviceStartDate: Promise<date | null>;
	    readonly serviceEndDate: Promise<date | null>;
	    readonly servicePeriodNumber: Promise<integer | null>;
	    readonly servicePeriodType: Promise<sageX3InvoicingData.enums.PeriodicityType | null>;
	    readonly tokenManagement: Promise<decimal | null>;
	    readonly weightDistributedOnLine: Promise<decimal | null>;
	    readonly volumeDistributedOnLine: Promise<decimal | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly importLineNumber: Promise<integer | null>;
	    readonly sourceDocumentType: Promise<sageX3Sales.enums.SalesInvoiceSource | null>;
	    readonly invoicePercentageForScheduledInvoice: Promise<decimal | null>;
	    readonly scheduledInvoiceLineNumber: Promise<integer | null>;
	    readonly scheduledinvoiceSource: Promise<sageX3SalesData.enums.SalesDocumentType | null>;
	    readonly invoiceLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly invoiceLineText: Promise<TextStream>;
	    readonly distributedInvoicingElements: Collection<sageX3Sales.nodes.SalesInvoiceLineDistributedInvoicingElements>;
	    readonly productStatisticalGroups: Collection<sageX3Sales.nodes.SalesInvoiceLineProductStatisticalGroups>;
	    readonly taxBasisAmounts: Collection<sageX3Sales.nodes.SalesInvoiceLineTaxBasisAmounts>;
	    readonly taxes: Collection<sageX3Sales.nodes.SalesInvoiceLineTaxes>;
	}
	//# sourceMappingURL=sales-invoice-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-line-taxes.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-line-taxes' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceLineTaxes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesInvoice: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoiceLine>;
	    readonly taxLevel: Reference<sageX3InvoicingData.nodes.TaxLevel | null>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly taxAmount: Promise<decimal | null>;
	}
	//# sourceMappingURL=sales-invoice-line-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-line-tax-basis-amounts.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-line-tax-basis-amounts' {
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceLineTaxBasisAmounts extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesInvoice: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoiceLine>;
	    readonly taxBasisAmount: Promise<decimal | null>;
	}
	//# sourceMappingURL=sales-invoice-line-tax-basis-amounts.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-line-product-statistical-groups.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-line-product-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceLineProductStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesInvoice: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoiceLine>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=sales-invoice-line-product-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-line-distributed-invoicing-elements.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-line-distributed-invoicing-elements' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceLineDistributedInvoicingElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesInvoice: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoiceLine>;
	    readonly distributedLineInvoicingElementNumber: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	    readonly distributedLineInvoicingElementAmount: Promise<decimal | null>;
	    readonly distributedLineInvoicingElementDiscount: Promise<decimal | null>;
	}
	//# sourceMappingURL=sales-invoice-line-distributed-invoicing-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-invoicing-elements.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-invoicing-elements' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceInvoicingElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoice>;
	    readonly invoicingElement: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	    readonly percentageOrAmount: Promise<decimal | null>;
	    readonly valueType: Promise<sageX3MasterData.enums.ValueType | null>;
	    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=sales-invoice-invoicing-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-discount-or-charge-calculation-rules.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-discount-or-charge-calculation-rules' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceDiscountOrChargeCalculationRules extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoice>;
	    readonly type: Promise<sageX3MasterData.enums.DiscountCalculationRules | null>;
	    readonly invoicingElement: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	}
	//# sourceMappingURL=sales-invoice-discount-or-charge-calculation-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-customer-statistical-groups.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-customer-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceCustomerStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoice>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=sales-invoice-customer-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-invoice-bill-to-customer-company-names.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-invoice-bill-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesInvoiceBillToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesInvoice>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=sales-invoice-bill-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDelivery extends Node {
	    readonly id: Promise<string>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly category: Promise<sageX3SalesData.enums.DeliveryCategory | null>;
	    readonly isLoanDelivery: Promise<boolean>;
	    readonly salesSite: Reference<sageX3System.nodes.Site>;
	    readonly salesInvoice: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly sequenceInSalesInvoice: Promise<integer | null>;
	    readonly salesInvoiceToBeIssued: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly salesInvoiceToBeIssuedReversalDate: Promise<date | null>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly payByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly groupCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly shipmentDate: Promise<date>;
	    readonly shipmentTime: Promise<string>;
	    readonly deliveryDate: Promise<date | null>;
	    readonly deliveryTime: Promise<string>;
	    readonly deliveryLeadTimeInDays: Promise<integer | null>;
	    readonly deliveryLeadTimeInHours: Promise<integer | null>;
	    readonly loanReturnDate: Promise<date | null>;
	    readonly shipToCustomerPostalCode: Promise<string>;
	    readonly shipToCustomerCity: Promise<string>;
	    readonly shipToCustomerState: Promise<string>;
	    readonly shipToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly shipToCustomerCountryName: Promise<string>;
	    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly billToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly billToCustomerPostalCode: Promise<string>;
	    readonly billToCustomerCity: Promise<string>;
	    readonly billToCustomerState: Promise<string>;
	    readonly billToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly billToCustomerCountryName: Promise<string>;
	    readonly billToCustomerEuropeanUnionVatNumber: Promise<string>;
	    readonly billToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly currencyRateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly inverseRate: Promise<decimal | null>;
	    readonly billToCustomerLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
	    readonly entityUse: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly routeNumber: Promise<sageX3SalesData.enums.RouteCode | null>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
	    readonly invoicingFrequency: Promise<sageX3SalesData.enums.InvoicingFrequency | null>;
	    readonly dueDateCalculationOrigin: Promise<sageX3SalesData.enums.DueDateCalculationSource | null>;
	    readonly invoicingMode: Promise<sageX3SalesData.enums.InvoicingMode | null>;
	    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder | null>;
	    readonly mustPrintTransportNote: Promise<boolean>;
	    readonly mustPrintPickTicket: Promise<boolean>;
	    readonly mustPrintPackingSlip: Promise<boolean>;
	    readonly isPickTicketPrinted: Promise<boolean>;
	    readonly isPackingSlipPrinted: Promise<boolean>;
	    readonly numberOfPackingSlipCopies: Promise<integer | null>;
	    readonly isValidated: Promise<boolean>;
	    readonly isInvoiced: Promise<boolean>;
	    readonly salesProforma: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly isIntersite: Promise<boolean>;
	    readonly isIntercompany: Promise<boolean>;
	    readonly sourceSite: Reference<sageX3System.nodes.Site | null>;
	    readonly receivingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly pickingHeaderTextKey: Promise<string>;
	    readonly pickingFooterTextKey: Promise<string>;
	    readonly deliveryHeaderTextKey: Promise<string>;
	    readonly deliveryFooterTextKey: Promise<string>;
	    readonly priceIncludingOrExcludingTax: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly linesAmountExcludingTax: Promise<decimal | null>;
	    readonly linesAmountIncludingTax: Promise<decimal | null>;
	    readonly linesAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly linesAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountExcludingTax: Promise<decimal | null>;
	    readonly totalAmountIncludingTax: Promise<decimal | null>;
	    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly numberOfLines: Promise<integer | null>;
	    readonly numberOfReturnedLines: Promise<integer | null>;
	    readonly returnStatus: Promise<sageX3SalesData.enums.ReturnStatus | null>;
	    readonly customerLocation: Reference<sageX3StockData.nodes.Location | null>;
	    readonly labelNumber: Promise<string>;
	    readonly numberOfPackages: Promise<integer | null>;
	    readonly isPacked: Promise<boolean>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly netWeight: Promise<decimal | null>;
	    readonly grossWeight: Promise<decimal | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly intrastatTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
	    readonly intrastatStatisticalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly intrastatTransportMode: Promise<sageX3MasterData.enums.IntrastatTransportMode | null>;
	    readonly intrastatProcessingNumber: Promise<integer | null>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly incotermTown: Promise<string>;
	    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly geographicCode: Promise<string>;
	    readonly insideCityLimits: Promise<string>;
	    readonly vertexTransactionType: Promise<string>;
	    readonly taxAmount: Promise<decimal | null>;
	    readonly taxableAmount: Promise<decimal | null>;
	    readonly vehicleLicensePlate: Promise<string>;
	    readonly trailerLicensePlate: Promise<string>;
	    readonly departureDate: Promise<date | null>;
	    readonly arrivalDate: Promise<date | null>;
	    readonly departureTime: Promise<string>;
	    readonly arrivalTime: Promise<string>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly priceStructure: Reference<sageX3InvoicingData.nodes.PriceStructure | null>;
	    readonly totalQuantityDistributedOnLines: Promise<decimal | null>;
	    readonly totalWeightDistributedOnLines: Promise<decimal | null>;
	    readonly totalVolumeDistributedOnLines: Promise<decimal | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly isForSubconractDelivery: Promise<boolean>;
	    readonly deliveryType: Reference<sageX3SalesData.nodes.SalesDeliveryType | null>;
	    readonly initialDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
	    readonly isValidatedAddress: Promise<boolean>;
	    readonly billOfLading: Promise<string>;
	    readonly salesDeliveryLines: Collection<sageX3Sales.nodes.SalesDeliveryLine>;
	    readonly pickingHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly pickingFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly deliveryHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly deliveryFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly deliveryFooterText: Promise<TextStream>;
	    readonly deliveryHeaderText: Promise<TextStream>;
	    readonly pickingFooterText: Promise<TextStream>;
	    readonly pickingHeaderText: Promise<TextStream>;
	    readonly billToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesDeliveryBillToCustomerAddressLines>;
	    readonly billToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesDeliveryBillToCustomerCompanyNames>;
	    readonly customerStatisticalGroups: Collection<sageX3Sales.nodes.SalesDeliveryCustomerStatisticalGroups>;
	    readonly dimensions: Collection<sageX3Sales.nodes.SalesDeliveryDimensions>;
	    readonly discountOrChargeCalculationRules: Collection<sageX3Sales.nodes.SalesDeliveryDiscountOrChargeCalculationRules>;
	    readonly invoicingElements: Collection<sageX3Sales.nodes.SalesDeliveryInvoicingElements>;
	    readonly salesReps: Collection<sageX3Sales.nodes.SalesDeliverySalesReps>;
	    readonly shipToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesDeliveryShipToCustomerAddressLines>;
	    readonly shipToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesDeliveryShipToCustomerCompanyNames>;
	}
	//# sourceMappingURL=sales-delivery.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-ship-to-customer-company-names.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-ship-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryShipToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDelivery>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=sales-delivery-ship-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-ship-to-customer-address-lines.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-ship-to-customer-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryShipToCustomerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDelivery>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=sales-delivery-ship-to-customer-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-sales-reps.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-sales-reps' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliverySalesReps extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDelivery>;
	    readonly salesRep: Reference<sageX3MasterData.nodes.SalesRep | null>;
	}
	//# sourceMappingURL=sales-delivery-sales-reps.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-line.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, TextStream, Collection } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryLine extends Node {
	    readonly salesDelivery: Reference<sageX3Sales.nodes.SalesDelivery>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly salesOrderCategory: Promise<sageX3SalesData.enums.OrderCategory | null>;
	    readonly salesOrderNumber: Reference<sageX3Sales.nodes.SalesOrder | null>;
	    readonly salesOrderLineNumber: Promise<integer | null>;
	    readonly salesOrderLine: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorProductVersion: Promise<string>;
	    readonly productDescriptionInUserLanguage: Promise<string>;
	    readonly productDescriptionInCustomerLanguage: Promise<string>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site>;
	    readonly locationReference: Promise<string>;
	    readonly shipmentDate: Promise<date>;
	    readonly salesRep1: Reference<sageX3MasterData.nodes.SalesRep | null>;
	    readonly salesRep2: Reference<sageX3MasterData.nodes.SalesRep | null>;
	    readonly salesRep1CommissionRate: Promise<decimal | null>;
	    readonly salesRep2CommissionRate: Promise<decimal | null>;
	    readonly salesRepCommissionFactor: Promise<decimal | null>;
	    readonly grossPrice: Promise<decimal | null>;
	    readonly priceReason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly netPrice: Promise<decimal | null>;
	    readonly netPriceExcludingTax: Promise<decimal | null>;
	    readonly netPriceIncludingTax: Promise<decimal | null>;
	    readonly margin: Promise<decimal | null>;
	    readonly costPrice: Promise<decimal | null>;
	    readonly discountOrCharge1: Promise<decimal | null>;
	    readonly discountOrCharge2: Promise<decimal | null>;
	    readonly discountOrCharge3: Promise<decimal | null>;
	    readonly discountOrCharge4: Promise<decimal | null>;
	    readonly discountOrCharge5: Promise<decimal | null>;
	    readonly discountOrCharge6: Promise<decimal | null>;
	    readonly discountOrCharge7: Promise<decimal | null>;
	    readonly discountOrCharge8: Promise<decimal | null>;
	    readonly discountOrCharge9: Promise<decimal | null>;
	    readonly discountOrCharge1Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge2Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge3Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge4Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge5Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge6Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge7Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge8Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly discountOrCharge9Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
	    readonly calculatedTaxableBase1: Promise<decimal | null>;
	    readonly calculatedTaxableBase2: Promise<decimal | null>;
	    readonly isLineWithDistributedInvoicingElement: Promise<boolean>;
	    readonly quantityInSalesUnitDelivered: Promise<decimal>;
	    readonly quantityInStockUnitInvoiced: Promise<decimal>;
	    readonly quantityInSalesUnitReturned: Promise<decimal | null>;
	    readonly quantityInStockUnitReturned: Promise<decimal | null>;
	    readonly quantityInSalesUnitWaitingForReturn: Promise<decimal | null>;
	    readonly quantityInStockUnitWaitingForReturn: Promise<decimal | null>;
	    readonly quantityInStockUnitInitiallyAllocatedOnOrder: Promise<decimal | null>;
	    readonly quantityInStockUnitPackaged: Promise<decimal | null>;
	    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
	    readonly packagingCapacity: Promise<decimal | null>;
	    readonly lineType: Promise<sageX3SalesData.enums.LineType | null>;
	    readonly freeProduct: Promise<sageX3SalesData.enums.Free | null>;
	    readonly freeProductLineSource: Reference<sageX3Sales.nodes.SalesDeliveryLine | null>;
	    readonly productStockManagement: Promise<sageX3MasterData.enums.StockManagement | null>;
	    readonly exclusiveLotFilter: Promise<string>;
	    readonly exclusiveStockStatusFilter: Promise<string>;
	    readonly preferentialStockLocationFilter: Reference<sageX3StockData.nodes.Location | null>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly deliveryLineTextKey: Promise<string>;
	    readonly pickingLineTextKey: Promise<string>;
	    readonly geographicCode: Promise<string>;
	    readonly insideCityLimits: Promise<string>;
	    readonly isTaxedGeographically: Promise<string>;
	    readonly isTaxable: Promise<boolean>;
	    readonly isRecordedTax: Promise<boolean>;
	    readonly taxRate: Promise<decimal | null>;
	    readonly taxBasisAmount: Promise<decimal | null>;
	    readonly isComponentPrintedOnPackingSlip: Promise<boolean>;
	    readonly isComponentPrintedOnInvoice: Promise<boolean>;
	    readonly receiptStatus: Promise<integer | null>;
	    readonly quantityInStockUnitReceived: Promise<decimal | null>;
	    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly sourceDocument: Promise<string>;
	    readonly sourceDocumentLineNumber: Promise<integer | null>;
	    readonly sourceDocumentSequenceNumber: Promise<integer | null>;
	    readonly weightDistributedOnLine: Promise<decimal | null>;
	    readonly volumeDistributedOnLine: Promise<decimal | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly isPacked: Promise<boolean>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly category: Promise<sageX3SalesData.enums.DeliveryCategory | null>;
	    readonly isValidatedLine: Promise<boolean>;
	    readonly deliveryLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly pickingLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly deliveryLineText: Promise<TextStream>;
	    readonly pickingLineText: Promise<TextStream>;
	    readonly distributedInvoicingElements: Collection<sageX3Sales.nodes.SalesDeliveryLineDistributedInvoicingElements>;
	    readonly productStatisticalGroups: Collection<sageX3Sales.nodes.SalesDeliveryLineProductStatisticalGroups>;
	    readonly taxes: Collection<sageX3Sales.nodes.SalesDeliveryLineTaxes>;
	}
	//# sourceMappingURL=sales-delivery-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-line-taxes.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-line-taxes' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryLineTaxes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesDelivery: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDeliveryLine>;
	    readonly taxLevel: Reference<sageX3InvoicingData.nodes.TaxLevel | null>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=sales-delivery-line-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-line-product-statistical-groups.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-line-product-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryLineProductStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesDelivery: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDeliveryLine>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=sales-delivery-line-product-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-line-distributed-invoicing-elements.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-line-distributed-invoicing-elements' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryLineDistributedInvoicingElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly salesDelivery: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDeliveryLine>;
	    readonly distributedLineInvoicingElementNumber: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	    readonly distributedLineInvoicingElementAmount: Promise<decimal | null>;
	}
	//# sourceMappingURL=sales-delivery-line-distributed-invoicing-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-invoicing-elements.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-invoicing-elements' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryInvoicingElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDelivery>;
	    readonly percentageOrAmount: Promise<decimal | null>;
	    readonly valueType: Promise<sageX3MasterData.enums.ValueType | null>;
	    readonly distributionKey: Reference<sageX3FinanceData.nodes.DistributionKey | null>;
	    readonly invoicingElement: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=sales-delivery-invoicing-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-discount-or-charge-calculation-rules.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-discount-or-charge-calculation-rules' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryDiscountOrChargeCalculationRules extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDelivery>;
	    readonly type: Promise<sageX3MasterData.enums.DiscountCalculationRules | null>;
	    readonly invoicingElement: Promise<integer | null>;
	}
	//# sourceMappingURL=sales-delivery-discount-or-charge-calculation-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-dimensions.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDelivery>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=sales-delivery-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-customer-statistical-groups.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-customer-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryCustomerStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDelivery>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=sales-delivery-customer-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-bill-to-customer-company-names.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-bill-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryBillToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDelivery>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=sales-delivery-bill-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/sales-delivery-bill-to-customer-address-lines.d.ts
declare module '@sage/x3-sales/lib/nodes/sales-delivery-bill-to-customer-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class SalesDeliveryBillToCustomerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Sales.nodes.SalesDelivery>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=sales-delivery-bill-to-customer-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/nodes/index.d.ts
declare module '@sage/x3-sales/lib/nodes/index' {
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-bill-to-customer-address-lines';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-bill-to-customer-company-names';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-customer-statistical-groups';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-dimensions';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-discount-or-charge-calculation-rules';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-invoicing-elements';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-line-distributed-invoicing-elements';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-line-product-statistical-groups';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-line-taxes';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-line';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-sales-reps';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-ship-to-customer-address-lines';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery-ship-to-customer-company-names';
	export * from '@sage/x3-sales/lib/nodes/sales-delivery';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-bill-to-customer-company-names';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-customer-statistical-groups';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-discount-or-charge-calculation-rules';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-invoicing-elements';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-line-distributed-invoicing-elements';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-line-product-statistical-groups';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-line-tax-basis-amounts';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-line-taxes';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-line';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-sales-order-of-prepayments';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-sales-reps';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-ship-to-customer-address-lines';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice-ship-to-customer-company-names';
	export * from '@sage/x3-sales/lib/nodes/sales-invoice';
	export * from '@sage/x3-sales/lib/nodes/sales-order-bill-to-customer-address-lines';
	export * from '@sage/x3-sales/lib/nodes/sales-order-bill-to-customer-company-names';
	export * from '@sage/x3-sales/lib/nodes/sales-order-customer-statistical-groups';
	export * from '@sage/x3-sales/lib/nodes/sales-order-dimensions';
	export * from '@sage/x3-sales/lib/nodes/sales-order-discount-or-charge-calculation-rules';
	export * from '@sage/x3-sales/lib/nodes/sales-order-invoicing-elements';
	export * from '@sage/x3-sales/lib/nodes/sales-order-line-dimension-dimensions';
	export * from '@sage/x3-sales/lib/nodes/sales-order-line-dimension';
	export * from '@sage/x3-sales/lib/nodes/sales-order-line-product-statistical-groups';
	export * from '@sage/x3-sales/lib/nodes/sales-order-line-taxes';
	export * from '@sage/x3-sales/lib/nodes/sales-order-line';
	export * from '@sage/x3-sales/lib/nodes/sales-order-quantity-line-distributed-invoicing-elements';
	export * from '@sage/x3-sales/lib/nodes/sales-order-quantity-line';
	export * from '@sage/x3-sales/lib/nodes/sales-order-sales-reps';
	export * from '@sage/x3-sales/lib/nodes/sales-order-ship-to-customer-address-lines';
	export * from '@sage/x3-sales/lib/nodes/sales-order-ship-to-customer-company-names';
	export * from '@sage/x3-sales/lib/nodes/sales-order-sold-to-customer-address-lines';
	export * from '@sage/x3-sales/lib/nodes/sales-order-sold-to-customer-company-names';
	export * from '@sage/x3-sales/lib/nodes/sales-order';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-dimensions';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-discount-or-charge-calculation-rules';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-invoicing-elements';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-line-distributed-invoicing-elements';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-line-taxes';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-line';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-sales-reps';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-ship-to-customer-address-lines';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-ship-to-customer-company-names';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-sold-to-customer-address-lines';
	export * from '@sage/x3-sales/lib/nodes/sales-quote-sold-to-customer-company-names';
	export * from '@sage/x3-sales/lib/nodes/sales-quote';
	export * from '@sage/x3-sales/lib/nodes/sales-return-dimensions';
	export * from '@sage/x3-sales/lib/nodes/sales-return-line';
	export * from '@sage/x3-sales/lib/nodes/sales-return-ship-to-customer-address-lines';
	export * from '@sage/x3-sales/lib/nodes/sales-return-ship-to-customer-company-names';
	export * from '@sage/x3-sales/lib/nodes/sales-return';
	export * from '@sage/x3-sales/lib/nodes/service-contract-template';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/node-extensions/product-extension.d.ts
declare module '@sage/x3-sales/lib/node-extensions/product-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class ProductExtension extends NodeExtension<sageX3MasterData.nodes.Product> {
	    readonly loanContract: Reference<sageX3Sales.nodes.ServiceContractTemplate | null>;
	    readonly warrantyContract: Reference<sageX3Sales.nodes.ServiceContractTemplate | null>;
	    readonly serviceContract: Reference<sageX3Sales.nodes.ServiceContractTemplate | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product' {
	    interface Product extends ProductExtension {
	    }
	}
	//# sourceMappingURL=product-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/node-extensions/product-category-extension.d.ts
declare module '@sage/x3-sales/lib/node-extensions/product-category-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	import { NodeExtension } from '@sage/xtrem-core';
	export class ProductCategoryExtension extends NodeExtension<sageX3MasterData.nodes.ProductCategory> {
	    readonly productType: Promise<sageX3Sales.enums.SalesProductType | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product-category' {
	    interface ProductCategory extends ProductCategoryExtension {
	    }
	}
	//# sourceMappingURL=product-category-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-sales/lib/node-extensions/index' {
	export * from '@sage/x3-sales/lib/node-extensions/customer-extension';
	export * from '@sage/x3-sales/lib/node-extensions/product-category-extension';
	export * from '@sage/x3-sales/lib/node-extensions/product-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/node-extensions/customer-extension.d.ts
declare module '@sage/x3-sales/lib/node-extensions/customer-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3Sales from '@sage/x3-sales/lib/index';
	export class CustomerExtension extends NodeExtension<sageX3MasterData.nodes.Customer> {
	    readonly customerType: Promise<sageX3SalesData.enums.CustomerType | null>;
	    readonly freightInvoicing: Promise<sageX3SalesData.enums.FreightInvoicing | null>;
	    readonly openItemStatementFrequency: Promise<sageX3SalesData.enums.StatementPeriod | null>;
	    readonly invoicePeriod: Promise<sageX3SalesData.enums.InvoicingFrequency | null>;
	    readonly dueDateOrigin: Promise<sageX3SalesData.enums.DueDateCalculationSource | null>;
	    readonly partialDelivery: Promise<sageX3SalesData.enums.PartialDelivery | null>;
	    readonly invoicingMode: Promise<sageX3SalesData.enums.InvoicingMode | null>;
	    readonly serviceContract: Reference<sageX3Sales.nodes.ServiceContractTemplate | null>;
	    readonly lastContactType: Promise<sageX3Sales.enums.SalesContactType | null>;
	    readonly nextContactType: Promise<sageX3Sales.enums.SalesContactType | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/customer' {
	    interface Customer extends CustomerExtension {
	    }
	}
	//# sourceMappingURL=customer-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/enums/sales-product-type.d.ts
declare module '@sage/x3-sales/lib/enums/sales-product-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesProductTypeEnum {
	    normal = 1,
	    flexibleKit = 2,
	    fixedKit = 3
	}
	export interface SalesProductType$EnumInterface {
	    normal: 1;
	    flexibleKit: 2;
	    fixedKit: 3;
	}
	export type SalesProductType = keyof SalesProductType$EnumInterface;
	export const salesProductTypeDatatype: X3EnumDataType<keyof SalesProductType$EnumInterface, unknown>;
	//# sourceMappingURL=sales-product-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/enums/sales-invoice-status.d.ts
declare module '@sage/x3-sales/lib/enums/sales-invoice-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesInvoiceStatusEnum {
	    notInvoiced = 1,
	    partlyInvoiced = 2,
	    invoiced = 3
	}
	export interface SalesInvoiceStatus$EnumInterface {
	    notInvoiced: 1;
	    partlyInvoiced: 2;
	    invoiced: 3;
	}
	export type SalesInvoiceStatus = keyof SalesInvoiceStatus$EnumInterface;
	export const salesInvoiceStatusDatatype: X3EnumDataType<keyof SalesInvoiceStatus$EnumInterface, unknown>;
	//# sourceMappingURL=sales-invoice-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/enums/sales-invoice-source.d.ts
declare module '@sage/x3-sales/lib/enums/sales-invoice-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesInvoiceSourceEnum {
	    direct = 1,
	    order = 2,
	    shipment = 3,
	    invoice = 4,
	    quote = 5,
	    return = 6,
	    serviceContract = 7,
	    serviceRequest = 8,
	    transfer = 9,
	    scheduledInvoice = 10
	}
	export interface SalesInvoiceSource$EnumInterface {
	    direct: 1;
	    order: 2;
	    shipment: 3;
	    invoice: 4;
	    quote: 5;
	    return: 6;
	    serviceContract: 7;
	    serviceRequest: 8;
	    transfer: 9;
	    scheduledInvoice: 10;
	}
	export type SalesInvoiceSource = keyof SalesInvoiceSource$EnumInterface;
	export const salesInvoiceSourceDatatype: X3EnumDataType<keyof SalesInvoiceSource$EnumInterface, unknown>;
	//# sourceMappingURL=sales-invoice-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/enums/sales-delivery-status.d.ts
declare module '@sage/x3-sales/lib/enums/sales-delivery-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesDeliveryStatusEnum {
	    notDelivered = 1,
	    partlyDelivered = 2,
	    delivered = 3
	}
	export interface SalesDeliveryStatus$EnumInterface {
	    notDelivered: 1;
	    partlyDelivered: 2;
	    delivered: 3;
	}
	export type SalesDeliveryStatus = keyof SalesDeliveryStatus$EnumInterface;
	export const salesDeliveryStatusDatatype: X3EnumDataType<keyof SalesDeliveryStatus$EnumInterface, unknown>;
	//# sourceMappingURL=sales-delivery-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/enums/sales-contact-type.d.ts
declare module '@sage/x3-sales/lib/enums/sales-contact-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesContactTypeEnum {
	    none = 1,
	    phone = 2,
	    appointment = 3,
	    email = 4,
	    mail = 5,
	    massMailing = 6
	}
	export interface SalesContactType$EnumInterface {
	    none: 1;
	    phone: 2;
	    appointment: 3;
	    email: 4;
	    mail: 5;
	    massMailing: 6;
	}
	export type SalesContactType = keyof SalesContactType$EnumInterface;
	export const salesContactTypeDatatype: X3EnumDataType<keyof SalesContactType$EnumInterface, unknown>;
	//# sourceMappingURL=sales-contact-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales/build/lib/enums/index.d.ts
declare module '@sage/x3-sales/lib/enums/index' {
	export * from '@sage/x3-sales/lib/enums/sales-contact-type';
	export * from '@sage/x3-sales/lib/enums/sales-delivery-status';
	export * from '@sage/x3-sales/lib/enums/sales-invoice-source';
	export * from '@sage/x3-sales/lib/enums/sales-invoice-status';
	export * from '@sage/x3-sales/lib/enums/sales-product-type';
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/x3-sales' {
	export * from '@sage/x3-sales/index';
}
