import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, integer, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesReturn extends Node {
    readonly id: Promise<string>;
    readonly receivingSite: Reference<sageX3System.nodes.Site>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly expirationDate: Promise<date | null>;
    readonly authorizedUser: Reference<sageX3System.nodes.User | null>;
    readonly expectedReturnDate: Promise<date | null>;
    readonly returnDate: Promise<date | null>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly shipToCustomerPostalCode: Promise<string>;
    readonly shipToCustomerCity: Promise<string>;
    readonly shipToCustomerState: Promise<string>;
    readonly shipToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly shipToCustomerCountryName: Promise<string>;
    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly deliveryDate: Promise<date | null>;
    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly salesSite: Reference<sageX3System.nodes.Site | null>;
    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
    readonly intrastatTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
    readonly intrastatStatisticalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly intrastatTransportMode: Promise<sageX3MasterData.enums.IntrastatTransportMode | null>;
    readonly intrastatProcessingNumber: Promise<integer | null>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly incotermTown: Promise<string>;
    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly billToCustomerEuropeanUnionVatNumber: Promise<string>;
    readonly loanReturn: Promise<boolean>;
    readonly subcontractMaterialReturn: Promise<boolean>;
    readonly loanSalesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
    readonly returnHeaderTextKey: Promise<string>;
    readonly returnFooterTextKey: Promise<string>;
    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly language: Reference<sageX3System.nodes.Language | null>;
    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
    readonly dockLocation: Reference<sageX3StockData.nodes.Location | null>;
    readonly isIntersite: Promise<boolean>;
    readonly isIntercompany: Promise<boolean>;
    readonly sourceSite: Reference<sageX3System.nodes.Site | null>;
    readonly priceStructure: Reference<sageX3InvoicingData.nodes.PriceStructure | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly returnType: Reference<sageX3SalesData.nodes.SalesReturnType | null>;
    readonly returnNumber: Reference<sageX3Sales.nodes.SalesReturn | null>;
    readonly category: Promise<sageX3SalesData.enums.ReturnCategory | null>;
    readonly arrivalDate: Promise<date | null>;
    readonly departureDate: Promise<date | null>;
    readonly departureTime: Promise<string>;
    readonly arrivalTime: Promise<string>;
    readonly vehicleLicensePlate: Promise<string>;
    readonly trailerLicensePlate: Promise<string>;
    readonly salesReturnLines: Collection<sageX3Sales.nodes.SalesReturnLine>;
    readonly returnHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly returnFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly returnFooterText: Promise<TextStream>;
    readonly returnHeaderText: Promise<TextStream>;
    readonly dimensions: Collection<sageX3Sales.nodes.SalesReturnDimensions>;
    readonly shipToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesReturnShipToCustomerAddressLines>;
    readonly shipToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesReturnShipToCustomerCompanyNames>;
}
//# sourceMappingURL=sales-return.d.ts.map