import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, date, TextStream } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesReturnLine extends Node {
    readonly salesReturn: Reference<sageX3Sales.nodes.SalesReturn>;
    readonly lineNumber: Promise<integer | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly productDescriptionInUserLanguage: Promise<string>;
    readonly productDescriptionInCustomerLanguage: Promise<string>;
    readonly salesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
    readonly salesDeliveryLineNumber: Reference<sageX3Sales.nodes.SalesDeliveryLine | null>;
    readonly quantityInSalesUnitDelivered: Promise<decimal | null>;
    readonly expectedReturnQuantity: Promise<decimal | null>;
    readonly expectedReturnQuantityInStockUnit: Promise<decimal | null>;
    readonly quantityInSalesUnitReturned: Promise<decimal | null>;
    readonly quantityInStockUnitReturned: Promise<decimal | null>;
    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly netPrice: Promise<decimal | null>;
    readonly netPriceExcludingTax: Promise<decimal | null>;
    readonly netPriceIncludingTax: Promise<decimal | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
    readonly returnReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly returnDate: Promise<date | null>;
    readonly actualStockReturn: Promise<boolean>;
    readonly returnDeductedFromTheInvoice: Promise<boolean>;
    readonly isToBeLinkedToCreditMemo: Promise<boolean>;
    readonly reactivatedOrder: Promise<boolean>;
    readonly creditMemo: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly creditMemoLineNumber: Reference<sageX3Sales.nodes.SalesInvoiceLine | null>;
    readonly creditMemoToBeIssued: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly creditMemoLineNumberToBeIssued: Reference<sageX3Sales.nodes.SalesInvoiceLine | null>;
    readonly reversalDocumentDate: Promise<date | null>;
    readonly receivingSite: Reference<sageX3System.nodes.Site>;
    readonly returnLineTextKey: Promise<string>;
    readonly orderPrice: Promise<decimal | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly category: Promise<sageX3SalesData.enums.ReturnCategory | null>;
    readonly returnLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly returnLineText: Promise<TextStream>;
}
//# sourceMappingURL=sales-return-line.d.ts.map