import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, integer, decimal, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesQuote extends Node {
    readonly id: Promise<string>;
    readonly quoteType: Reference<sageX3SalesData.nodes.SalesQuoteType>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly salesSite: Reference<sageX3System.nodes.Site>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly customerQuoteReference: Promise<string>;
    readonly quoteDate: Promise<date>;
    readonly validityDate: Promise<date | null>;
    readonly deliveryLeadTime: Promise<integer | null>;
    readonly salesOrderType: Reference<sageX3SalesData.nodes.SalesOrderType | null>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly soldToCustomerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly soldToCustomerPostalCode: Promise<string>;
    readonly soldToCustomerCity: Promise<string>;
    readonly soldToCustomerState: Promise<string>;
    readonly soldToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly soldToCustomerCountryName: Promise<string>;
    readonly soldToCustomerContact: Reference<sageX3MasterData.nodes.BusinessPartnerContact | null>;
    readonly shipToCustomerPostalCode: Promise<string>;
    readonly shipToCustomerCity: Promise<string>;
    readonly shipToCustomerState: Promise<string>;
    readonly shipToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly shipToCustomerCountryName: Promise<string>;
    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.BusinessPartnerContact | null>;
    readonly billToCustomerEuropeanUnionVatNumber: Promise<string>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly currencyRateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly currencyRate: Promise<decimal | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly soldToCustomerLanguage: Reference<sageX3System.nodes.Language | null>;
    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
    readonly entityUseCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly shippingSite: Reference<sageX3System.nodes.Site>;
    readonly priceIncludingOrExcludingTax: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly linesAmountExcludingTax: Promise<decimal | null>;
    readonly linesAmountIncludingTax: Promise<decimal | null>;
    readonly linesAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly linesAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountExcludingTax: Promise<decimal | null>;
    readonly totalAmountIncludingTax: Promise<decimal | null>;
    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalMargin: Promise<decimal | null>;
    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
    readonly probabilityPercentage: Promise<integer | null>;
    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder | null>;
    readonly orderDate: Promise<date | null>;
    readonly numberOfOrders: Promise<integer | null>;
    readonly numberOfValidatedLines: Promise<integer | null>;
    readonly numberOfLines: Promise<integer | null>;
    readonly quoteStatus: Promise<sageX3SalesData.enums.QuoteStatus | null>;
    readonly signatureStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
    readonly isQuotePrinted: Promise<boolean>;
    readonly numberOfQuoteCopies: Promise<integer | null>;
    readonly quoteHeaderTextKey: Promise<string>;
    readonly quoteFooterTextKey: Promise<string>;
    readonly salesProforma: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly incotermTown: Promise<string>;
    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly geographicCode: Promise<string>;
    readonly insideCityLimits: Promise<string>;
    readonly vertexTransactionType: Promise<string>;
    readonly taxAmount: Promise<decimal | null>;
    readonly taxableAmount: Promise<decimal | null>;
    readonly priceStructure: Reference<sageX3InvoicingData.nodes.PriceStructure | null>;
    readonly totalQuantityDistributedOnLines: Promise<decimal | null>;
    readonly totalWeightDistributedOnLines: Promise<decimal | null>;
    readonly totalVolumeDistributedOnLines: Promise<decimal | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly isValidatedAddress: Promise<boolean>;
    readonly revisionNumber: Promise<integer | null>;
    readonly hasElectronicSignature: Promise<boolean>;
    readonly finalNumber: Promise<string>;
    readonly validationDate: Promise<date | null>;
    readonly salesQuoteLines: Collection<sageX3Sales.nodes.SalesQuoteLine>;
    readonly quoteHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly quoteFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly quoteFooterText: Promise<TextStream>;
    readonly quoteHeaderText: Promise<TextStream>;
    readonly dimensions: Collection<sageX3Sales.nodes.SalesQuoteDimensions>;
    readonly discountOrChargeCalculationRules: Collection<sageX3Sales.nodes.SalesQuoteDiscountOrChargeCalculationRules>;
    readonly invoicingElements: Collection<sageX3Sales.nodes.SalesQuoteInvoicingElements>;
    readonly salesReps: Collection<sageX3Sales.nodes.SalesQuoteSalesReps>;
    readonly shipToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesQuoteShipToCustomerAddressLines>;
    readonly shipToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesQuoteShipToCustomerCompanyNames>;
    readonly soldToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesQuoteSoldToCustomerAddressLines>;
    readonly soldToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesQuoteSoldToCustomerCompanyNames>;
}
//# sourceMappingURL=sales-quote.d.ts.map