import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, TextStream, Collection } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesQuoteLine extends Node {
    readonly salesQuote: Reference<sageX3Sales.nodes.SalesQuote>;
    readonly lineNumber: Promise<integer | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly salesSite: Reference<sageX3System.nodes.Site>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly quoteDate: Promise<date>;
    readonly deliveryLeadTime: Promise<integer | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorProductVersion: Reference<sageX3MasterData.nodes.ProductVersion | null>;
    readonly productDescriptionInUserLanguage: Promise<string>;
    readonly productDescriptionInCustomerLanguage: Promise<string>;
    readonly salesRep1: Reference<sageX3MasterData.nodes.SalesRep | null>;
    readonly salesRep1CommissionRate: Promise<decimal | null>;
    readonly salesRep2: Reference<sageX3MasterData.nodes.SalesRep | null>;
    readonly salesRep2CommissionRate: Promise<decimal | null>;
    readonly salesRepCommissionFactor: Promise<decimal | null>;
    readonly grossPrice: Promise<decimal | null>;
    readonly priceReason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly netPrice: Promise<decimal | null>;
    readonly margin: Promise<decimal | null>;
    readonly netPriceExcludingTax: Promise<decimal | null>;
    readonly netPriceIncludingTax: Promise<decimal | null>;
    readonly costPrice: Promise<decimal | null>;
    readonly discountOrCharge1: Promise<decimal | null>;
    readonly discountOrCharge2: Promise<decimal | null>;
    readonly discountOrCharge3: Promise<decimal | null>;
    readonly discountOrCharge4: Promise<decimal | null>;
    readonly discountOrCharge5: Promise<decimal | null>;
    readonly discountOrCharge6: Promise<decimal | null>;
    readonly discountOrCharge7: Promise<decimal | null>;
    readonly discountOrCharge8: Promise<decimal | null>;
    readonly discountOrCharge9: Promise<decimal | null>;
    readonly discountOrCharge1Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge2Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge3Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge4Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge5Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge6Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge7Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge8Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge9Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly calculatedTaxableBase1: Promise<decimal | null>;
    readonly calculatedTaxableBase2: Promise<decimal | null>;
    readonly isLineWithDistributedInvoicingElement: Promise<boolean>;
    readonly quoteQuantity: Promise<decimal>;
    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly shippingSite: Reference<sageX3System.nodes.Site>;
    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly lineType: Promise<sageX3SalesData.enums.LineType | null>;
    readonly freeProduct: Promise<sageX3SalesData.enums.Free | null>;
    readonly freeProductLineSource: Promise<integer | null>;
    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder | null>;
    readonly salesOrderLine: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
    readonly isOrdered: Promise<boolean>;
    readonly orderedQuantity: Promise<decimal | null>;
    readonly quoteLineTextKey: Promise<string>;
    readonly geographicCode: Promise<string>;
    readonly insideCityLimits: Promise<string>;
    readonly isTaxedGeographically: Promise<string>;
    readonly isTaxable: Promise<boolean>;
    readonly isRecordedTax: Promise<boolean>;
    readonly taxRate: Promise<decimal | null>;
    readonly taxableAmount: Promise<decimal | null>;
    readonly isComponentPrintedOnAcknowledgement: Promise<boolean>;
    readonly isComponentPrintedOnPackingSlip: Promise<boolean>;
    readonly isComponentPrintedOnInvoice: Promise<boolean>;
    readonly weightDistributedOnLine: Promise<decimal | null>;
    readonly volumeDistributedOnLine: Promise<decimal | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly importLineNumber: Promise<integer | null>;
    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly isDeliverable: Promise<boolean>;
    readonly lineRevisionNumber: Promise<integer | null>;
    readonly quoteLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly quoteLineText: Promise<TextStream>;
    readonly distributedInvoicingElements: Collection<sageX3Sales.nodes.SalesQuoteLineDistributedInvoicingElements>;
    readonly taxes: Collection<sageX3Sales.nodes.SalesQuoteLineTaxes>;
}
//# sourceMappingURL=sales-quote-line.d.ts.map