"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesQuoteLineDistributedInvoicingElements = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'SFL'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            salesQuote: 'salesQuote',
            lineNumber: 'lineNumber',
        },
        distributedLineInvoicingElementNumber: {
            code: 'distributedLineInvoicingElementNumber',
        },
    },
};
let SalesQuoteLineDistributedInvoicingElements = class SalesQuoteLineDistributedInvoicingElements extends xtrem_core_1.Node {
};
exports.SalesQuoteLineDistributedInvoicingElements = SalesQuoteLineDistributedInvoicingElements;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], SalesQuoteLineDistributedInvoicingElements.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'SQHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuoteLineDistributedInvoicingElements.prototype, "salesQuote", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SQDLIN',
    })
], SalesQuoteLineDistributedInvoicingElements.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesQuoteLine,
    })
], SalesQuoteLineDistributedInvoicingElements.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTANUM',
        columnType: 'integer',
        node: () => sageX3InvoicingData.nodes.SalesInvoicingElement,
    })
], SalesQuoteLineDistributedInvoicingElements.prototype, "distributedLineInvoicingElementNumber", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTANOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLineDistributedInvoicingElements.prototype, "distributedLineInvoicingElementAmount", void 0);
exports.SalesQuoteLineDistributedInvoicingElements = SalesQuoteLineDistributedInvoicingElements = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SQUOTED',
        keyPropertyNames: ['denormalizedIndex', 'salesQuote', 'lineNumber'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], SalesQuoteLineDistributedInvoicingElements);
//# sourceMappingURL=sales-quote-line-distributed-invoicing-elements.js.map