"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesQuoteDimensions = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'ANA'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            id: 'id',
        },
        dimensionType: {
            dimensionType: 'dimensionType',
        },
        dimension: {
            dimensionType: 'dimensionType',
            dimension: 'dimension',
        },
    },
};
let SalesQuoteDimensions = class SalesQuoteDimensions extends xtrem_core_1.Node {
};
exports.SalesQuoteDimensions = SalesQuoteDimensions;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], SalesQuoteDimensions.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'SQHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuoteDimensions.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesQuote,
    })
], SalesQuoteDimensions.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.DimensionType,
    })
], SalesQuoteDimensions.prototype, "dimensionType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CCE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Dimension,
    })
], SalesQuoteDimensions.prototype, "dimension", void 0);
exports.SalesQuoteDimensions = SalesQuoteDimensions = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SQUOTE',
        keyPropertyNames: ['denormalizedIndex', 'id'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], SalesQuoteDimensions);
//# sourceMappingURL=sales-quote-dimensions.js.map