"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesOrderLineProductStatisticalGroups = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'STI'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            salesOrder: 'salesOrder',
            lineNumber: 'lineNumber',
            sequenceNumber: 'sequenceNumber',
        },
        value: {
            async glossaryId() {
                return typesLib.add(typesLib.sub((await this.denormalizedIndex), 1), 20);
            },
            code: 'value',
        },
    },
};
let SalesOrderLineProductStatisticalGroups = class SalesOrderLineProductStatisticalGroups extends xtrem_core_1.Node {
};
exports.SalesOrderLineProductStatisticalGroups = SalesOrderLineProductStatisticalGroups;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], SalesOrderLineProductStatisticalGroups.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'SOHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLineProductStatisticalGroups.prototype, "salesOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOPLIN',
    })
], SalesOrderLineProductStatisticalGroups.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOPSEQ',
    })
], SalesOrderLineProductStatisticalGroups.prototype, "sequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesOrderLine,
    })
], SalesOrderLineProductStatisticalGroups.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TSICOD',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesOrderLineProductStatisticalGroups.prototype, "value", void 0);
exports.SalesOrderLineProductStatisticalGroups = SalesOrderLineProductStatisticalGroups = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SORDERP',
        keyPropertyNames: ['denormalizedIndex', 'salesOrder', 'lineNumber', 'sequenceNumber'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], SalesOrderLineProductStatisticalGroups);
//# sourceMappingURL=sales-order-line-product-statistical-groups.js.map