"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesOrderLineDimension = void 0;
const sageX3StockData = require("@sage/x3-stock-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const joins = {
    referenceJoins: {
        salesOrder: {
            id: 'salesOrder',
        },
        salesOrderLine: {
            salesOrder: 'salesOrder',
            lineNumber: 'salesOrderLine',
            sequenceNumber: 'sequenceNumber',
        },
    },
};
let SalesOrderLineDimension = class SalesOrderLineDimension extends xtrem_core_1.Node {
};
exports.SalesOrderLineDimension = SalesOrderLineDimension;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        isNotEmpty: true,
        columnName: 'ABRFIC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLineDimension.prototype, "abbreviation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYP',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], SalesOrderLineDimension.prototype, "typ", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesOrder,
    })
], SalesOrderLineDimension.prototype, "salesOrder", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRLIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesOrderLine,
    })
], SalesOrderLineDimension.prototype, "salesOrderLine", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isStored: true,
        isNullable: true,
        columnName: 'VCRSEQ',
    })
], SalesOrderLineDimension.prototype, "sequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'CPLCLE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLineDimension.prototype, "keyComplement", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isStored: true,
        isNullable: true,
        columnName: 'ANALIG',
    })
], SalesOrderLineDimension.prototype, "sortValue", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderLineDimensionDimensions,
    })
], SalesOrderLineDimension.prototype, "dimensions", void 0);
exports.SalesOrderLineDimension = SalesOrderLineDimension = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CPTANALIN',
        keyPropertyNames: [
            'abbreviation',
            'typ',
            'salesOrder',
            'salesOrderLine',
            'sequenceNumber',
            'keyComplement',
            'sortValue',
        ],
        indexes: [
            {
                orderBy: {
                    abbreviation: 1,
                    typ: 1,
                    salesOrder: 1,
                    salesOrderLine: 1,
                    sequenceNumber: 1,
                    keyComplement: 1,
                    sortValue: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['typ', 'salesOrderLine', 'sequenceNumber', 'keyComplement', 'sortValue'],
        }),
        getFilters() {
            return [{ _and: [{ abbreviation: 'SOP' }, { typ: null }] }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SalesOrderLineDimension);
//# sourceMappingURL=sales-order-line-dimension.js.map