"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesOrderLineDimensionDimensions = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3StockData = require("@sage/x3-stock-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'ANA'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            abbreviation: 'abbreviation',
            typ: 'typ',
            salesOrder: 'salesOrder',
            salesOrderLine: 'salesOrderLine',
            sequenceNumber: 'sequenceNumber',
            keyComplement: 'keyComplement',
            sortValue: 'sortValue',
        },
        dimensionType: {
            dimensionType: 'dimensionType',
        },
        dimension: {
            dimensionType: 'dimensionType',
            dimension: 'dimension',
        },
    },
};
let SalesOrderLineDimensionDimensions = class SalesOrderLineDimensionDimensions extends xtrem_core_1.Node {
};
exports.SalesOrderLineDimensionDimensions = SalesOrderLineDimensionDimensions;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], SalesOrderLineDimensionDimensions.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        isNotEmpty: true,
        columnName: 'ABRFIC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLineDimensionDimensions.prototype, "abbreviation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isStored: true,
        columnName: 'VCRTYP',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], SalesOrderLineDimensionDimensions.prototype, "typ", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'VCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLineDimensionDimensions.prototype, "salesOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRLIN',
    })
], SalesOrderLineDimensionDimensions.prototype, "salesOrderLine", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isStored: true,
        columnName: 'VCRSEQ',
    })
], SalesOrderLineDimensionDimensions.prototype, "sequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        isNotEmpty: true,
        columnName: 'CPLCLE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLineDimensionDimensions.prototype, "keyComplement", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isStored: true,
        columnName: 'ANALIG',
    })
], SalesOrderLineDimensionDimensions.prototype, "sortValue", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesOrderLineDimension,
    })
], SalesOrderLineDimensionDimensions.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.DimensionType,
    })
], SalesOrderLineDimensionDimensions.prototype, "dimensionType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CCE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Dimension,
    })
], SalesOrderLineDimensionDimensions.prototype, "dimension", void 0);
exports.SalesOrderLineDimensionDimensions = SalesOrderLineDimensionDimensions = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CPTANALIN',
        keyPropertyNames: [
            'denormalizedIndex',
            'abbreviation',
            'typ',
            'salesOrder',
            'salesOrderLine',
            'sequenceNumber',
            'keyComplement',
            'sortValue',
        ],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], SalesOrderLineDimensionDimensions);
//# sourceMappingURL=sales-order-line-dimension-dimensions.js.map