"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesInvoiceSalesOrderOfPrepayments = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const denormalized = { maxRepeat: 4 };
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            id: 'id',
        },
        paymentMethodOfPrepayments: {
            code: 'paymentMethodOfPrepayments',
            async legislation() {
                return (await (await (await this._denormalizedParent).company).legislation)?.code;
            },
        },
        salesOrderLineNumberOfPrepayment: {
            documentType() {
                return '*SO';
            },
            documentNumber: 'salesOrderOfPrepayment',
            lineNumber() {
                return 1;
            },
            openItemLineNumber: 'salesOrderLineNumberOfPrepayment',
        },
    },
};
let SalesInvoiceSalesOrderOfPrepayments = class SalesInvoiceSalesOrderOfPrepayments extends xtrem_core_1.Node {
};
exports.SalesInvoiceSalesOrderOfPrepayments = SalesInvoiceSalesOrderOfPrepayments;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], SalesInvoiceSalesOrderOfPrepayments.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'NUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoiceSalesOrderOfPrepayments.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesInvoice,
    })
], SalesInvoiceSalesOrderOfPrepayments.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAM',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.PaymentMethod,
    })
], SalesInvoiceSalesOrderOfPrepayments.prototype, "paymentMethodOfPrepayments", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INSATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceSalesOrderOfPrepayments.prototype, "prepaymentAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INSORDNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoiceSalesOrderOfPrepayments.prototype, "salesOrderOfPrepayment", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INSLIN',
        columnType: 'integer',
        filters: {
            lookup: {
                documentType: '*SO',
                lineNumber: 1,
            },
            control: {
                documentType: '*SO',
                lineNumber: 1,
            },
        },
        node: () => sageX3FinanceData.nodes.OpenItem,
    })
], SalesInvoiceSalesOrderOfPrepayments.prototype, "salesOrderLineNumberOfPrepayment", void 0);
exports.SalesInvoiceSalesOrderOfPrepayments = SalesInvoiceSalesOrderOfPrepayments = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SINVOICEV',
        keyPropertyNames: ['denormalizedIndex', 'id'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], SalesInvoiceSalesOrderOfPrepayments);
//# sourceMappingURL=sales-invoice-sales-order-of-prepayments.js.map