import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, date, TextStream, Collection } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesInvoiceLine extends Node {
    readonly salesInvoice: Reference<sageX3Sales.nodes.SalesInvoice>;
    readonly lineNumber: Promise<integer | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly salesOrderNumber: Reference<sageX3Sales.nodes.SalesOrder | null>;
    readonly salesOrderLineNumber: Promise<integer | null>;
    readonly salesOrderLine: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
    readonly salesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
    readonly salesDeliveryLine: Reference<sageX3Sales.nodes.SalesDeliveryLine | null>;
    readonly sourceSalesInvoice: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly sourceSalesInvoiceLine: Reference<sageX3Sales.nodes.SalesInvoiceLine | null>;
    readonly salesReturn: Reference<sageX3Sales.nodes.SalesReturn | null>;
    readonly salesReturnLine: Reference<sageX3Sales.nodes.SalesReturnLine | null>;
    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorProductVersion: Promise<string>;
    readonly productDescriptionInUserLanguage: Promise<string>;
    readonly productDescriptionInCustomerLanguage: Promise<string>;
    readonly salesRep1: Reference<sageX3MasterData.nodes.SalesRep | null>;
    readonly salesRep2: Reference<sageX3MasterData.nodes.SalesRep | null>;
    readonly salesRep1CommissionRate: Promise<decimal | null>;
    readonly salesRep2CommissionRate: Promise<decimal | null>;
    readonly salesRep1CommissionBase: Promise<decimal | null>;
    readonly salesRep2CommissionBase: Promise<decimal | null>;
    readonly salesRep1CommissionAmount: Promise<decimal | null>;
    readonly salesRep2CommissionAmount: Promise<decimal | null>;
    readonly salesRepCommissionFactor: Promise<decimal | null>;
    readonly grossPrice: Promise<decimal | null>;
    readonly priceReason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly netPrice: Promise<decimal | null>;
    readonly netPriceExcludingTax: Promise<decimal | null>;
    readonly netPriceIncludingTax: Promise<decimal | null>;
    readonly margin: Promise<decimal | null>;
    readonly costPrice: Promise<decimal | null>;
    readonly discountOrCharge1: Promise<decimal | null>;
    readonly discountOrCharge2: Promise<decimal | null>;
    readonly discountOrCharge3: Promise<decimal | null>;
    readonly discountOrCharge4: Promise<decimal | null>;
    readonly discountOrCharge5: Promise<decimal | null>;
    readonly discountOrCharge6: Promise<decimal | null>;
    readonly discountOrCharge7: Promise<decimal | null>;
    readonly discountOrCharge8: Promise<decimal | null>;
    readonly discountOrCharge9: Promise<decimal | null>;
    readonly discountOrCharge1Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge2Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge3Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge4Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge5Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge6Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge7Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge8Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge9Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly lineAmountEnteredManually: Promise<decimal | null>;
    readonly lineAmountExcludingTax: Promise<decimal | null>;
    readonly discountLineAmount: Promise<decimal | null>;
    readonly calculatedTaxableBase1: Promise<decimal | null>;
    readonly calculatedTaxableBase2: Promise<decimal | null>;
    readonly taxRate: Promise<decimal | null>;
    readonly lineAmountIncludingTax: Promise<decimal | null>;
    readonly isLineWithDistributedInvoicingElement: Promise<boolean>;
    readonly quantityInSalesUnitInvoiced: Promise<decimal>;
    readonly quantityInStockUnitInvoiced: Promise<decimal>;
    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
    readonly productStockManagement: Promise<sageX3MasterData.enums.StockManagement | null>;
    readonly exclusiveLotFilter: Promise<string>;
    readonly exclusiveStockStatusFilter: Promise<string>;
    readonly preferentialStockLocationFilter: Reference<sageX3StockData.nodes.Location | null>;
    readonly stockPriceInCreditMemoWithStockMovement: Promise<decimal | null>;
    readonly allocationType: Promise<sageX3MasterData.enums.TypeOfAllocation | null>;
    readonly salesSite: Reference<sageX3System.nodes.Site>;
    readonly invoiceDate: Promise<date>;
    readonly lineType: Promise<sageX3SalesData.enums.LineType | null>;
    readonly freeProduct: Promise<sageX3SalesData.enums.Free | null>;
    readonly freeProductLineSource: Reference<sageX3Sales.nodes.SalesInvoiceLine | null>;
    readonly invoiceLineTextKey: Promise<string>;
    readonly isExtractedIntrastatLine: Promise<boolean>;
    readonly isIntrastatPhysicalFlow: Promise<boolean>;
    readonly geographicCode: Promise<string>;
    readonly insideCityLimits: Promise<string>;
    readonly isTaxedGeographically: Promise<string>;
    readonly isTaxable: Promise<boolean>;
    readonly isRecordedTax: Promise<boolean>;
    readonly isPrintedOnInvoice: Promise<boolean>;
    readonly serviceStartDate: Promise<date | null>;
    readonly serviceEndDate: Promise<date | null>;
    readonly servicePeriodNumber: Promise<integer | null>;
    readonly servicePeriodType: Promise<sageX3InvoicingData.enums.PeriodicityType | null>;
    readonly tokenManagement: Promise<decimal | null>;
    readonly weightDistributedOnLine: Promise<decimal | null>;
    readonly volumeDistributedOnLine: Promise<decimal | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly importLineNumber: Promise<integer | null>;
    readonly sourceDocumentType: Promise<sageX3Sales.enums.SalesInvoiceSource | null>;
    readonly invoicePercentageForScheduledInvoice: Promise<decimal | null>;
    readonly scheduledInvoiceLineNumber: Promise<integer | null>;
    readonly scheduledinvoiceSource: Promise<sageX3SalesData.enums.SalesDocumentType | null>;
    readonly invoiceLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly invoiceLineText: Promise<TextStream>;
    readonly distributedInvoicingElements: Collection<sageX3Sales.nodes.SalesInvoiceLineDistributedInvoicingElements>;
    readonly productStatisticalGroups: Collection<sageX3Sales.nodes.SalesInvoiceLineProductStatisticalGroups>;
    readonly taxBasisAmounts: Collection<sageX3Sales.nodes.SalesInvoiceLineTaxBasisAmounts>;
    readonly taxes: Collection<sageX3Sales.nodes.SalesInvoiceLineTaxes>;
}
//# sourceMappingURL=sales-invoice-line.d.ts.map