"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesInvoiceLineTaxes = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const denormalized = { maxRepeat: 3 };
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            salesInvoice: 'salesInvoice',
            lineNumber: 'lineNumber',
        },
        taxLevel: {
            code: 'taxLevel',
            async legislation() {
                return (await (await (await this._denormalizedParent).company).legislation)?.code;
            },
        },
        tax: {
            code: 'tax',
            async legislation() {
                return (await (await (await this._denormalizedParent).company).legislation)?.code;
            },
        },
    },
};
let SalesInvoiceLineTaxes = class SalesInvoiceLineTaxes extends xtrem_core_1.Node {
};
exports.SalesInvoiceLineTaxes = SalesInvoiceLineTaxes;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], SalesInvoiceLineTaxes.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'NUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoiceLineTaxes.prototype, "salesInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SIDLIN',
    })
], SalesInvoiceLineTaxes.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesInvoiceLine,
    })
], SalesInvoiceLineTaxes.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VACITM',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.TaxLevel,
    })
], SalesInvoiceLineTaxes.prototype, "taxLevel", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VAT',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
    })
], SalesInvoiceLineTaxes.prototype, "tax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLineTaxes.prototype, "taxAmount", void 0);
exports.SalesInvoiceLineTaxes = SalesInvoiceLineTaxes = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SINVOICED',
        keyPropertyNames: ['denormalizedIndex', 'salesInvoice', 'lineNumber'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], SalesInvoiceLineTaxes);
//# sourceMappingURL=sales-invoice-line-taxes.js.map