"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesInvoiceDiscountOrChargeCalculationRules = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'SPR'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            id: 'id',
        },
        invoicingElement: {
            code: 'invoicingElement',
        },
    },
};
let SalesInvoiceDiscountOrChargeCalculationRules = class SalesInvoiceDiscountOrChargeCalculationRules extends xtrem_core_1.Node {
};
exports.SalesInvoiceDiscountOrChargeCalculationRules = SalesInvoiceDiscountOrChargeCalculationRules;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], SalesInvoiceDiscountOrChargeCalculationRules.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'NUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoiceDiscountOrChargeCalculationRules.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesInvoice,
    })
], SalesInvoiceDiscountOrChargeCalculationRules.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGTYP',
        dataType: () => sageX3MasterData.enums.discountCalculationRulesDatatype,
    })
], SalesInvoiceDiscountOrChargeCalculationRules.prototype, "type", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVDTALIN',
        columnType: 'integer',
        node: () => sageX3InvoicingData.nodes.SalesInvoicingElement,
    })
], SalesInvoiceDiscountOrChargeCalculationRules.prototype, "invoicingElement", void 0);
exports.SalesInvoiceDiscountOrChargeCalculationRules = SalesInvoiceDiscountOrChargeCalculationRules = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SINVOICEV',
        keyPropertyNames: ['denormalizedIndex', 'id'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], SalesInvoiceDiscountOrChargeCalculationRules);
//# sourceMappingURL=sales-invoice-discount-or-charge-calculation-rules.js.map