"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesDeliverySalesReps = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'REP'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            id: 'id',
        },
        salesRep: {
            code: 'salesRep',
        },
    },
};
let SalesDeliverySalesReps = class SalesDeliverySalesReps extends xtrem_core_1.Node {
};
exports.SalesDeliverySalesReps = SalesDeliverySalesReps;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], SalesDeliverySalesReps.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'SDHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliverySalesReps.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesDelivery,
    })
], SalesDeliverySalesReps.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REP',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SalesRep,
    })
], SalesDeliverySalesReps.prototype, "salesRep", void 0);
exports.SalesDeliverySalesReps = SalesDeliverySalesReps = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SDELIVERY',
        keyPropertyNames: ['denormalizedIndex', 'id'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], SalesDeliverySalesReps);
//# sourceMappingURL=sales-delivery-sales-reps.js.map