"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesDeliveryLine = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3PhysicalFlowsData = require("@sage/x3-physical-flows-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3SalesData = require("@sage/x3-sales-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const joins = {
    referenceJoins: {
        salesDelivery: {
            id: 'salesDelivery',
        },
        company: {
            code: 'company',
        },
        salesOrderNumber: {
            id: 'salesOrderNumber',
        },
        salesOrderLine: {
            salesOrder: 'salesOrderNumber',
            lineNumber: 'salesOrderLineNumber',
            sequenceNumber: 'salesOrderLine',
        },
        soldToCustomer: {
            code: 'soldToCustomer',
        },
        shipToCustomerAddress: {
            customer: 'soldToCustomer',
            shipToAddress: 'shipToCustomerAddress',
        },
        product: {
            code: 'product',
        },
        majorProductVersion: {
            product: 'product',
            code: 'majorProductVersion',
        },
        shippingSite: {
            code: 'shippingSite',
        },
        salesRep1: {
            code: 'salesRep1',
        },
        salesRep2: {
            code: 'salesRep2',
        },
        priceReason: {
            code: 'priceReason',
        },
        discountOrCharge1Reason: {
            code: 'discountOrCharge1Reason',
        },
        discountOrCharge2Reason: {
            code: 'discountOrCharge2Reason',
        },
        discountOrCharge3Reason: {
            code: 'discountOrCharge3Reason',
        },
        discountOrCharge4Reason: {
            code: 'discountOrCharge4Reason',
        },
        discountOrCharge5Reason: {
            code: 'discountOrCharge5Reason',
        },
        discountOrCharge6Reason: {
            code: 'discountOrCharge6Reason',
        },
        discountOrCharge7Reason: {
            code: 'discountOrCharge7Reason',
        },
        discountOrCharge8Reason: {
            code: 'discountOrCharge8Reason',
        },
        discountOrCharge9Reason: {
            code: 'discountOrCharge9Reason',
        },
        salesUnit: {
            code: 'salesUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        packaging: {
            code: 'packaging',
        },
        freeProductLineSource: {
            salesDelivery: 'salesDelivery',
            lineNumber: 'freeProductLineSource',
        },
        preferentialStockLocationFilter: {
            stockSite: 'shippingSite',
            code: 'preferentialStockLocationFilter',
        },
        weightUnit: {
            code: 'weightUnit',
        },
        weightUnitForDistributionOnLines: {
            code: 'weightUnitForDistributionOnLines',
        },
        volumeUnitForDistributionOnLines: {
            code: 'volumeUnitForDistributionOnLines',
        },
        warehouse: {
            code: 'warehouse',
        },
        project: {
            id: 'project',
        },
        deliveryLineTextRef: {
            code: 'deliveryLineTextKey',
        },
        pickingLineTextRef: {
            code: 'pickingLineTextKey',
        },
    },
};
const compositeReferences = {
    deliveryLineTextRef: {
        deliveryLineText: 'text',
    },
    pickingLineTextRef: {
        pickingLineText: 'text',
    },
};
let SalesDeliveryLine = class SalesDeliveryLine extends xtrem_core_1.Node {
};
exports.SalesDeliveryLine = SalesDeliveryLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SDHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesDelivery,
    })
], SalesDeliveryLine.prototype, "salesDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDDLIN',
    })
], SalesDeliveryLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], SalesDeliveryLine.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOHCAT',
        dataType: () => sageX3SalesData.enums.orderCategoryDatatype,
    })
], SalesDeliveryLine.prototype, "salesOrderCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesOrder,
    })
], SalesDeliveryLine.prototype, "salesOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOPLIN',
    })
], SalesDeliveryLine.prototype, "salesOrderLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOQSEQ',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesOrderLine,
    })
], SalesDeliveryLine.prototype, "salesOrderLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCORD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesDeliveryLine.prototype, "soldToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ShipToCustomerAddress,
    })
], SalesDeliveryLine.prototype, "shipToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], SalesDeliveryLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], SalesDeliveryLine.prototype, "majorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], SalesDeliveryLine.prototype, "minorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliveryLine.prototype, "productDescriptionInUserLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliveryLine.prototype, "productDescriptionInCustomerLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesDeliveryLine.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USEPLC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliveryLine.prototype, "locationReference", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHIDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesDeliveryLine.prototype, "shipmentDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REP1',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SalesRep,
        serviceOptions: () => [sageX3System.serviceOptions.Re1ActivityCode],
    })
], SalesDeliveryLine.prototype, "salesRep1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REP2',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SalesRep,
        serviceOptions: () => [sageX3System.serviceOptions.Re2ActivityCode],
    })
], SalesDeliveryLine.prototype, "salesRep2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPRAT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re1ActivityCode],
    })
], SalesDeliveryLine.prototype, "salesRep1CommissionRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPRAT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re2ActivityCode],
    })
], SalesDeliveryLine.prototype, "salesRep2CommissionRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "salesRepCommissionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GROPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "grossPrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIREN',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
    })
], SalesDeliveryLine.prototype, "priceReason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "netPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRINOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "netPriceExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRIATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "netPriceIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PFM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "margin", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "costPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp1ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp2ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp3ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp4ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge4", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp5ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge5", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp6ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge6", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp7ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge7", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp8ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge8", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp9ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge9", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN1',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp1ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge1Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN2',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp2ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge2Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN3',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp3ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge3Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN4',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp4ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge4Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN5',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp5ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge5Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN6',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp6ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge6Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN7',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp7ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge7Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN8',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp8ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge8Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN9',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp9ActivityCode],
    })
], SalesDeliveryLine.prototype, "discountOrCharge9Reason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "calculatedTaxableBase1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "calculatedTaxableBase2", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSPLINFLG',
    })
], SalesDeliveryLine.prototype, "isLineWithDistributedInvoicingElement", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "quantityInSalesUnitDelivered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "quantityInStockUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RTNQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "quantityInSalesUnitReturned", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RTNQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "quantityInStockUnitReturned", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "quantityInSalesUnitWaitingForReturn", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRTQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "quantityInStockUnitWaitingForReturn", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OALQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "quantityInStockUnitInitiallyAllocatedOnOrder", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PACQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "quantityInStockUnitPackaged", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesDeliveryLine.prototype, "salesUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesDeliveryLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SAUSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "salesUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCK',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.Packaging,
    })
], SalesDeliveryLine.prototype, "packaging", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCKCAP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "packagingCapacity", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINTYP',
        dataType: () => sageX3SalesData.enums.lineTypeDatatype,
    })
], SalesDeliveryLine.prototype, "lineType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FOCFLG',
        dataType: () => sageX3SalesData.enums.freeDatatype,
    })
], SalesDeliveryLine.prototype, "freeProduct", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORILIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesDeliveryLine,
    })
], SalesDeliveryLine.prototype, "freeProductLineSource", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOMGTCOD',
        dataType: () => sageX3MasterData.enums.stockManagementDatatype,
    })
], SalesDeliveryLine.prototype, "productStockManagement", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliveryLine.prototype, "exclusiveLotFilter", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliveryLine.prototype, "exclusiveStockStatusFilter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOC',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Location,
    })
], SalesDeliveryLine.prototype, "preferentialStockLocationFilter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesDeliveryLine.prototype, "weightUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UNTWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "weight", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'SDDTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliveryLine.prototype, "deliveryLineTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'PRPTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliveryLine.prototype, "pickingLineTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GEOCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesDeliveryLine.prototype, "geographicCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INSCTYFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesDeliveryLine.prototype, "insideCityLimits", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXGEOFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesDeliveryLine.prototype, "isTaxedGeographically", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesDeliveryLine.prototype, "isTaxable", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXREGFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesDeliveryLine.prototype, "isRecordedTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RATTAXLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesDeliveryLine.prototype, "taxRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASTAXLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesDeliveryLine.prototype, "taxBasisAmount", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NDEPRNBOM',
    })
], SalesDeliveryLine.prototype, "isComponentPrintedOnPackingSlip", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVPRNBOM',
    })
], SalesDeliveryLine.prototype, "isComponentPrintedOnInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPFLG',
    })
], SalesDeliveryLine.prototype, "receiptStatus", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "quantityInStockUnitReceived", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYPORI',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], SalesDeliveryLine.prototype, "sourceDocumentType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRNUMORI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliveryLine.prototype, "sourceDocument", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRLINORI',
    })
], SalesDeliveryLine.prototype, "sourceDocumentLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRSEQORI',
    })
], SalesDeliveryLine.prototype, "sourceDocumentSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPLINWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "weightDistributedOnLine", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPLINVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryLine.prototype, "volumeDistributedOnLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesDeliveryLine.prototype, "weightUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesDeliveryLine.prototype, "volumeUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRH',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], SalesDeliveryLine.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCKFLG',
    })
], SalesDeliveryLine.prototype, "isPacked", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], SalesDeliveryLine.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDHCAT',
        dataType: () => sageX3SalesData.enums.deliveryCategoryDatatype,
    })
], SalesDeliveryLine.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINCFMFLG',
    })
], SalesDeliveryLine.prototype, "isValidatedLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesDeliveryLine.prototype, "deliveryLineTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesDeliveryLine.prototype, "pickingLineTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesDeliveryLine.prototype, "deliveryLineText", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesDeliveryLine.prototype, "pickingLineText", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesDeliveryLineDistributedInvoicingElements,
    })
], SalesDeliveryLine.prototype, "distributedInvoicingElements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesDeliveryLineProductStatisticalGroups,
    })
], SalesDeliveryLine.prototype, "productStatisticalGroups", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesDeliveryLineTaxes,
    })
], SalesDeliveryLine.prototype, "taxes", void 0);
exports.SalesDeliveryLine = SalesDeliveryLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SDELIVERYD',
        keyPropertyNames: ['salesDelivery', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    salesDelivery: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['lineNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SalesDeliveryLine);
//# sourceMappingURL=sales-delivery-line.js.map