import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, TextStream, Collection } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesDeliveryLine extends Node {
    readonly salesDelivery: Reference<sageX3Sales.nodes.SalesDelivery>;
    readonly lineNumber: Promise<integer | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly salesOrderCategory: Promise<sageX3SalesData.enums.OrderCategory | null>;
    readonly salesOrderNumber: Reference<sageX3Sales.nodes.SalesOrder | null>;
    readonly salesOrderLineNumber: Promise<integer | null>;
    readonly salesOrderLine: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorProductVersion: Promise<string>;
    readonly productDescriptionInUserLanguage: Promise<string>;
    readonly productDescriptionInCustomerLanguage: Promise<string>;
    readonly shippingSite: Reference<sageX3System.nodes.Site>;
    readonly locationReference: Promise<string>;
    readonly shipmentDate: Promise<date>;
    readonly salesRep1: Reference<sageX3MasterData.nodes.SalesRep | null>;
    readonly salesRep2: Reference<sageX3MasterData.nodes.SalesRep | null>;
    readonly salesRep1CommissionRate: Promise<decimal | null>;
    readonly salesRep2CommissionRate: Promise<decimal | null>;
    readonly salesRepCommissionFactor: Promise<decimal | null>;
    readonly grossPrice: Promise<decimal | null>;
    readonly priceReason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly netPrice: Promise<decimal | null>;
    readonly netPriceExcludingTax: Promise<decimal | null>;
    readonly netPriceIncludingTax: Promise<decimal | null>;
    readonly margin: Promise<decimal | null>;
    readonly costPrice: Promise<decimal | null>;
    readonly discountOrCharge1: Promise<decimal | null>;
    readonly discountOrCharge2: Promise<decimal | null>;
    readonly discountOrCharge3: Promise<decimal | null>;
    readonly discountOrCharge4: Promise<decimal | null>;
    readonly discountOrCharge5: Promise<decimal | null>;
    readonly discountOrCharge6: Promise<decimal | null>;
    readonly discountOrCharge7: Promise<decimal | null>;
    readonly discountOrCharge8: Promise<decimal | null>;
    readonly discountOrCharge9: Promise<decimal | null>;
    readonly discountOrCharge1Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge2Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge3Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge4Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge5Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge6Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge7Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge8Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge9Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly calculatedTaxableBase1: Promise<decimal | null>;
    readonly calculatedTaxableBase2: Promise<decimal | null>;
    readonly isLineWithDistributedInvoicingElement: Promise<boolean>;
    readonly quantityInSalesUnitDelivered: Promise<decimal>;
    readonly quantityInStockUnitInvoiced: Promise<decimal>;
    readonly quantityInSalesUnitReturned: Promise<decimal | null>;
    readonly quantityInStockUnitReturned: Promise<decimal | null>;
    readonly quantityInSalesUnitWaitingForReturn: Promise<decimal | null>;
    readonly quantityInStockUnitWaitingForReturn: Promise<decimal | null>;
    readonly quantityInStockUnitInitiallyAllocatedOnOrder: Promise<decimal | null>;
    readonly quantityInStockUnitPackaged: Promise<decimal | null>;
    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
    readonly packagingCapacity: Promise<decimal | null>;
    readonly lineType: Promise<sageX3SalesData.enums.LineType | null>;
    readonly freeProduct: Promise<sageX3SalesData.enums.Free | null>;
    readonly freeProductLineSource: Reference<sageX3Sales.nodes.SalesDeliveryLine | null>;
    readonly productStockManagement: Promise<sageX3MasterData.enums.StockManagement | null>;
    readonly exclusiveLotFilter: Promise<string>;
    readonly exclusiveStockStatusFilter: Promise<string>;
    readonly preferentialStockLocationFilter: Reference<sageX3StockData.nodes.Location | null>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly weight: Promise<decimal | null>;
    readonly deliveryLineTextKey: Promise<string>;
    readonly pickingLineTextKey: Promise<string>;
    readonly geographicCode: Promise<string>;
    readonly insideCityLimits: Promise<string>;
    readonly isTaxedGeographically: Promise<string>;
    readonly isTaxable: Promise<boolean>;
    readonly isRecordedTax: Promise<boolean>;
    readonly taxRate: Promise<decimal | null>;
    readonly taxBasisAmount: Promise<decimal | null>;
    readonly isComponentPrintedOnPackingSlip: Promise<boolean>;
    readonly isComponentPrintedOnInvoice: Promise<boolean>;
    readonly receiptStatus: Promise<integer | null>;
    readonly quantityInStockUnitReceived: Promise<decimal | null>;
    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly sourceDocument: Promise<string>;
    readonly sourceDocumentLineNumber: Promise<integer | null>;
    readonly sourceDocumentSequenceNumber: Promise<integer | null>;
    readonly weightDistributedOnLine: Promise<decimal | null>;
    readonly volumeDistributedOnLine: Promise<decimal | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly isPacked: Promise<boolean>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly category: Promise<sageX3SalesData.enums.DeliveryCategory | null>;
    readonly isValidatedLine: Promise<boolean>;
    readonly deliveryLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly pickingLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly deliveryLineText: Promise<TextStream>;
    readonly pickingLineText: Promise<TextStream>;
    readonly distributedInvoicingElements: Collection<sageX3Sales.nodes.SalesDeliveryLineDistributedInvoicingElements>;
    readonly productStatisticalGroups: Collection<sageX3Sales.nodes.SalesDeliveryLineProductStatisticalGroups>;
    readonly taxes: Collection<sageX3Sales.nodes.SalesDeliveryLineTaxes>;
}
//# sourceMappingURL=sales-delivery-line.d.ts.map