"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesDeliveryInvoicingElements = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'SFI'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            id: 'id',
        },
        distributionKey: {
            code: 'distributionKey',
            numberOfLines() {
                return 1;
            },
        },
        invoicingElement: {
            code: 'invoicingElement',
        },
        sageSalesTax: {
            glossaryId() {
                return 203;
            },
            code: 'sageSalesTax',
        },
    },
};
let SalesDeliveryInvoicingElements = class SalesDeliveryInvoicingElements extends xtrem_core_1.Node {
};
exports.SalesDeliveryInvoicingElements = SalesDeliveryInvoicingElements;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], SalesDeliveryInvoicingElements.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'SDHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliveryInvoicingElements.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesDelivery,
    })
], SalesDeliveryInvoicingElements.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVDTAAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesDeliveryInvoicingElements.prototype, "percentageOrAmount", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVDTATYP',
        dataType: () => sageX3MasterData.enums.valueTypeDatatype,
    })
], SalesDeliveryInvoicingElements.prototype, "valueType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVDTADSP',
        columnType: 'string',
        filters: {
            lookup: {
                numberOfLines: 1,
            },
            control: {
                numberOfLines: 1,
            },
        },
        node: () => sageX3FinanceData.nodes.DistributionKey,
    })
], SalesDeliveryInvoicingElements.prototype, "distributionKey", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVDTA',
        columnType: 'integer',
        node: () => sageX3InvoicingData.nodes.SalesInvoicingElement,
    })
], SalesDeliveryInvoicingElements.prototype, "invoicingElement", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SFISSTCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 203,
            },
            control: {
                glossaryId: 203,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesDeliveryInvoicingElements.prototype, "sageSalesTax", void 0);
exports.SalesDeliveryInvoicingElements = SalesDeliveryInvoicingElements = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SDELIVERY',
        keyPropertyNames: ['denormalizedIndex', 'id'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], SalesDeliveryInvoicingElements);
//# sourceMappingURL=sales-delivery-invoicing-elements.js.map