"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerExtension = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3SalesData = require("@sage/x3-sales-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3Sales = require("..");
const joins = {
    referenceJoins: {
        serviceContract: {
            id: 'serviceContract',
        },
    },
};
let CustomerExtension = class CustomerExtension extends xtrem_core_1.NodeExtension {
};
exports.CustomerExtension = CustomerExtension;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCTYP',
        dataType: () => sageX3SalesData.enums.customerTypeDatatype,
    })
], CustomerExtension.prototype, "customerType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FREINV',
        dataType: () => sageX3SalesData.enums.freightInvoicingDatatype,
    })
], CustomerExtension.prototype, "freightInvoicing", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOIPER',
        dataType: () => sageX3SalesData.enums.statementPeriodDatatype,
    })
], CustomerExtension.prototype, "openItemStatementFrequency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVPER',
        dataType: () => sageX3SalesData.enums.invoicingFrequencyDatatype,
    })
], CustomerExtension.prototype, "invoicePeriod", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DUDCLC',
        dataType: () => sageX3SalesData.enums.dueDateCalculationSourceDatatype,
    })
], CustomerExtension.prototype, "dueDateOrigin", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DME',
        dataType: () => sageX3SalesData.enums.partialDeliveryDatatype,
    })
], CustomerExtension.prototype, "partialDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IME',
        dataType: () => sageX3SalesData.enums.invoicingModeDatatype,
    })
], CustomerExtension.prototype, "invoicingMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COTCHX',
        columnType: 'string',
        node: () => sageX3Sales.nodes.ServiceContractTemplate,
    })
], CustomerExtension.prototype, "serviceContract", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTLASTYP',
        dataType: () => sageX3Sales.enums.salesContactTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PptActivityCode],
    })
], CustomerExtension.prototype, "lastContactType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTNEXTYP',
        dataType: () => sageX3Sales.enums.salesContactTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PptActivityCode],
    })
], CustomerExtension.prototype, "nextContactType", void 0);
exports.CustomerExtension = CustomerExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3MasterData.nodes.Customer,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], CustomerExtension);
//# sourceMappingURL=customer-extension.js.map