declare module '@sage/x3-sales-api-partial' {
    import type {
        AccountScheme,
        AccountingCode,
        AutomaticJournal,
        BankAccount,
        CustomerDimensions,
        CustomerDimensionsBinding,
        CustomerDimensionsInput,
        CustomerInvoiceHeaderCurrencyRates,
        CustomerInvoiceHeaderCurrencyRatesInput,
        CustomerInvoiceHeaderDimensions,
        CustomerInvoiceHeaderDimensionsInput,
        Dimension,
        DimensionType,
        DistributionKey,
        EntryType,
        Factor,
        Journal,
        OpenItem,
        Package as SageX3FinanceData$Package,
        ProductCategoryDimensions,
        ProductCategoryDimensionsBinding,
        ProductCategoryDimensionsInput,
        ProductDimensions,
        ProductDimensionsBinding,
        ProductDimensionsInput,
        ReminderGroup,
    } from '@sage/x3-finance-data-api';
    import type {
        CustomerInvoiceHeader,
        CustomerInvoiceHeaderBillToCustomerAddressLines,
        CustomerInvoiceHeaderBillToCustomerAddressLinesInput,
        CustomerInvoiceHeaderComments,
        CustomerInvoiceHeaderCommentsInput,
        CustomerInvoiceHeaderPayByBusinessPartnerAddressLines,
        CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesInput,
        CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames,
        CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesInput,
        CustomerInvoiceHeaderTaxes,
        CustomerInvoicingElements,
        CustomerInvoicingElementsBinding,
        CustomerInvoicingElementsInput,
        EarlyDiscountLateCharge,
        InvoicingTerm,
        Mandate,
        Package as SageX3InvoicingData$Package,
        PaymentMethod,
        PaymentTerm,
        PriceStructure,
        ProductCategoryTaxLevels,
        ProductCategoryTaxLevelsBinding,
        ProductCategoryTaxLevelsInput,
        ProductTaxLevels,
        ProductTaxLevelsBinding,
        ProductTaxLevelsInput,
        SalesInvoicingElement,
        Tax,
        TaxLevel,
        TaxRule,
    } from '@sage/x3-invoicing-data-api';
    import type { Package as SageX3ManufacturingData$Package } from '@sage/x3-manufacturing-data-api';
    import type {
        BomCodes,
        BusinessPartner,
        BusinessPartnerAddress,
        BusinessPartnerCompanyNames,
        BusinessPartnerCompanyNamesInput,
        BusinessPartnerContact,
        Carrier,
        Currency,
        Customer,
        CustomerAddress,
        CustomerAddressInput,
        CustomerBankDetail,
        CustomerBankDetailInput,
        CustomerCashTaxRules,
        CustomerCashTaxRulesBinding,
        CustomerCashTaxRulesInput,
        CustomerCategory,
        CustomerContact,
        CustomerContactInput,
        CustomerInput,
        CustomerPaymentDays,
        CustomerPaymentDaysBinding,
        CustomerPaymentDaysInput,
        CustomerProduct,
        CustomerProductInput,
        CustomerSalesReps,
        CustomerSalesRepsBinding,
        CustomerSalesRepsInput,
        CustomerStatisticalGroups,
        CustomerStatisticalGroupsBinding,
        CustomerStatisticalGroupsInput,
        Incoterm,
        Package as SageX3MasterData$Package,
        PrintTemplate,
        Product,
        ProductCategory,
        ProductCategoryStatisticalGroups,
        ProductCategoryStatisticalGroupsBinding,
        ProductCategoryStatisticalGroupsInput,
        ProductInput,
        ProductPackingUnits,
        ProductPackingUnitsBinding,
        ProductPackingUnitsInput,
        ProductSite,
        ProductStatisticalGroups,
        ProductStatisticalGroupsBinding,
        ProductStatisticalGroupsInput,
        ProductVersion,
        SalesRep,
        ShipToCustomerAddress,
        ShipToCustomerAddressInput,
        SupplierProduct,
        SupplierProductInput,
        TechnicalSheet,
        UnavailablePeriods,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type {
        IntrastatStatisticalRule,
        IntrastatTransactionNature,
        Package as SageX3PhysicalFlowsData$Package,
        Packaging,
    } from '@sage/x3-physical-flows-data-api';
    import type {
        CostType,
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type {
        DeliveryMode,
        FreightCostStructure,
        MatchingTolerance,
        Package as SageX3PurchasingData$Package,
    } from '@sage/x3-purchasing-data-api';
    import type {
        Package as SageX3SalesData$Package,
        SalesDeliveryType,
        SalesInvoiceType,
        SalesOrderType,
        SalesPriceReason,
        SalesQuoteType,
        SalesReturnType,
    } from '@sage/x3-sales-data-api';
    import type { Package as SageX3Stock$Package } from '@sage/x3-stock-api';
    import type {
        Location,
        MajorVersionStatus,
        Package as SageX3StockData$Package,
        ProductCategoryDefaultLocations,
        ProductCategoryDefaultLocationsBinding,
        ProductCategoryDefaultLocationsInput,
        ProductCategoryOverheads,
        ProductCategoryOverheadsBinding,
        ProductCategoryOverheadsInput,
        ProductCategoryPackingUnits,
        ProductCategoryPackingUnitsBinding,
        ProductCategoryPackingUnitsInput,
        StockManagementRules,
        StockManagementRulesInput,
        Warehouse,
    } from '@sage/x3-stock-data-api';
    import type { Country, Package as SageX3Structure$Package, SiteGroupings } from '@sage/x3-structure-api';
    import type {
        Access,
        Company,
        GenericPrintReport,
        Language,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        CreateOperation,
        DeleteOperation,
        GetDefaultsOperation,
        GetDuplicateOperation,
        QueryOperation,
        ReadOperation,
        TextStream,
        UpdateByIdOperation,
        UpdateOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface SalesContactType$Enum {
        none: 1;
        phone: 2;
        appointment: 3;
        email: 4;
        mail: 5;
        massMailing: 6;
    }
    export type SalesContactType = keyof SalesContactType$Enum;
    export interface SalesDeliveryStatus$Enum {
        notDelivered: 1;
        partlyDelivered: 2;
        delivered: 3;
    }
    export type SalesDeliveryStatus = keyof SalesDeliveryStatus$Enum;
    export interface SalesInvoiceSource$Enum {
        direct: 1;
        order: 2;
        shipment: 3;
        invoice: 4;
        quote: 5;
        return: 6;
        serviceContract: 7;
        serviceRequest: 8;
        transfer: 9;
        scheduledInvoice: 10;
    }
    export type SalesInvoiceSource = keyof SalesInvoiceSource$Enum;
    export interface SalesInvoiceStatus$Enum {
        notInvoiced: 1;
        partlyInvoiced: 2;
        invoiced: 3;
    }
    export type SalesInvoiceStatus = keyof SalesInvoiceStatus$Enum;
    export interface SalesProductType$Enum {
        normal: 1;
        flexibleKit: 2;
        fixedKit: 3;
    }
    export type SalesProductType = keyof SalesProductType$Enum;
    export interface SalesDeliveryBillToCustomerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesDeliveryBillToCustomerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SalesDeliveryBillToCustomerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesDeliveryBillToCustomerAddressLines$Operations {
        query: QueryOperation<SalesDeliveryBillToCustomerAddressLines>;
        read: ReadOperation<SalesDeliveryBillToCustomerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryBillToCustomerAddressLines>;
            query: AggregateQueryOperation<SalesDeliveryBillToCustomerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SalesDeliveryBillToCustomerAddressLines>;
    }
    export interface SalesDeliveryBillToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesDeliveryBillToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SalesDeliveryBillToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesDeliveryBillToCustomerCompanyNames$Operations {
        query: QueryOperation<SalesDeliveryBillToCustomerCompanyNames>;
        read: ReadOperation<SalesDeliveryBillToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryBillToCustomerCompanyNames>;
            query: AggregateQueryOperation<SalesDeliveryBillToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SalesDeliveryBillToCustomerCompanyNames>;
    }
    export interface SalesDeliveryCustomerStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        value: MiscellaneousTable;
    }
    export interface SalesDeliveryCustomerStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        value?: string;
    }
    export interface SalesDeliveryCustomerStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        value: MiscellaneousTable;
    }
    export interface SalesDeliveryCustomerStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesDeliveryCustomerStatisticalGroups$Operations {
        query: QueryOperation<SalesDeliveryCustomerStatisticalGroups>;
        read: ReadOperation<SalesDeliveryCustomerStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryCustomerStatisticalGroups>;
            query: AggregateQueryOperation<SalesDeliveryCustomerStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: SalesDeliveryCustomerStatisticalGroupsInput },
        ): SalesDeliveryCustomerStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<SalesDeliveryCustomerStatisticalGroups>;
    }
    export interface SalesDeliveryDimensions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface SalesDeliveryDimensionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        dimensionType?: string;
        dimension?: string;
    }
    export interface SalesDeliveryDimensionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface SalesDeliveryDimensions$Lookups {
        dimensionType: QueryOperation<DimensionType>;
        dimension: QueryOperation<Dimension>;
    }
    export interface SalesDeliveryDimensions$Operations {
        query: QueryOperation<SalesDeliveryDimensions>;
        read: ReadOperation<SalesDeliveryDimensions>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryDimensions>;
            query: AggregateQueryOperation<SalesDeliveryDimensions>;
        };
        lookups(dataOrId: string | { data: SalesDeliveryDimensionsInput }): SalesDeliveryDimensions$Lookups;
        getDefaults: GetDefaultsOperation<SalesDeliveryDimensions>;
    }
    export interface SalesDeliveryDiscountOrChargeCalculationRules extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        type: DiscountCalculationRules;
        invoicingElement: integer;
    }
    export interface SalesDeliveryDiscountOrChargeCalculationRulesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        type?: DiscountCalculationRules;
        invoicingElement?: integer | string;
    }
    export interface SalesDeliveryDiscountOrChargeCalculationRulesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        type: DiscountCalculationRules;
        invoicingElement: integer;
    }
    export interface SalesDeliveryDiscountOrChargeCalculationRules$Operations {
        query: QueryOperation<SalesDeliveryDiscountOrChargeCalculationRules>;
        read: ReadOperation<SalesDeliveryDiscountOrChargeCalculationRules>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryDiscountOrChargeCalculationRules>;
            query: AggregateQueryOperation<SalesDeliveryDiscountOrChargeCalculationRules>;
        };
        getDefaults: GetDefaultsOperation<SalesDeliveryDiscountOrChargeCalculationRules>;
    }
    export interface SalesDeliveryInvoicingElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        percentageOrAmount: string;
        valueType: ValueType;
        distributionKey: DistributionKey;
        invoicingElement: SalesInvoicingElement;
        sageSalesTax: MiscellaneousTable;
    }
    export interface SalesDeliveryInvoicingElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        percentageOrAmount?: decimal | string;
        valueType?: ValueType;
        distributionKey?: string;
        invoicingElement?: integer | string;
        sageSalesTax?: string;
    }
    export interface SalesDeliveryInvoicingElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        percentageOrAmount: string;
        valueType: ValueType;
        distributionKey: DistributionKey;
        invoicingElement: SalesInvoicingElement;
        sageSalesTax: MiscellaneousTable;
    }
    export interface SalesDeliveryInvoicingElements$Lookups {
        distributionKey: QueryOperation<DistributionKey>;
        invoicingElement: QueryOperation<SalesInvoicingElement>;
        sageSalesTax: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesDeliveryInvoicingElements$Operations {
        query: QueryOperation<SalesDeliveryInvoicingElements>;
        read: ReadOperation<SalesDeliveryInvoicingElements>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryInvoicingElements>;
            query: AggregateQueryOperation<SalesDeliveryInvoicingElements>;
        };
        lookups(
            dataOrId: string | { data: SalesDeliveryInvoicingElementsInput },
        ): SalesDeliveryInvoicingElements$Lookups;
        getDefaults: GetDefaultsOperation<SalesDeliveryInvoicingElements>;
    }
    export interface SalesDeliveryLineDistributedInvoicingElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesDelivery: string;
        lineNumber: integer;
        distributedLineInvoicingElementNumber: SalesInvoicingElement;
        distributedLineInvoicingElementAmount: string;
    }
    export interface SalesDeliveryLineDistributedInvoicingElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesDelivery?: string;
        lineNumber?: integer | string;
        distributedLineInvoicingElementNumber?: integer | string;
        distributedLineInvoicingElementAmount?: decimal | string;
    }
    export interface SalesDeliveryLineDistributedInvoicingElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesDelivery: string;
        lineNumber: integer;
        distributedLineInvoicingElementNumber: SalesInvoicingElement;
        distributedLineInvoicingElementAmount: string;
    }
    export interface SalesDeliveryLineDistributedInvoicingElements$Lookups {
        distributedLineInvoicingElementNumber: QueryOperation<SalesInvoicingElement>;
    }
    export interface SalesDeliveryLineDistributedInvoicingElements$Operations {
        query: QueryOperation<SalesDeliveryLineDistributedInvoicingElements>;
        read: ReadOperation<SalesDeliveryLineDistributedInvoicingElements>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryLineDistributedInvoicingElements>;
            query: AggregateQueryOperation<SalesDeliveryLineDistributedInvoicingElements>;
        };
        lookups(
            dataOrId: string | { data: SalesDeliveryLineDistributedInvoicingElementsInput },
        ): SalesDeliveryLineDistributedInvoicingElements$Lookups;
        getDefaults: GetDefaultsOperation<SalesDeliveryLineDistributedInvoicingElements>;
    }
    export interface SalesDeliveryLineProductStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesDelivery: string;
        lineNumber: integer;
        value: MiscellaneousTable;
    }
    export interface SalesDeliveryLineProductStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesDelivery?: string;
        lineNumber?: integer | string;
        value?: string;
    }
    export interface SalesDeliveryLineProductStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesDelivery: string;
        lineNumber: integer;
        value: MiscellaneousTable;
    }
    export interface SalesDeliveryLineProductStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesDeliveryLineProductStatisticalGroups$Operations {
        query: QueryOperation<SalesDeliveryLineProductStatisticalGroups>;
        read: ReadOperation<SalesDeliveryLineProductStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryLineProductStatisticalGroups>;
            query: AggregateQueryOperation<SalesDeliveryLineProductStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: SalesDeliveryLineProductStatisticalGroupsInput },
        ): SalesDeliveryLineProductStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<SalesDeliveryLineProductStatisticalGroups>;
    }
    export interface SalesDeliveryLineTaxes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesDelivery: string;
        lineNumber: integer;
        taxLevel: TaxLevel;
        tax: Tax;
    }
    export interface SalesDeliveryLineTaxesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesDelivery?: string;
        lineNumber?: integer | string;
        taxLevel?: string;
        tax?: string;
    }
    export interface SalesDeliveryLineTaxesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesDelivery: string;
        lineNumber: integer;
        taxLevel: TaxLevel;
        tax: Tax;
    }
    export interface SalesDeliveryLineTaxes$Lookups {
        taxLevel: QueryOperation<TaxLevel>;
        tax: QueryOperation<Tax>;
    }
    export interface SalesDeliveryLineTaxes$Operations {
        query: QueryOperation<SalesDeliveryLineTaxes>;
        read: ReadOperation<SalesDeliveryLineTaxes>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryLineTaxes>;
            query: AggregateQueryOperation<SalesDeliveryLineTaxes>;
        };
        lookups(dataOrId: string | { data: SalesDeliveryLineTaxesInput }): SalesDeliveryLineTaxes$Lookups;
        getDefaults: GetDefaultsOperation<SalesDeliveryLineTaxes>;
    }
    export interface SalesDeliveryLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesDelivery: SalesDelivery;
        lineNumber: integer;
        company: Company;
        salesOrderCategory: OrderCategory;
        salesOrderNumber: SalesOrder;
        salesOrderLineNumber: integer;
        salesOrderLine: SalesOrderLine;
        soldToCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        shippingSite: Site;
        locationReference: string;
        shipmentDate: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        isLineWithDistributedInvoicingElement: boolean;
        quantityInSalesUnitDelivered: string;
        quantityInStockUnitInvoiced: string;
        quantityInSalesUnitReturned: string;
        quantityInStockUnitReturned: string;
        quantityInSalesUnitWaitingForReturn: string;
        quantityInStockUnitWaitingForReturn: string;
        quantityInStockUnitInitiallyAllocatedOnOrder: string;
        quantityInStockUnitPackaged: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        packaging: Packaging;
        packagingCapacity: string;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesDeliveryLine;
        productStockManagement: StockManagement;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        preferentialStockLocationFilter: Location;
        weightUnit: UnitOfMeasure;
        weight: string;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        taxRate: string;
        taxBasisAmount: string;
        isComponentPrintedOnPackingSlip: boolean;
        isComponentPrintedOnInvoice: boolean;
        receiptStatus: integer;
        quantityInStockUnitReceived: string;
        sourceDocumentType: EntryTypeEnum;
        sourceDocument: string;
        sourceDocumentLineNumber: integer;
        sourceDocumentSequenceNumber: integer;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        warehouse: Warehouse;
        isPacked: boolean;
        project: ProjectLink;
        category: DeliveryCategory;
        isValidatedLine: boolean;
        deliveryLineText: TextStream;
        pickingLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesDeliveryLineDistributedInvoicingElements>;
        productStatisticalGroups: ClientCollection<SalesDeliveryLineProductStatisticalGroups>;
        taxes: ClientCollection<SalesDeliveryLineTaxes>;
    }
    export interface SalesDeliveryLineInput extends ClientNodeInput {
        salesDelivery?: string;
        lineNumber?: integer | string;
        company?: string;
        salesOrderCategory?: OrderCategory;
        salesOrderNumber?: string;
        salesOrderLineNumber?: integer | string;
        salesOrderLine?: integer | string;
        soldToCustomer?: string;
        shipToCustomerAddress?: string;
        product?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        shippingSite?: string;
        locationReference?: string;
        shipmentDate?: string;
        salesRep1?: string;
        salesRep2?: string;
        salesRep1CommissionRate?: decimal | string;
        salesRep2CommissionRate?: decimal | string;
        salesRepCommissionFactor?: decimal | string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        netPrice?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        margin?: decimal | string;
        costPrice?: decimal | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        isLineWithDistributedInvoicingElement?: boolean | string;
        quantityInSalesUnitDelivered?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        quantityInSalesUnitReturned?: decimal | string;
        quantityInStockUnitReturned?: decimal | string;
        quantityInSalesUnitWaitingForReturn?: decimal | string;
        quantityInStockUnitWaitingForReturn?: decimal | string;
        quantityInStockUnitInitiallyAllocatedOnOrder?: decimal | string;
        quantityInStockUnitPackaged?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        packaging?: string;
        packagingCapacity?: decimal | string;
        lineType?: LineType;
        freeProduct?: Free;
        freeProductLineSource?: integer | string;
        productStockManagement?: StockManagement;
        exclusiveLotFilter?: string;
        exclusiveStockStatusFilter?: string;
        preferentialStockLocationFilter?: string;
        weightUnit?: string;
        weight?: decimal | string;
        geographicCode?: string;
        insideCityLimits?: string;
        isTaxedGeographically?: string;
        isTaxable?: boolean | string;
        isRecordedTax?: boolean | string;
        taxRate?: decimal | string;
        taxBasisAmount?: decimal | string;
        isComponentPrintedOnPackingSlip?: boolean | string;
        isComponentPrintedOnInvoice?: boolean | string;
        receiptStatus?: integer | string;
        quantityInStockUnitReceived?: decimal | string;
        sourceDocumentType?: EntryTypeEnum;
        sourceDocument?: string;
        sourceDocumentLineNumber?: integer | string;
        sourceDocumentSequenceNumber?: integer | string;
        weightDistributedOnLine?: decimal | string;
        volumeDistributedOnLine?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        warehouse?: string;
        isPacked?: boolean | string;
        project?: string;
        category?: DeliveryCategory;
        isValidatedLine?: boolean | string;
        deliveryLineText?: TextStream;
        pickingLineText?: TextStream;
        distributedInvoicingElements?: Partial<SalesDeliveryLineDistributedInvoicingElementsInput>[];
        productStatisticalGroups?: Partial<SalesDeliveryLineProductStatisticalGroupsInput>[];
        taxes?: Partial<SalesDeliveryLineTaxesInput>[];
    }
    export interface SalesDeliveryLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesDelivery: SalesDelivery;
        lineNumber: integer;
        company: Company;
        salesOrderCategory: OrderCategory;
        salesOrderNumber: SalesOrder;
        salesOrderLineNumber: integer;
        salesOrderLine: SalesOrderLine;
        soldToCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        shippingSite: Site;
        locationReference: string;
        shipmentDate: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        isLineWithDistributedInvoicingElement: boolean;
        quantityInSalesUnitDelivered: string;
        quantityInStockUnitInvoiced: string;
        quantityInSalesUnitReturned: string;
        quantityInStockUnitReturned: string;
        quantityInSalesUnitWaitingForReturn: string;
        quantityInStockUnitWaitingForReturn: string;
        quantityInStockUnitInitiallyAllocatedOnOrder: string;
        quantityInStockUnitPackaged: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        packaging: Packaging;
        packagingCapacity: string;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesDeliveryLine;
        productStockManagement: StockManagement;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        preferentialStockLocationFilter: Location;
        weightUnit: UnitOfMeasure;
        weight: string;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        taxRate: string;
        taxBasisAmount: string;
        isComponentPrintedOnPackingSlip: boolean;
        isComponentPrintedOnInvoice: boolean;
        receiptStatus: integer;
        quantityInStockUnitReceived: string;
        sourceDocumentType: EntryTypeEnum;
        sourceDocument: string;
        sourceDocumentLineNumber: integer;
        sourceDocumentSequenceNumber: integer;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        warehouse: Warehouse;
        isPacked: boolean;
        project: ProjectLink;
        category: DeliveryCategory;
        isValidatedLine: boolean;
        deliveryLineText: TextStream;
        pickingLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesDeliveryLineDistributedInvoicingElementsBinding>;
        productStatisticalGroups: ClientCollection<SalesDeliveryLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<SalesDeliveryLineTaxesBinding>;
    }
    export interface SalesDeliveryLine$Lookups {
        salesDelivery: QueryOperation<SalesDelivery>;
        company: QueryOperation<Company>;
        salesOrderNumber: QueryOperation<SalesOrder>;
        salesOrderLine: QueryOperation<SalesOrderLine>;
        soldToCustomer: QueryOperation<Customer>;
        shipToCustomerAddress: QueryOperation<ShipToCustomerAddress>;
        product: QueryOperation<Product>;
        majorProductVersion: QueryOperation<MajorVersionStatus>;
        shippingSite: QueryOperation<Site>;
        salesRep1: QueryOperation<SalesRep>;
        salesRep2: QueryOperation<SalesRep>;
        priceReason: QueryOperation<SalesPriceReason>;
        discountOrCharge1Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge2Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge3Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge4Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge5Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge6Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge7Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge8Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge9Reason: QueryOperation<SalesPriceReason>;
        salesUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        packaging: QueryOperation<Packaging>;
        freeProductLineSource: QueryOperation<SalesDeliveryLine>;
        preferentialStockLocationFilter: QueryOperation<Location>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        warehouse: QueryOperation<Warehouse>;
        project: QueryOperation<ProjectLink>;
    }
    export interface SalesDeliveryLine$Operations {
        query: QueryOperation<SalesDeliveryLine>;
        read: ReadOperation<SalesDeliveryLine>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryLine>;
            query: AggregateQueryOperation<SalesDeliveryLine>;
        };
        lookups(dataOrId: string | { data: SalesDeliveryLineInput }): SalesDeliveryLine$Lookups;
        getDefaults: GetDefaultsOperation<SalesDeliveryLine>;
    }
    export interface SalesDeliverySalesReps extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        salesRep: SalesRep;
    }
    export interface SalesDeliverySalesRepsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        salesRep?: string;
    }
    export interface SalesDeliverySalesRepsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        salesRep: SalesRep;
    }
    export interface SalesDeliverySalesReps$Lookups {
        salesRep: QueryOperation<SalesRep>;
    }
    export interface SalesDeliverySalesReps$Operations {
        query: QueryOperation<SalesDeliverySalesReps>;
        read: ReadOperation<SalesDeliverySalesReps>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliverySalesReps>;
            query: AggregateQueryOperation<SalesDeliverySalesReps>;
        };
        lookups(dataOrId: string | { data: SalesDeliverySalesRepsInput }): SalesDeliverySalesReps$Lookups;
        getDefaults: GetDefaultsOperation<SalesDeliverySalesReps>;
    }
    export interface SalesDeliveryShipToCustomerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesDeliveryShipToCustomerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SalesDeliveryShipToCustomerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesDeliveryShipToCustomerAddressLines$Operations {
        query: QueryOperation<SalesDeliveryShipToCustomerAddressLines>;
        read: ReadOperation<SalesDeliveryShipToCustomerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryShipToCustomerAddressLines>;
            query: AggregateQueryOperation<SalesDeliveryShipToCustomerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SalesDeliveryShipToCustomerAddressLines>;
    }
    export interface SalesDeliveryShipToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesDeliveryShipToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SalesDeliveryShipToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesDeliveryShipToCustomerCompanyNames$Operations {
        query: QueryOperation<SalesDeliveryShipToCustomerCompanyNames>;
        read: ReadOperation<SalesDeliveryShipToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryShipToCustomerCompanyNames>;
            query: AggregateQueryOperation<SalesDeliveryShipToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SalesDeliveryShipToCustomerCompanyNames>;
    }
    export interface SalesDelivery extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        shippingSite: Site;
        company: Company;
        category: DeliveryCategory;
        isLoanDelivery: boolean;
        salesSite: Site;
        salesInvoice: SalesInvoice;
        sequenceInSalesInvoice: integer;
        salesInvoiceToBeIssued: SalesInvoice;
        salesInvoiceToBeIssuedReversalDate: string;
        soldToCustomer: Customer;
        billToCustomer: Customer;
        payByBusinessPartner: BusinessPartner;
        groupCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        project: ProjectLink;
        shipmentDate: string;
        shipmentTime: string;
        deliveryDate: string;
        deliveryTime: string;
        deliveryLeadTimeInDays: integer;
        deliveryLeadTimeInHours: integer;
        loanReturnDate: string;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: CustomerContact;
        billToCustomerAddress: CustomerAddress;
        billToCustomerPostalCode: string;
        billToCustomerCity: string;
        billToCustomerState: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        billToCustomerEuropeanUnionVatNumber: string;
        billToCustomerContact: CustomerContact;
        currency: Currency;
        currencyRateType: ExchangeRateType;
        inverseRate: string;
        billToCustomerLanguage: Language;
        taxRule: TaxRule;
        entityUse: MiscellaneousTable;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        routeNumber: RouteCode;
        carrier: Carrier;
        deliveryMode: DeliveryMode;
        invoicingFrequency: InvoicingFrequency;
        dueDateCalculationOrigin: DueDateCalculationSource;
        invoicingMode: InvoicingMode;
        salesOrder: SalesOrder;
        mustPrintTransportNote: boolean;
        mustPrintPickTicket: boolean;
        mustPrintPackingSlip: boolean;
        isPickTicketPrinted: boolean;
        isPackingSlipPrinted: boolean;
        numberOfPackingSlipCopies: integer;
        isValidated: boolean;
        isInvoiced: boolean;
        salesProforma: SalesInvoice;
        isIntersite: boolean;
        isIntercompany: boolean;
        sourceSite: Site;
        receivingSite: Site;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        linesAmountExcludingTax: string;
        linesAmountIncludingTax: string;
        linesAmountExcludingTaxInCompanyCurrency: string;
        linesAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        numberOfLines: integer;
        numberOfReturnedLines: integer;
        returnStatus: ReturnStatus;
        customerLocation: Location;
        labelNumber: string;
        numberOfPackages: integer;
        isPacked: boolean;
        weightUnit: UnitOfMeasure;
        volumeUnit: UnitOfMeasure;
        netWeight: string;
        grossWeight: string;
        volume: string;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        intrastatProcessingNumber: integer;
        incoterm: Incoterm;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: CustomerAddress;
        geographicCode: string;
        insideCityLimits: string;
        vertexTransactionType: string;
        taxAmount: string;
        taxableAmount: string;
        vehicleLicensePlate: string;
        trailerLicensePlate: string;
        departureDate: string;
        arrivalDate: string;
        departureTime: string;
        arrivalTime: string;
        stockMovementGroup: MiscellaneousTable;
        stockMovementCode: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        priceStructure: PriceStructure;
        totalQuantityDistributedOnLines: string;
        totalWeightDistributedOnLines: string;
        totalVolumeDistributedOnLines: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        warehouse: Warehouse;
        isForSubconractDelivery: boolean;
        deliveryType: SalesDeliveryType;
        initialDelivery: SalesDelivery;
        isValidatedAddress: boolean;
        billOfLading: string;
        salesDeliveryLines: ClientCollection<SalesDeliveryLine>;
        deliveryFooterText: TextStream;
        deliveryHeaderText: TextStream;
        pickingFooterText: TextStream;
        pickingHeaderText: TextStream;
        billToCustomerAddressLines: ClientCollection<SalesDeliveryBillToCustomerAddressLines>;
        billToCustomerCompanyNames: ClientCollection<SalesDeliveryBillToCustomerCompanyNames>;
        customerStatisticalGroups: ClientCollection<SalesDeliveryCustomerStatisticalGroups>;
        dimensions: ClientCollection<SalesDeliveryDimensions>;
        discountOrChargeCalculationRules: ClientCollection<SalesDeliveryDiscountOrChargeCalculationRules>;
        invoicingElements: ClientCollection<SalesDeliveryInvoicingElements>;
        salesReps: ClientCollection<SalesDeliverySalesReps>;
        shipToCustomerAddressLines: ClientCollection<SalesDeliveryShipToCustomerAddressLines>;
        shipToCustomerCompanyNames: ClientCollection<SalesDeliveryShipToCustomerCompanyNames>;
    }
    export interface SalesDeliveryInput extends ClientNodeInput {
        id?: string;
        shippingSite?: string;
        company?: string;
        category?: DeliveryCategory;
        isLoanDelivery?: boolean | string;
        salesSite?: string;
        salesInvoice?: string;
        sequenceInSalesInvoice?: integer | string;
        salesInvoiceToBeIssued?: string;
        salesInvoiceToBeIssuedReversalDate?: string;
        soldToCustomer?: string;
        billToCustomer?: string;
        payByBusinessPartner?: string;
        groupCustomer?: string;
        shipToCustomerAddress?: string;
        project?: string;
        shipmentDate?: string;
        shipmentTime?: string;
        deliveryDate?: string;
        deliveryTime?: string;
        deliveryLeadTimeInDays?: integer | string;
        deliveryLeadTimeInHours?: integer | string;
        loanReturnDate?: string;
        shipToCustomerPostalCode?: string;
        shipToCustomerCity?: string;
        shipToCustomerState?: string;
        shipToCustomerCountry?: string;
        shipToCustomerCountryName?: string;
        shipToCustomerContact?: string;
        billToCustomerAddress?: string;
        billToCustomerPostalCode?: string;
        billToCustomerCity?: string;
        billToCustomerState?: string;
        billToCustomerCountry?: string;
        billToCustomerCountryName?: string;
        billToCustomerEuropeanUnionVatNumber?: string;
        billToCustomerContact?: string;
        currency?: string;
        currencyRateType?: ExchangeRateType;
        inverseRate?: decimal | string;
        billToCustomerLanguage?: string;
        taxRule?: string;
        entityUse?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        routeNumber?: RouteCode;
        carrier?: string;
        deliveryMode?: string;
        invoicingFrequency?: InvoicingFrequency;
        dueDateCalculationOrigin?: DueDateCalculationSource;
        invoicingMode?: InvoicingMode;
        salesOrder?: string;
        mustPrintTransportNote?: boolean | string;
        mustPrintPickTicket?: boolean | string;
        mustPrintPackingSlip?: boolean | string;
        isPickTicketPrinted?: boolean | string;
        isPackingSlipPrinted?: boolean | string;
        numberOfPackingSlipCopies?: integer | string;
        isValidated?: boolean | string;
        isInvoiced?: boolean | string;
        salesProforma?: string;
        isIntersite?: boolean | string;
        isIntercompany?: boolean | string;
        sourceSite?: string;
        receivingSite?: string;
        priceIncludingOrExcludingTax?: PriceAmountTaxTax;
        linesAmountExcludingTax?: decimal | string;
        linesAmountIncludingTax?: decimal | string;
        linesAmountExcludingTaxInCompanyCurrency?: decimal | string;
        linesAmountIncludingTaxInCompanyCurrency?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        numberOfLines?: integer | string;
        numberOfReturnedLines?: integer | string;
        returnStatus?: ReturnStatus;
        customerLocation?: string;
        labelNumber?: string;
        numberOfPackages?: integer | string;
        isPacked?: boolean | string;
        weightUnit?: string;
        volumeUnit?: string;
        netWeight?: decimal | string;
        grossWeight?: decimal | string;
        volume?: decimal | string;
        intrastatTransactionNature?: string;
        intrastatStatisticalRule?: string;
        intrastatTransportLocation?: CountryLocation;
        intrastatTransportMode?: IntrastatTransportMode;
        intrastatProcessingNumber?: integer | string;
        incoterm?: string;
        incotermTown?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        geographicCode?: string;
        insideCityLimits?: string;
        vertexTransactionType?: string;
        taxAmount?: decimal | string;
        taxableAmount?: decimal | string;
        vehicleLicensePlate?: string;
        trailerLicensePlate?: string;
        departureDate?: string;
        arrivalDate?: string;
        departureTime?: string;
        arrivalTime?: string;
        stockMovementGroup?: string;
        stockMovementCode?: string;
        stockAutomaticJournal?: string;
        priceStructure?: string;
        totalQuantityDistributedOnLines?: decimal | string;
        totalWeightDistributedOnLines?: decimal | string;
        totalVolumeDistributedOnLines?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        warehouse?: string;
        isForSubconractDelivery?: boolean | string;
        deliveryType?: string;
        initialDelivery?: string;
        isValidatedAddress?: boolean | string;
        billOfLading?: string;
        salesDeliveryLines?: Partial<SalesDeliveryLineInput>[];
        deliveryFooterText?: TextStream;
        deliveryHeaderText?: TextStream;
        pickingFooterText?: TextStream;
        pickingHeaderText?: TextStream;
        billToCustomerAddressLines?: Partial<SalesDeliveryBillToCustomerAddressLinesInput>[];
        billToCustomerCompanyNames?: Partial<SalesDeliveryBillToCustomerCompanyNamesInput>[];
        customerStatisticalGroups?: Partial<SalesDeliveryCustomerStatisticalGroupsInput>[];
        dimensions?: Partial<SalesDeliveryDimensionsInput>[];
        discountOrChargeCalculationRules?: Partial<SalesDeliveryDiscountOrChargeCalculationRulesInput>[];
        invoicingElements?: Partial<SalesDeliveryInvoicingElementsInput>[];
        salesReps?: Partial<SalesDeliverySalesRepsInput>[];
        shipToCustomerAddressLines?: Partial<SalesDeliveryShipToCustomerAddressLinesInput>[];
        shipToCustomerCompanyNames?: Partial<SalesDeliveryShipToCustomerCompanyNamesInput>[];
    }
    export interface SalesDeliveryBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        shippingSite: Site;
        company: Company;
        category: DeliveryCategory;
        isLoanDelivery: boolean;
        salesSite: Site;
        salesInvoice: SalesInvoice;
        sequenceInSalesInvoice: integer;
        salesInvoiceToBeIssued: SalesInvoice;
        salesInvoiceToBeIssuedReversalDate: string;
        soldToCustomer: Customer;
        billToCustomer: Customer;
        payByBusinessPartner: BusinessPartner;
        groupCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        project: ProjectLink;
        shipmentDate: string;
        shipmentTime: string;
        deliveryDate: string;
        deliveryTime: string;
        deliveryLeadTimeInDays: integer;
        deliveryLeadTimeInHours: integer;
        loanReturnDate: string;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: CustomerContact;
        billToCustomerAddress: CustomerAddress;
        billToCustomerPostalCode: string;
        billToCustomerCity: string;
        billToCustomerState: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        billToCustomerEuropeanUnionVatNumber: string;
        billToCustomerContact: CustomerContact;
        currency: Currency;
        currencyRateType: ExchangeRateType;
        inverseRate: string;
        billToCustomerLanguage: Language;
        taxRule: TaxRule;
        entityUse: MiscellaneousTable;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        routeNumber: RouteCode;
        carrier: Carrier;
        deliveryMode: DeliveryMode;
        invoicingFrequency: InvoicingFrequency;
        dueDateCalculationOrigin: DueDateCalculationSource;
        invoicingMode: InvoicingMode;
        salesOrder: SalesOrder;
        mustPrintTransportNote: boolean;
        mustPrintPickTicket: boolean;
        mustPrintPackingSlip: boolean;
        isPickTicketPrinted: boolean;
        isPackingSlipPrinted: boolean;
        numberOfPackingSlipCopies: integer;
        isValidated: boolean;
        isInvoiced: boolean;
        salesProforma: SalesInvoice;
        isIntersite: boolean;
        isIntercompany: boolean;
        sourceSite: Site;
        receivingSite: Site;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        linesAmountExcludingTax: string;
        linesAmountIncludingTax: string;
        linesAmountExcludingTaxInCompanyCurrency: string;
        linesAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        numberOfLines: integer;
        numberOfReturnedLines: integer;
        returnStatus: ReturnStatus;
        customerLocation: Location;
        labelNumber: string;
        numberOfPackages: integer;
        isPacked: boolean;
        weightUnit: UnitOfMeasure;
        volumeUnit: UnitOfMeasure;
        netWeight: string;
        grossWeight: string;
        volume: string;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        intrastatProcessingNumber: integer;
        incoterm: Incoterm;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: CustomerAddress;
        geographicCode: string;
        insideCityLimits: string;
        vertexTransactionType: string;
        taxAmount: string;
        taxableAmount: string;
        vehicleLicensePlate: string;
        trailerLicensePlate: string;
        departureDate: string;
        arrivalDate: string;
        departureTime: string;
        arrivalTime: string;
        stockMovementGroup: MiscellaneousTable;
        stockMovementCode: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        priceStructure: PriceStructure;
        totalQuantityDistributedOnLines: string;
        totalWeightDistributedOnLines: string;
        totalVolumeDistributedOnLines: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        warehouse: Warehouse;
        isForSubconractDelivery: boolean;
        deliveryType: SalesDeliveryType;
        initialDelivery: SalesDelivery;
        isValidatedAddress: boolean;
        billOfLading: string;
        salesDeliveryLines: ClientCollection<SalesDeliveryLine>;
        deliveryFooterText: TextStream;
        deliveryHeaderText: TextStream;
        pickingFooterText: TextStream;
        pickingHeaderText: TextStream;
        billToCustomerAddressLines: ClientCollection<SalesDeliveryBillToCustomerAddressLinesBinding>;
        billToCustomerCompanyNames: ClientCollection<SalesDeliveryBillToCustomerCompanyNamesBinding>;
        customerStatisticalGroups: ClientCollection<SalesDeliveryCustomerStatisticalGroupsBinding>;
        dimensions: ClientCollection<SalesDeliveryDimensionsBinding>;
        discountOrChargeCalculationRules: ClientCollection<SalesDeliveryDiscountOrChargeCalculationRulesBinding>;
        invoicingElements: ClientCollection<SalesDeliveryInvoicingElementsBinding>;
        salesReps: ClientCollection<SalesDeliverySalesRepsBinding>;
        shipToCustomerAddressLines: ClientCollection<SalesDeliveryShipToCustomerAddressLinesBinding>;
        shipToCustomerCompanyNames: ClientCollection<SalesDeliveryShipToCustomerCompanyNamesBinding>;
    }
    export interface SalesDelivery$Lookups {
        shippingSite: QueryOperation<Site>;
        company: QueryOperation<Company>;
        salesSite: QueryOperation<Site>;
        salesInvoice: QueryOperation<SalesInvoice>;
        salesInvoiceToBeIssued: QueryOperation<SalesInvoice>;
        soldToCustomer: QueryOperation<Customer>;
        billToCustomer: QueryOperation<Customer>;
        payByBusinessPartner: QueryOperation<BusinessPartner>;
        groupCustomer: QueryOperation<Customer>;
        shipToCustomerAddress: QueryOperation<ShipToCustomerAddress>;
        project: QueryOperation<ProjectLink>;
        shipToCustomerCountry: QueryOperation<Country>;
        shipToCustomerContact: QueryOperation<CustomerContact>;
        billToCustomerAddress: QueryOperation<CustomerAddress>;
        billToCustomerCountry: QueryOperation<Country>;
        billToCustomerContact: QueryOperation<CustomerContact>;
        currency: QueryOperation<Currency>;
        billToCustomerLanguage: QueryOperation<Language>;
        taxRule: QueryOperation<TaxRule>;
        entityUse: QueryOperation<MiscellaneousTable>;
        paymentTerm: QueryOperation<PaymentTerm>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        carrier: QueryOperation<Carrier>;
        deliveryMode: QueryOperation<DeliveryMode>;
        salesOrder: QueryOperation<SalesOrder>;
        salesProforma: QueryOperation<SalesInvoice>;
        sourceSite: QueryOperation<Site>;
        receivingSite: QueryOperation<Site>;
        customerLocation: QueryOperation<Location>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
        intrastatTransactionNature: QueryOperation<IntrastatTransactionNature>;
        intrastatStatisticalRule: QueryOperation<IntrastatStatisticalRule>;
        incoterm: QueryOperation<Incoterm>;
        forwardingAgent: QueryOperation<Carrier>;
        forwardingAgentAddress: QueryOperation<CustomerAddress>;
        stockMovementGroup: QueryOperation<MiscellaneousTable>;
        stockMovementCode: QueryOperation<MiscellaneousTable>;
        stockAutomaticJournal: QueryOperation<AutomaticJournal>;
        priceStructure: QueryOperation<PriceStructure>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        warehouse: QueryOperation<Warehouse>;
        deliveryType: QueryOperation<SalesDeliveryType>;
        initialDelivery: QueryOperation<SalesDelivery>;
    }
    export interface SalesDelivery$Operations {
        query: QueryOperation<SalesDelivery>;
        read: ReadOperation<SalesDelivery>;
        aggregate: {
            read: AggregateReadOperation<SalesDelivery>;
            query: AggregateQueryOperation<SalesDelivery>;
        };
        lookups(dataOrId: string | { data: SalesDeliveryInput }): SalesDelivery$Lookups;
        getDefaults: GetDefaultsOperation<SalesDelivery>;
    }
    export interface SalesInvoiceBillToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesInvoiceBillToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SalesInvoiceBillToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesInvoiceBillToCustomerCompanyNames$Operations {
        query: QueryOperation<SalesInvoiceBillToCustomerCompanyNames>;
        read: ReadOperation<SalesInvoiceBillToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceBillToCustomerCompanyNames>;
            query: AggregateQueryOperation<SalesInvoiceBillToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SalesInvoiceBillToCustomerCompanyNames>;
    }
    export interface SalesInvoiceCustomerStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        value: MiscellaneousTable;
    }
    export interface SalesInvoiceCustomerStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        value?: string;
    }
    export interface SalesInvoiceCustomerStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        value: MiscellaneousTable;
    }
    export interface SalesInvoiceCustomerStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesInvoiceCustomerStatisticalGroups$Operations {
        query: QueryOperation<SalesInvoiceCustomerStatisticalGroups>;
        read: ReadOperation<SalesInvoiceCustomerStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceCustomerStatisticalGroups>;
            query: AggregateQueryOperation<SalesInvoiceCustomerStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: SalesInvoiceCustomerStatisticalGroupsInput },
        ): SalesInvoiceCustomerStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoiceCustomerStatisticalGroups>;
    }
    export interface SalesInvoiceDiscountOrChargeCalculationRules extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        type: DiscountCalculationRules;
        invoicingElement: SalesInvoicingElement;
    }
    export interface SalesInvoiceDiscountOrChargeCalculationRulesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        type?: DiscountCalculationRules;
        invoicingElement?: integer | string;
    }
    export interface SalesInvoiceDiscountOrChargeCalculationRulesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        type: DiscountCalculationRules;
        invoicingElement: SalesInvoicingElement;
    }
    export interface SalesInvoiceDiscountOrChargeCalculationRules$Lookups {
        invoicingElement: QueryOperation<SalesInvoicingElement>;
    }
    export interface SalesInvoiceDiscountOrChargeCalculationRules$Operations {
        query: QueryOperation<SalesInvoiceDiscountOrChargeCalculationRules>;
        read: ReadOperation<SalesInvoiceDiscountOrChargeCalculationRules>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceDiscountOrChargeCalculationRules>;
            query: AggregateQueryOperation<SalesInvoiceDiscountOrChargeCalculationRules>;
        };
        lookups(
            dataOrId: string | { data: SalesInvoiceDiscountOrChargeCalculationRulesInput },
        ): SalesInvoiceDiscountOrChargeCalculationRules$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoiceDiscountOrChargeCalculationRules>;
    }
    export interface SalesInvoiceInvoicingElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoicingElement: SalesInvoicingElement;
        percentageOrAmount: string;
        valueType: ValueType;
        sageSalesTax: MiscellaneousTable;
    }
    export interface SalesInvoiceInvoicingElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        invoicingElement?: integer | string;
        percentageOrAmount?: decimal | string;
        valueType?: ValueType;
        sageSalesTax?: string;
    }
    export interface SalesInvoiceInvoicingElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoicingElement: SalesInvoicingElement;
        percentageOrAmount: string;
        valueType: ValueType;
        sageSalesTax: MiscellaneousTable;
    }
    export interface SalesInvoiceInvoicingElements$Lookups {
        invoicingElement: QueryOperation<SalesInvoicingElement>;
        sageSalesTax: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesInvoiceInvoicingElements$Operations {
        query: QueryOperation<SalesInvoiceInvoicingElements>;
        read: ReadOperation<SalesInvoiceInvoicingElements>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceInvoicingElements>;
            query: AggregateQueryOperation<SalesInvoiceInvoicingElements>;
        };
        lookups(dataOrId: string | { data: SalesInvoiceInvoicingElementsInput }): SalesInvoiceInvoicingElements$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoiceInvoicingElements>;
    }
    export interface SalesInvoiceLineDistributedInvoicingElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesInvoice: string;
        lineNumber: integer;
        distributedLineInvoicingElementNumber: SalesInvoicingElement;
        distributedLineInvoicingElementAmount: string;
        distributedLineInvoicingElementDiscount: string;
    }
    export interface SalesInvoiceLineDistributedInvoicingElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesInvoice?: string;
        lineNumber?: integer | string;
        distributedLineInvoicingElementNumber?: integer | string;
        distributedLineInvoicingElementAmount?: decimal | string;
        distributedLineInvoicingElementDiscount?: decimal | string;
    }
    export interface SalesInvoiceLineDistributedInvoicingElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesInvoice: string;
        lineNumber: integer;
        distributedLineInvoicingElementNumber: SalesInvoicingElement;
        distributedLineInvoicingElementAmount: string;
        distributedLineInvoicingElementDiscount: string;
    }
    export interface SalesInvoiceLineDistributedInvoicingElements$Lookups {
        distributedLineInvoicingElementNumber: QueryOperation<SalesInvoicingElement>;
    }
    export interface SalesInvoiceLineDistributedInvoicingElements$Operations {
        query: QueryOperation<SalesInvoiceLineDistributedInvoicingElements>;
        read: ReadOperation<SalesInvoiceLineDistributedInvoicingElements>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceLineDistributedInvoicingElements>;
            query: AggregateQueryOperation<SalesInvoiceLineDistributedInvoicingElements>;
        };
        lookups(
            dataOrId: string | { data: SalesInvoiceLineDistributedInvoicingElementsInput },
        ): SalesInvoiceLineDistributedInvoicingElements$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoiceLineDistributedInvoicingElements>;
    }
    export interface SalesInvoiceLineProductStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesInvoice: string;
        lineNumber: integer;
        value: MiscellaneousTable;
    }
    export interface SalesInvoiceLineProductStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesInvoice?: string;
        lineNumber?: integer | string;
        value?: string;
    }
    export interface SalesInvoiceLineProductStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesInvoice: string;
        lineNumber: integer;
        value: MiscellaneousTable;
    }
    export interface SalesInvoiceLineProductStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesInvoiceLineProductStatisticalGroups$Operations {
        query: QueryOperation<SalesInvoiceLineProductStatisticalGroups>;
        read: ReadOperation<SalesInvoiceLineProductStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceLineProductStatisticalGroups>;
            query: AggregateQueryOperation<SalesInvoiceLineProductStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: SalesInvoiceLineProductStatisticalGroupsInput },
        ): SalesInvoiceLineProductStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoiceLineProductStatisticalGroups>;
    }
    export interface SalesInvoiceLineTaxBasisAmounts extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesInvoice: string;
        lineNumber: integer;
        taxBasisAmount: string;
    }
    export interface SalesInvoiceLineTaxBasisAmountsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesInvoice?: string;
        lineNumber?: integer | string;
        taxBasisAmount?: decimal | string;
    }
    export interface SalesInvoiceLineTaxBasisAmountsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesInvoice: string;
        lineNumber: integer;
        taxBasisAmount: string;
    }
    export interface SalesInvoiceLineTaxBasisAmounts$Operations {
        query: QueryOperation<SalesInvoiceLineTaxBasisAmounts>;
        read: ReadOperation<SalesInvoiceLineTaxBasisAmounts>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceLineTaxBasisAmounts>;
            query: AggregateQueryOperation<SalesInvoiceLineTaxBasisAmounts>;
        };
        getDefaults: GetDefaultsOperation<SalesInvoiceLineTaxBasisAmounts>;
    }
    export interface SalesInvoiceLineTaxes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesInvoice: string;
        lineNumber: integer;
        taxLevel: TaxLevel;
        tax: Tax;
        taxAmount: string;
    }
    export interface SalesInvoiceLineTaxesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesInvoice?: string;
        lineNumber?: integer | string;
        taxLevel?: string;
        tax?: string;
        taxAmount?: decimal | string;
    }
    export interface SalesInvoiceLineTaxesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesInvoice: string;
        lineNumber: integer;
        taxLevel: TaxLevel;
        tax: Tax;
        taxAmount: string;
    }
    export interface SalesInvoiceLineTaxes$Lookups {
        taxLevel: QueryOperation<TaxLevel>;
        tax: QueryOperation<Tax>;
    }
    export interface SalesInvoiceLineTaxes$Operations {
        query: QueryOperation<SalesInvoiceLineTaxes>;
        read: ReadOperation<SalesInvoiceLineTaxes>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceLineTaxes>;
            query: AggregateQueryOperation<SalesInvoiceLineTaxes>;
        };
        lookups(dataOrId: string | { data: SalesInvoiceLineTaxesInput }): SalesInvoiceLineTaxes$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoiceLineTaxes>;
    }
    export interface SalesInvoiceLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesInvoice: SalesInvoice;
        lineNumber: integer;
        company: Company;
        salesOrderNumber: SalesOrder;
        salesOrderLineNumber: integer;
        salesOrderLine: SalesOrderLine;
        salesDelivery: SalesDelivery;
        salesDeliveryLine: SalesDeliveryLine;
        sourceSalesInvoice: SalesInvoice;
        sourceSalesInvoiceLine: SalesInvoiceLine;
        salesReturn: SalesReturn;
        salesReturnLine: SalesReturnLine;
        billToCustomer: Customer;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRep1CommissionBase: string;
        salesRep2CommissionBase: string;
        salesRep1CommissionAmount: string;
        salesRep2CommissionAmount: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        lineAmountEnteredManually: string;
        lineAmountExcludingTax: string;
        discountLineAmount: string;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        taxRate: string;
        lineAmountIncludingTax: string;
        isLineWithDistributedInvoicingElement: boolean;
        quantityInSalesUnitInvoiced: string;
        quantityInStockUnitInvoiced: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        shippingSite: Site;
        productStockManagement: StockManagement;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        preferentialStockLocationFilter: Location;
        stockPriceInCreditMemoWithStockMovement: string;
        allocationType: TypeOfAllocation;
        salesSite: Site;
        invoiceDate: string;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesInvoiceLine;
        isExtractedIntrastatLine: boolean;
        isIntrastatPhysicalFlow: boolean;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        isPrintedOnInvoice: boolean;
        serviceStartDate: string;
        serviceEndDate: string;
        servicePeriodNumber: integer;
        servicePeriodType: PeriodicityType;
        tokenManagement: string;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        warehouse: Warehouse;
        project: ProjectLink;
        importLineNumber: integer;
        sourceDocumentType: SalesInvoiceSource;
        invoicePercentageForScheduledInvoice: string;
        scheduledInvoiceLineNumber: integer;
        scheduledinvoiceSource: SalesDocumentType;
        invoiceLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesInvoiceLineDistributedInvoicingElements>;
        productStatisticalGroups: ClientCollection<SalesInvoiceLineProductStatisticalGroups>;
        taxBasisAmounts: ClientCollection<SalesInvoiceLineTaxBasisAmounts>;
        taxes: ClientCollection<SalesInvoiceLineTaxes>;
    }
    export interface SalesInvoiceLineInput extends ClientNodeInput {
        salesInvoice?: string;
        lineNumber?: integer | string;
        company?: string;
        salesOrderNumber?: string;
        salesOrderLineNumber?: integer | string;
        salesOrderLine?: integer | string;
        salesDelivery?: string;
        salesDeliveryLine?: integer | string;
        sourceSalesInvoice?: string;
        sourceSalesInvoiceLine?: integer | string;
        salesReturn?: string;
        salesReturnLine?: integer | string;
        billToCustomer?: string;
        product?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        salesRep1?: string;
        salesRep2?: string;
        salesRep1CommissionRate?: decimal | string;
        salesRep2CommissionRate?: decimal | string;
        salesRep1CommissionBase?: decimal | string;
        salesRep2CommissionBase?: decimal | string;
        salesRep1CommissionAmount?: decimal | string;
        salesRep2CommissionAmount?: decimal | string;
        salesRepCommissionFactor?: decimal | string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        netPrice?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        margin?: decimal | string;
        costPrice?: decimal | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        lineAmountEnteredManually?: decimal | string;
        lineAmountExcludingTax?: decimal | string;
        discountLineAmount?: decimal | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        taxRate?: decimal | string;
        lineAmountIncludingTax?: decimal | string;
        isLineWithDistributedInvoicingElement?: boolean | string;
        quantityInSalesUnitInvoiced?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        shippingSite?: string;
        productStockManagement?: StockManagement;
        exclusiveLotFilter?: string;
        exclusiveStockStatusFilter?: string;
        preferentialStockLocationFilter?: string;
        stockPriceInCreditMemoWithStockMovement?: decimal | string;
        allocationType?: TypeOfAllocation;
        salesSite?: string;
        invoiceDate?: string;
        lineType?: LineType;
        freeProduct?: Free;
        freeProductLineSource?: integer | string;
        isExtractedIntrastatLine?: boolean | string;
        isIntrastatPhysicalFlow?: boolean | string;
        geographicCode?: string;
        insideCityLimits?: string;
        isTaxedGeographically?: string;
        isTaxable?: boolean | string;
        isRecordedTax?: boolean | string;
        isPrintedOnInvoice?: boolean | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        servicePeriodNumber?: integer | string;
        servicePeriodType?: PeriodicityType;
        tokenManagement?: decimal | string;
        weightDistributedOnLine?: decimal | string;
        volumeDistributedOnLine?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        warehouse?: string;
        project?: string;
        importLineNumber?: integer | string;
        sourceDocumentType?: SalesInvoiceSource;
        invoicePercentageForScheduledInvoice?: decimal | string;
        scheduledInvoiceLineNumber?: integer | string;
        scheduledinvoiceSource?: SalesDocumentType;
        invoiceLineText?: TextStream;
        distributedInvoicingElements?: Partial<SalesInvoiceLineDistributedInvoicingElementsInput>[];
        productStatisticalGroups?: Partial<SalesInvoiceLineProductStatisticalGroupsInput>[];
        taxBasisAmounts?: Partial<SalesInvoiceLineTaxBasisAmountsInput>[];
        taxes?: Partial<SalesInvoiceLineTaxesInput>[];
    }
    export interface SalesInvoiceLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesInvoice: SalesInvoice;
        lineNumber: integer;
        company: Company;
        salesOrderNumber: SalesOrder;
        salesOrderLineNumber: integer;
        salesOrderLine: SalesOrderLine;
        salesDelivery: SalesDelivery;
        salesDeliveryLine: SalesDeliveryLine;
        sourceSalesInvoice: SalesInvoice;
        sourceSalesInvoiceLine: SalesInvoiceLine;
        salesReturn: SalesReturn;
        salesReturnLine: SalesReturnLine;
        billToCustomer: Customer;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRep1CommissionBase: string;
        salesRep2CommissionBase: string;
        salesRep1CommissionAmount: string;
        salesRep2CommissionAmount: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        lineAmountEnteredManually: string;
        lineAmountExcludingTax: string;
        discountLineAmount: string;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        taxRate: string;
        lineAmountIncludingTax: string;
        isLineWithDistributedInvoicingElement: boolean;
        quantityInSalesUnitInvoiced: string;
        quantityInStockUnitInvoiced: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        shippingSite: Site;
        productStockManagement: StockManagement;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        preferentialStockLocationFilter: Location;
        stockPriceInCreditMemoWithStockMovement: string;
        allocationType: TypeOfAllocation;
        salesSite: Site;
        invoiceDate: string;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesInvoiceLine;
        isExtractedIntrastatLine: boolean;
        isIntrastatPhysicalFlow: boolean;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        isPrintedOnInvoice: boolean;
        serviceStartDate: string;
        serviceEndDate: string;
        servicePeriodNumber: integer;
        servicePeriodType: PeriodicityType;
        tokenManagement: string;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        warehouse: Warehouse;
        project: ProjectLink;
        importLineNumber: integer;
        sourceDocumentType: SalesInvoiceSource;
        invoicePercentageForScheduledInvoice: string;
        scheduledInvoiceLineNumber: integer;
        scheduledinvoiceSource: SalesDocumentType;
        invoiceLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesInvoiceLineDistributedInvoicingElementsBinding>;
        productStatisticalGroups: ClientCollection<SalesInvoiceLineProductStatisticalGroupsBinding>;
        taxBasisAmounts: ClientCollection<SalesInvoiceLineTaxBasisAmountsBinding>;
        taxes: ClientCollection<SalesInvoiceLineTaxesBinding>;
    }
    export interface SalesInvoiceLine$Lookups {
        salesInvoice: QueryOperation<SalesInvoice>;
        company: QueryOperation<Company>;
        salesOrderNumber: QueryOperation<SalesOrder>;
        salesOrderLine: QueryOperation<SalesOrderLine>;
        salesDelivery: QueryOperation<SalesDelivery>;
        salesDeliveryLine: QueryOperation<SalesDeliveryLine>;
        sourceSalesInvoice: QueryOperation<SalesInvoice>;
        sourceSalesInvoiceLine: QueryOperation<SalesInvoiceLine>;
        salesReturn: QueryOperation<SalesReturn>;
        salesReturnLine: QueryOperation<SalesReturnLine>;
        billToCustomer: QueryOperation<Customer>;
        product: QueryOperation<Product>;
        majorProductVersion: QueryOperation<MajorVersionStatus>;
        salesRep1: QueryOperation<SalesRep>;
        salesRep2: QueryOperation<SalesRep>;
        priceReason: QueryOperation<SalesPriceReason>;
        discountOrCharge1Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge2Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge3Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge4Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge5Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge6Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge7Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge8Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge9Reason: QueryOperation<SalesPriceReason>;
        salesUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        shippingSite: QueryOperation<Site>;
        preferentialStockLocationFilter: QueryOperation<Location>;
        salesSite: QueryOperation<Site>;
        freeProductLineSource: QueryOperation<SalesInvoiceLine>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        warehouse: QueryOperation<Warehouse>;
        project: QueryOperation<ProjectLink>;
    }
    export interface SalesInvoiceLine$Operations {
        query: QueryOperation<SalesInvoiceLine>;
        read: ReadOperation<SalesInvoiceLine>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceLine>;
            query: AggregateQueryOperation<SalesInvoiceLine>;
        };
        lookups(dataOrId: string | { data: SalesInvoiceLineInput }): SalesInvoiceLine$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoiceLine>;
    }
    export interface SalesInvoiceSalesOrderOfPrepayments extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        paymentMethodOfPrepayments: PaymentMethod;
        prepaymentAmountIncludingTax: string;
        salesOrderOfPrepayment: string;
        salesOrderLineNumberOfPrepayment: OpenItem;
    }
    export interface SalesInvoiceSalesOrderOfPrepaymentsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        paymentMethodOfPrepayments?: string;
        prepaymentAmountIncludingTax?: decimal | string;
        salesOrderOfPrepayment?: string;
        salesOrderLineNumberOfPrepayment?: integer | string;
    }
    export interface SalesInvoiceSalesOrderOfPrepaymentsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        paymentMethodOfPrepayments: PaymentMethod;
        prepaymentAmountIncludingTax: string;
        salesOrderOfPrepayment: string;
        salesOrderLineNumberOfPrepayment: OpenItem;
    }
    export interface SalesInvoiceSalesOrderOfPrepayments$Lookups {
        paymentMethodOfPrepayments: QueryOperation<PaymentMethod>;
        salesOrderLineNumberOfPrepayment: QueryOperation<OpenItem>;
    }
    export interface SalesInvoiceSalesOrderOfPrepayments$Operations {
        query: QueryOperation<SalesInvoiceSalesOrderOfPrepayments>;
        read: ReadOperation<SalesInvoiceSalesOrderOfPrepayments>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceSalesOrderOfPrepayments>;
            query: AggregateQueryOperation<SalesInvoiceSalesOrderOfPrepayments>;
        };
        lookups(
            dataOrId: string | { data: SalesInvoiceSalesOrderOfPrepaymentsInput },
        ): SalesInvoiceSalesOrderOfPrepayments$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoiceSalesOrderOfPrepayments>;
    }
    export interface SalesInvoiceSalesReps extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        salesRep: SalesRep;
    }
    export interface SalesInvoiceSalesRepsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        salesRep?: string;
    }
    export interface SalesInvoiceSalesRepsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        salesRep: SalesRep;
    }
    export interface SalesInvoiceSalesReps$Lookups {
        salesRep: QueryOperation<SalesRep>;
    }
    export interface SalesInvoiceSalesReps$Operations {
        query: QueryOperation<SalesInvoiceSalesReps>;
        read: ReadOperation<SalesInvoiceSalesReps>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceSalesReps>;
            query: AggregateQueryOperation<SalesInvoiceSalesReps>;
        };
        lookups(dataOrId: string | { data: SalesInvoiceSalesRepsInput }): SalesInvoiceSalesReps$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoiceSalesReps>;
    }
    export interface SalesInvoiceShipToCustomerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesInvoiceShipToCustomerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SalesInvoiceShipToCustomerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesInvoiceShipToCustomerAddressLines$Operations {
        query: QueryOperation<SalesInvoiceShipToCustomerAddressLines>;
        read: ReadOperation<SalesInvoiceShipToCustomerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceShipToCustomerAddressLines>;
            query: AggregateQueryOperation<SalesInvoiceShipToCustomerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SalesInvoiceShipToCustomerAddressLines>;
    }
    export interface SalesInvoiceShipToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesInvoiceShipToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SalesInvoiceShipToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesInvoiceShipToCustomerCompanyNames$Operations {
        query: QueryOperation<SalesInvoiceShipToCustomerCompanyNames>;
        read: ReadOperation<SalesInvoiceShipToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceShipToCustomerCompanyNames>;
            query: AggregateQueryOperation<SalesInvoiceShipToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SalesInvoiceShipToCustomerCompanyNames>;
    }
    export interface SalesInvoice extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: CustomerInvoiceHeader;
        company: Company;
        salesSite: Site;
        shippingSite: Site;
        billToCustomer: Customer;
        soldToCustomer: Customer;
        groupCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        billToCustomerEuropeanUnionVatNumber: string;
        billToCustomerContact: CustomerContact;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: CustomerContact;
        payByBusinessPartner: BusinessPartner;
        factor: Factor;
        invoiceType: SalesInvoiceType;
        category: InvoiceType;
        sourceDocumentCategory: SalesInvoiceSource;
        sourceDocumentNumber: string;
        sourceDocumentDate: string;
        invoiceDate: string;
        currency: Currency;
        status: InvoiceStatus;
        isOnCreditMemo: boolean;
        hasStockTransaction: boolean;
        internalReference: string;
        project: ProjectLink;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        creditMemoReason: MiscellaneousTable;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        billToCustomerLanguage: Language;
        isIntersite: boolean;
        isIntercompany: boolean;
        sourceSite: Site;
        numberOfLines: integer;
        numberOfInvoiceCopies: integer;
        numberOfCreditMemoCopies: integer;
        stockMovementCode: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        dockLocation: Location;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatAdjustmentTransactionNature: IntrastatTransactionNature;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatAdjustmentStatisticalRule: IntrastatStatisticalRule;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        incoterm: Incoterm;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: CustomerAddress;
        geographicCode: string;
        insideCityLimits: string;
        marketingCampaign: string;
        priceStructure: PriceStructure;
        totalQuantityDistributedOnLines: string;
        totalWeightDistributedOnLines: string;
        totalVolumeDistributedOnLines: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        isPrinted: boolean;
        isValidatedAddress: boolean;
        departureDate: string;
        arrivalDate: string;
        departureTime: string;
        arrivalTime: string;
        vehicleLicensePlate: string;
        trailerLicensePlate: string;
        sourceDocumentType: SalesDocumentType;
        finalSequenceNumber: SalesInvoice;
        hasElectronicSignature: boolean;
        salesInvoiceLines: ClientCollection<SalesInvoiceLine>;
        customerInvoiceHeader: CustomerInvoiceHeader;
        accountingDate: string;
        billToCustomerAddress: CustomerAddress;
        billToCustomerAddressLines: ClientCollection<CustomerInvoiceHeaderBillToCustomerAddressLines>;
        billToCustomerCity: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        billToCustomerPostalCode: string;
        billToCustomerState: string;
        businessProcessType: MiscellaneousTable;
        cancellationStatus: integer;
        cashVatTaxRule: boolean;
        comments: ClientCollection<CustomerInvoiceHeaderComments>;
        control: string;
        correctionMethod: CorrectionMethod;
        creditMemoReferenceEndDate: string;
        creditMemoReferenceStartDate: string;
        currencyRates: ClientCollection<CustomerInvoiceHeaderCurrencyRates>;
        customerSourceDocument: string;
        customerSourceDocumentDate: string;
        debitOrCredit: integer;
        derCode: string;
        dimensions: ClientCollection<CustomerInvoiceHeaderDimensions>;
        dueDateCalculationStartDate: string;
        earlyDiscountOrLateChargeBasis: string;
        earlyDiscountOrLateChargeRate: string;
        entityUserCode: MiscellaneousTable;
        entryType: EntryType;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        fiscalYear: integer;
        inPaymentSlipWithReferenceNumber: string;
        internalNumber: integer;
        intrastatProcessingNumber: integer;
        invoiceFooterText: TextStream;
        invoiceHeaderText: TextStream;
        isDirectInvoice: boolean;
        isExternalDocument: boolean;
        journal: Journal;
        lastServiceAccountedDate: string;
        mandate: Mandate;
        numberOfTaxes: integer;
        originalDocumentNumber: string;
        originalInvoiceNumber: string;
        payByBusinessPartnerAddress: BusinessPartnerAddress;
        payByBusinessPartnerAddressLines: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
        payByBusinessPartnerCity: string;
        payByBusinessPartnerCompanyNames: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
        payByBusinessPartnerCountry: Country;
        payByBusinessPartnerCountryName: string;
        payByBusinessPartnerPostalCode: string;
        payByBusinessPartnerState: string;
        paymentBank: BankAccount;
        paymentTerm: PaymentTerm;
        period: integer;
        rateDate: string;
        rateType: ExchangeRateType;
        serviceEndDate: string;
        serviceStartDate: string;
        siteIdentificationNumber: string;
        sourceModule: ModuleTable;
        spanishInvoiceType: SpanishInvoiceType;
        stockMovementGroup: MiscellaneousTable;
        taxReferenceDate: string;
        taxes: ClientCollection<CustomerInvoiceHeaderTaxes>;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        vatDeclarationNumber: string;
        versionControlSystemNumber: string;
        warehouse: Warehouse;
        billToCustomerCompanyNames: ClientCollection<SalesInvoiceBillToCustomerCompanyNames>;
        customerStatisticalGroups: ClientCollection<SalesInvoiceCustomerStatisticalGroups>;
        discountOrChargeCalculationRules: ClientCollection<SalesInvoiceDiscountOrChargeCalculationRules>;
        invoicingElements: ClientCollection<SalesInvoiceInvoicingElements>;
        salesOrderOfPrepayments: ClientCollection<SalesInvoiceSalesOrderOfPrepayments>;
        salesReps: ClientCollection<SalesInvoiceSalesReps>;
        shipToCustomerAddressLines: ClientCollection<SalesInvoiceShipToCustomerAddressLines>;
        shipToCustomerCompanyNames: ClientCollection<SalesInvoiceShipToCustomerCompanyNames>;
    }
    export interface SalesInvoiceInput extends ClientNodeInput {
        id?: string;
        company?: string;
        salesSite?: string;
        shippingSite?: string;
        billToCustomer?: string;
        soldToCustomer?: string;
        groupCustomer?: string;
        shipToCustomerAddress?: string;
        billToCustomerEuropeanUnionVatNumber?: string;
        billToCustomerContact?: string;
        shipToCustomerPostalCode?: string;
        shipToCustomerCity?: string;
        shipToCustomerState?: string;
        shipToCustomerCountry?: string;
        shipToCustomerCountryName?: string;
        shipToCustomerContact?: string;
        payByBusinessPartner?: string;
        factor?: string;
        invoiceType?: string;
        category?: InvoiceType;
        sourceDocumentCategory?: SalesInvoiceSource;
        sourceDocumentNumber?: string;
        sourceDocumentDate?: string;
        invoiceDate?: string;
        currency?: string;
        status?: InvoiceStatus;
        isOnCreditMemo?: boolean | string;
        hasStockTransaction?: boolean | string;
        internalReference?: string;
        project?: string;
        priceIncludingOrExcludingTax?: PriceAmountTaxTax;
        creditMemoReason?: string;
        earlyDiscountOrLateCharge?: string;
        billToCustomerLanguage?: string;
        isIntersite?: boolean | string;
        isIntercompany?: boolean | string;
        sourceSite?: string;
        numberOfLines?: integer | string;
        numberOfInvoiceCopies?: integer | string;
        numberOfCreditMemoCopies?: integer | string;
        stockMovementCode?: string;
        stockAutomaticJournal?: string;
        dockLocation?: string;
        intrastatTransactionNature?: string;
        intrastatAdjustmentTransactionNature?: string;
        intrastatStatisticalRule?: string;
        intrastatAdjustmentStatisticalRule?: string;
        intrastatTransportLocation?: CountryLocation;
        intrastatTransportMode?: IntrastatTransportMode;
        incoterm?: string;
        incotermTown?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        geographicCode?: string;
        insideCityLimits?: string;
        marketingCampaign?: string;
        priceStructure?: string;
        totalQuantityDistributedOnLines?: decimal | string;
        totalWeightDistributedOnLines?: decimal | string;
        totalVolumeDistributedOnLines?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        isPrinted?: boolean | string;
        isValidatedAddress?: boolean | string;
        departureDate?: string;
        arrivalDate?: string;
        departureTime?: string;
        arrivalTime?: string;
        vehicleLicensePlate?: string;
        trailerLicensePlate?: string;
        sourceDocumentType?: SalesDocumentType;
        finalSequenceNumber?: string;
        hasElectronicSignature?: boolean | string;
        salesInvoiceLines?: Partial<SalesInvoiceLineInput>[];
        customerInvoiceHeader?: string;
        accountingDate?: string;
        billToCustomerAddress?: string;
        billToCustomerAddressLines?: Partial<CustomerInvoiceHeaderBillToCustomerAddressLinesInput>[];
        billToCustomerCity?: string;
        billToCustomerCountry?: string;
        billToCustomerCountryName?: string;
        billToCustomerPostalCode?: string;
        billToCustomerState?: string;
        businessProcessType?: string;
        cancellationStatus?: integer | string;
        cashVatTaxRule?: boolean | string;
        comments?: Partial<CustomerInvoiceHeaderCommentsInput>[];
        control?: string;
        correctionMethod?: CorrectionMethod;
        creditMemoReferenceEndDate?: string;
        creditMemoReferenceStartDate?: string;
        currencyRates?: Partial<CustomerInvoiceHeaderCurrencyRatesInput>[];
        customerSourceDocument?: string;
        customerSourceDocumentDate?: string;
        debitOrCredit?: integer | string;
        derCode?: string;
        dimensions?: Partial<CustomerInvoiceHeaderDimensionsInput>[];
        dueDateCalculationStartDate?: string;
        earlyDiscountOrLateChargeBasis?: decimal | string;
        earlyDiscountOrLateChargeRate?: decimal | string;
        entityUserCode?: string;
        entryType?: string;
        field40Reason?: string;
        field41Reason?: string;
        fiscalYear?: integer | string;
        inPaymentSlipWithReferenceNumber?: string;
        internalNumber?: integer | string;
        intrastatProcessingNumber?: integer | string;
        invoiceFooterText?: TextStream;
        invoiceHeaderText?: TextStream;
        isDirectInvoice?: boolean | string;
        isExternalDocument?: boolean | string;
        journal?: string;
        lastServiceAccountedDate?: string;
        mandate?: string;
        numberOfTaxes?: integer | string;
        originalDocumentNumber?: string;
        originalInvoiceNumber?: string;
        payByBusinessPartnerAddress?: string;
        payByBusinessPartnerAddressLines?: Partial<CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesInput>[];
        payByBusinessPartnerCity?: string;
        payByBusinessPartnerCompanyNames?: Partial<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesInput>[];
        payByBusinessPartnerCountry?: string;
        payByBusinessPartnerCountryName?: string;
        payByBusinessPartnerPostalCode?: string;
        payByBusinessPartnerState?: string;
        paymentBank?: string;
        paymentTerm?: string;
        period?: integer | string;
        rateDate?: string;
        rateType?: ExchangeRateType;
        serviceEndDate?: string;
        serviceStartDate?: string;
        siteIdentificationNumber?: string;
        sourceModule?: ModuleTable;
        spanishInvoiceType?: SpanishInvoiceType;
        stockMovementGroup?: string;
        taxReferenceDate?: string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        vatDeclarationNumber?: string;
        versionControlSystemNumber?: string;
        warehouse?: string;
        billToCustomerCompanyNames?: Partial<SalesInvoiceBillToCustomerCompanyNamesInput>[];
        customerStatisticalGroups?: Partial<SalesInvoiceCustomerStatisticalGroupsInput>[];
        discountOrChargeCalculationRules?: Partial<SalesInvoiceDiscountOrChargeCalculationRulesInput>[];
        invoicingElements?: Partial<SalesInvoiceInvoicingElementsInput>[];
        salesOrderOfPrepayments?: Partial<SalesInvoiceSalesOrderOfPrepaymentsInput>[];
        salesReps?: Partial<SalesInvoiceSalesRepsInput>[];
        shipToCustomerAddressLines?: Partial<SalesInvoiceShipToCustomerAddressLinesInput>[];
        shipToCustomerCompanyNames?: Partial<SalesInvoiceShipToCustomerCompanyNamesInput>[];
    }
    export interface SalesInvoiceBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: CustomerInvoiceHeader;
        company: Company;
        salesSite: Site;
        shippingSite: Site;
        billToCustomer: Customer;
        soldToCustomer: Customer;
        groupCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        billToCustomerEuropeanUnionVatNumber: string;
        billToCustomerContact: CustomerContact;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: CustomerContact;
        payByBusinessPartner: BusinessPartner;
        factor: Factor;
        invoiceType: SalesInvoiceType;
        category: InvoiceType;
        sourceDocumentCategory: SalesInvoiceSource;
        sourceDocumentNumber: string;
        sourceDocumentDate: string;
        invoiceDate: string;
        currency: Currency;
        status: InvoiceStatus;
        isOnCreditMemo: boolean;
        hasStockTransaction: boolean;
        internalReference: string;
        project: ProjectLink;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        creditMemoReason: MiscellaneousTable;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        billToCustomerLanguage: Language;
        isIntersite: boolean;
        isIntercompany: boolean;
        sourceSite: Site;
        numberOfLines: integer;
        numberOfInvoiceCopies: integer;
        numberOfCreditMemoCopies: integer;
        stockMovementCode: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        dockLocation: Location;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatAdjustmentTransactionNature: IntrastatTransactionNature;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatAdjustmentStatisticalRule: IntrastatStatisticalRule;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        incoterm: Incoterm;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: CustomerAddress;
        geographicCode: string;
        insideCityLimits: string;
        marketingCampaign: string;
        priceStructure: PriceStructure;
        totalQuantityDistributedOnLines: string;
        totalWeightDistributedOnLines: string;
        totalVolumeDistributedOnLines: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        isPrinted: boolean;
        isValidatedAddress: boolean;
        departureDate: string;
        arrivalDate: string;
        departureTime: string;
        arrivalTime: string;
        vehicleLicensePlate: string;
        trailerLicensePlate: string;
        sourceDocumentType: SalesDocumentType;
        finalSequenceNumber: SalesInvoice;
        hasElectronicSignature: boolean;
        salesInvoiceLines: ClientCollection<SalesInvoiceLine>;
        customerInvoiceHeader: CustomerInvoiceHeader;
        accountingDate: string;
        billToCustomerAddress: CustomerAddress;
        billToCustomerAddressLines: ClientCollection<CustomerInvoiceHeaderBillToCustomerAddressLines>;
        billToCustomerCity: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        billToCustomerPostalCode: string;
        billToCustomerState: string;
        businessProcessType: MiscellaneousTable;
        cancellationStatus: integer;
        cashVatTaxRule: boolean;
        comments: ClientCollection<CustomerInvoiceHeaderComments>;
        control: string;
        correctionMethod: CorrectionMethod;
        creditMemoReferenceEndDate: string;
        creditMemoReferenceStartDate: string;
        currencyRates: ClientCollection<CustomerInvoiceHeaderCurrencyRates>;
        customerSourceDocument: string;
        customerSourceDocumentDate: string;
        debitOrCredit: integer;
        derCode: string;
        dimensions: ClientCollection<CustomerInvoiceHeaderDimensions>;
        dueDateCalculationStartDate: string;
        earlyDiscountOrLateChargeBasis: string;
        earlyDiscountOrLateChargeRate: string;
        entityUserCode: MiscellaneousTable;
        entryType: EntryType;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        fiscalYear: integer;
        inPaymentSlipWithReferenceNumber: string;
        internalNumber: integer;
        intrastatProcessingNumber: integer;
        invoiceFooterText: TextStream;
        invoiceHeaderText: TextStream;
        isDirectInvoice: boolean;
        isExternalDocument: boolean;
        journal: Journal;
        lastServiceAccountedDate: string;
        mandate: Mandate;
        numberOfTaxes: integer;
        originalDocumentNumber: string;
        originalInvoiceNumber: string;
        payByBusinessPartnerAddress: BusinessPartnerAddress;
        payByBusinessPartnerAddressLines: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
        payByBusinessPartnerCity: string;
        payByBusinessPartnerCompanyNames: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
        payByBusinessPartnerCountry: Country;
        payByBusinessPartnerCountryName: string;
        payByBusinessPartnerPostalCode: string;
        payByBusinessPartnerState: string;
        paymentBank: BankAccount;
        paymentTerm: PaymentTerm;
        period: integer;
        rateDate: string;
        rateType: ExchangeRateType;
        serviceEndDate: string;
        serviceStartDate: string;
        siteIdentificationNumber: string;
        sourceModule: ModuleTable;
        spanishInvoiceType: SpanishInvoiceType;
        stockMovementGroup: MiscellaneousTable;
        taxReferenceDate: string;
        taxes: ClientCollection<CustomerInvoiceHeaderTaxes>;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        vatDeclarationNumber: string;
        versionControlSystemNumber: string;
        warehouse: Warehouse;
        billToCustomerCompanyNames: ClientCollection<SalesInvoiceBillToCustomerCompanyNamesBinding>;
        customerStatisticalGroups: ClientCollection<SalesInvoiceCustomerStatisticalGroupsBinding>;
        discountOrChargeCalculationRules: ClientCollection<SalesInvoiceDiscountOrChargeCalculationRulesBinding>;
        invoicingElements: ClientCollection<SalesInvoiceInvoicingElementsBinding>;
        salesOrderOfPrepayments: ClientCollection<SalesInvoiceSalesOrderOfPrepaymentsBinding>;
        salesReps: ClientCollection<SalesInvoiceSalesRepsBinding>;
        shipToCustomerAddressLines: ClientCollection<SalesInvoiceShipToCustomerAddressLinesBinding>;
        shipToCustomerCompanyNames: ClientCollection<SalesInvoiceShipToCustomerCompanyNamesBinding>;
    }
    export interface SalesInvoice$Lookups {
        id: QueryOperation<CustomerInvoiceHeader>;
        company: QueryOperation<Company>;
        salesSite: QueryOperation<Site>;
        shippingSite: QueryOperation<Site>;
        billToCustomer: QueryOperation<Customer>;
        soldToCustomer: QueryOperation<Customer>;
        groupCustomer: QueryOperation<Customer>;
        shipToCustomerAddress: QueryOperation<ShipToCustomerAddress>;
        billToCustomerContact: QueryOperation<CustomerContact>;
        shipToCustomerCountry: QueryOperation<Country>;
        shipToCustomerContact: QueryOperation<CustomerContact>;
        payByBusinessPartner: QueryOperation<BusinessPartner>;
        factor: QueryOperation<Factor>;
        invoiceType: QueryOperation<SalesInvoiceType>;
        currency: QueryOperation<Currency>;
        project: QueryOperation<ProjectLink>;
        creditMemoReason: QueryOperation<MiscellaneousTable>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        billToCustomerLanguage: QueryOperation<Language>;
        sourceSite: QueryOperation<Site>;
        stockMovementCode: QueryOperation<MiscellaneousTable>;
        stockAutomaticJournal: QueryOperation<AutomaticJournal>;
        dockLocation: QueryOperation<Location>;
        intrastatTransactionNature: QueryOperation<IntrastatTransactionNature>;
        intrastatAdjustmentTransactionNature: QueryOperation<IntrastatTransactionNature>;
        intrastatStatisticalRule: QueryOperation<IntrastatStatisticalRule>;
        intrastatAdjustmentStatisticalRule: QueryOperation<IntrastatStatisticalRule>;
        incoterm: QueryOperation<Incoterm>;
        forwardingAgent: QueryOperation<Carrier>;
        forwardingAgentAddress: QueryOperation<CustomerAddress>;
        priceStructure: QueryOperation<PriceStructure>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        finalSequenceNumber: QueryOperation<SalesInvoice>;
        customerInvoiceHeader: QueryOperation<CustomerInvoiceHeader>;
        billToCustomerAddress: QueryOperation<CustomerAddress>;
        billToCustomerCountry: QueryOperation<Country>;
        businessProcessType: QueryOperation<MiscellaneousTable>;
        entityUserCode: QueryOperation<MiscellaneousTable>;
        entryType: QueryOperation<EntryType>;
        field40Reason: QueryOperation<MiscellaneousTable>;
        field41Reason: QueryOperation<MiscellaneousTable>;
        journal: QueryOperation<Journal>;
        mandate: QueryOperation<Mandate>;
        payByBusinessPartnerAddress: QueryOperation<BusinessPartnerAddress>;
        payByBusinessPartnerCountry: QueryOperation<Country>;
        paymentBank: QueryOperation<BankAccount>;
        paymentTerm: QueryOperation<PaymentTerm>;
        stockMovementGroup: QueryOperation<MiscellaneousTable>;
        warehouse: QueryOperation<Warehouse>;
    }
    export interface SalesInvoice$Operations {
        query: QueryOperation<SalesInvoice>;
        read: ReadOperation<SalesInvoice>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoice>;
            query: AggregateQueryOperation<SalesInvoice>;
        };
        lookups(dataOrId: string | { data: SalesInvoiceInput }): SalesInvoice$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoice>;
    }
    export interface SalesOrderBillToCustomerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesOrderBillToCustomerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SalesOrderBillToCustomerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesOrderBillToCustomerAddressLines$Operations {
        query: QueryOperation<SalesOrderBillToCustomerAddressLines>;
        read: ReadOperation<SalesOrderBillToCustomerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderBillToCustomerAddressLines>;
            query: AggregateQueryOperation<SalesOrderBillToCustomerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SalesOrderBillToCustomerAddressLines>;
    }
    export interface SalesOrderBillToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesOrderBillToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SalesOrderBillToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesOrderBillToCustomerCompanyNames$Operations {
        query: QueryOperation<SalesOrderBillToCustomerCompanyNames>;
        read: ReadOperation<SalesOrderBillToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderBillToCustomerCompanyNames>;
            query: AggregateQueryOperation<SalesOrderBillToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SalesOrderBillToCustomerCompanyNames>;
    }
    export interface SalesOrderCustomerStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        value: MiscellaneousTable;
    }
    export interface SalesOrderCustomerStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        value?: string;
    }
    export interface SalesOrderCustomerStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        value: MiscellaneousTable;
    }
    export interface SalesOrderCustomerStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesOrderCustomerStatisticalGroups$Operations {
        query: QueryOperation<SalesOrderCustomerStatisticalGroups>;
        read: ReadOperation<SalesOrderCustomerStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderCustomerStatisticalGroups>;
            query: AggregateQueryOperation<SalesOrderCustomerStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: SalesOrderCustomerStatisticalGroupsInput },
        ): SalesOrderCustomerStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderCustomerStatisticalGroups>;
    }
    export interface SalesOrderDimensions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface SalesOrderDimensionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        dimensionType?: string;
        dimension?: string;
    }
    export interface SalesOrderDimensionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface SalesOrderDimensions$Lookups {
        dimensionType: QueryOperation<DimensionType>;
        dimension: QueryOperation<Dimension>;
    }
    export interface SalesOrderDimensions$Operations {
        query: QueryOperation<SalesOrderDimensions>;
        read: ReadOperation<SalesOrderDimensions>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderDimensions>;
            query: AggregateQueryOperation<SalesOrderDimensions>;
        };
        lookups(dataOrId: string | { data: SalesOrderDimensionsInput }): SalesOrderDimensions$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderDimensions>;
    }
    export interface SalesOrderDiscountOrChargeCalculationRules extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        type: DiscountCalculationRules;
        invoicingElement: SalesInvoicingElement;
    }
    export interface SalesOrderDiscountOrChargeCalculationRulesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        type?: DiscountCalculationRules;
        invoicingElement?: integer | string;
    }
    export interface SalesOrderDiscountOrChargeCalculationRulesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        type: DiscountCalculationRules;
        invoicingElement: SalesInvoicingElement;
    }
    export interface SalesOrderDiscountOrChargeCalculationRules$Lookups {
        invoicingElement: QueryOperation<SalesInvoicingElement>;
    }
    export interface SalesOrderDiscountOrChargeCalculationRules$Operations {
        query: QueryOperation<SalesOrderDiscountOrChargeCalculationRules>;
        read: ReadOperation<SalesOrderDiscountOrChargeCalculationRules>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderDiscountOrChargeCalculationRules>;
            query: AggregateQueryOperation<SalesOrderDiscountOrChargeCalculationRules>;
        };
        lookups(
            dataOrId: string | { data: SalesOrderDiscountOrChargeCalculationRulesInput },
        ): SalesOrderDiscountOrChargeCalculationRules$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderDiscountOrChargeCalculationRules>;
    }
    export interface SalesOrderInvoicingElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        percentageOrAmount: string;
        valueType: ValueType;
        distributionKey: DistributionKey;
        invoicingElement: SalesInvoicingElement;
        sageSalesTax: MiscellaneousTable;
    }
    export interface SalesOrderInvoicingElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        percentageOrAmount?: decimal | string;
        valueType?: ValueType;
        distributionKey?: string;
        invoicingElement?: integer | string;
        sageSalesTax?: string;
    }
    export interface SalesOrderInvoicingElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        percentageOrAmount: string;
        valueType: ValueType;
        distributionKey: DistributionKey;
        invoicingElement: SalesInvoicingElement;
        sageSalesTax: MiscellaneousTable;
    }
    export interface SalesOrderInvoicingElements$Lookups {
        distributionKey: QueryOperation<DistributionKey>;
        invoicingElement: QueryOperation<SalesInvoicingElement>;
        sageSalesTax: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesOrderInvoicingElements$Operations {
        query: QueryOperation<SalesOrderInvoicingElements>;
        read: ReadOperation<SalesOrderInvoicingElements>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderInvoicingElements>;
            query: AggregateQueryOperation<SalesOrderInvoicingElements>;
        };
        lookups(dataOrId: string | { data: SalesOrderInvoicingElementsInput }): SalesOrderInvoicingElements$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderInvoicingElements>;
    }
    export interface SalesOrderLineDimensionDimensions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesOrder: string;
        salesOrderLine: integer;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface SalesOrderLineDimensionDimensionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesOrder?: string;
        salesOrderLine?: integer | string;
        dimensionType?: string;
        dimension?: string;
    }
    export interface SalesOrderLineDimensionDimensionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesOrder: string;
        salesOrderLine: integer;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface SalesOrderLineDimensionDimensions$Lookups {
        dimensionType: QueryOperation<DimensionType>;
        dimension: QueryOperation<Dimension>;
    }
    export interface SalesOrderLineDimensionDimensions$Operations {
        query: QueryOperation<SalesOrderLineDimensionDimensions>;
        read: ReadOperation<SalesOrderLineDimensionDimensions>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderLineDimensionDimensions>;
            query: AggregateQueryOperation<SalesOrderLineDimensionDimensions>;
        };
        lookups(
            dataOrId: string | { data: SalesOrderLineDimensionDimensionsInput },
        ): SalesOrderLineDimensionDimensions$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderLineDimensionDimensions>;
    }
    export interface SalesOrderLineDimension extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesOrder: SalesOrder;
        salesOrderLine: SalesOrderLine;
        dimensions: ClientCollection<SalesOrderLineDimensionDimensions>;
    }
    export interface SalesOrderLineDimensionInput extends ClientNodeInput {
        salesOrder?: string;
        salesOrderLine?: integer | string;
        dimensions?: Partial<SalesOrderLineDimensionDimensionsInput>[];
    }
    export interface SalesOrderLineDimensionBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesOrder: SalesOrder;
        salesOrderLine: SalesOrderLine;
        dimensions: ClientCollection<SalesOrderLineDimensionDimensionsBinding>;
    }
    export interface SalesOrderLineDimension$Lookups {
        salesOrder: QueryOperation<SalesOrder>;
        salesOrderLine: QueryOperation<SalesOrderLine>;
    }
    export interface SalesOrderLineDimension$Operations {
        query: QueryOperation<SalesOrderLineDimension>;
        read: ReadOperation<SalesOrderLineDimension>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderLineDimension>;
            query: AggregateQueryOperation<SalesOrderLineDimension>;
        };
        lookups(dataOrId: string | { data: SalesOrderLineDimensionInput }): SalesOrderLineDimension$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderLineDimension>;
    }
    export interface SalesOrderLineProductStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        value: MiscellaneousTable;
    }
    export interface SalesOrderLineProductStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        value?: string;
    }
    export interface SalesOrderLineProductStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        value: MiscellaneousTable;
    }
    export interface SalesOrderLineProductStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesOrderLineProductStatisticalGroups$Operations {
        query: QueryOperation<SalesOrderLineProductStatisticalGroups>;
        read: ReadOperation<SalesOrderLineProductStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderLineProductStatisticalGroups>;
            query: AggregateQueryOperation<SalesOrderLineProductStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: SalesOrderLineProductStatisticalGroupsInput },
        ): SalesOrderLineProductStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderLineProductStatisticalGroups>;
    }
    export interface SalesOrderLineTaxes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        taxLevel: TaxLevel;
        tax: Tax;
    }
    export interface SalesOrderLineTaxesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        taxLevel?: string;
        tax?: string;
    }
    export interface SalesOrderLineTaxesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        taxLevel: TaxLevel;
        tax: Tax;
    }
    export interface SalesOrderLineTaxes$Lookups {
        taxLevel: QueryOperation<TaxLevel>;
        tax: QueryOperation<Tax>;
    }
    export interface SalesOrderLineTaxes$Operations {
        query: QueryOperation<SalesOrderLineTaxes>;
        read: ReadOperation<SalesOrderLineTaxes>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderLineTaxes>;
            query: AggregateQueryOperation<SalesOrderLineTaxes>;
        };
        lookups(dataOrId: string | { data: SalesOrderLineTaxesInput }): SalesOrderLineTaxes$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderLineTaxes>;
    }
    export interface SalesOrderLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesOrder: SalesOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        category: OrderCategory;
        soldToCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        shipToCustomerContact: CustomerContact;
        billToCustomer: Customer;
        shippingSite: Site;
        salesSite: Site;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        customerProduct: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        lineStatus: LineStatus;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesOrderLine;
        salesQuote: SalesQuote;
        salesQuoteLineNumber: SalesQuoteLine;
        lineRevisionNumber: integer;
        sageSalesTax: MiscellaneousTable;
        consumerSalesPrice: string;
        invoicingTerm: InvoicingTerm;
        allocationType: AllocationType;
        backToBackOrderLineNumber: integer;
        backToBackOrderNumber: string;
        backToBackOrderSequenceNumber: integer;
        carrier: Carrier;
        closingDate: string;
        closingReason: MiscellaneousTable;
        completeDeliveryPriority: integer;
        deliveryLeadTime: integer;
        deliveryMode: DeliveryMode;
        deliveryPriority: DeliveryPriority;
        dimensions: ClientCollection<SalesOrderLineDimensionDimensions>;
        distributedInvoicingElements: ClientCollection<SalesOrderQuantityLineDistributedInvoicingElements>;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        expectedDeliveryDate: string;
        geographicCode: string;
        importLineNumber: integer;
        insideCityLimits: string;
        invoicedAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnInvoice: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isDeliverable: boolean;
        isInvoiced: boolean;
        isLineWithDistributedInvoicingElement: boolean;
        isRecordedTax: boolean;
        isTaxable: boolean;
        isTaxedGeographically: string;
        latestDeliveryDate: string;
        latestDeliveryTime: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        orderDate: string;
        orderLineText: TextStream;
        packaging: Packaging;
        packagingCapacity: string;
        preferentialStockLocationFilter: Location;
        preparationCode: string;
        productSource: SourceOfShipment;
        productStockManagement: StockManagement;
        project: ProjectLink;
        quantityInSalesUnitAllocated: string;
        quantityInSalesUnitDelivered: string;
        quantityInSalesUnitInPreparation: string;
        quantityInSalesUnitInitiallyOrdered: string;
        quantityInSalesUnitInvoiced: string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice: string;
        quantityInSalesUnitOnPickList: string;
        quantityInSalesUnitOrdered: string;
        quantityInSalesUnitPrepared: string;
        quantityInSalesUnitShortage: string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock: string;
        quantityInStockUnitAllocated: string;
        quantityInStockUnitDelivered: string;
        quantityInStockUnitInPreparation: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice: string;
        quantityInStockUnitOnPickList: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitPrepared: string;
        quantityInStockUnitShortage: string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock: string;
        requestedDeliveryDate: string;
        requestedDeliveryReference: string;
        requestedDeliveryTime: string;
        routeNumber: RouteCode;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        shipmentDate: string;
        shipmentTime: string;
        taxRate: string;
        taxableAmount: string;
        tokenManagement: string;
        useByDate: string;
        volumeDistributedOnLine: string;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        weightDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workInProgressStatus: StatusInProgress;
        productStatisticalGroups: ClientCollection<SalesOrderLineProductStatisticalGroups>;
        taxes: ClientCollection<SalesOrderLineTaxes>;
    }
    export interface SalesOrderLineInput extends ClientNodeInput {
        salesOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        company?: string;
        category?: OrderCategory;
        soldToCustomer?: string;
        shipToCustomerAddress?: string;
        shipToCustomerContact?: string;
        billToCustomer?: string;
        shippingSite?: string;
        salesSite?: string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        customerProduct?: string;
        salesRep1?: string;
        salesRep2?: string;
        salesRep1CommissionRate?: decimal | string;
        salesRep2CommissionRate?: decimal | string;
        salesRepCommissionFactor?: decimal | string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        netPrice?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        margin?: decimal | string;
        costPrice?: decimal | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        lineStatus?: LineStatus;
        lineType?: LineType;
        freeProduct?: Free;
        freeProductLineSource?: integer | string;
        salesQuote?: string;
        salesQuoteLineNumber?: integer | string;
        lineRevisionNumber?: integer | string;
        sageSalesTax?: string;
        consumerSalesPrice?: decimal | string;
        invoicingTerm?: string;
        allocationType?: AllocationType;
        backToBackOrderLineNumber?: integer | string;
        backToBackOrderNumber?: string;
        backToBackOrderSequenceNumber?: integer | string;
        carrier?: string;
        closingDate?: string;
        closingReason?: string;
        completeDeliveryPriority?: integer | string;
        deliveryLeadTime?: integer | string;
        deliveryMode?: string;
        deliveryPriority?: DeliveryPriority;
        dimensions?: Partial<SalesOrderLineDimensionDimensionsInput>[];
        distributedInvoicingElements?: Partial<SalesOrderQuantityLineDistributedInvoicingElementsInput>[];
        exclusiveLotFilter?: string;
        exclusiveStockStatusFilter?: string;
        expectedDeliveryDate?: string;
        geographicCode?: string;
        importLineNumber?: integer | string;
        insideCityLimits?: string;
        invoicedAmount?: decimal | string;
        isComponentPrintedOnAcknowledgement?: boolean | string;
        isComponentPrintedOnInvoice?: boolean | string;
        isComponentPrintedOnPackingSlip?: boolean | string;
        isDeliverable?: boolean | string;
        isInvoiced?: boolean | string;
        isLineWithDistributedInvoicingElement?: boolean | string;
        isRecordedTax?: boolean | string;
        isTaxable?: boolean | string;
        isTaxedGeographically?: string;
        latestDeliveryDate?: string;
        latestDeliveryTime?: string;
        locationReference?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        orderDate?: string;
        orderLineText?: TextStream;
        packaging?: string;
        packagingCapacity?: decimal | string;
        preferentialStockLocationFilter?: string;
        preparationCode?: string;
        productSource?: SourceOfShipment;
        productStockManagement?: StockManagement;
        project?: string;
        quantityInSalesUnitAllocated?: decimal | string;
        quantityInSalesUnitDelivered?: decimal | string;
        quantityInSalesUnitInPreparation?: decimal | string;
        quantityInSalesUnitInitiallyOrdered?: decimal | string;
        quantityInSalesUnitInvoiced?: decimal | string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice?: decimal | string;
        quantityInSalesUnitOnPickList?: decimal | string;
        quantityInSalesUnitOrdered?: decimal | string;
        quantityInSalesUnitPrepared?: decimal | string;
        quantityInSalesUnitShortage?: decimal | string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock?: decimal | string;
        quantityInStockUnitAllocated?: decimal | string;
        quantityInStockUnitDelivered?: decimal | string;
        quantityInStockUnitInPreparation?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice?: decimal | string;
        quantityInStockUnitOnPickList?: decimal | string;
        quantityInStockUnitOrdered?: decimal | string;
        quantityInStockUnitPrepared?: decimal | string;
        quantityInStockUnitShortage?: decimal | string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock?: decimal | string;
        requestedDeliveryDate?: string;
        requestedDeliveryReference?: string;
        requestedDeliveryTime?: string;
        routeNumber?: RouteCode;
        salesDelivery?: string;
        salesDeliveryLineNumber?: integer | string;
        shipmentDate?: string;
        shipmentTime?: string;
        taxRate?: decimal | string;
        taxableAmount?: decimal | string;
        tokenManagement?: decimal | string;
        useByDate?: string;
        volumeDistributedOnLine?: decimal | string;
        volumeUnitForDistributionOnLines?: string;
        weightDistributedOnLine?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        workInProgressOrderNumber?: string;
        workInProgressStatus?: StatusInProgress;
        productStatisticalGroups?: Partial<SalesOrderLineProductStatisticalGroupsInput>[];
        taxes?: Partial<SalesOrderLineTaxesInput>[];
    }
    export interface SalesOrderLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesOrder: SalesOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        category: OrderCategory;
        soldToCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        shipToCustomerContact: CustomerContact;
        billToCustomer: Customer;
        shippingSite: Site;
        salesSite: Site;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        customerProduct: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        lineStatus: LineStatus;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesOrderLine;
        salesQuote: SalesQuote;
        salesQuoteLineNumber: SalesQuoteLine;
        lineRevisionNumber: integer;
        sageSalesTax: MiscellaneousTable;
        consumerSalesPrice: string;
        invoicingTerm: InvoicingTerm;
        allocationType: AllocationType;
        backToBackOrderLineNumber: integer;
        backToBackOrderNumber: string;
        backToBackOrderSequenceNumber: integer;
        carrier: Carrier;
        closingDate: string;
        closingReason: MiscellaneousTable;
        completeDeliveryPriority: integer;
        deliveryLeadTime: integer;
        deliveryMode: DeliveryMode;
        deliveryPriority: DeliveryPriority;
        dimensions: ClientCollection<SalesOrderLineDimensionDimensions>;
        distributedInvoicingElements: ClientCollection<SalesOrderQuantityLineDistributedInvoicingElements>;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        expectedDeliveryDate: string;
        geographicCode: string;
        importLineNumber: integer;
        insideCityLimits: string;
        invoicedAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnInvoice: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isDeliverable: boolean;
        isInvoiced: boolean;
        isLineWithDistributedInvoicingElement: boolean;
        isRecordedTax: boolean;
        isTaxable: boolean;
        isTaxedGeographically: string;
        latestDeliveryDate: string;
        latestDeliveryTime: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        orderDate: string;
        orderLineText: TextStream;
        packaging: Packaging;
        packagingCapacity: string;
        preferentialStockLocationFilter: Location;
        preparationCode: string;
        productSource: SourceOfShipment;
        productStockManagement: StockManagement;
        project: ProjectLink;
        quantityInSalesUnitAllocated: string;
        quantityInSalesUnitDelivered: string;
        quantityInSalesUnitInPreparation: string;
        quantityInSalesUnitInitiallyOrdered: string;
        quantityInSalesUnitInvoiced: string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice: string;
        quantityInSalesUnitOnPickList: string;
        quantityInSalesUnitOrdered: string;
        quantityInSalesUnitPrepared: string;
        quantityInSalesUnitShortage: string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock: string;
        quantityInStockUnitAllocated: string;
        quantityInStockUnitDelivered: string;
        quantityInStockUnitInPreparation: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice: string;
        quantityInStockUnitOnPickList: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitPrepared: string;
        quantityInStockUnitShortage: string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock: string;
        requestedDeliveryDate: string;
        requestedDeliveryReference: string;
        requestedDeliveryTime: string;
        routeNumber: RouteCode;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        shipmentDate: string;
        shipmentTime: string;
        taxRate: string;
        taxableAmount: string;
        tokenManagement: string;
        useByDate: string;
        volumeDistributedOnLine: string;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        weightDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workInProgressStatus: StatusInProgress;
        productStatisticalGroups: ClientCollection<SalesOrderLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<SalesOrderLineTaxesBinding>;
    }
    export interface SalesOrderLine$Lookups {
        salesOrder: QueryOperation<SalesOrder>;
        company: QueryOperation<Company>;
        soldToCustomer: QueryOperation<Customer>;
        shipToCustomerAddress: QueryOperation<ShipToCustomerAddress>;
        shipToCustomerContact: QueryOperation<CustomerContact>;
        billToCustomer: QueryOperation<Customer>;
        shippingSite: QueryOperation<Site>;
        salesSite: QueryOperation<Site>;
        product: QueryOperation<Product>;
        salesRep1: QueryOperation<SalesRep>;
        salesRep2: QueryOperation<SalesRep>;
        priceReason: QueryOperation<SalesPriceReason>;
        discountOrCharge1Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge2Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge3Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge4Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge5Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge6Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge7Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge8Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge9Reason: QueryOperation<SalesPriceReason>;
        salesUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        freeProductLineSource: QueryOperation<SalesOrderLine>;
        salesQuote: QueryOperation<SalesQuote>;
        salesQuoteLineNumber: QueryOperation<SalesQuoteLine>;
        sageSalesTax: QueryOperation<MiscellaneousTable>;
        invoicingTerm: QueryOperation<InvoicingTerm>;
        carrier: QueryOperation<Carrier>;
        closingReason: QueryOperation<MiscellaneousTable>;
        deliveryMode: QueryOperation<DeliveryMode>;
        majorProductVersion: QueryOperation<MajorVersionStatus>;
        packaging: QueryOperation<Packaging>;
        preferentialStockLocationFilter: QueryOperation<Location>;
        project: QueryOperation<ProjectLink>;
        salesDelivery: QueryOperation<SalesDelivery>;
        salesDeliveryLineNumber: QueryOperation<SalesDeliveryLine>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
    }
    export interface SalesOrderLine$Operations {
        query: QueryOperation<SalesOrderLine>;
        read: ReadOperation<SalesOrderLine>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderLine>;
            query: AggregateQueryOperation<SalesOrderLine>;
        };
        lookups(dataOrId: string | { data: SalesOrderLineInput }): SalesOrderLine$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderLine>;
    }
    export interface SalesOrderQuantityLineDistributedInvoicingElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        distributedLineInvoicingElementNumber: SalesInvoicingElement;
        distributedLineInvoicingElementAmount: string;
    }
    export interface SalesOrderQuantityLineDistributedInvoicingElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        distributedLineInvoicingElementNumber?: integer | string;
        distributedLineInvoicingElementAmount?: decimal | string;
    }
    export interface SalesOrderQuantityLineDistributedInvoicingElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        distributedLineInvoicingElementNumber: SalesInvoicingElement;
        distributedLineInvoicingElementAmount: string;
    }
    export interface SalesOrderQuantityLineDistributedInvoicingElements$Lookups {
        distributedLineInvoicingElementNumber: QueryOperation<SalesInvoicingElement>;
    }
    export interface SalesOrderQuantityLineDistributedInvoicingElements$Operations {
        query: QueryOperation<SalesOrderQuantityLineDistributedInvoicingElements>;
        read: ReadOperation<SalesOrderQuantityLineDistributedInvoicingElements>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderQuantityLineDistributedInvoicingElements>;
            query: AggregateQueryOperation<SalesOrderQuantityLineDistributedInvoicingElements>;
        };
        lookups(
            dataOrId: string | { data: SalesOrderQuantityLineDistributedInvoicingElementsInput },
        ): SalesOrderQuantityLineDistributedInvoicingElements$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderQuantityLineDistributedInvoicingElements>;
    }
    export interface SalesOrderSalesReps extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        salesRep: SalesRep;
    }
    export interface SalesOrderSalesRepsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        salesRep?: string;
    }
    export interface SalesOrderSalesRepsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        salesRep: SalesRep;
    }
    export interface SalesOrderSalesReps$Lookups {
        salesRep: QueryOperation<SalesRep>;
    }
    export interface SalesOrderSalesReps$Operations {
        query: QueryOperation<SalesOrderSalesReps>;
        read: ReadOperation<SalesOrderSalesReps>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderSalesReps>;
            query: AggregateQueryOperation<SalesOrderSalesReps>;
        };
        lookups(dataOrId: string | { data: SalesOrderSalesRepsInput }): SalesOrderSalesReps$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderSalesReps>;
    }
    export interface SalesOrderShipToCustomerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesOrderShipToCustomerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SalesOrderShipToCustomerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesOrderShipToCustomerAddressLines$Operations {
        query: QueryOperation<SalesOrderShipToCustomerAddressLines>;
        read: ReadOperation<SalesOrderShipToCustomerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderShipToCustomerAddressLines>;
            query: AggregateQueryOperation<SalesOrderShipToCustomerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SalesOrderShipToCustomerAddressLines>;
    }
    export interface SalesOrderShipToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesOrderShipToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SalesOrderShipToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesOrderShipToCustomerCompanyNames$Operations {
        query: QueryOperation<SalesOrderShipToCustomerCompanyNames>;
        read: ReadOperation<SalesOrderShipToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderShipToCustomerCompanyNames>;
            query: AggregateQueryOperation<SalesOrderShipToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SalesOrderShipToCustomerCompanyNames>;
    }
    export interface SalesOrderSoldToCustomerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesOrderSoldToCustomerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SalesOrderSoldToCustomerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesOrderSoldToCustomerAddressLines$Operations {
        query: QueryOperation<SalesOrderSoldToCustomerAddressLines>;
        read: ReadOperation<SalesOrderSoldToCustomerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderSoldToCustomerAddressLines>;
            query: AggregateQueryOperation<SalesOrderSoldToCustomerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SalesOrderSoldToCustomerAddressLines>;
    }
    export interface SalesOrderSoldToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesOrderSoldToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SalesOrderSoldToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesOrderSoldToCustomerCompanyNames$Operations {
        query: QueryOperation<SalesOrderSoldToCustomerCompanyNames>;
        read: ReadOperation<SalesOrderSoldToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderSoldToCustomerCompanyNames>;
            query: AggregateQueryOperation<SalesOrderSoldToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SalesOrderSoldToCustomerCompanyNames>;
    }
    export interface SalesOrder extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        company: Company;
        salesOrderType: SalesOrderType;
        category: OrderCategory;
        salesSite: Site;
        soldToCustomer: Customer;
        billToCustomer: Customer;
        payByBusinessPartner: BusinessPartner;
        payByBusinessPartnerAddress: BusinessPartnerAddress;
        groupCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        customerOrderReference: string;
        additionnalReference: string;
        project: ProjectLink;
        orderDate: string;
        shipmentDate: string;
        requestedDeliveryDate: string;
        loanReturnDate: string;
        deliveryLeadTime: integer;
        soldToCustomerAddress: CustomerAddress;
        soldToCustomerPostalCode: string;
        soldToCustomerCity: string;
        soldToCustomerState: string;
        soldToCustomerCountry: Country;
        soldToCustomerCountryName: string;
        soldToCustomerContact: CustomerContact;
        billToCustomerAddress: CustomerAddress;
        billToCustomerPostalCode: string;
        billToCustomerCity: string;
        billToCustomerState: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        billToCustomerEuropeanUnionVatNumber: string;
        billToCustomerContact: CustomerContact;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: CustomerContact;
        currency: Currency;
        currencyRateType: ExchangeRateType;
        currencyRate: string;
        soldToCustomerLanguage: Language;
        taxRule: TaxRule;
        entityUseCode: MiscellaneousTable;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        carrier: Carrier;
        deliveryMode: DeliveryMode;
        shippingSite: Site;
        routeNumber: RouteCode;
        deliveryPriority: DeliveryPriority;
        isOrderClosingAllowed: boolean;
        mustContainOneOrderPerDelivery: boolean;
        partialDelivery: PartialDelivery;
        invoicingMode: InvoicingMode;
        mustPrintAcknowledgment: boolean;
        isAcknowledgmentPrinted: boolean;
        numberOfAcknowledgmentCopies: integer;
        salesQuote: SalesQuote;
        isIntersite: boolean;
        isIntercompany: boolean;
        sourceSite: Site;
        salesProforma: SalesInvoice;
        lastSalesDelivery: SalesDelivery;
        lastSalesDeliveryDate: string;
        lastSalesInvoice: SalesInvoice;
        lastSalesInvoiceDate: string;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        linesAmountExcludingTax: string;
        linesAmountIncludingTax: string;
        linesAmountExcludingTaxInCompanyCurrency: string;
        linesAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        linesAmountRemainingToDeliverExcludingTax: string;
        linesAmountRemainingToDeliverIncludingTax: string;
        totalMargin: string;
        allocationType: AllocationType;
        isUnlocked: boolean;
        numberOfLines: integer;
        numberOfClosedLines: integer;
        numberOfLinesToAllocate: integer;
        numberOfDeliveredLines: integer;
        numberOfInvoicedLines: integer;
        orderStatus: OrderStatus;
        allocationStatus: AllocationStatus;
        deliveryStatus: SalesDeliveryStatus;
        invoicedStatus: SalesInvoiceStatus;
        creditLevelStatus: CreditStatus;
        signatureStatus: NoInPartInFull;
        revisionNumber: integer;
        shipperOrReceiverCode: string;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: CustomerAddress;
        geographicCode: string;
        insideCityLimits: string;
        vertexTransactionType: string;
        taxAmount: string;
        taxableAmount: string;
        closingReason: MiscellaneousTable;
        closingDate: string;
        marketingOperationType: string;
        priceStructure: PriceStructure;
        totalQuantityDistributedOnLines: string;
        totalWeightDistributedOnLines: string;
        totalVolumeDistributedOnLines: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        deliveryType: SalesDeliveryType;
        manualHoldStatus: HoldStatus;
        manualHoldReason: MiscellaneousTable;
        manualHoldOrReleaseUser: User;
        manualHoldOrReleaseDate: string;
        manualHoldOrReleaseTime: string;
        previousManualHoldReason: MiscellaneousTable;
        previousManualHoldOrReleaseUser: User;
        previousManualHoldOrReleaseDate: string;
        previousManualHoldOrReleaseTime: string;
        previousCreditLevelStatus: CreditStatus;
        isValidatedAddress: boolean;
        requestedDeliveryTime: string;
        invoicingTerm: InvoicingTerm;
        scheduledInvoiceStartDueDate: string;
        linesAmountRemainingToInvoiceExcludingTax: string;
        linesAmountRemainingToInvoiceIncludingTax: string;
        linesAmountExcludingTaxforScheduledInvoicesRemainingToInvoice: string;
        linesAmountIncludingTaxforScheduledInvoicesRemainingToInvoice: string;
        draftStatus: integer;
        isRejectedDraft: boolean;
        rejectedDraftReason: string;
        hasElectronicSignature: boolean;
        finalNumber: string;
        validationDate: string;
        salesOrderLines: ClientCollection<SalesOrderLine>;
        orderFooterText: TextStream;
        orderHeaderText: TextStream;
        billToCustomerAddressLines: ClientCollection<SalesOrderBillToCustomerAddressLines>;
        billToCustomerCompanyNames: ClientCollection<SalesOrderBillToCustomerCompanyNames>;
        customerStatisticalGroups: ClientCollection<SalesOrderCustomerStatisticalGroups>;
        dimensions: ClientCollection<SalesOrderDimensions>;
        discountOrChargeCalculationRules: ClientCollection<SalesOrderDiscountOrChargeCalculationRules>;
        invoicingElements: ClientCollection<SalesOrderInvoicingElements>;
        salesReps: ClientCollection<SalesOrderSalesReps>;
        shipToCustomerAddressLines: ClientCollection<SalesOrderShipToCustomerAddressLines>;
        shipToCustomerCompanyNames: ClientCollection<SalesOrderShipToCustomerCompanyNames>;
        soldToCustomerAddressLines: ClientCollection<SalesOrderSoldToCustomerAddressLines>;
        soldToCustomerCompanyNames: ClientCollection<SalesOrderSoldToCustomerCompanyNames>;
    }
    export interface SalesOrderInput extends ClientNodeInput {
        id?: string;
        company?: string;
        salesOrderType?: string;
        category?: OrderCategory;
        salesSite?: string;
        soldToCustomer?: string;
        billToCustomer?: string;
        payByBusinessPartner?: string;
        payByBusinessPartnerAddress?: string;
        groupCustomer?: string;
        shipToCustomerAddress?: string;
        customerOrderReference?: string;
        additionnalReference?: string;
        project?: string;
        orderDate?: string;
        shipmentDate?: string;
        requestedDeliveryDate?: string;
        loanReturnDate?: string;
        deliveryLeadTime?: integer | string;
        soldToCustomerAddress?: string;
        soldToCustomerPostalCode?: string;
        soldToCustomerCity?: string;
        soldToCustomerState?: string;
        soldToCustomerCountry?: string;
        soldToCustomerCountryName?: string;
        soldToCustomerContact?: string;
        billToCustomerAddress?: string;
        billToCustomerPostalCode?: string;
        billToCustomerCity?: string;
        billToCustomerState?: string;
        billToCustomerCountry?: string;
        billToCustomerCountryName?: string;
        billToCustomerEuropeanUnionVatNumber?: string;
        billToCustomerContact?: string;
        shipToCustomerPostalCode?: string;
        shipToCustomerCity?: string;
        shipToCustomerState?: string;
        shipToCustomerCountry?: string;
        shipToCustomerCountryName?: string;
        shipToCustomerContact?: string;
        currency?: string;
        currencyRateType?: ExchangeRateType;
        currencyRate?: decimal | string;
        soldToCustomerLanguage?: string;
        taxRule?: string;
        entityUseCode?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        carrier?: string;
        deliveryMode?: string;
        shippingSite?: string;
        routeNumber?: RouteCode;
        deliveryPriority?: DeliveryPriority;
        isOrderClosingAllowed?: boolean | string;
        mustContainOneOrderPerDelivery?: boolean | string;
        partialDelivery?: PartialDelivery;
        invoicingMode?: InvoicingMode;
        mustPrintAcknowledgment?: boolean | string;
        isAcknowledgmentPrinted?: boolean | string;
        numberOfAcknowledgmentCopies?: integer | string;
        salesQuote?: string;
        isIntersite?: boolean | string;
        isIntercompany?: boolean | string;
        sourceSite?: string;
        salesProforma?: string;
        lastSalesDelivery?: string;
        lastSalesDeliveryDate?: string;
        lastSalesInvoice?: string;
        lastSalesInvoiceDate?: string;
        priceIncludingOrExcludingTax?: PriceAmountTaxTax;
        linesAmountExcludingTax?: decimal | string;
        linesAmountIncludingTax?: decimal | string;
        linesAmountExcludingTaxInCompanyCurrency?: decimal | string;
        linesAmountIncludingTaxInCompanyCurrency?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        linesAmountRemainingToDeliverExcludingTax?: decimal | string;
        linesAmountRemainingToDeliverIncludingTax?: decimal | string;
        totalMargin?: decimal | string;
        allocationType?: AllocationType;
        isUnlocked?: boolean | string;
        numberOfLines?: integer | string;
        numberOfClosedLines?: integer | string;
        numberOfLinesToAllocate?: integer | string;
        numberOfDeliveredLines?: integer | string;
        numberOfInvoicedLines?: integer | string;
        orderStatus?: OrderStatus;
        allocationStatus?: AllocationStatus;
        deliveryStatus?: SalesDeliveryStatus;
        invoicedStatus?: SalesInvoiceStatus;
        creditLevelStatus?: CreditStatus;
        signatureStatus?: NoInPartInFull;
        revisionNumber?: integer | string;
        shipperOrReceiverCode?: string;
        incoterm?: string;
        intrastatTransportLocation?: CountryLocation;
        incotermTown?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        geographicCode?: string;
        insideCityLimits?: string;
        vertexTransactionType?: string;
        taxAmount?: decimal | string;
        taxableAmount?: decimal | string;
        closingReason?: string;
        closingDate?: string;
        marketingOperationType?: string;
        priceStructure?: string;
        totalQuantityDistributedOnLines?: decimal | string;
        totalWeightDistributedOnLines?: decimal | string;
        totalVolumeDistributedOnLines?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        deliveryType?: string;
        manualHoldStatus?: HoldStatus;
        manualHoldReason?: string;
        manualHoldOrReleaseUser?: string;
        manualHoldOrReleaseDate?: string;
        manualHoldOrReleaseTime?: string;
        previousManualHoldReason?: string;
        previousManualHoldOrReleaseUser?: string;
        previousManualHoldOrReleaseDate?: string;
        previousManualHoldOrReleaseTime?: string;
        previousCreditLevelStatus?: CreditStatus;
        isValidatedAddress?: boolean | string;
        requestedDeliveryTime?: string;
        invoicingTerm?: string;
        scheduledInvoiceStartDueDate?: string;
        linesAmountRemainingToInvoiceExcludingTax?: decimal | string;
        linesAmountRemainingToInvoiceIncludingTax?: decimal | string;
        linesAmountExcludingTaxforScheduledInvoicesRemainingToInvoice?: decimal | string;
        linesAmountIncludingTaxforScheduledInvoicesRemainingToInvoice?: decimal | string;
        draftStatus?: integer | string;
        isRejectedDraft?: boolean | string;
        rejectedDraftReason?: string;
        hasElectronicSignature?: boolean | string;
        finalNumber?: string;
        validationDate?: string;
        salesOrderLines?: Partial<SalesOrderLineInput>[];
        orderFooterText?: TextStream;
        orderHeaderText?: TextStream;
        _x3Transaction?: string;
        billToCustomerAddressLines?: Partial<SalesOrderBillToCustomerAddressLinesInput>[];
        billToCustomerCompanyNames?: Partial<SalesOrderBillToCustomerCompanyNamesInput>[];
        customerStatisticalGroups?: Partial<SalesOrderCustomerStatisticalGroupsInput>[];
        dimensions?: Partial<SalesOrderDimensionsInput>[];
        discountOrChargeCalculationRules?: Partial<SalesOrderDiscountOrChargeCalculationRulesInput>[];
        invoicingElements?: Partial<SalesOrderInvoicingElementsInput>[];
        salesReps?: Partial<SalesOrderSalesRepsInput>[];
        shipToCustomerAddressLines?: Partial<SalesOrderShipToCustomerAddressLinesInput>[];
        shipToCustomerCompanyNames?: Partial<SalesOrderShipToCustomerCompanyNamesInput>[];
        soldToCustomerAddressLines?: Partial<SalesOrderSoldToCustomerAddressLinesInput>[];
        soldToCustomerCompanyNames?: Partial<SalesOrderSoldToCustomerCompanyNamesInput>[];
    }
    export interface SalesOrderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        company: Company;
        salesOrderType: SalesOrderType;
        category: OrderCategory;
        salesSite: Site;
        soldToCustomer: Customer;
        billToCustomer: Customer;
        payByBusinessPartner: BusinessPartner;
        payByBusinessPartnerAddress: BusinessPartnerAddress;
        groupCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        customerOrderReference: string;
        additionnalReference: string;
        project: ProjectLink;
        orderDate: string;
        shipmentDate: string;
        requestedDeliveryDate: string;
        loanReturnDate: string;
        deliveryLeadTime: integer;
        soldToCustomerAddress: CustomerAddress;
        soldToCustomerPostalCode: string;
        soldToCustomerCity: string;
        soldToCustomerState: string;
        soldToCustomerCountry: Country;
        soldToCustomerCountryName: string;
        soldToCustomerContact: CustomerContact;
        billToCustomerAddress: CustomerAddress;
        billToCustomerPostalCode: string;
        billToCustomerCity: string;
        billToCustomerState: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        billToCustomerEuropeanUnionVatNumber: string;
        billToCustomerContact: CustomerContact;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: CustomerContact;
        currency: Currency;
        currencyRateType: ExchangeRateType;
        currencyRate: string;
        soldToCustomerLanguage: Language;
        taxRule: TaxRule;
        entityUseCode: MiscellaneousTable;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        carrier: Carrier;
        deliveryMode: DeliveryMode;
        shippingSite: Site;
        routeNumber: RouteCode;
        deliveryPriority: DeliveryPriority;
        isOrderClosingAllowed: boolean;
        mustContainOneOrderPerDelivery: boolean;
        partialDelivery: PartialDelivery;
        invoicingMode: InvoicingMode;
        mustPrintAcknowledgment: boolean;
        isAcknowledgmentPrinted: boolean;
        numberOfAcknowledgmentCopies: integer;
        salesQuote: SalesQuote;
        isIntersite: boolean;
        isIntercompany: boolean;
        sourceSite: Site;
        salesProforma: SalesInvoice;
        lastSalesDelivery: SalesDelivery;
        lastSalesDeliveryDate: string;
        lastSalesInvoice: SalesInvoice;
        lastSalesInvoiceDate: string;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        linesAmountExcludingTax: string;
        linesAmountIncludingTax: string;
        linesAmountExcludingTaxInCompanyCurrency: string;
        linesAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        linesAmountRemainingToDeliverExcludingTax: string;
        linesAmountRemainingToDeliverIncludingTax: string;
        totalMargin: string;
        allocationType: AllocationType;
        isUnlocked: boolean;
        numberOfLines: integer;
        numberOfClosedLines: integer;
        numberOfLinesToAllocate: integer;
        numberOfDeliveredLines: integer;
        numberOfInvoicedLines: integer;
        orderStatus: OrderStatus;
        allocationStatus: AllocationStatus;
        deliveryStatus: SalesDeliveryStatus;
        invoicedStatus: SalesInvoiceStatus;
        creditLevelStatus: CreditStatus;
        signatureStatus: NoInPartInFull;
        revisionNumber: integer;
        shipperOrReceiverCode: string;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: CustomerAddress;
        geographicCode: string;
        insideCityLimits: string;
        vertexTransactionType: string;
        taxAmount: string;
        taxableAmount: string;
        closingReason: MiscellaneousTable;
        closingDate: string;
        marketingOperationType: string;
        priceStructure: PriceStructure;
        totalQuantityDistributedOnLines: string;
        totalWeightDistributedOnLines: string;
        totalVolumeDistributedOnLines: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        deliveryType: SalesDeliveryType;
        manualHoldStatus: HoldStatus;
        manualHoldReason: MiscellaneousTable;
        manualHoldOrReleaseUser: User;
        manualHoldOrReleaseDate: string;
        manualHoldOrReleaseTime: string;
        previousManualHoldReason: MiscellaneousTable;
        previousManualHoldOrReleaseUser: User;
        previousManualHoldOrReleaseDate: string;
        previousManualHoldOrReleaseTime: string;
        previousCreditLevelStatus: CreditStatus;
        isValidatedAddress: boolean;
        requestedDeliveryTime: string;
        invoicingTerm: InvoicingTerm;
        scheduledInvoiceStartDueDate: string;
        linesAmountRemainingToInvoiceExcludingTax: string;
        linesAmountRemainingToInvoiceIncludingTax: string;
        linesAmountExcludingTaxforScheduledInvoicesRemainingToInvoice: string;
        linesAmountIncludingTaxforScheduledInvoicesRemainingToInvoice: string;
        draftStatus: integer;
        isRejectedDraft: boolean;
        rejectedDraftReason: string;
        hasElectronicSignature: boolean;
        finalNumber: string;
        validationDate: string;
        salesOrderLines: ClientCollection<SalesOrderLine>;
        orderFooterText: TextStream;
        orderHeaderText: TextStream;
        _x3Transaction: string;
        billToCustomerAddressLines: ClientCollection<SalesOrderBillToCustomerAddressLinesBinding>;
        billToCustomerCompanyNames: ClientCollection<SalesOrderBillToCustomerCompanyNamesBinding>;
        customerStatisticalGroups: ClientCollection<SalesOrderCustomerStatisticalGroupsBinding>;
        dimensions: ClientCollection<SalesOrderDimensionsBinding>;
        discountOrChargeCalculationRules: ClientCollection<SalesOrderDiscountOrChargeCalculationRulesBinding>;
        invoicingElements: ClientCollection<SalesOrderInvoicingElementsBinding>;
        salesReps: ClientCollection<SalesOrderSalesRepsBinding>;
        shipToCustomerAddressLines: ClientCollection<SalesOrderShipToCustomerAddressLinesBinding>;
        shipToCustomerCompanyNames: ClientCollection<SalesOrderShipToCustomerCompanyNamesBinding>;
        soldToCustomerAddressLines: ClientCollection<SalesOrderSoldToCustomerAddressLinesBinding>;
        soldToCustomerCompanyNames: ClientCollection<SalesOrderSoldToCustomerCompanyNamesBinding>;
    }
    export interface SalesOrder$Lookups {
        company: QueryOperation<Company>;
        salesOrderType: QueryOperation<SalesOrderType>;
        salesSite: QueryOperation<Site>;
        soldToCustomer: QueryOperation<Customer>;
        billToCustomer: QueryOperation<Customer>;
        payByBusinessPartner: QueryOperation<BusinessPartner>;
        payByBusinessPartnerAddress: QueryOperation<BusinessPartnerAddress>;
        groupCustomer: QueryOperation<Customer>;
        shipToCustomerAddress: QueryOperation<ShipToCustomerAddress>;
        project: QueryOperation<ProjectLink>;
        soldToCustomerAddress: QueryOperation<CustomerAddress>;
        soldToCustomerCountry: QueryOperation<Country>;
        soldToCustomerContact: QueryOperation<CustomerContact>;
        billToCustomerAddress: QueryOperation<CustomerAddress>;
        billToCustomerCountry: QueryOperation<Country>;
        billToCustomerContact: QueryOperation<CustomerContact>;
        shipToCustomerCountry: QueryOperation<Country>;
        shipToCustomerContact: QueryOperation<CustomerContact>;
        currency: QueryOperation<Currency>;
        soldToCustomerLanguage: QueryOperation<Language>;
        taxRule: QueryOperation<TaxRule>;
        entityUseCode: QueryOperation<MiscellaneousTable>;
        paymentTerm: QueryOperation<PaymentTerm>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        carrier: QueryOperation<Carrier>;
        deliveryMode: QueryOperation<DeliveryMode>;
        shippingSite: QueryOperation<Site>;
        salesQuote: QueryOperation<SalesQuote>;
        sourceSite: QueryOperation<Site>;
        salesProforma: QueryOperation<SalesInvoice>;
        lastSalesDelivery: QueryOperation<SalesDelivery>;
        lastSalesInvoice: QueryOperation<SalesInvoice>;
        incoterm: QueryOperation<Incoterm>;
        forwardingAgent: QueryOperation<Carrier>;
        forwardingAgentAddress: QueryOperation<CustomerAddress>;
        closingReason: QueryOperation<MiscellaneousTable>;
        priceStructure: QueryOperation<PriceStructure>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        deliveryType: QueryOperation<SalesDeliveryType>;
        manualHoldReason: QueryOperation<MiscellaneousTable>;
        manualHoldOrReleaseUser: QueryOperation<User>;
        previousManualHoldReason: QueryOperation<MiscellaneousTable>;
        previousManualHoldOrReleaseUser: QueryOperation<User>;
        invoicingTerm: QueryOperation<InvoicingTerm>;
    }
    export interface SalesOrder$Operations {
        query: QueryOperation<SalesOrder>;
        read: ReadOperation<SalesOrder>;
        aggregate: {
            read: AggregateReadOperation<SalesOrder>;
            query: AggregateQueryOperation<SalesOrder>;
        };
        create: CreateOperation<SalesOrderInput, SalesOrder>;
        getDuplicate: GetDuplicateOperation<SalesOrder>;
        update: UpdateOperation<SalesOrderInput, SalesOrder>;
        updateById: UpdateByIdOperation<SalesOrderInput, SalesOrder>;
        delete: DeleteOperation<{}>;
        deleteById: DeleteOperation<string>;
        lookups(dataOrId: string | { data: SalesOrderInput }): SalesOrder$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrder>;
    }
    export interface SalesQuoteDimensions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface SalesQuoteDimensionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        dimensionType?: string;
        dimension?: string;
    }
    export interface SalesQuoteDimensionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface SalesQuoteDimensions$Lookups {
        dimensionType: QueryOperation<DimensionType>;
        dimension: QueryOperation<Dimension>;
    }
    export interface SalesQuoteDimensions$Operations {
        query: QueryOperation<SalesQuoteDimensions>;
        read: ReadOperation<SalesQuoteDimensions>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteDimensions>;
            query: AggregateQueryOperation<SalesQuoteDimensions>;
        };
        lookups(dataOrId: string | { data: SalesQuoteDimensionsInput }): SalesQuoteDimensions$Lookups;
        getDefaults: GetDefaultsOperation<SalesQuoteDimensions>;
    }
    export interface SalesQuoteDiscountOrChargeCalculationRules extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        type: DiscountCalculationRules;
        invoicingElement: SalesInvoicingElement;
    }
    export interface SalesQuoteDiscountOrChargeCalculationRulesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        type?: DiscountCalculationRules;
        invoicingElement?: integer | string;
    }
    export interface SalesQuoteDiscountOrChargeCalculationRulesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        type: DiscountCalculationRules;
        invoicingElement: SalesInvoicingElement;
    }
    export interface SalesQuoteDiscountOrChargeCalculationRules$Lookups {
        invoicingElement: QueryOperation<SalesInvoicingElement>;
    }
    export interface SalesQuoteDiscountOrChargeCalculationRules$Operations {
        query: QueryOperation<SalesQuoteDiscountOrChargeCalculationRules>;
        read: ReadOperation<SalesQuoteDiscountOrChargeCalculationRules>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteDiscountOrChargeCalculationRules>;
            query: AggregateQueryOperation<SalesQuoteDiscountOrChargeCalculationRules>;
        };
        lookups(
            dataOrId: string | { data: SalesQuoteDiscountOrChargeCalculationRulesInput },
        ): SalesQuoteDiscountOrChargeCalculationRules$Lookups;
        getDefaults: GetDefaultsOperation<SalesQuoteDiscountOrChargeCalculationRules>;
    }
    export interface SalesQuoteInvoicingElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        percentageOrAmount: string;
        valueType: ValueType;
        distributionKey: DistributionKey;
        invoicingElement: SalesInvoicingElement;
        sageSalesTax: MiscellaneousTable;
    }
    export interface SalesQuoteInvoicingElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        percentageOrAmount?: decimal | string;
        valueType?: ValueType;
        distributionKey?: string;
        invoicingElement?: integer | string;
        sageSalesTax?: string;
    }
    export interface SalesQuoteInvoicingElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        percentageOrAmount: string;
        valueType: ValueType;
        distributionKey: DistributionKey;
        invoicingElement: SalesInvoicingElement;
        sageSalesTax: MiscellaneousTable;
    }
    export interface SalesQuoteInvoicingElements$Lookups {
        distributionKey: QueryOperation<DistributionKey>;
        invoicingElement: QueryOperation<SalesInvoicingElement>;
        sageSalesTax: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesQuoteInvoicingElements$Operations {
        query: QueryOperation<SalesQuoteInvoicingElements>;
        read: ReadOperation<SalesQuoteInvoicingElements>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteInvoicingElements>;
            query: AggregateQueryOperation<SalesQuoteInvoicingElements>;
        };
        lookups(dataOrId: string | { data: SalesQuoteInvoicingElementsInput }): SalesQuoteInvoicingElements$Lookups;
        getDefaults: GetDefaultsOperation<SalesQuoteInvoicingElements>;
    }
    export interface SalesQuoteLineDistributedInvoicingElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesQuote: string;
        lineNumber: integer;
        distributedLineInvoicingElementNumber: SalesInvoicingElement;
        distributedLineInvoicingElementAmount: string;
    }
    export interface SalesQuoteLineDistributedInvoicingElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesQuote?: string;
        lineNumber?: integer | string;
        distributedLineInvoicingElementNumber?: integer | string;
        distributedLineInvoicingElementAmount?: decimal | string;
    }
    export interface SalesQuoteLineDistributedInvoicingElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesQuote: string;
        lineNumber: integer;
        distributedLineInvoicingElementNumber: SalesInvoicingElement;
        distributedLineInvoicingElementAmount: string;
    }
    export interface SalesQuoteLineDistributedInvoicingElements$Lookups {
        distributedLineInvoicingElementNumber: QueryOperation<SalesInvoicingElement>;
    }
    export interface SalesQuoteLineDistributedInvoicingElements$Operations {
        query: QueryOperation<SalesQuoteLineDistributedInvoicingElements>;
        read: ReadOperation<SalesQuoteLineDistributedInvoicingElements>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteLineDistributedInvoicingElements>;
            query: AggregateQueryOperation<SalesQuoteLineDistributedInvoicingElements>;
        };
        lookups(
            dataOrId: string | { data: SalesQuoteLineDistributedInvoicingElementsInput },
        ): SalesQuoteLineDistributedInvoicingElements$Lookups;
        getDefaults: GetDefaultsOperation<SalesQuoteLineDistributedInvoicingElements>;
    }
    export interface SalesQuoteLineTaxes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesQuote: string;
        lineNumber: integer;
        taxLevel: TaxLevel;
        tax: Tax;
    }
    export interface SalesQuoteLineTaxesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        salesQuote?: string;
        lineNumber?: integer | string;
        taxLevel?: string;
        tax?: string;
    }
    export interface SalesQuoteLineTaxesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        salesQuote: string;
        lineNumber: integer;
        taxLevel: TaxLevel;
        tax: Tax;
    }
    export interface SalesQuoteLineTaxes$Lookups {
        taxLevel: QueryOperation<TaxLevel>;
        tax: QueryOperation<Tax>;
    }
    export interface SalesQuoteLineTaxes$Operations {
        query: QueryOperation<SalesQuoteLineTaxes>;
        read: ReadOperation<SalesQuoteLineTaxes>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteLineTaxes>;
            query: AggregateQueryOperation<SalesQuoteLineTaxes>;
        };
        lookups(dataOrId: string | { data: SalesQuoteLineTaxesInput }): SalesQuoteLineTaxes$Lookups;
        getDefaults: GetDefaultsOperation<SalesQuoteLineTaxes>;
    }
    export interface SalesQuoteLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesQuote: SalesQuote;
        lineNumber: integer;
        company: Company;
        salesSite: Site;
        soldToCustomer: Customer;
        quoteDate: string;
        deliveryLeadTime: integer;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: ProductVersion;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesRep1: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2: SalesRep;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        margin: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        isLineWithDistributedInvoicingElement: boolean;
        quoteQuantity: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        shipToCustomerAddress: CustomerAddress;
        shippingSite: Site;
        shipToCustomerContact: CustomerContact;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: integer;
        salesOrder: SalesOrder;
        salesOrderLine: SalesOrderLine;
        isOrdered: boolean;
        orderedQuantity: string;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        taxRate: string;
        taxableAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isComponentPrintedOnInvoice: boolean;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        project: ProjectLink;
        importLineNumber: integer;
        sageSalesTax: MiscellaneousTable;
        isDeliverable: boolean;
        lineRevisionNumber: integer;
        quoteLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesQuoteLineDistributedInvoicingElements>;
        taxes: ClientCollection<SalesQuoteLineTaxes>;
    }
    export interface SalesQuoteLineInput extends ClientNodeInput {
        salesQuote?: string;
        lineNumber?: integer | string;
        company?: string;
        salesSite?: string;
        soldToCustomer?: string;
        quoteDate?: string;
        deliveryLeadTime?: integer | string;
        product?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        salesRep1?: string;
        salesRep1CommissionRate?: decimal | string;
        salesRep2?: string;
        salesRep2CommissionRate?: decimal | string;
        salesRepCommissionFactor?: decimal | string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        netPrice?: decimal | string;
        margin?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        costPrice?: decimal | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        isLineWithDistributedInvoicingElement?: boolean | string;
        quoteQuantity?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        shipToCustomerAddress?: string;
        shippingSite?: string;
        shipToCustomerContact?: string;
        lineType?: LineType;
        freeProduct?: Free;
        freeProductLineSource?: integer | string;
        salesOrder?: string;
        salesOrderLine?: integer | string;
        isOrdered?: boolean | string;
        orderedQuantity?: decimal | string;
        geographicCode?: string;
        insideCityLimits?: string;
        isTaxedGeographically?: string;
        isTaxable?: boolean | string;
        isRecordedTax?: boolean | string;
        taxRate?: decimal | string;
        taxableAmount?: decimal | string;
        isComponentPrintedOnAcknowledgement?: boolean | string;
        isComponentPrintedOnPackingSlip?: boolean | string;
        isComponentPrintedOnInvoice?: boolean | string;
        weightDistributedOnLine?: decimal | string;
        volumeDistributedOnLine?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        project?: string;
        importLineNumber?: integer | string;
        sageSalesTax?: string;
        isDeliverable?: boolean | string;
        lineRevisionNumber?: integer | string;
        quoteLineText?: TextStream;
        distributedInvoicingElements?: Partial<SalesQuoteLineDistributedInvoicingElementsInput>[];
        taxes?: Partial<SalesQuoteLineTaxesInput>[];
    }
    export interface SalesQuoteLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesQuote: SalesQuote;
        lineNumber: integer;
        company: Company;
        salesSite: Site;
        soldToCustomer: Customer;
        quoteDate: string;
        deliveryLeadTime: integer;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: ProductVersion;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesRep1: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2: SalesRep;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        margin: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        isLineWithDistributedInvoicingElement: boolean;
        quoteQuantity: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        shipToCustomerAddress: CustomerAddress;
        shippingSite: Site;
        shipToCustomerContact: CustomerContact;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: integer;
        salesOrder: SalesOrder;
        salesOrderLine: SalesOrderLine;
        isOrdered: boolean;
        orderedQuantity: string;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        taxRate: string;
        taxableAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isComponentPrintedOnInvoice: boolean;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        project: ProjectLink;
        importLineNumber: integer;
        sageSalesTax: MiscellaneousTable;
        isDeliverable: boolean;
        lineRevisionNumber: integer;
        quoteLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesQuoteLineDistributedInvoicingElementsBinding>;
        taxes: ClientCollection<SalesQuoteLineTaxesBinding>;
    }
    export interface SalesQuoteLine$Lookups {
        salesQuote: QueryOperation<SalesQuote>;
        company: QueryOperation<Company>;
        salesSite: QueryOperation<Site>;
        soldToCustomer: QueryOperation<Customer>;
        product: QueryOperation<Product>;
        majorProductVersion: QueryOperation<MajorVersionStatus>;
        minorProductVersion: QueryOperation<ProductVersion>;
        salesRep1: QueryOperation<SalesRep>;
        salesRep2: QueryOperation<SalesRep>;
        priceReason: QueryOperation<SalesPriceReason>;
        discountOrCharge1Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge2Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge3Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge4Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge5Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge6Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge7Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge8Reason: QueryOperation<SalesPriceReason>;
        discountOrCharge9Reason: QueryOperation<SalesPriceReason>;
        salesUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        shipToCustomerAddress: QueryOperation<CustomerAddress>;
        shippingSite: QueryOperation<Site>;
        shipToCustomerContact: QueryOperation<CustomerContact>;
        salesOrder: QueryOperation<SalesOrder>;
        salesOrderLine: QueryOperation<SalesOrderLine>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        project: QueryOperation<ProjectLink>;
        sageSalesTax: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesQuoteLine$Operations {
        query: QueryOperation<SalesQuoteLine>;
        read: ReadOperation<SalesQuoteLine>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteLine>;
            query: AggregateQueryOperation<SalesQuoteLine>;
        };
        lookups(dataOrId: string | { data: SalesQuoteLineInput }): SalesQuoteLine$Lookups;
        getDefaults: GetDefaultsOperation<SalesQuoteLine>;
    }
    export interface SalesQuoteSalesReps extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        salesRep: SalesRep;
    }
    export interface SalesQuoteSalesRepsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        salesRep?: string;
    }
    export interface SalesQuoteSalesRepsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        salesRep: SalesRep;
    }
    export interface SalesQuoteSalesReps$Lookups {
        salesRep: QueryOperation<SalesRep>;
    }
    export interface SalesQuoteSalesReps$Operations {
        query: QueryOperation<SalesQuoteSalesReps>;
        read: ReadOperation<SalesQuoteSalesReps>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteSalesReps>;
            query: AggregateQueryOperation<SalesQuoteSalesReps>;
        };
        lookups(dataOrId: string | { data: SalesQuoteSalesRepsInput }): SalesQuoteSalesReps$Lookups;
        getDefaults: GetDefaultsOperation<SalesQuoteSalesReps>;
    }
    export interface SalesQuoteShipToCustomerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesQuoteShipToCustomerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SalesQuoteShipToCustomerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesQuoteShipToCustomerAddressLines$Operations {
        query: QueryOperation<SalesQuoteShipToCustomerAddressLines>;
        read: ReadOperation<SalesQuoteShipToCustomerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteShipToCustomerAddressLines>;
            query: AggregateQueryOperation<SalesQuoteShipToCustomerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SalesQuoteShipToCustomerAddressLines>;
    }
    export interface SalesQuoteShipToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesQuoteShipToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SalesQuoteShipToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesQuoteShipToCustomerCompanyNames$Operations {
        query: QueryOperation<SalesQuoteShipToCustomerCompanyNames>;
        read: ReadOperation<SalesQuoteShipToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteShipToCustomerCompanyNames>;
            query: AggregateQueryOperation<SalesQuoteShipToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SalesQuoteShipToCustomerCompanyNames>;
    }
    export interface SalesQuoteSoldToCustomerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesQuoteSoldToCustomerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SalesQuoteSoldToCustomerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesQuoteSoldToCustomerAddressLines$Operations {
        query: QueryOperation<SalesQuoteSoldToCustomerAddressLines>;
        read: ReadOperation<SalesQuoteSoldToCustomerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteSoldToCustomerAddressLines>;
            query: AggregateQueryOperation<SalesQuoteSoldToCustomerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SalesQuoteSoldToCustomerAddressLines>;
    }
    export interface SalesQuoteSoldToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesQuoteSoldToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SalesQuoteSoldToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesQuoteSoldToCustomerCompanyNames$Operations {
        query: QueryOperation<SalesQuoteSoldToCustomerCompanyNames>;
        read: ReadOperation<SalesQuoteSoldToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteSoldToCustomerCompanyNames>;
            query: AggregateQueryOperation<SalesQuoteSoldToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SalesQuoteSoldToCustomerCompanyNames>;
    }
    export interface SalesQuote extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        quoteType: SalesQuoteType;
        company: Company;
        salesSite: Site;
        soldToCustomer: BusinessPartner;
        customerQuoteReference: string;
        quoteDate: string;
        validityDate: string;
        deliveryLeadTime: integer;
        salesOrderType: SalesOrderType;
        shipToCustomerAddress: BusinessPartnerAddress;
        soldToCustomerAddress: BusinessPartnerAddress;
        soldToCustomerPostalCode: string;
        soldToCustomerCity: string;
        soldToCustomerState: string;
        soldToCustomerCountry: Country;
        soldToCustomerCountryName: string;
        soldToCustomerContact: BusinessPartnerContact;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: BusinessPartnerContact;
        billToCustomerEuropeanUnionVatNumber: string;
        currency: Currency;
        currencyRateType: ExchangeRateType;
        currencyRate: string;
        project: ProjectLink;
        soldToCustomerLanguage: Language;
        taxRule: TaxRule;
        entityUseCode: MiscellaneousTable;
        shippingSite: Site;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        linesAmountExcludingTax: string;
        linesAmountIncludingTax: string;
        linesAmountExcludingTaxInCompanyCurrency: string;
        linesAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        totalMargin: string;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        paymentTerm: PaymentTerm;
        probabilityPercentage: integer;
        salesOrder: SalesOrder;
        orderDate: string;
        numberOfOrders: integer;
        numberOfValidatedLines: integer;
        numberOfLines: integer;
        quoteStatus: QuoteStatus;
        signatureStatus: NoInPartInFull;
        isQuotePrinted: boolean;
        numberOfQuoteCopies: integer;
        salesProforma: SalesInvoice;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: BusinessPartnerAddress;
        geographicCode: string;
        insideCityLimits: string;
        vertexTransactionType: string;
        taxAmount: string;
        taxableAmount: string;
        priceStructure: PriceStructure;
        totalQuantityDistributedOnLines: string;
        totalWeightDistributedOnLines: string;
        totalVolumeDistributedOnLines: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        isValidatedAddress: boolean;
        revisionNumber: integer;
        hasElectronicSignature: boolean;
        finalNumber: string;
        validationDate: string;
        salesQuoteLines: ClientCollection<SalesQuoteLine>;
        quoteFooterText: TextStream;
        quoteHeaderText: TextStream;
        dimensions: ClientCollection<SalesQuoteDimensions>;
        discountOrChargeCalculationRules: ClientCollection<SalesQuoteDiscountOrChargeCalculationRules>;
        invoicingElements: ClientCollection<SalesQuoteInvoicingElements>;
        salesReps: ClientCollection<SalesQuoteSalesReps>;
        shipToCustomerAddressLines: ClientCollection<SalesQuoteShipToCustomerAddressLines>;
        shipToCustomerCompanyNames: ClientCollection<SalesQuoteShipToCustomerCompanyNames>;
        soldToCustomerAddressLines: ClientCollection<SalesQuoteSoldToCustomerAddressLines>;
        soldToCustomerCompanyNames: ClientCollection<SalesQuoteSoldToCustomerCompanyNames>;
    }
    export interface SalesQuoteInput extends ClientNodeInput {
        id?: string;
        quoteType?: string;
        company?: string;
        salesSite?: string;
        soldToCustomer?: string;
        customerQuoteReference?: string;
        quoteDate?: string;
        validityDate?: string;
        deliveryLeadTime?: integer | string;
        salesOrderType?: string;
        shipToCustomerAddress?: string;
        soldToCustomerAddress?: string;
        soldToCustomerPostalCode?: string;
        soldToCustomerCity?: string;
        soldToCustomerState?: string;
        soldToCustomerCountry?: string;
        soldToCustomerCountryName?: string;
        soldToCustomerContact?: string;
        shipToCustomerPostalCode?: string;
        shipToCustomerCity?: string;
        shipToCustomerState?: string;
        shipToCustomerCountry?: string;
        shipToCustomerCountryName?: string;
        shipToCustomerContact?: string;
        billToCustomerEuropeanUnionVatNumber?: string;
        currency?: string;
        currencyRateType?: ExchangeRateType;
        currencyRate?: decimal | string;
        project?: string;
        soldToCustomerLanguage?: string;
        taxRule?: string;
        entityUseCode?: string;
        shippingSite?: string;
        priceIncludingOrExcludingTax?: PriceAmountTaxTax;
        linesAmountExcludingTax?: decimal | string;
        linesAmountIncludingTax?: decimal | string;
        linesAmountExcludingTaxInCompanyCurrency?: decimal | string;
        linesAmountIncludingTaxInCompanyCurrency?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        totalMargin?: decimal | string;
        earlyDiscountOrLateCharge?: string;
        paymentTerm?: string;
        probabilityPercentage?: integer | string;
        salesOrder?: string;
        orderDate?: string;
        numberOfOrders?: integer | string;
        numberOfValidatedLines?: integer | string;
        numberOfLines?: integer | string;
        quoteStatus?: QuoteStatus;
        signatureStatus?: NoInPartInFull;
        isQuotePrinted?: boolean | string;
        numberOfQuoteCopies?: integer | string;
        salesProforma?: string;
        incoterm?: string;
        intrastatTransportLocation?: CountryLocation;
        incotermTown?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        geographicCode?: string;
        insideCityLimits?: string;
        vertexTransactionType?: string;
        taxAmount?: decimal | string;
        taxableAmount?: decimal | string;
        priceStructure?: string;
        totalQuantityDistributedOnLines?: decimal | string;
        totalWeightDistributedOnLines?: decimal | string;
        totalVolumeDistributedOnLines?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        isValidatedAddress?: boolean | string;
        revisionNumber?: integer | string;
        hasElectronicSignature?: boolean | string;
        finalNumber?: string;
        validationDate?: string;
        salesQuoteLines?: Partial<SalesQuoteLineInput>[];
        quoteFooterText?: TextStream;
        quoteHeaderText?: TextStream;
        dimensions?: Partial<SalesQuoteDimensionsInput>[];
        discountOrChargeCalculationRules?: Partial<SalesQuoteDiscountOrChargeCalculationRulesInput>[];
        invoicingElements?: Partial<SalesQuoteInvoicingElementsInput>[];
        salesReps?: Partial<SalesQuoteSalesRepsInput>[];
        shipToCustomerAddressLines?: Partial<SalesQuoteShipToCustomerAddressLinesInput>[];
        shipToCustomerCompanyNames?: Partial<SalesQuoteShipToCustomerCompanyNamesInput>[];
        soldToCustomerAddressLines?: Partial<SalesQuoteSoldToCustomerAddressLinesInput>[];
        soldToCustomerCompanyNames?: Partial<SalesQuoteSoldToCustomerCompanyNamesInput>[];
    }
    export interface SalesQuoteBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        quoteType: SalesQuoteType;
        company: Company;
        salesSite: Site;
        soldToCustomer: BusinessPartner;
        customerQuoteReference: string;
        quoteDate: string;
        validityDate: string;
        deliveryLeadTime: integer;
        salesOrderType: SalesOrderType;
        shipToCustomerAddress: BusinessPartnerAddress;
        soldToCustomerAddress: BusinessPartnerAddress;
        soldToCustomerPostalCode: string;
        soldToCustomerCity: string;
        soldToCustomerState: string;
        soldToCustomerCountry: Country;
        soldToCustomerCountryName: string;
        soldToCustomerContact: BusinessPartnerContact;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: BusinessPartnerContact;
        billToCustomerEuropeanUnionVatNumber: string;
        currency: Currency;
        currencyRateType: ExchangeRateType;
        currencyRate: string;
        project: ProjectLink;
        soldToCustomerLanguage: Language;
        taxRule: TaxRule;
        entityUseCode: MiscellaneousTable;
        shippingSite: Site;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        linesAmountExcludingTax: string;
        linesAmountIncludingTax: string;
        linesAmountExcludingTaxInCompanyCurrency: string;
        linesAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        totalMargin: string;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        paymentTerm: PaymentTerm;
        probabilityPercentage: integer;
        salesOrder: SalesOrder;
        orderDate: string;
        numberOfOrders: integer;
        numberOfValidatedLines: integer;
        numberOfLines: integer;
        quoteStatus: QuoteStatus;
        signatureStatus: NoInPartInFull;
        isQuotePrinted: boolean;
        numberOfQuoteCopies: integer;
        salesProforma: SalesInvoice;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: BusinessPartnerAddress;
        geographicCode: string;
        insideCityLimits: string;
        vertexTransactionType: string;
        taxAmount: string;
        taxableAmount: string;
        priceStructure: PriceStructure;
        totalQuantityDistributedOnLines: string;
        totalWeightDistributedOnLines: string;
        totalVolumeDistributedOnLines: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        isValidatedAddress: boolean;
        revisionNumber: integer;
        hasElectronicSignature: boolean;
        finalNumber: string;
        validationDate: string;
        salesQuoteLines: ClientCollection<SalesQuoteLine>;
        quoteFooterText: TextStream;
        quoteHeaderText: TextStream;
        dimensions: ClientCollection<SalesQuoteDimensionsBinding>;
        discountOrChargeCalculationRules: ClientCollection<SalesQuoteDiscountOrChargeCalculationRulesBinding>;
        invoicingElements: ClientCollection<SalesQuoteInvoicingElementsBinding>;
        salesReps: ClientCollection<SalesQuoteSalesRepsBinding>;
        shipToCustomerAddressLines: ClientCollection<SalesQuoteShipToCustomerAddressLinesBinding>;
        shipToCustomerCompanyNames: ClientCollection<SalesQuoteShipToCustomerCompanyNamesBinding>;
        soldToCustomerAddressLines: ClientCollection<SalesQuoteSoldToCustomerAddressLinesBinding>;
        soldToCustomerCompanyNames: ClientCollection<SalesQuoteSoldToCustomerCompanyNamesBinding>;
    }
    export interface SalesQuote$Lookups {
        quoteType: QueryOperation<SalesQuoteType>;
        company: QueryOperation<Company>;
        salesSite: QueryOperation<Site>;
        soldToCustomer: QueryOperation<BusinessPartner>;
        salesOrderType: QueryOperation<SalesOrderType>;
        shipToCustomerAddress: QueryOperation<BusinessPartnerAddress>;
        soldToCustomerAddress: QueryOperation<BusinessPartnerAddress>;
        soldToCustomerCountry: QueryOperation<Country>;
        soldToCustomerContact: QueryOperation<BusinessPartnerContact>;
        shipToCustomerCountry: QueryOperation<Country>;
        shipToCustomerContact: QueryOperation<BusinessPartnerContact>;
        currency: QueryOperation<Currency>;
        project: QueryOperation<ProjectLink>;
        soldToCustomerLanguage: QueryOperation<Language>;
        taxRule: QueryOperation<TaxRule>;
        entityUseCode: QueryOperation<MiscellaneousTable>;
        shippingSite: QueryOperation<Site>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        paymentTerm: QueryOperation<PaymentTerm>;
        salesOrder: QueryOperation<SalesOrder>;
        salesProforma: QueryOperation<SalesInvoice>;
        incoterm: QueryOperation<Incoterm>;
        forwardingAgent: QueryOperation<Carrier>;
        forwardingAgentAddress: QueryOperation<BusinessPartnerAddress>;
        priceStructure: QueryOperation<PriceStructure>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
    }
    export interface SalesQuote$Operations {
        query: QueryOperation<SalesQuote>;
        read: ReadOperation<SalesQuote>;
        aggregate: {
            read: AggregateReadOperation<SalesQuote>;
            query: AggregateQueryOperation<SalesQuote>;
        };
        lookups(dataOrId: string | { data: SalesQuoteInput }): SalesQuote$Lookups;
        getDefaults: GetDefaultsOperation<SalesQuote>;
    }
    export interface SalesReturnDimensions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface SalesReturnDimensionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        dimensionType?: string;
        dimension?: string;
    }
    export interface SalesReturnDimensionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface SalesReturnDimensions$Lookups {
        dimensionType: QueryOperation<DimensionType>;
        dimension: QueryOperation<Dimension>;
    }
    export interface SalesReturnDimensions$Operations {
        query: QueryOperation<SalesReturnDimensions>;
        read: ReadOperation<SalesReturnDimensions>;
        aggregate: {
            read: AggregateReadOperation<SalesReturnDimensions>;
            query: AggregateQueryOperation<SalesReturnDimensions>;
        };
        lookups(dataOrId: string | { data: SalesReturnDimensionsInput }): SalesReturnDimensions$Lookups;
        getDefaults: GetDefaultsOperation<SalesReturnDimensions>;
    }
    export interface SalesReturnLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesReturn: SalesReturn;
        lineNumber: integer;
        company: Company;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        quantityInSalesUnitDelivered: string;
        expectedReturnQuantity: string;
        expectedReturnQuantityInStockUnit: string;
        quantityInSalesUnitReturned: string;
        quantityInStockUnitReturned: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        currency: Currency;
        returnReason: MiscellaneousTable;
        returnDate: string;
        actualStockReturn: boolean;
        returnDeductedFromTheInvoice: boolean;
        isToBeLinkedToCreditMemo: boolean;
        reactivatedOrder: boolean;
        creditMemo: SalesInvoice;
        creditMemoLineNumber: SalesInvoiceLine;
        creditMemoToBeIssued: SalesInvoice;
        creditMemoLineNumberToBeIssued: SalesInvoiceLine;
        reversalDocumentDate: string;
        receivingSite: Site;
        orderPrice: string;
        warehouse: Warehouse;
        project: ProjectLink;
        category: ReturnCategory;
        returnLineText: TextStream;
    }
    export interface SalesReturnLineInput extends ClientNodeInput {
        salesReturn?: string;
        lineNumber?: integer | string;
        company?: string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        salesDelivery?: string;
        salesDeliveryLineNumber?: integer | string;
        quantityInSalesUnitDelivered?: decimal | string;
        expectedReturnQuantity?: decimal | string;
        expectedReturnQuantityInStockUnit?: decimal | string;
        quantityInSalesUnitReturned?: decimal | string;
        quantityInStockUnitReturned?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        netPrice?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        currency?: string;
        returnReason?: string;
        returnDate?: string;
        actualStockReturn?: boolean | string;
        returnDeductedFromTheInvoice?: boolean | string;
        isToBeLinkedToCreditMemo?: boolean | string;
        reactivatedOrder?: boolean | string;
        creditMemo?: string;
        creditMemoLineNumber?: integer | string;
        creditMemoToBeIssued?: string;
        creditMemoLineNumberToBeIssued?: integer | string;
        reversalDocumentDate?: string;
        receivingSite?: string;
        orderPrice?: decimal | string;
        warehouse?: string;
        project?: string;
        category?: ReturnCategory;
        returnLineText?: TextStream;
    }
    export interface SalesReturnLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesReturn: SalesReturn;
        lineNumber: integer;
        company: Company;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        quantityInSalesUnitDelivered: string;
        expectedReturnQuantity: string;
        expectedReturnQuantityInStockUnit: string;
        quantityInSalesUnitReturned: string;
        quantityInStockUnitReturned: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        currency: Currency;
        returnReason: MiscellaneousTable;
        returnDate: string;
        actualStockReturn: boolean;
        returnDeductedFromTheInvoice: boolean;
        isToBeLinkedToCreditMemo: boolean;
        reactivatedOrder: boolean;
        creditMemo: SalesInvoice;
        creditMemoLineNumber: SalesInvoiceLine;
        creditMemoToBeIssued: SalesInvoice;
        creditMemoLineNumberToBeIssued: SalesInvoiceLine;
        reversalDocumentDate: string;
        receivingSite: Site;
        orderPrice: string;
        warehouse: Warehouse;
        project: ProjectLink;
        category: ReturnCategory;
        returnLineText: TextStream;
    }
    export interface SalesReturnLine$Lookups {
        salesReturn: QueryOperation<SalesReturn>;
        company: QueryOperation<Company>;
        product: QueryOperation<Product>;
        salesDelivery: QueryOperation<SalesDelivery>;
        salesDeliveryLineNumber: QueryOperation<SalesDeliveryLine>;
        salesUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        currency: QueryOperation<Currency>;
        returnReason: QueryOperation<MiscellaneousTable>;
        creditMemo: QueryOperation<SalesInvoice>;
        creditMemoLineNumber: QueryOperation<SalesInvoiceLine>;
        creditMemoToBeIssued: QueryOperation<SalesInvoice>;
        creditMemoLineNumberToBeIssued: QueryOperation<SalesInvoiceLine>;
        receivingSite: QueryOperation<Site>;
        warehouse: QueryOperation<Warehouse>;
        project: QueryOperation<ProjectLink>;
    }
    export interface SalesReturnLine$Operations {
        query: QueryOperation<SalesReturnLine>;
        read: ReadOperation<SalesReturnLine>;
        aggregate: {
            read: AggregateReadOperation<SalesReturnLine>;
            query: AggregateQueryOperation<SalesReturnLine>;
        };
        lookups(dataOrId: string | { data: SalesReturnLineInput }): SalesReturnLine$Lookups;
        getDefaults: GetDefaultsOperation<SalesReturnLine>;
    }
    export interface SalesReturnShipToCustomerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesReturnShipToCustomerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SalesReturnShipToCustomerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SalesReturnShipToCustomerAddressLines$Operations {
        query: QueryOperation<SalesReturnShipToCustomerAddressLines>;
        read: ReadOperation<SalesReturnShipToCustomerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SalesReturnShipToCustomerAddressLines>;
            query: AggregateQueryOperation<SalesReturnShipToCustomerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SalesReturnShipToCustomerAddressLines>;
    }
    export interface SalesReturnShipToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesReturnShipToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SalesReturnShipToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SalesReturnShipToCustomerCompanyNames$Operations {
        query: QueryOperation<SalesReturnShipToCustomerCompanyNames>;
        read: ReadOperation<SalesReturnShipToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SalesReturnShipToCustomerCompanyNames>;
            query: AggregateQueryOperation<SalesReturnShipToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SalesReturnShipToCustomerCompanyNames>;
    }
    export interface SalesReturn extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        receivingSite: Site;
        company: Company;
        expirationDate: string;
        authorizedUser: User;
        expectedReturnDate: string;
        returnDate: string;
        soldToCustomer: Customer;
        shipToCustomerAddress: CustomerAddress;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: CustomerContact;
        deliveryDate: string;
        billToCustomer: Customer;
        salesSite: Site;
        shippingSite: Site;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        intrastatProcessingNumber: integer;
        incoterm: Incoterm;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: CustomerAddress;
        billToCustomerEuropeanUnionVatNumber: string;
        loanReturn: boolean;
        subcontractMaterialReturn: boolean;
        loanSalesDelivery: SalesDelivery;
        stockMovementGroup: MiscellaneousTable;
        language: Language;
        stockMovementCode: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        dockLocation: Location;
        isIntersite: boolean;
        isIntercompany: boolean;
        sourceSite: Site;
        priceStructure: PriceStructure;
        warehouse: Warehouse;
        project: ProjectLink;
        returnType: SalesReturnType;
        returnNumber: SalesReturn;
        category: ReturnCategory;
        arrivalDate: string;
        departureDate: string;
        departureTime: string;
        arrivalTime: string;
        vehicleLicensePlate: string;
        trailerLicensePlate: string;
        salesReturnLines: ClientCollection<SalesReturnLine>;
        returnFooterText: TextStream;
        returnHeaderText: TextStream;
        dimensions: ClientCollection<SalesReturnDimensions>;
        shipToCustomerAddressLines: ClientCollection<SalesReturnShipToCustomerAddressLines>;
        shipToCustomerCompanyNames: ClientCollection<SalesReturnShipToCustomerCompanyNames>;
    }
    export interface SalesReturnInput extends ClientNodeInput {
        id?: string;
        receivingSite?: string;
        company?: string;
        expirationDate?: string;
        authorizedUser?: string;
        expectedReturnDate?: string;
        returnDate?: string;
        soldToCustomer?: string;
        shipToCustomerAddress?: string;
        shipToCustomerPostalCode?: string;
        shipToCustomerCity?: string;
        shipToCustomerState?: string;
        shipToCustomerCountry?: string;
        shipToCustomerCountryName?: string;
        shipToCustomerContact?: string;
        deliveryDate?: string;
        billToCustomer?: string;
        salesSite?: string;
        shippingSite?: string;
        intrastatTransactionNature?: string;
        intrastatStatisticalRule?: string;
        intrastatTransportLocation?: CountryLocation;
        intrastatTransportMode?: IntrastatTransportMode;
        intrastatProcessingNumber?: integer | string;
        incoterm?: string;
        incotermTown?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        billToCustomerEuropeanUnionVatNumber?: string;
        loanReturn?: boolean | string;
        subcontractMaterialReturn?: boolean | string;
        loanSalesDelivery?: string;
        stockMovementGroup?: string;
        language?: string;
        stockMovementCode?: string;
        stockAutomaticJournal?: string;
        dockLocation?: string;
        isIntersite?: boolean | string;
        isIntercompany?: boolean | string;
        sourceSite?: string;
        priceStructure?: string;
        warehouse?: string;
        project?: string;
        returnType?: string;
        returnNumber?: string;
        category?: ReturnCategory;
        arrivalDate?: string;
        departureDate?: string;
        departureTime?: string;
        arrivalTime?: string;
        vehicleLicensePlate?: string;
        trailerLicensePlate?: string;
        salesReturnLines?: Partial<SalesReturnLineInput>[];
        returnFooterText?: TextStream;
        returnHeaderText?: TextStream;
        dimensions?: Partial<SalesReturnDimensionsInput>[];
        shipToCustomerAddressLines?: Partial<SalesReturnShipToCustomerAddressLinesInput>[];
        shipToCustomerCompanyNames?: Partial<SalesReturnShipToCustomerCompanyNamesInput>[];
    }
    export interface SalesReturnBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        receivingSite: Site;
        company: Company;
        expirationDate: string;
        authorizedUser: User;
        expectedReturnDate: string;
        returnDate: string;
        soldToCustomer: Customer;
        shipToCustomerAddress: CustomerAddress;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: CustomerContact;
        deliveryDate: string;
        billToCustomer: Customer;
        salesSite: Site;
        shippingSite: Site;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        intrastatProcessingNumber: integer;
        incoterm: Incoterm;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: CustomerAddress;
        billToCustomerEuropeanUnionVatNumber: string;
        loanReturn: boolean;
        subcontractMaterialReturn: boolean;
        loanSalesDelivery: SalesDelivery;
        stockMovementGroup: MiscellaneousTable;
        language: Language;
        stockMovementCode: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        dockLocation: Location;
        isIntersite: boolean;
        isIntercompany: boolean;
        sourceSite: Site;
        priceStructure: PriceStructure;
        warehouse: Warehouse;
        project: ProjectLink;
        returnType: SalesReturnType;
        returnNumber: SalesReturn;
        category: ReturnCategory;
        arrivalDate: string;
        departureDate: string;
        departureTime: string;
        arrivalTime: string;
        vehicleLicensePlate: string;
        trailerLicensePlate: string;
        salesReturnLines: ClientCollection<SalesReturnLine>;
        returnFooterText: TextStream;
        returnHeaderText: TextStream;
        dimensions: ClientCollection<SalesReturnDimensionsBinding>;
        shipToCustomerAddressLines: ClientCollection<SalesReturnShipToCustomerAddressLinesBinding>;
        shipToCustomerCompanyNames: ClientCollection<SalesReturnShipToCustomerCompanyNamesBinding>;
    }
    export interface SalesReturn$Lookups {
        receivingSite: QueryOperation<Site>;
        company: QueryOperation<Company>;
        authorizedUser: QueryOperation<User>;
        soldToCustomer: QueryOperation<Customer>;
        shipToCustomerAddress: QueryOperation<CustomerAddress>;
        shipToCustomerCountry: QueryOperation<Country>;
        shipToCustomerContact: QueryOperation<CustomerContact>;
        billToCustomer: QueryOperation<Customer>;
        salesSite: QueryOperation<Site>;
        shippingSite: QueryOperation<Site>;
        intrastatTransactionNature: QueryOperation<IntrastatTransactionNature>;
        intrastatStatisticalRule: QueryOperation<IntrastatStatisticalRule>;
        incoterm: QueryOperation<Incoterm>;
        forwardingAgent: QueryOperation<Carrier>;
        forwardingAgentAddress: QueryOperation<CustomerAddress>;
        loanSalesDelivery: QueryOperation<SalesDelivery>;
        stockMovementGroup: QueryOperation<MiscellaneousTable>;
        language: QueryOperation<Language>;
        stockMovementCode: QueryOperation<MiscellaneousTable>;
        stockAutomaticJournal: QueryOperation<AutomaticJournal>;
        dockLocation: QueryOperation<Location>;
        sourceSite: QueryOperation<Site>;
        priceStructure: QueryOperation<PriceStructure>;
        warehouse: QueryOperation<Warehouse>;
        project: QueryOperation<ProjectLink>;
        returnType: QueryOperation<SalesReturnType>;
        returnNumber: QueryOperation<SalesReturn>;
    }
    export interface SalesReturn$Operations {
        query: QueryOperation<SalesReturn>;
        read: ReadOperation<SalesReturn>;
        aggregate: {
            read: AggregateReadOperation<SalesReturn>;
            query: AggregateQueryOperation<SalesReturn>;
        };
        lookups(dataOrId: string | { data: SalesReturnInput }): SalesReturn$Lookups;
        getDefaults: GetDefaultsOperation<SalesReturn>;
    }
    export interface ServiceContractTemplate extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        description: string;
    }
    export interface ServiceContractTemplateInput extends ClientNodeInput {
        id?: string;
        description?: string;
    }
    export interface ServiceContractTemplateBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        description: string;
    }
    export interface ServiceContractTemplate$Operations {
        query: QueryOperation<ServiceContractTemplate>;
        read: ReadOperation<ServiceContractTemplate>;
        aggregate: {
            read: AggregateReadOperation<ServiceContractTemplate>;
            query: AggregateQueryOperation<ServiceContractTemplate>;
        };
        getDefaults: GetDefaultsOperation<ServiceContractTemplate>;
    }
    export interface CustomerExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        customerCategory: CustomerCategory;
        billToCustomer: Customer;
        billToCustomerAddress: CustomerAddress;
        payByCustomer: BusinessPartner;
        payByCustomerAddress: BusinessPartnerAddress;
        groupCustomer: Customer;
        riskCustomer: Customer;
        defaultAddress: CustomerAddress;
        defaultShipToAddress: ShipToCustomerAddress;
        defaultContact: CustomerContact;
        isActive: boolean;
        ourSupplierCode: string;
        currency: Currency;
        rateType: ExchangeRateType;
        commissionCategory: CommissionCategory;
        exemptionTaxNumber: string;
        priceOrAmountType: PriceAmountTaxTax;
        creditControl: WorkInProgressControl;
        authorizedCreditAmount: string;
        minimumOrderAmount: string;
        creditInsuranceAmount: string;
        insuranceDate: string;
        insuranceCompany: BusinessPartner;
        reminderType: ReminderType;
        minimumReminderAmount: string;
        canBeMatched: boolean;
        isLoanAllowed: boolean;
        mustPrintAcknowledgment: boolean;
        isOrderClosingAllowed: boolean;
        mustContainOneOrderPerDelivery: boolean;
        businessSector: MiscellaneousTable;
        prospectOrigin: MiscellaneousTable;
        tokenCredit: integer;
        manualAdditionalToken: integer;
        totalTokenCredit: integer;
        necessaryTokensForServiceContract: integer;
        firstContactDate: string;
        firstOrderDate: string;
        lastQuoteDate: string;
        lastContactDate: string;
        nextContactDate: string;
        customerAbcClass: ProductAbcClass;
        printTemplate: PrintTemplate;
        initialDateSinceCustomer: string;
        unavailablePaymentPeriod: UnavailablePeriods;
        isSubjectToTax: boolean;
        isEfatElectronicInvoicingAllowed: boolean;
        contact: CustomerContact;
        startDateforElectronicInvoice: string;
        isElectronicInvoiceAllowed: boolean;
        addresses: ClientCollection<CustomerAddress>;
        contacts: ClientCollection<CustomerContact>;
        bankDetails: ClientCollection<CustomerBankDetail>;
        businessPartner: BusinessPartner;
        shipToCustomers: ClientCollection<ShipToCustomerAddress>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        electronicAddress: string;
        electronicInvoiceType: ElectronicInvoiceType;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        invoiceHeaderText: TextStream;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        orderHeaderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        routingCode: string;
        serviceCode: string;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
        cashTaxRules: ClientCollection<CustomerCashTaxRules>;
        paymentDays: ClientCollection<CustomerPaymentDays>;
        salesReps: ClientCollection<CustomerSalesReps>;
        statisticalGroups: ClientCollection<CustomerStatisticalGroups>;
        taxRule: TaxRule;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        invoicingTerm: InvoicingTerm;
        invoicingElements: ClientCollection<CustomerInvoicingElements>;
        reminderGroup: ReminderGroup;
        factor: Factor;
        paymentBank: BankAccount;
        accountingCode: AccountingCode;
        accountStructure: AccountScheme;
        dimensions: ClientCollection<CustomerDimensions>;
        customerType: CustomerType;
        freightInvoicing: FreightInvoicing;
        openItemStatementFrequency: StatementPeriod;
        invoicePeriod: InvoicingFrequency;
        dueDateOrigin: DueDateCalculationSource;
        partialDelivery: PartialDelivery;
        invoicingMode: InvoicingMode;
        serviceContract: ServiceContractTemplate;
        lastContactType: SalesContactType;
        nextContactType: SalesContactType;
    }
    export interface CustomerInputExtension {
        code?: string;
        customerCategory?: string;
        billToCustomer?: string;
        billToCustomerAddress?: string;
        payByCustomer?: string;
        payByCustomerAddress?: string;
        groupCustomer?: string;
        riskCustomer?: string;
        defaultAddress?: string;
        defaultShipToAddress?: string;
        defaultContact?: string;
        isActive?: boolean | string;
        ourSupplierCode?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        commissionCategory?: CommissionCategory;
        exemptionTaxNumber?: string;
        priceOrAmountType?: PriceAmountTaxTax;
        creditControl?: WorkInProgressControl;
        authorizedCreditAmount?: decimal | string;
        minimumOrderAmount?: decimal | string;
        creditInsuranceAmount?: decimal | string;
        insuranceDate?: string;
        insuranceCompany?: string;
        reminderType?: ReminderType;
        minimumReminderAmount?: decimal | string;
        canBeMatched?: boolean | string;
        isLoanAllowed?: boolean | string;
        mustPrintAcknowledgment?: boolean | string;
        isOrderClosingAllowed?: boolean | string;
        mustContainOneOrderPerDelivery?: boolean | string;
        businessSector?: string;
        prospectOrigin?: string;
        tokenCredit?: integer | string;
        manualAdditionalToken?: integer | string;
        totalTokenCredit?: integer | string;
        necessaryTokensForServiceContract?: integer | string;
        firstContactDate?: string;
        firstOrderDate?: string;
        lastQuoteDate?: string;
        lastContactDate?: string;
        nextContactDate?: string;
        customerAbcClass?: ProductAbcClass;
        printTemplate?: string;
        initialDateSinceCustomer?: string;
        unavailablePaymentPeriod?: string;
        isSubjectToTax?: boolean | string;
        isEfatElectronicInvoicingAllowed?: boolean | string;
        contact?: string;
        startDateforElectronicInvoice?: string;
        isElectronicInvoiceAllowed?: boolean | string;
        addresses?: Partial<CustomerAddressInput>[];
        contacts?: Partial<CustomerContactInput>[];
        bankDetails?: Partial<CustomerBankDetailInput>[];
        businessPartner?: string;
        shipToCustomers?: Partial<ShipToCustomerAddressInput>[];
        acronym?: string;
        businessPartnerSite?: string;
        cfonbPaymentMethod?: string;
        companyName1?: string;
        companyName2?: string;
        companyNames?: Partial<BusinessPartnerCompanyNamesInput>[];
        consolidationCode?: string;
        consolidationGroup?: string;
        consolidationPartner?: string;
        country?: string;
        customerOrSupplierOriginCategory?: string;
        documentType?: DocumentType;
        economicOperatorRegistrationAndIdNumber?: string;
        electronicAddress?: string;
        electronicInvoiceType?: ElectronicInvoiceType;
        europeanUnionVatNumber?: string;
        fiscalCode?: string;
        invoiceHeaderText?: TextStream;
        isCashExcluded?: boolean | string;
        isIntersite?: boolean | string;
        isMailingProhibited?: boolean | string;
        isPhysicalPerson?: boolean | string;
        isPublicSector?: boolean | string;
        isServiceCaller?: boolean | string;
        isServiceSupplier?: boolean | string;
        italianTaxNumber?: string;
        language?: string;
        nonResidentAccount?: string;
        orderHeaderText?: TextStream;
        registrationNumber?: string;
        relatedCompany?: RelatedCompanySettings;
        reportAccessCode?: string;
        routingCode?: string;
        serviceCode?: string;
        shortCompanyName?: string;
        siteIdentificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        vatNumber?: string;
        cashTaxRules?: Partial<CustomerCashTaxRulesInput>[];
        paymentDays?: Partial<CustomerPaymentDaysInput>[];
        salesReps?: Partial<CustomerSalesRepsInput>[];
        statisticalGroups?: Partial<CustomerStatisticalGroupsInput>[];
        taxRule?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        invoicingTerm?: string;
        invoicingElements?: Partial<CustomerInvoicingElementsInput>[];
        reminderGroup?: string;
        factor?: string;
        paymentBank?: string;
        accountingCode?: string;
        accountStructure?: string;
        dimensions?: Partial<CustomerDimensionsInput>[];
        customerType?: CustomerType;
        freightInvoicing?: FreightInvoicing;
        openItemStatementFrequency?: StatementPeriod;
        invoicePeriod?: InvoicingFrequency;
        dueDateOrigin?: DueDateCalculationSource;
        partialDelivery?: PartialDelivery;
        invoicingMode?: InvoicingMode;
        serviceContract?: string;
        lastContactType?: SalesContactType;
        nextContactType?: SalesContactType;
    }
    export interface CustomerBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        customerCategory: CustomerCategory;
        billToCustomer: Customer;
        billToCustomerAddress: CustomerAddress;
        payByCustomer: BusinessPartner;
        payByCustomerAddress: BusinessPartnerAddress;
        groupCustomer: Customer;
        riskCustomer: Customer;
        defaultAddress: CustomerAddress;
        defaultShipToAddress: ShipToCustomerAddress;
        defaultContact: CustomerContact;
        isActive: boolean;
        ourSupplierCode: string;
        currency: Currency;
        rateType: ExchangeRateType;
        commissionCategory: CommissionCategory;
        exemptionTaxNumber: string;
        priceOrAmountType: PriceAmountTaxTax;
        creditControl: WorkInProgressControl;
        authorizedCreditAmount: string;
        minimumOrderAmount: string;
        creditInsuranceAmount: string;
        insuranceDate: string;
        insuranceCompany: BusinessPartner;
        reminderType: ReminderType;
        minimumReminderAmount: string;
        canBeMatched: boolean;
        isLoanAllowed: boolean;
        mustPrintAcknowledgment: boolean;
        isOrderClosingAllowed: boolean;
        mustContainOneOrderPerDelivery: boolean;
        businessSector: MiscellaneousTable;
        prospectOrigin: MiscellaneousTable;
        tokenCredit: integer;
        manualAdditionalToken: integer;
        totalTokenCredit: integer;
        necessaryTokensForServiceContract: integer;
        firstContactDate: string;
        firstOrderDate: string;
        lastQuoteDate: string;
        lastContactDate: string;
        nextContactDate: string;
        customerAbcClass: ProductAbcClass;
        printTemplate: PrintTemplate;
        initialDateSinceCustomer: string;
        unavailablePaymentPeriod: UnavailablePeriods;
        isSubjectToTax: boolean;
        isEfatElectronicInvoicingAllowed: boolean;
        contact: CustomerContact;
        startDateforElectronicInvoice: string;
        isElectronicInvoiceAllowed: boolean;
        addresses: ClientCollection<CustomerAddress>;
        contacts: ClientCollection<CustomerContact>;
        bankDetails: ClientCollection<CustomerBankDetail>;
        businessPartner: BusinessPartner;
        shipToCustomers: ClientCollection<ShipToCustomerAddress>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        electronicAddress: string;
        electronicInvoiceType: ElectronicInvoiceType;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        invoiceHeaderText: TextStream;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        orderHeaderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        routingCode: string;
        serviceCode: string;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
        cashTaxRules: ClientCollection<CustomerCashTaxRulesBinding>;
        paymentDays: ClientCollection<CustomerPaymentDaysBinding>;
        salesReps: ClientCollection<CustomerSalesRepsBinding>;
        statisticalGroups: ClientCollection<CustomerStatisticalGroupsBinding>;
        taxRule: TaxRule;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        invoicingTerm: InvoicingTerm;
        invoicingElements: ClientCollection<CustomerInvoicingElementsBinding>;
        reminderGroup: ReminderGroup;
        factor: Factor;
        paymentBank: BankAccount;
        accountingCode: AccountingCode;
        accountStructure: AccountScheme;
        dimensions: ClientCollection<CustomerDimensionsBinding>;
        customerType: CustomerType;
        freightInvoicing: FreightInvoicing;
        openItemStatementFrequency: StatementPeriod;
        invoicePeriod: InvoicingFrequency;
        dueDateOrigin: DueDateCalculationSource;
        partialDelivery: PartialDelivery;
        invoicingMode: InvoicingMode;
        serviceContract: ServiceContractTemplate;
        lastContactType: SalesContactType;
        nextContactType: SalesContactType;
    }
    export interface CustomerExtension$Lookups {
        serviceContract: QueryOperation<ServiceContractTemplate>;
    }
    export interface CustomerExtension$Operations {
        lookups(dataOrId: string | { data: CustomerInput }): CustomerExtension$Lookups;
    }
    export interface ProductCategoryExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroups>;
        costType: CostType;
        lotManagementMode: LotManagementMode;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        materialCostGroup: MaterialCostGroup;
        reorderingManagementMode: ReorderingManagementMode;
        stockVersionMode: StockVersionMode;
        stockManagementRules: ClientCollection<StockManagementRules>;
        defaultLocations: ClientCollection<ProductCategoryDefaultLocations>;
        overheads: ClientCollection<ProductCategoryOverheads>;
        packingUnits: ClientCollection<ProductCategoryPackingUnits>;
        invoicingTerm: InvoicingTerm;
        taxLevels: ClientCollection<ProductCategoryTaxLevels>;
        accountingCode: AccountingCode;
        dimensions: ClientCollection<ProductCategoryDimensions>;
        packaging: Packaging;
        costStructure: FreightCostStructure;
        matchingTolerance: MatchingTolerance;
        productType: SalesProductType;
    }
    export interface ProductCategoryInputExtension {
        stockSite?: string;
        code?: string;
        description?: string;
        localizedDescription?: string;
        shortDescription?: string;
        localizedShortDescription?: string;
        isSold?: boolean | string;
        productSequenceNumber?: string;
        creationMethod?: ProductCreationMode;
        qualityControlManagementMode?: SubjectToControl;
        qualityControlAccessCode?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticUnit?: string;
        euUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        euUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseConversionFactorEntryAllowed?: boolean | string;
        isSalesConversionFactorEntryAllowed?: boolean | string;
        weightUnit?: string;
        stockUnitWeight?: decimal | string;
        volumeUnit?: string;
        stockUnitVolume?: decimal | string;
        labelFormatForStockUnit?: string;
        stockManagementMode?: StockManagement;
        managementMode?: StandardProductCode;
        isNegativeStockAuthorized?: boolean | string;
        lotSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        serialSequenceNumber?: string;
        valuationMethod?: string;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        userAccessCode?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        reorderLeadTime?: decimal | string;
        buyer?: string;
        planner?: string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        salesPriceOrigin?: PriceOrigin;
        percentagePricePurchaseApplied?: decimal | string;
        configuratorProductLine?: string;
        isLocationManaged?: boolean | string;
        salesOrderAllocationRule?: string;
        workOrderAllocationRule?: string;
        shipmentAllocationRule?: string;
        materialConsumptionAllocationRule?: string;
        transferAllocationRule?: string;
        subcontractReplenishmentAllocationRule?: string;
        subcontractConsumptionAllocationRule?: string;
        afterSalesAllocationRule?: string;
        isStatusAAuthorizedInGlobalAllocation?: boolean | string;
        isStatusQAuthorizedInGlobalAllocation?: boolean | string;
        isStatusRAuthorizedInGlobalAllocation?: boolean | string;
        abcClass?: ProductAbcClass;
        stockWithdrawalMode?: StockWithdrawal;
        countManagementMode?: Count;
        trendProfile?: string;
        shrinkagePercent?: decimal | string;
        planningFirmHorizon?: integer | string;
        planningFirmHorizonTimeUnit?: LeadTimeUnit;
        planningRequestHorizon?: integer | string;
        planningRequestHorizonTimeUnit?: LeadTimeUnit;
        reorderingPeriodicity?: integer | string;
        reorderingSuggestionType?: SuggestionType;
        reorderingSite?: string;
        reorderingPolicy?: string;
        stockCoverageInWeeks?: integer | string;
        safetyStock?: decimal | string;
        reorderingThreshold?: decimal | string;
        reorderingMaximumStock?: decimal | string;
        economicOrderQuantity?: decimal | string;
        technicalLotQuantity?: decimal | string;
        standardCostUpdate?: PriceUpdateMode;
        revisedStandardCostUpdate?: PriceUpdateMode;
        budgetStandardCostUpdate?: PriceUpdateMode;
        simulatedCostUpdate?: PriceUpdateMode;
        isReleasedIfShortage?: boolean | string;
        automaticClosingPercentage?: decimal | string;
        salesDeliveryTolerance?: decimal | string;
        salesMinimumQuantity?: decimal | string;
        salesMaximumQuantity?: decimal | string;
        isLoanAuthorized?: boolean | string;
        isBackToBackOrderManaged?: boolean | string;
        directBackToBackOrderQuantity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTool?: boolean | string;
        isDeliverable?: boolean | string;
        isIntermediary?: boolean | string;
        isMaintenance?: boolean | string;
        packagingCapacity?: decimal | string;
        assignmentRules?: string;
        isStockDetailedInPacking?: boolean | string;
        technicalSheet?: string;
        orderWarehouse?: string;
        workOrderWarehouse?: string;
        shippingWarehouse?: string;
        materialConsumptionWarehouse?: string;
        internalMovementWarehouse?: string;
        subcontractShipmentWarehouse?: string;
        subcontractConsumptionWarehouse?: string;
        afterSalesWarehouse?: string;
        canBeCapitalized?: boolean | string;
        isPackingManaged?: boolean | string;
        sageSalesTax?: string;
        saftProductType?: SafTProductType;
        freightClass?: string;
        freightCommodityCode?: string;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        inventoryProductType?: ProductType;
        containerManagement?: boolean | string;
        statisticalGroups?: Partial<ProductCategoryStatisticalGroupsInput>[];
        costType?: string;
        lotManagementMode?: LotManagementMode;
        traceabilityManagementMode?: TraceabilityManagementMode;
        traceabilityLevel?: TraceabilityLevel;
        materialCostGroup?: MaterialCostGroup;
        reorderingManagementMode?: ReorderingManagementMode;
        stockVersionMode?: StockVersionMode;
        stockManagementRules?: Partial<StockManagementRulesInput>[];
        defaultLocations?: Partial<ProductCategoryDefaultLocationsInput>[];
        overheads?: Partial<ProductCategoryOverheadsInput>[];
        packingUnits?: Partial<ProductCategoryPackingUnitsInput>[];
        invoicingTerm?: string;
        taxLevels?: Partial<ProductCategoryTaxLevelsInput>[];
        accountingCode?: string;
        dimensions?: Partial<ProductCategoryDimensionsInput>[];
        packaging?: string;
        costStructure?: string;
        matchingTolerance?: string;
        productType?: SalesProductType;
    }
    export interface ProductCategoryBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroupsBinding>;
        costType: CostType;
        lotManagementMode: LotManagementMode;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        materialCostGroup: MaterialCostGroup;
        reorderingManagementMode: ReorderingManagementMode;
        stockVersionMode: StockVersionMode;
        stockManagementRules: ClientCollection<StockManagementRules>;
        defaultLocations: ClientCollection<ProductCategoryDefaultLocationsBinding>;
        overheads: ClientCollection<ProductCategoryOverheadsBinding>;
        packingUnits: ClientCollection<ProductCategoryPackingUnitsBinding>;
        invoicingTerm: InvoicingTerm;
        taxLevels: ClientCollection<ProductCategoryTaxLevelsBinding>;
        accountingCode: AccountingCode;
        dimensions: ClientCollection<ProductCategoryDimensionsBinding>;
        packaging: Packaging;
        costStructure: FreightCostStructure;
        matchingTolerance: MatchingTolerance;
        productType: SalesProductType;
    }
    export interface ProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnits>;
        statisticalGroups: ClientCollection<ProductStatisticalGroups>;
        costType: CostType;
        stockManagementMode: StockManagement;
        lotManagementMode: LotManagementMode;
        materialCostGroup: MaterialCostGroup;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        stockVersionMode: StockVersionMode;
        taxLevels: ClientCollection<ProductTaxLevels>;
        accountingCode: AccountingCode;
        dimensions: ClientCollection<ProductDimensions>;
        costStructure: FreightCostStructure;
        matchingTolerance: MatchingTolerance;
        basePrice: string;
        packaging: Packaging;
        packagingCapacity: string;
        productPickingText: TextStream;
        productSalesText: TextStream;
        substitutionDate: string;
        substitutionProduct: Product;
        loanContract: ServiceContractTemplate;
        warrantyContract: ServiceContractTemplate;
        serviceContract: ServiceContractTemplate;
    }
    export interface ProductInputExtension {
        code?: string;
        company?: string;
        productCategory?: string;
        searchKey?: string;
        description1?: string;
        description2?: string;
        description3?: string;
        localizedDescription1?: string;
        localizedDescription2?: string;
        localizedDescription3?: string;
        managementMode?: StandardProductCode;
        standard?: string;
        upc?: string;
        productStatus?: ProductStatus;
        isPrototype?: boolean | string;
        defaultPotencyInPercentage?: decimal | string;
        defaultPotencyInInternationalUnit?: decimal | string;
        serviceLifeStartDate?: string;
        serviceLifeEndDate?: string;
        storageSheet?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticalUnit?: string;
        eeUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseFactorEntryAllowed?: boolean | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        isSalesFactorEntryAllowed?: boolean | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        eeUnitToStockUnitConversionFactor?: decimal | string;
        weightUnit?: string;
        productWeight?: decimal | string;
        volumeUnit?: string;
        productVolume?: decimal | string;
        lotSequenceNumber?: string;
        serialSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        expirationLeadTime?: integer | string;
        checkLeadTime?: integer | string;
        isNegativeStockAuthorized?: boolean | string;
        costGroup?: string;
        userAccessCode?: string;
        alternateProduct?: string;
        isIntrastatDeclarationSubmitted?: boolean | string;
        intrastatCommodity?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        buyer?: string;
        planner?: string;
        reorderLeadTime?: integer | string;
        purchaseBasePrice?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        exemptionFlag?: string;
        taxFlagStatusLocal?: string;
        configuratorProductLine?: string;
        configuratorNumericField1?: decimal | string;
        configuratorNumericField2?: decimal | string;
        configuratorNumericField3?: decimal | string;
        configuratorNumericField4?: decimal | string;
        configuratorNumericField5?: decimal | string;
        configuratorNumericField6?: decimal | string;
        configuratorAlphaField1?: string;
        configuratorAlphaField2?: string;
        configuratorAlphaField3?: string;
        configuratorAlphaField4?: string;
        configuratorAlphaField5?: string;
        configuratorAlphaField6?: string;
        configurationJournal?: string;
        configuratorBusinessPartner?: string;
        configuratorBusinessPartnerReference?: string;
        configuratorReferenceProduct?: string;
        configuratorPurgeDate?: string;
        isInstalledBaseCreated?: boolean | string;
        voucherCategory?: string;
        tokensToBeCredited?: integer | string;
        creditUnit?: string;
        labelFormatForStockUnit?: string;
        bomCodeForAfterSales?: integer | string;
        productTypeForAfterSales?: TypeOfProduct;
        isAfterSalesProductIssuedByDefault?: boolean | string;
        daysUnit?: string;
        hourUnit?: string;
        minuteUnit?: string;
        productDensity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTools?: boolean | string;
        isDeliverable?: boolean | string;
        isSold?: boolean | string;
        isIntermediary?: boolean | string;
        isCapitalized?: boolean | string;
        newStockStatusAfterRecontrol?: string;
        useByDateCoefficient?: decimal | string;
        intrastatFederalStateOrRegion?: string;
        plmProductReference?: string;
        plmLinkedDocuments?: string;
        plmProductHistory?: string;
        sageSalesTax?: string;
        allergens?: string;
        allergenChangeDate?: string;
        allergenBomCode?: integer | string;
        saftProductType?: SafTProductType;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        productType?: ProductType;
        globalTradeItemNumber?: string;
        supplierProduct?: Partial<SupplierProductInput>[];
        customerProduct?: Partial<CustomerProductInput>[];
        manufacturingText?: TextStream;
        picture?: BinaryStream;
        purchasingText?: TextStream;
        packingUnits?: Partial<ProductPackingUnitsInput>[];
        statisticalGroups?: Partial<ProductStatisticalGroupsInput>[];
        costType?: string;
        stockManagementMode?: StockManagement;
        lotManagementMode?: LotManagementMode;
        materialCostGroup?: MaterialCostGroup;
        traceabilityManagementMode?: TraceabilityManagementMode;
        traceabilityLevel?: TraceabilityLevel;
        expirationTimeUnit?: ExpirationLeadTimeUnits;
        recontrolTimeUnit?: ExpirationLeadTimeUnits;
        stockVersionMode?: StockVersionMode;
        taxLevels?: Partial<ProductTaxLevelsInput>[];
        accountingCode?: string;
        dimensions?: Partial<ProductDimensionsInput>[];
        costStructure?: string;
        matchingTolerance?: string;
        basePrice?: decimal | string;
        packaging?: string;
        packagingCapacity?: decimal | string;
        productPickingText?: TextStream;
        productSalesText?: TextStream;
        substitutionDate?: string;
        substitutionProduct?: string;
        loanContract?: string;
        warrantyContract?: string;
        serviceContract?: string;
    }
    export interface ProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnitsBinding>;
        statisticalGroups: ClientCollection<ProductStatisticalGroupsBinding>;
        costType: CostType;
        stockManagementMode: StockManagement;
        lotManagementMode: LotManagementMode;
        materialCostGroup: MaterialCostGroup;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        stockVersionMode: StockVersionMode;
        taxLevels: ClientCollection<ProductTaxLevelsBinding>;
        accountingCode: AccountingCode;
        dimensions: ClientCollection<ProductDimensionsBinding>;
        costStructure: FreightCostStructure;
        matchingTolerance: MatchingTolerance;
        basePrice: string;
        packaging: Packaging;
        packagingCapacity: string;
        productPickingText: TextStream;
        productSalesText: TextStream;
        substitutionDate: string;
        substitutionProduct: Product;
        loanContract: ServiceContractTemplate;
        warrantyContract: ServiceContractTemplate;
        serviceContract: ServiceContractTemplate;
    }
    export interface ProductExtension$Lookups {
        loanContract: QueryOperation<ServiceContractTemplate>;
        warrantyContract: QueryOperation<ServiceContractTemplate>;
        serviceContract: QueryOperation<ServiceContractTemplate>;
    }
    export interface ProductExtension$Operations {
        lookups(dataOrId: string | { data: ProductInput }): ProductExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-sales/SalesDeliveryBillToCustomerAddressLines': SalesDeliveryBillToCustomerAddressLines$Operations;
        '@sage/x3-sales/SalesDeliveryBillToCustomerCompanyNames': SalesDeliveryBillToCustomerCompanyNames$Operations;
        '@sage/x3-sales/SalesDeliveryCustomerStatisticalGroups': SalesDeliveryCustomerStatisticalGroups$Operations;
        '@sage/x3-sales/SalesDeliveryDimensions': SalesDeliveryDimensions$Operations;
        '@sage/x3-sales/SalesDeliveryDiscountOrChargeCalculationRules': SalesDeliveryDiscountOrChargeCalculationRules$Operations;
        '@sage/x3-sales/SalesDeliveryInvoicingElements': SalesDeliveryInvoicingElements$Operations;
        '@sage/x3-sales/SalesDeliveryLineDistributedInvoicingElements': SalesDeliveryLineDistributedInvoicingElements$Operations;
        '@sage/x3-sales/SalesDeliveryLineProductStatisticalGroups': SalesDeliveryLineProductStatisticalGroups$Operations;
        '@sage/x3-sales/SalesDeliveryLineTaxes': SalesDeliveryLineTaxes$Operations;
        '@sage/x3-sales/SalesDeliveryLine': SalesDeliveryLine$Operations;
        '@sage/x3-sales/SalesDeliverySalesReps': SalesDeliverySalesReps$Operations;
        '@sage/x3-sales/SalesDeliveryShipToCustomerAddressLines': SalesDeliveryShipToCustomerAddressLines$Operations;
        '@sage/x3-sales/SalesDeliveryShipToCustomerCompanyNames': SalesDeliveryShipToCustomerCompanyNames$Operations;
        '@sage/x3-sales/SalesDelivery': SalesDelivery$Operations;
        '@sage/x3-sales/SalesInvoiceBillToCustomerCompanyNames': SalesInvoiceBillToCustomerCompanyNames$Operations;
        '@sage/x3-sales/SalesInvoiceCustomerStatisticalGroups': SalesInvoiceCustomerStatisticalGroups$Operations;
        '@sage/x3-sales/SalesInvoiceDiscountOrChargeCalculationRules': SalesInvoiceDiscountOrChargeCalculationRules$Operations;
        '@sage/x3-sales/SalesInvoiceInvoicingElements': SalesInvoiceInvoicingElements$Operations;
        '@sage/x3-sales/SalesInvoiceLineDistributedInvoicingElements': SalesInvoiceLineDistributedInvoicingElements$Operations;
        '@sage/x3-sales/SalesInvoiceLineProductStatisticalGroups': SalesInvoiceLineProductStatisticalGroups$Operations;
        '@sage/x3-sales/SalesInvoiceLineTaxBasisAmounts': SalesInvoiceLineTaxBasisAmounts$Operations;
        '@sage/x3-sales/SalesInvoiceLineTaxes': SalesInvoiceLineTaxes$Operations;
        '@sage/x3-sales/SalesInvoiceLine': SalesInvoiceLine$Operations;
        '@sage/x3-sales/SalesInvoiceSalesOrderOfPrepayments': SalesInvoiceSalesOrderOfPrepayments$Operations;
        '@sage/x3-sales/SalesInvoiceSalesReps': SalesInvoiceSalesReps$Operations;
        '@sage/x3-sales/SalesInvoiceShipToCustomerAddressLines': SalesInvoiceShipToCustomerAddressLines$Operations;
        '@sage/x3-sales/SalesInvoiceShipToCustomerCompanyNames': SalesInvoiceShipToCustomerCompanyNames$Operations;
        '@sage/x3-sales/SalesInvoice': SalesInvoice$Operations;
        '@sage/x3-sales/SalesOrderBillToCustomerAddressLines': SalesOrderBillToCustomerAddressLines$Operations;
        '@sage/x3-sales/SalesOrderBillToCustomerCompanyNames': SalesOrderBillToCustomerCompanyNames$Operations;
        '@sage/x3-sales/SalesOrderCustomerStatisticalGroups': SalesOrderCustomerStatisticalGroups$Operations;
        '@sage/x3-sales/SalesOrderDimensions': SalesOrderDimensions$Operations;
        '@sage/x3-sales/SalesOrderDiscountOrChargeCalculationRules': SalesOrderDiscountOrChargeCalculationRules$Operations;
        '@sage/x3-sales/SalesOrderInvoicingElements': SalesOrderInvoicingElements$Operations;
        '@sage/x3-sales/SalesOrderLineDimensionDimensions': SalesOrderLineDimensionDimensions$Operations;
        '@sage/x3-sales/SalesOrderLineDimension': SalesOrderLineDimension$Operations;
        '@sage/x3-sales/SalesOrderLineProductStatisticalGroups': SalesOrderLineProductStatisticalGroups$Operations;
        '@sage/x3-sales/SalesOrderLineTaxes': SalesOrderLineTaxes$Operations;
        '@sage/x3-sales/SalesOrderLine': SalesOrderLine$Operations;
        '@sage/x3-sales/SalesOrderQuantityLineDistributedInvoicingElements': SalesOrderQuantityLineDistributedInvoicingElements$Operations;
        '@sage/x3-sales/SalesOrderSalesReps': SalesOrderSalesReps$Operations;
        '@sage/x3-sales/SalesOrderShipToCustomerAddressLines': SalesOrderShipToCustomerAddressLines$Operations;
        '@sage/x3-sales/SalesOrderShipToCustomerCompanyNames': SalesOrderShipToCustomerCompanyNames$Operations;
        '@sage/x3-sales/SalesOrderSoldToCustomerAddressLines': SalesOrderSoldToCustomerAddressLines$Operations;
        '@sage/x3-sales/SalesOrderSoldToCustomerCompanyNames': SalesOrderSoldToCustomerCompanyNames$Operations;
        '@sage/x3-sales/SalesOrder': SalesOrder$Operations;
        '@sage/x3-sales/SalesQuoteDimensions': SalesQuoteDimensions$Operations;
        '@sage/x3-sales/SalesQuoteDiscountOrChargeCalculationRules': SalesQuoteDiscountOrChargeCalculationRules$Operations;
        '@sage/x3-sales/SalesQuoteInvoicingElements': SalesQuoteInvoicingElements$Operations;
        '@sage/x3-sales/SalesQuoteLineDistributedInvoicingElements': SalesQuoteLineDistributedInvoicingElements$Operations;
        '@sage/x3-sales/SalesQuoteLineTaxes': SalesQuoteLineTaxes$Operations;
        '@sage/x3-sales/SalesQuoteLine': SalesQuoteLine$Operations;
        '@sage/x3-sales/SalesQuoteSalesReps': SalesQuoteSalesReps$Operations;
        '@sage/x3-sales/SalesQuoteShipToCustomerAddressLines': SalesQuoteShipToCustomerAddressLines$Operations;
        '@sage/x3-sales/SalesQuoteShipToCustomerCompanyNames': SalesQuoteShipToCustomerCompanyNames$Operations;
        '@sage/x3-sales/SalesQuoteSoldToCustomerAddressLines': SalesQuoteSoldToCustomerAddressLines$Operations;
        '@sage/x3-sales/SalesQuoteSoldToCustomerCompanyNames': SalesQuoteSoldToCustomerCompanyNames$Operations;
        '@sage/x3-sales/SalesQuote': SalesQuote$Operations;
        '@sage/x3-sales/SalesReturnDimensions': SalesReturnDimensions$Operations;
        '@sage/x3-sales/SalesReturnLine': SalesReturnLine$Operations;
        '@sage/x3-sales/SalesReturnShipToCustomerAddressLines': SalesReturnShipToCustomerAddressLines$Operations;
        '@sage/x3-sales/SalesReturnShipToCustomerCompanyNames': SalesReturnShipToCustomerCompanyNames$Operations;
        '@sage/x3-sales/SalesReturn': SalesReturn$Operations;
        '@sage/x3-sales/ServiceContractTemplate': ServiceContractTemplate$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3FinanceData$Package,
            SageX3InvoicingData$Package,
            SageX3ManufacturingData$Package,
            SageX3MasterData$Package,
            SageX3PhysicalFlowsData$Package,
            SageX3ProjectManagementData$Package,
            SageX3PurchasingData$Package,
            SageX3SalesData$Package,
            SageX3Stock$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-sales-api' {
    export type * from '@sage/x3-sales-api-partial';
}
declare module '@sage/x3-finance-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-physical-flows-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-purchasing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-sales-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type {
        CustomerBindingExtension,
        CustomerExtension,
        CustomerExtension$Lookups,
        CustomerExtension$Operations,
        CustomerInputExtension,
        ProductBindingExtension,
        ProductCategoryBindingExtension,
        ProductCategoryExtension,
        ProductCategoryInputExtension,
        ProductExtension,
        ProductExtension$Lookups,
        ProductExtension$Operations,
        ProductInputExtension,
    } from '@sage/x3-sales-api';
    export interface Customer extends CustomerExtension {}
    export interface CustomerBinding extends CustomerBindingExtension {}
    export interface CustomerInput extends CustomerInputExtension {}
    export interface Customer$Lookups extends CustomerExtension$Lookups {}
    export interface Customer$Operations extends CustomerExtension$Operations {}
    export interface ProductCategory extends ProductCategoryExtension {}
    export interface ProductCategoryBinding extends ProductCategoryBindingExtension {}
    export interface ProductCategoryInput extends ProductCategoryInputExtension {}
    export interface Product extends ProductExtension {}
    export interface ProductBinding extends ProductBindingExtension {}
    export interface ProductInput extends ProductInputExtension {}
    export interface Product$Lookups extends ProductExtension$Lookups {}
    export interface Product$Operations extends ProductExtension$Operations {}
}
