declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        VitalClientNode,
        VitalClientNodeInput,
        integer,
    } from '@sage/xtrem-client';
    export interface SysModuleTable$Enum {
        supervisor: 1;
        financials: 2;
        aparAccounting: 3;
        external: 4;
        sales: 5;
        purchasing: 6;
        stock: 7;
        manufacturing: 8;
        commonData: 9;
        development: 10;
        sageX3Internals: 11;
        helpDesk: 12;
        crmActivities: 13;
        fixedAssets: 14;
        humanResourcesAdministration: 15;
        moduleSpe1: 16;
        moduleSpe2: 17;
        moduleSpe3: 18;
        moduleSpe4: 19;
        humanCapitalManagement: 20;
    }
    export type SysModuleTable = keyof SysModuleTable$Enum;
    export interface SysSequenceNumberType$Enum {
        alphanumeric: 1;
        numeric: 2;
    }
    export type SysSequenceNumberType = keyof SysSequenceNumberType$Enum;
    export interface SysTypeOfDependency$Enum {
        none: 1;
        reverse: 2;
        sizing: 3;
        formula: 4;
    }
    export type SysTypeOfDependency = keyof SysTypeOfDependency$Enum;
    export interface SysTypesOfActivityCode$Enum {
        functional: 1;
        sizing: 2;
        localization: 3;
    }
    export type SysTypesOfActivityCode = keyof SysTypesOfActivityCode$Enum;
    export interface SysMiscellaneousTablesColumns extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
    }
    export interface SysMiscellaneousTablesColumnsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
    }
    export interface SysMiscellaneousTablesColumnsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
    }
    export interface SysMiscellaneousTablesColumns$Operations {
        query: QueryOperation<SysMiscellaneousTablesColumns>;
        read: ReadOperation<SysMiscellaneousTablesColumns>;
        aggregate: {
            read: AggregateReadOperation<SysMiscellaneousTablesColumns>;
            query: AggregateQueryOperation<SysMiscellaneousTablesColumns>;
        };
        getDefaults: GetDefaultsOperation<SysMiscellaneousTablesColumns>;
    }
    export interface SysUser extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        name: string;
        nameDescription: string;
        code: string;
        displayName: string;
        photo: BinaryStream;
    }
    export interface SysUserInput extends ClientNodeInput {
        name?: string;
        nameDescription?: string;
        code?: string;
    }
    export interface SysUserBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        name: string;
        nameDescription: string;
        code: string;
        displayName: string;
        photo: BinaryStream;
    }
    export interface SysUser$Lookups {
        functionProfile: QueryOperation<SysUserFunctionProfile>;
    }
    export interface SysUser$Operations {
        query: QueryOperation<SysUser>;
        read: ReadOperation<SysUser>;
        aggregate: {
            read: AggregateReadOperation<SysUser>;
            query: AggregateQueryOperation<SysUser>;
        };
        lookups(dataOrId: string | { data: SysUserInput }): SysUser$Lookups;
        getDefaults: GetDefaultsOperation<SysUser>;
    }
    export interface Package {
        '@sage/xtrem-x3-system-utils/SysMiscellaneousTablesColumns': SysMiscellaneousTablesColumns$Operations;
        '@sage/xtrem-x3-system-utils/SysUser': SysUser$Operations;
    }
    export interface GraphApi extends Package, SageXtremAppMetadata$Package {}
}
declare module '@sage/xtrem-x3-system-utils-api' {
    export type * from '@sage/xtrem-x3-system-utils-api-partial';
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/xtrem-x3-system-utils-api';
    export interface GraphApi extends GraphApiExtension {}
}
