"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @fileoverview Only allow code that may be translated to SQL
 * @author Sage
 */
const xtrem_ts_to_sql_1 = require("@sage/xtrem-ts-to-sql");
const rule = {
    defaultOptions: [],
    meta: {
        type: 'problem',
        docs: {
            url: '',
            description: 'Only allow code that may be translated to SQL',
            recommended: 'strict',
        },
        fixable: undefined, // or "code" or "whitespace"
        schema: [
        // fill in your schema
        ],
        messages: {
            cannotBeConvertedToSql: 'Cannot be converted to SQL: {{error}}.',
        },
    },
    create(context) {
        const queryFilterSelector = "CallExpression[callee.type='MemberExpression'][callee.property.name='query']" +
            ' > ObjectExpression' +
            ' > Property[key.name="filter"]' +
            ' > FunctionExpression';
        const referenceJoinSelector = 'PropertyDefinition' +
            ' > Decorator' +
            " > CallExpression[callee.property.name='referenceProperty']" +
            ' > ObjectExpression' +
            " > Property[key.name='join']" +
            ' > ObjectExpression' +
            ' > Property' +
            ' > FunctionExpression';
        const checkFunction = (node) => {
            try {
                new xtrem_ts_to_sql_1.EsLintConverter({}).convertFunctionExpression(node);
            }
            catch (ex) {
                context.report({
                    node: ex instanceof xtrem_ts_to_sql_1.ConversionError ? ex.node : node,
                    messageId: 'cannotBeConvertedToSql',
                    data: {
                        error: ex.message,
                    },
                });
            }
        };
        return {
            [queryFilterSelector](node) {
                checkFunction(node);
            },
            [referenceJoinSelector](node) {
                checkFunction(node);
            },
        };
    },
};
exports.default = rule;
//# sourceMappingURL=sql-compatible.js.map