"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildDefaultValueNotCompliantError = void 0;
/**
 * @fileoverview Check property decorators
 * @author Sage
 */
const xtrem_ts_to_sql_1 = require("@sage/xtrem-ts-to-sql");
const property_decorators_errors_1 = require("./property-decorators-errors");
function buildDefaultValueNotCompliantError(propertyName) {
    return `The function ${propertyName}.defaultValue() is too complex to be parsed. You will need to create a DataUpdateAction to support upgrades (see https://confluence.sage.com/display/XTREEM/Upgrade+Engine)`;
}
exports.buildDefaultValueNotCompliantError = buildDefaultValueNotCompliantError;
function checkDefaultValueFunction(context, fnToTest) {
    const error = (0, property_decorators_errors_1.getErrorWhenConverting)(fnToTest);
    if (!error)
        return;
    const propertyName = (0, property_decorators_errors_1.getEnclosingPropertyName)(fnToTest);
    context.report({
        node: error instanceof xtrem_ts_to_sql_1.ConversionError ? error.node : fnToTest,
        messageId: 'error',
        data: {
            error: buildDefaultValueNotCompliantError(propertyName),
        },
    });
}
const rule = {
    defaultOptions: [],
    meta: {
        type: 'problem',
        docs: {
            url: '',
            description: 'Check property decorators',
            recommended: 'recommended',
        },
        fixable: 'code', // or "code" or "whitespace"
        schema: [
        // fill in your schema
        ],
        messages: {
            error: '{{error}}',
        },
    },
    create(context) {
        // Retrieve all the property decorators
        const decoratorsSelector = 'PropertyDefinition > Decorator > CallExpression > ObjectExpression';
        return {
            // Rule: defaultValue() functions must be "ts-to-sql compliant"
            [`${decoratorsSelector} > Property[key.name="defaultValue"][value.type='FunctionExpression'] > FunctionExpression`](defaultValueFunction) {
                checkDefaultValueFunction(context, defaultValueFunction);
            },
        };
    },
};
exports.default = rule;
//# sourceMappingURL=property-decorators-warnings.js.map