"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rules = exports.configs = void 0;
/**
 * @fileoverview Lint rules for Xtrem development
 * @author Sage
 */
const lodash_1 = require("lodash");
const requireIndex = require('requireindex');
// import all rules in lib/rules
const transformDir = (dir) => (0, lodash_1.transform)(requireIndex(`${__dirname}/${dir}`), (result, val, key) => {
    result[key] = val.default;
});
const rules = transformDir('rules');
exports.rules = rules;
const configs = {
    'recommended-json': {
        plugins: ['@sage/xtrem'],
        rules: {
            '@sage/xtrem/no-exclusive-graphql-tests': 'error',
            '@typescript-eslint/*': 'off',
            '@typescript-eslint/quotes': 'off',
            '@typescript-eslint/semi': 'off',
            '@typescript-eslint/comma-dangle': 'off',
            '@typescript-eslint/no-unused-expressions': 'off',
        },
    },
    'recommended-ts': {
        plugins: ['@sage/xtrem'],
        rules: {
            // Enabled for debug
            // '@sage/xtrem/ast-explorer': 'error',
            '@sage/xtrem/check-nullable-property': 'warn',
            '@sage/xtrem/property-decorators-errors': 'error',
            '@sage/xtrem/property-decorators-warnings': 'warn',
            '@sage/xtrem/check-data-update-actions': 'error',
            '@sage/xtrem/sql-compatible': 'error',
            '@sage/xtrem/call-super-in-control': 'error',
        },
    },
    'ast-explorer-ts': {
        plugins: ['@sage/xtrem'],
        rules: {
            '@sage/xtrem/ast-explorer': 'warn',
        },
    },
};
exports.configs = configs;
//# sourceMappingURL=index.js.map