/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.broadcastCompilerSuccessMessage=exports.addCompilerErrorToDispatchQueue=exports.addTsLoaderErrorToDispatchQueue=exports.addTsDiagnosticToDispatchQueue=exports.broadcastMessage=exports.initiateSocketServer=exports.EventType=void 0;const xtrem_core_1=require("@sage/xtrem-core"),lodash_1=require("lodash"),path=require("path"),io=require("socket.io"),ts=require("typescript"),logger=new xtrem_core_1.Logger(__filename,"xtrem-cli-socket"),authenticatedClients=[],errorsToDispatch=[];var EventType;!function(e){e.AUTH="AUTH",e.REBOUNCE="REBOUNCE",e.FATAL_ERROR="FATAL_ERROR",e.COMPILER_STARTED="COMPILER_STARTED",e.COMPILER_SUCCESS="COMPILER_SUCCESS",e.COMPILER_FAILURE="COMPILER_FAILURE"}(EventType||(exports.EventType=EventType={}));const initiateSocketServer=(e,t)=>new Promise(r=>{const s=new io.Server;s.on("connection",s=>{s.on(EventType.AUTH,t=>{if(String(t)===String(e))authenticatedClients.push(s),logger.debug(()=>`Client connected and authenticated ${s.id}`),r();else logger.warn(()=>`Client failed to authenticate: ${s.id}`),s.disconnect()}),s.on(EventType.REBOUNCE,()=>{if(-1!==authenticatedClients.indexOf(s))t?.onRebounce?.()}),s.on(EventType.AUTH,t=>{if(String(t)===String(e))authenticatedClients.push(s),logger.debug(()=>`Client connected and authenticated ${s.id}`),r();else logger.warn(()=>`Client failed to authenticate: ${s.id}`),s.disconnect()}),s.on("disconnect",()=>{const e=authenticatedClients.indexOf(s);if(logger.debug(()=>`Client was disconnected: ${s.id}`),-1!==e)authenticatedClients.splice(e,1)})}),s.listen(4002),logger.debug(()=>`Compilation event stream has been initialized with the following key: ${e}`)});exports.initiateSocketServer=initiateSocketServer;const broadcastMessage=(e,t)=>{logger.debug(()=>`Broadcasting message: ${e}`),authenticatedClients.forEach(r=>{r.emit(e,t)})};exports.broadcastMessage=broadcastMessage;const dispatchErrors=()=>{(0,exports.broadcastMessage)(EventType.COMPILER_FAILURE,errorsToDispatch),errorsToDispatch.splice(0,errorsToDispatch.length)},debouncedDispatch=(0,lodash_1.debounce)(dispatchErrors,300),addTsDiagnosticToDispatchQueue=(e,t)=>{if(e.file&&e.start){const{line:r,character:s}=e.file.getLineAndCharacterOfPosition(e.start),o=ts.flattenDiagnosticMessageText(e.messageText,"\n").trim();(0,exports.addCompilerErrorToDispatchQueue)({code:e.code,file:e.file.fileName,line:r+1,character:s+1,message:o,source:t})}};exports.addTsDiagnosticToDispatchQueue=addTsDiagnosticToDispatchQueue;const addTsLoaderErrorToDispatchQueue=(e,t)=>{const r=e.split("\n");if(r.length>0)try{const e=JSON.parse(r[r.length-1]);return void(0,exports.addCompilerErrorToDispatchQueue)({code:e.code,file:path.isAbsolute(e.file)?e.file:path.resolve(t,e.file),line:e.line,character:e.character,message:e.content,source:"client"})}catch(e){}(0,exports.addCompilerErrorToDispatchQueue)({code:1e3,file:"UNKNOWN",line:0,character:0,message:e,source:"client"})};exports.addTsLoaderErrorToDispatchQueue=addTsLoaderErrorToDispatchQueue;const addCompilerErrorToDispatchQueue=e=>{errorsToDispatch.push(e),debouncedDispatch()};exports.addCompilerErrorToDispatchQueue=addCompilerErrorToDispatchQueue;const broadcastCompilerSuccessMessage=e=>{if(0===errorsToDispatch.length)(0,exports.broadcastMessage)(EventType.COMPILER_SUCCESS,e)};exports.broadcastCompilerSuccessMessage=broadcastCompilerSuccessMessage;
//# sourceMappingURL=socket-helper.js.map