import * as ts from 'typescript';
export declare enum EventType {
    AUTH = "AUTH",
    REBOUNCE = "REBOUNCE",
    FATAL_ERROR = "FATAL_ERROR",
    COMPILER_STARTED = "COMPILER_STARTED",
    COMPILER_SUCCESS = "COMPILER_SUCCESS",
    COMPILER_FAILURE = "COMPILER_FAILURE"
}
export type ErrorSource = 'server' | 'client';
export interface Event {
    type: EventType;
    data: any;
}
export interface CompilationError {
    code: number;
    file: string;
    line: number;
    character: number;
    message: string;
    source: ErrorSource;
}
export declare const initiateSocketServer: (key: string, options?: {
    onRebounce: () => void;
}) => Promise<void>;
export declare const broadcastMessage: (type: EventType, data?: any) => void;
export declare const addTsDiagnosticToDispatchQueue: (diagnostic: ts.Diagnostic, source: ErrorSource) => void;
export declare const addTsLoaderErrorToDispatchQueue: (error: string, dir: string) => void;
export declare const addCompilerErrorToDispatchQueue: (error: CompilationError) => void;
export declare const broadcastCompilerSuccessMessage: (type: ErrorSource) => void;
//# sourceMappingURL=socket-helper.d.ts.map