/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.hashFile=exports.getMetadataFilePathForClientFile=exports.copyFolderRecursive=exports.copyFile=exports.safeRmSync=exports.mkdirp=exports.getNpmCommandName=exports.ArtifactTypes=exports.PackagingMode=void 0;const crypto=require("crypto"),fs=require("fs"),path=require("path");var PackagingMode,ArtifactTypes;!function(e){e.DEV="DEV",e.PROD="PROD"}(PackagingMode||(exports.PackagingMode=PackagingMode={})),function(e){e.Pages="pages",e.Stickers="stickers",e.PageExtensions="page-extensions",e.PageFragments="page-fragments"}(ArtifactTypes||(exports.ArtifactTypes=ArtifactTypes={}));const getNpmCommandName=()=>"win32"===process.platform?"npm.cmd":"npm";function mkdirp(e){try{fs.mkdirSync(e,{recursive:true})}catch(e){if("EEXIST"!==e.code)throw e}}function safeRmSync(e,t){try{fs.rmSync(e,t)}catch(e){if("ENOENT"!==e.code)throw e}}function copyFile(e,t){let s=t;const a=path.dirname(s);if(!fs.existsSync(a))fs.mkdirSync(a);if(fs.existsSync(t))if(fs.lstatSync(t).isDirectory())s=path.join(t,path.basename(e));fs.writeFileSync(s,fs.readFileSync(e))}function copyFolderRecursive(e,t,s=false){let a=[];const r=s?path.resolve(t):path.join(t,path.basename(e));if(!fs.existsSync(r))fs.mkdirSync(r);if(fs.lstatSync(e).isDirectory())a=fs.readdirSync(e),a.forEach(t=>{const s=path.join(e,t);if(fs.lstatSync(s).isDirectory())copyFolderRecursive(s,r);else copyFile(s,r)})}function getMetadataFilePathForClientFile(e,t){const s=path.basename(path.dirname(t)),a=path.resolve(e,`build/lib/${s}`),r=path.basename(t).replace(/\.ts$/,".meta.json");return path.resolve(a,r)}function hashFile(e){return crypto.createHash("md5").update(fs.readFileSync(e,"utf-8")).digest("hex")}exports.getNpmCommandName=getNpmCommandName,exports.mkdirp=mkdirp,exports.safeRmSync=safeRmSync,exports.copyFile=copyFile,exports.copyFolderRecursive=copyFolderRecursive,exports.getMetadataFilePathForClientFile=getMetadataFilePathForClientFile,exports.hashFile=hashFile;
//# sourceMappingURL=file.js.map