/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai");require("chai-as-promised");const path=require("path"),test_1=require("../lib/commands/handlers/test"),utils_1=require("../lib/commands/utils");describe.skip("GraphQL framework tests",()=>{const e=path.join(__dirname,"fixtures/x3-test");before(()=>{(0,xtrem_core_1.getTestFixtures)().updateContext(),process.env.APPLICATION_DIR=e,xtrem_core_1.ConfigManager.load(path.join(__dirname,".."),"test")}),it("passing tests",async()=>{await(0,test_1.executeGraphqlTests)(xtrem_cli_lib_1.ExecutionMode.INTEGRATED,e,false,"pass"),chai_1.assert.isEmpty(utils_1.mochaErrors,"Positive flow test should not return errors")}),it("execution mode tests",async()=>{await(0,test_1.executeGraphqlTests)(xtrem_cli_lib_1.ExecutionMode.INTEGRATED,e,false,"execution-mode"),chai_1.assert.isEmpty(utils_1.mochaErrors,"Positive flow test should not return errors")}),it("layers",async()=>{await(0,test_1.executeGraphqlTests)(xtrem_cli_lib_1.ExecutionMode.INTEGRATED,e,false,"layers"),chai_1.assert.isEmpty(utils_1.mochaErrors,"layer configuration should not throw any error")}),it("failing tests",async()=>{await chai_1.assert.isRejected((0,test_1.executeGraphqlTests)(xtrem_cli_lib_1.ExecutionMode.INTEGRATED,e,false,"fail")),chai_1.assert.isNotEmpty(utils_1.mochaErrors,"MochaErrors should contain error reports from failing tests."),(0,chai_1.expect)(utils_1.mochaErrors["fail-missing-request"][0]).to.match(/Request file is missing, you need to add either 'request\.graphql' or 'request\.graphql\.hbs' to.*fail-missing-request.*See https:\/\/confluence\.sage\.com\/display\/ETNA\/GraphQL\+test\+framework for a detailed documentation\./),(0,chai_1.expect)(utils_1.mochaErrors["fail-empty-request-file"][0]).to.match(/'request\.graphql' under.*fail-empty-request-file.*is empty\. See https:\/\/confluence\.sage\.com\/display\/ETNA\/GraphQL\+test\+framework for a detailed documentation\./),(0,chai_1.expect)(utils_1.mochaErrors["fail-empty-response-file"][0]).to.match(/'response.json' under.*fail-empty-response-file.*is empty\. See https:\/\/confluence\.sage\.com\/display\/ETNA\/GraphQL\+test\+framework for a detailed documentation\./),(0,chai_1.expect)(utils_1.mochaErrors["fail-missing-response"][0]).to.match(/Response file is missing, you need to add either 'response\.json' or 'response\.json\.hbs' to.*fail-missing-response.*See https:\/\/confluence\.sage\.com\/display\/ETNA\/GraphQL\+test\+framework for a detailed documentation\./),(0,chai_1.expect)(utils_1.mochaErrors["fail-missing-parameters-file"][0]).to.match(/Parameters file is missing: you need to add a file called 'parameters\.json' under.*fail-missing-parameters-file.*See https:\/\/confluence\.sage\.com\/display\/ETNA\/GraphQL\+test\+framework for a detailed documentation\./),(0,chai_1.expect)(utils_1.mochaErrors["fail-missing-parameters"][0]).to.match(/You need to add the following variables as an object to 'filter by countryName' under the 'input' key: \["TestNodes\.countryName"\]\. See https:\/\/confluence\.sage\.com\/display\/ETNA\/GraphQL\+test\+framework for a detailed documentation\./),(0,chai_1.expect)(utils_1.mochaErrors["fail-missing-parameters-output"][0]).to.match(/You need to add the following variables as an object to 'filter by countryName' under the 'output' key: \["code","countryName","description"\]\. See https:\/\/confluence\.sage.com\/display\/ETNA\/GraphQL\+test\+framework for a detailed documentation\./),(0,chai_1.expect)(utils_1.mochaErrors["fail-invalid-mock"][0]).to.equal("No plugin found for 'invalid' mock.: expected undefined to exist"),(0,chai_1.expect)(utils_1.mochaErrors["fail-without-hbs-with-env-parameters-variables"][0]).to.match(/'variables' property is only for handlebars tests \(with request\.graphql\.hbs and response\.json\.hbs\)\. See https:\/\/confluence\.sage.com\/display\/ETNA\/GraphQL\+test\+framework for a detailed documentation\./),(0,chai_1.expect)(utils_1.mochaErrors["fail-without-hbs-with-env-parameters-and-output"][0]).to.match(/'output' property is only for handlebars tests \(with request\.graphql\.hbs and response\.json\.hbs\)\. See https:\/\/confluence\.sage.com\/display\/ETNA\/GraphQL\+test\+framework for a detailed documentation\./),(0,chai_1.expect)(utils_1.mochaErrors["fail-without-hbs-with-env-parameters-and-input"][0]).to.match(/'input' property is only for handlebars tests \(with request\.graphql\.hbs and response\.json\.hbs\)\. See https:\/\/confluence\.sage.com\/display\/ETNA\/GraphQL\+test\+framework for a detailed documentation\./)})});
//# sourceMappingURL=graphql-test.js.map