/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),xtrem_decimal_1=require("@sage/xtrem-decimal"),chai_1=require("chai");function toString(a){return void 0!==a?a.toString():a}const mapArguments=a=>Object.keys(a).reduce((a,t)=>(a[t]=toString(a[t]),a),a),assertEqual=chai_1.assert.equal;chai_1.assert.equal=function(a,t,s){assertEqual.apply(chai_1.assert,mapArguments(arguments))};const assertStrictEqual=chai_1.assert.strictEqual;function round(a,t){const s=1/t;return Math.round(a*s)/s}function round2(a,t){const s=Math.pow(10,t);return Math.round(a*s)/s}chai_1.assert.strictEqual=function(a,t,s){assertStrictEqual.apply(chai_1.assert,mapArguments(arguments))},describe("Instantiation",function(){it("Instantiation",function(){chai_1.assert.strictEqual(xtrem_decimal_1.Decimal.make("123.456"),123.456)})}),describe("Literals",function(){it("literals",function(){let a=.1;chai_1.assert.strictEqual(1,1),chai_1.assert.strictEqual(.1,.1),chai_1.assert.strictEqual(a,.1),chai_1.assert.strictEqual(.1,a),chai_1.assert.equal(a,.1),chai_1.assert.equal(.1,a),a=-.1,chai_1.assert.strictEqual(-.1,-.1),chai_1.assert.strictEqual(a,-.1),chai_1.assert.strictEqual(-.1,a),a=0xab54a98ceb1f0800,chai_1.assert.strictEqual(a,0xab54a98ceb1f0800),chai_1.assert.strictEqual(0xab54a98ceb1f0800,a),chai_1.assert.strictEqual(0xab54a98ceb1f0800,0xab54a98ceb1f0800);let t=1;chai_1.assert.strictEqual(t,1),t=-1,chai_1.assert.strictEqual(t,-1)}),it("literal is Decimal",function(){chai_1.assert.ok(xtrem_decimal_1.Decimal.isDecimal(xtrem_decimal_1.Decimal.make(123.456))),chai_1.assert.ok(xtrem_decimal_1.Decimal.isDecimal(xtrem_decimal_1.Decimal.make("123.456"))),chai_1.assert.ok(xtrem_decimal_1.Decimal.isDecimal(123.456)),chai_1.assert.ok(!xtrem_decimal_1.Decimal.isDecimal(1)),chai_1.assert.ok(!xtrem_decimal_1.Decimal.isDecimal(1)),chai_1.assert.ok(!xtrem_decimal_1.Decimal.isDecimal(-1)),chai_1.assert.ok(!xtrem_decimal_1.Decimal.isDecimal(1e10)),chai_1.assert.ok(!xtrem_decimal_1.Decimal.isDecimal(1e-10)),chai_1.assert.ok(!xtrem_decimal_1.Decimal.isDecimal(1e10)),chai_1.assert.ok(!xtrem_decimal_1.Decimal.isDecimal(-1e10))})}),describe("Add",function(){it("basic additions",function(){const a=.1,t=.2;let s=a+t;s=.1+.2,chai_1.assert.strictEqual(s,.3);const i=a+t+s;chai_1.assert.strictEqual(i,.6);const e=.4+i;chai_1.assert.strictEqual(e,1);const c=1+e;chai_1.assert.strictEqual(c,2);const r=c+1;chai_1.assert.strictEqual(r,3),chai_1.assert.strictEqual(.1+.2,.3),chai_1.assert.strictEqual(1.3,1.3),chai_1.assert.strictEqual(1.3,1.3),chai_1.assert.strictEqual(1e-15+2e-15,3e-15),chai_1.assert.strictEqual(-1e-15-2e-15,-3e-15),chai_1.assert.strictEqual(0,0),chai_1.assert.strictEqual(1,1),chai_1.assert.strictEqual(-1,-1);const l=0+`${123}.${456}`;chai_1.assert.strictEqual(l,"0123.456"),chai_1.assert.strictEqual("0123.456","0123.456");const _="s1",u="s2";chai_1.assert.strictEqual(_+u,"s1s2")})}),describe("Subtract",function(){it("basic subtractions",function(){const a=.2,t=.1,s=a-t;chai_1.assert.strictEqual(s,.1);const i=t-a;chai_1.assert.strictEqual(i,-.1),chai_1.assert.strictEqual(.4-.1,.3),chai_1.assert.strictEqual(1-.7,.3),chai_1.assert.strictEqual(1.3-1,.3),chai_1.assert.strictEqual(-123.456,-123.456),chai_1.assert.strictEqual(-123.456,-123.456),chai_1.assert.strictEqual(120.056,120.056),chai_1.assert.strictEqual(120.456,120.456)})}),describe("Multiply",function(){it("basic multiplications",function(){const a=.2*.3;chai_1.assert.strictEqual(a,.06),chai_1.assert.strictEqual(.06,.06),chai_1.assert.strictEqual(.6,.6),chai_1.assert.strictEqual(.6,.6),chai_1.assert.strictEqual(1.23456789012,1.23456789012),chai_1.assert.strictEqual(1.23456789012,1.23456789012),chai_1.assert.strictEqual(1.234567890123,1.234567890123),chai_1.assert.strictEqual(1.234567890123,1.234567890123),chai_1.assert.strictEqual(1.2345678901234,1.2345678901234),chai_1.assert.strictEqual(1.2345678901234,1.2345678901234),chai_1.assert.strictEqual(246.912,246.912),chai_1.assert.strictEqual(246.912,246.912);const t=10;chai_1.assert.strictEqual(4*t,40)})}),describe("Divide",function(){it("basic divisions",function(){const a=.6/.2;chai_1.assert.strictEqual(a,3),chai_1.assert.strictEqual(.6/.2,3),chai_1.assert.strictEqual(.3,.3),chai_1.assert.strictEqual(10,10),chai_1.assert.strictEqual(4.8,4.8),chai_1.assert.strictEqual(4.8,4.8)})}),describe("tests on compound assignment operators",function(){it("tests on compound assignment operators",function(){let a=.8;chai_1.assert.strictEqual(a,.8),a+=1,chai_1.assert.strictEqual(a,1.8),a/=2,chai_1.assert.strictEqual(a,.9),a*=2,chai_1.assert.strictEqual(a,1.8);let t=1;t+=2,chai_1.assert.ok(!xtrem_decimal_1.Decimal.isDecimal(t)),chai_1.assert.strictEqual(t,3),t-=3,chai_1.assert.ok(!xtrem_decimal_1.Decimal.isDecimal(t)),chai_1.assert.strictEqual(t,0)})}),describe("tests on unary expressions",function(){it("tests on unary expressions",function(){const a="1";chai_1.assert.strictEqual(+a,1);const t="1";chai_1.assert.strictEqual(1,+t);const s=1;chai_1.assert.strictEqual(+s,1);const i=1;chai_1.assert.strictEqual(1,+i)})}),describe("conditions",function(){it("basic conditions",function(){const a=.1,t=.2;chai_1.assert.equal(a,a),chai_1.assert.strictEqual(a,a),chai_1.assert.equal(a,.1),chai_1.assert.strictEqual(a,.1),chai_1.assert.strictEqual(.1,a),chai_1.assert.notStrictEqual(1,a),chai_1.assert.notStrictEqual(a,1),chai_1.assert.notStrictEqual(0,0),chai_1.assert.notStrictEqual(1,1),chai_1.assert.equal("0",0),chai_1.assert.equal("1",1),chai_1.assert.notOk(.1!=a),chai_1.assert.notOk(.1!==a),chai_1.assert.notOk(a!=a),chai_1.assert.ok(a<t),chai_1.assert.ok(a<=t),chai_1.assert.notOk(a>t),chai_1.assert.notOk(a>=t),chai_1.assert.ok(true),chai_1.assert.notOk(false),chai_1.assert.equal(0,0),chai_1.assert.equal(0,"0"),chai_1.assert.equal("0",0),chai_1.assert.equal(0,0),chai_1.assert.ok(!0),chai_1.assert.equal(0,0),chai_1.assert.ok(!0),chai_1.assert.equal(0,0),chai_1.assert.ok(!0),chai_1.assert.notEqual(0,1),chai_1.assert.notOk(false),chai_1.assert.notEqual(0,1),chai_1.assert.notOk(!1),chai_1.assert.notEqual(0,1),chai_1.assert.notOk(!1),chai_1.assert.notEqual(0,1),chai_1.assert.notOk(!1);const s=1;let i,e;chai_1.assert.equal(1,1),chai_1.assert.equal(1,"1"),chai_1.assert.ok(true),chai_1.assert.equal(1,1),chai_1.assert.ok(true),chai_1.assert.equal(1,s),chai_1.assert.ok(1===s),chai_1.assert.equal(1,s.toNumber()),chai_1.assert.ok(1===s.toNumber()),chai_1.assert.equal(1,1),chai_1.assert.ok(true),chai_1.assert.notEqual(1,3),chai_1.assert.notOk(1==3),chai_1.assert.notEqual(1,3),chai_1.assert.notOk(1==3),chai_1.assert.notEqual(1,3),chai_1.assert.notOk(1==3),chai_1.assert.equal(3,3),chai_1.assert.equal(3,"3"),chai_1.assert.ok(true),chai_1.assert.equal(3,3),chai_1.assert.ok(true),chai_1.assert.equal(3,3),chai_1.assert.ok(true),chai_1.assert.notEqual(4,3),chai_1.assert.notOk(4==3),chai_1.assert.notEqual(4,"3"),chai_1.assert.notOk(false),chai_1.assert.notEqual(4,3),chai_1.assert.notOk(4==3),chai_1.assert.notEqual(4,"3.0"),chai_1.assert.notEqual(4,3),chai_1.assert.notOk(4==3),chai_1.assert.ok(1<2),chai_1.assert.ok(1<2),chai_1.assert.ok(1<2),chai_1.assert.notOk(2<1),chai_1.assert.notOk(2<1),chai_1.assert.notOk(2<1),chai_1.assert.ok(true),chai_1.assert.ok(true),chai_1.assert.ok(true),chai_1.assert.ok(true),chai_1.assert.ok(true),chai_1.assert.ok(true),chai_1.assert.notOk(2<=1),chai_1.assert.notOk(2<=1),chai_1.assert.notOk(2<=1),chai_1.assert.ok(3>2),chai_1.assert.ok(3>2),chai_1.assert.ok(3>2),chai_1.assert.notOk(2>3),chai_1.assert.notOk(2>3),chai_1.assert.notOk(2>3),chai_1.assert.ok(true),chai_1.assert.ok(true),chai_1.assert.ok(true),chai_1.assert.ok(true),chai_1.assert.ok(true),chai_1.assert.ok(true),chai_1.assert.notOk(2>=3),chai_1.assert.notOk(2>=3),chai_1.assert.notOk(2>=3),chai_1.assert.equal(i,e),chai_1.assert.strictEqual(i,e),chai_1.assert.notOk(i!=e),chai_1.assert.notOk(i!==e);const c={value:"string"};chai_1.assert.ok(null!=c),chai_1.assert.ok(void 0!==c),chai_1.assert.ok(null!=c.value),chai_1.assert.ok(null!=c.value),chai_1.assert.ok(null!=c.value),chai_1.assert.ok(null!=c.value),chai_1.assert.ok(void 0!==c.value),chai_1.assert.ok(void 0!==c.value),chai_1.assert.ok(null!==c.value),chai_1.assert.ok(null!==c.value)})}),describe("Objects",function(){it("tests with Objects",function(){const a={value:.1};chai_1.assert.strictEqual(a.value,.1)})}),describe("unary expressions",function(){it("prefix unary expressions block 1",function(){let a=1.8,t=0;t=++a,chai_1.assert.strictEqual(t,2.8),chai_1.assert.strictEqual(a,2.8),t=--a,chai_1.assert.strictEqual(t,1.8),chai_1.assert.strictEqual(a,1.8);let s=1;chai_1.assert.ok(xtrem_decimal_1.Decimal.isDecimal(s)),s=s.toNumber(),chai_1.assert.ok("number"==typeof s),chai_1.assert.notOk(xtrem_decimal_1.Decimal.isDecimal(s)),s=+s,chai_1.assert.ok("number"==typeof s),chai_1.assert.notOk(xtrem_decimal_1.Decimal.isDecimal(s)),s=-s,chai_1.assert.ok("number"==typeof s),chai_1.assert.notOk(xtrem_decimal_1.Decimal.isDecimal(s))}),it("postfix unary expressions block 1",function(){let a=1.8,t=0;t=a++,chai_1.assert.strictEqual(t,1.8),chai_1.assert.strictEqual(a,2.8),t=a--,chai_1.assert.strictEqual(t,2.8),chai_1.assert.strictEqual(a,1.8)}),it("postfix unary expressions block 2",function(){let a=1.8,t=0;t=a++,chai_1.assert.strictEqual(t,1.8),chai_1.assert.strictEqual(a,2.8),t=a--,chai_1.assert.strictEqual(t,2.8),chai_1.assert.strictEqual(a,1.8)})}),describe("Functions",function(){const f1=a=>a,f2=(a,t)=>a+t,parseNumber=a=>{if(xtrem_core_1.DateValue.isDate(a))return a.value;return+a};it("functions",function(){let a=.1;const t=.2;chai_1.assert.strictEqual(f1(a),a),a=0xab54a98ceb1f0800,chai_1.assert.strictEqual(f1(a),a),a=.1,chai_1.assert.strictEqual(f2(a,t),.3)}),it("dates",function(){const a=2017,t=xtrem_core_1.DateValue.make(a+1,1,1);chai_1.assert.strictEqual(t.year,a+1),chai_1.assert.strictEqual(t.year,2018),chai_1.assert.strictEqual(t.month,1),chai_1.assert.strictEqual(t.day,1);const s=t.addDays(-1);chai_1.assert.strictEqual(s.year,2017);const i=xtrem_core_1.DateValue.today();chai_1.assert.ok(0!=parseNumber(i)),chai_1.assert.ok(0!==parseNumber(i))})}),describe("Blocks",function(){it("Block if 1",function(){let a,t=true;for(a=0;a<2;a++,t=false)if(t)chai_1.assert.strictEqual(a,0);else chai_1.assert.strictEqual(a,1);chai_1.assert.strictEqual(a,2)}),it("Block if 2",function(){for(let a=0,t=true;a<2;a++,t=false)if(t)chai_1.assert.strictEqual(a,0);else chai_1.assert.strictEqual(a,1)}),it("Block if 3",function(){for(let a=true,t=0;t<2;a=false){if(a)chai_1.assert.strictEqual(t,0);else chai_1.assert.strictEqual(t,1);t++}})}),describe("Spreads",function(){it("spread",function(){const a={...{key1:1}};chai_1.assert.strictEqual(a.key1,1)})}),describe("Math",function(){it("max",function(){chai_1.assert.isTrue(xtrem_decimal_1.Decimal.isDecimal(Math.max(1,2.01))),chai_1.assert.strictEqual(typeof Math.max(1,2),"number"),chai_1.assert.strictEqual(Math.max(1,2),2),chai_1.assert.strictEqual(Math.max(1,2.01),2.01),chai_1.assert.strictEqual(Math.max(1,3.01,2),3.01),chai_1.assert.strictEqual(Math.max(2.01,1),2.01),chai_1.assert.strictEqual(Math.max(.1,.2),.2);const a=new xtrem_decimal_1.Decimal("5.03248572345834856933174533434346346912144534543e+24");chai_1.assert.strictEqual(Math.max(1,a),a);const t=Math.max(1,2);chai_1.assert.isTrue("number"==typeof t),assertStrictEqual(t,2)}),it("min",function(){chai_1.assert.isTrue(xtrem_decimal_1.Decimal.isDecimal(Math.min(1,2.01))),chai_1.assert.strictEqual(typeof Math.min(1,2),"number"),chai_1.assert.strictEqual(Math.min(1,2),1),chai_1.assert.strictEqual(Math.min(1,2.01),1),chai_1.assert.strictEqual(Math.min(2.01,1),1),chai_1.assert.strictEqual(Math.min(2.01,1,.5),.5),chai_1.assert.strictEqual(Math.min(.1,.2),.1);const a=new xtrem_decimal_1.Decimal("5.03248572345834856933174533434346346912144534543e+24");chai_1.assert.strictEqual(Math.min(1,a),1);const t=Math.min(1,2);chai_1.assert.isTrue("number"==typeof t),assertStrictEqual(t,1)}),it("round",function(){chai_1.assert.strictEqual(typeof Math.round(.9),"number"),chai_1.assert.strictEqual(typeof Math.round(0),"number"),chai_1.assert.strictEqual(Math.round(.9),1),chai_1.assert.equal(round(30.4166667,.01),30.42),chai_1.assert.equal(round2(.73213,5),.73213),chai_1.assert.equal(round2(.732131,5),.73213),chai_1.assert.equal(round2(.732138,5),.73214),chai_1.assert.equal(round2(1,5),1),chai_1.assert.equal(round2(1,5),xtrem_decimal_1.Decimal.toNumber(1));const a=Math.round(.73213*Math.pow(10,5))/Math.pow(10,5),t=.73213;chai_1.assert.strictEqual(a,t),chai_1.assert.strictEqual(Math.round(1.9),2),chai_1.assert.strictEqual(Math.round(1.4),1);const s=new xtrem_decimal_1.Decimal("5032485723458348569331745334343463469121445345.43");chai_1.assert.strictEqual(Math.round(s),5032485723458349e30);const i=Math.round(1);chai_1.assert.strictEqual(typeof i,"number"),assertStrictEqual(i,1)}),it("floor",function(){chai_1.assert.strictEqual(typeof Math.floor(.9),"number"),chai_1.assert.strictEqual(typeof Math.floor(0),"number"),chai_1.assert.strictEqual(Math.floor(.9),0),chai_1.assert.strictEqual(Math.floor(.1),0),chai_1.assert.strictEqual(Math.floor(1.9),1),chai_1.assert.strictEqual(Math.floor(1.1),1);const a=new xtrem_decimal_1.Decimal("5032485723458348569331745334343463469121445345.43");chai_1.assert.strictEqual(Math.floor(a),5032485723458349e30)}),it("ceil",function(){chai_1.assert.strictEqual(typeof Math.ceil(0),"number"),chai_1.assert.strictEqual(typeof Math.ceil(.9),"number"),chai_1.assert.strictEqual(Math.ceil(.9),1),chai_1.assert.strictEqual(Math.ceil(.1),1),chai_1.assert.strictEqual(Math.ceil(1.9),2),chai_1.assert.strictEqual(Math.ceil(1.1),2);const a=new xtrem_decimal_1.Decimal("5032485723458348569331745334343463469121445345.43");chai_1.assert.strictEqual(Math.ceil(a),5032485723458349e30)}),it("abs",function(){chai_1.assert.isTrue(xtrem_decimal_1.Decimal.isDecimal(Math.abs(-.9))),chai_1.assert.strictEqual(typeof Math.abs(-1),"number"),chai_1.assert.strictEqual(Math.abs(-.9),.9);const a=new xtrem_decimal_1.Decimal("-5032485723458348569331745334343463469121445345.43"),t=new xtrem_decimal_1.Decimal("5032485723458348569331745334343463469121445345.43");chai_1.assert.strictEqual(Math.abs(a),t);const s=Math.abs(-1);chai_1.assert.strictEqual(typeof s,"number"),assertStrictEqual(s,1)}),it("pow",function(){chai_1.assert.isTrue(xtrem_decimal_1.Decimal.isDecimal(Math.pow(2.01,2))),chai_1.assert.strictEqual(typeof Math.pow(2,2),"number"),chai_1.assert.strictEqual(Math.pow(2,2),4),chai_1.assert.strictEqual(Math.pow(2.01,2),4.0401);const a=new xtrem_decimal_1.Decimal("5.0324857234583485693e+45"),t=new xtrem_decimal_1.Decimal("2.5325912556812097992e+91"),s=Math.pow(a,2);chai_1.assert.strictEqual(s,t)})});
//# sourceMappingURL=decimal-tests.js.map