// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/index.d.ts
declare module '@sage/xtrem-cli-dev/index' {
	export * from '@sage/xtrem-cli-dev/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/index' {
	/// <reference types="@sage/xtrem-cli-lib" />
	import { Argv } from 'yargs';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/index';
	export const plugin: (yargs: Argv) => Argv;
	export const builder: {
	    start: (yargs: Argv) => Argv;
	};
	export const handler: {
	    start: (argv: any, commandContext?: any) => Promise<import("@sage/xtrem-cli-lib").PluggableHandlerResult>;
	};
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/extensions/start/watch-server.d.ts
declare module '@sage/xtrem-cli-dev/lib/extensions/start/watch-server' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	import { Observable, Observer } from 'rxjs';
	import { TypescriptObserverInput } from '@sage/xtrem-cli-dev/lib/commands/utils/index';
	export const startWatchServer: (executionMode: ExecutionMode, dir: string, isUsingReferences: boolean) => Observable<boolean>;
	export const typescriptObserver: (observerInput: TypescriptObserverInput) => Observer<boolean>;
	//# sourceMappingURL=watch-server.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/extensions/start/watch-client.d.ts
declare module '@sage/xtrem-cli-dev/lib/extensions/start/watch-client' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	import { Observer } from 'rxjs';
	import { TypescriptObserverInput, WebpackResult } from '@sage/xtrem-cli-dev/lib/commands/utils/index';
	export const watchClientArtifacts: (executionMode: ExecutionMode, buildDir: string) => import("rxjs").Observable<WebpackResult> | undefined;
	export const printCompilerErrorMessage: (executionMode: ExecutionMode, error: {
	    message: string;
	    chunkName?: string;
	    chunkEntry?: boolean;
	    chunkInitial?: boolean;
	    file?: string;
	    moduleIdentifier?: string;
	    moduleName?: string;
	    loc?: string;
	    chunkId?: string | number;
	    moduleId?: string | number;
	    moduleTrace?: any;
	    details?: any;
	    stack?: any;
	}) => void;
	export const webpackObserver: ({ executionMode, deployedApp, dir, }: TypescriptObserverInput) => Observer<WebpackResult>;
	//# sourceMappingURL=watch-client.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/extensions/start/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/extensions/start/index' {
	export * from '@sage/xtrem-cli-dev/lib/extensions/start/handler';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/extensions/start/handler.d.ts
declare module '@sage/xtrem-cli-dev/lib/extensions/start/handler' {
	import { PluggableHandlerResult } from '@sage/xtrem-cli-lib';
	import { StartContext, StartOptions } from '@sage/xtrem-cli-main';
	export interface StartDevOptions extends StartOptions {
	    watchAll?: boolean;
	    watchServer?: boolean;
	    watchClient?: boolean;
	    socketKey?: string;
	}
	export const startHandler: (options: StartDevOptions, startContext: StartContext) => Promise<PluggableHandlerResult>;
	//# sourceMappingURL=handler.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/test.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/test' {
	import { Argv } from 'yargs';
	export const command: string[];
	export const desc = "Executes tests";
	export const builder: (yargs: Argv) => Argv<{}>;
	export const handler: (argv: object) => Promise<any>;
	//# sourceMappingURL=test.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/lint.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/lint' {
	import { Argv } from 'yargs';
	import { LintOptions } from '@sage/xtrem-cli-dev/lib/commands/utils/index';
	export const command: string[];
	export const desc = "Lints the source-code with ts-lint and prettier";
	export const builder: (yargs: Argv) => Argv<{}>;
	export const handler: (argv: LintOptions) => Promise<void>;
	//# sourceMappingURL=lint.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/init.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/init' {
	import { Argv } from 'yargs';
	export const command: string[];
	export const desc = "Creates an empty xtrem package. It prompts for installation details";
	export const builder: (yargs: Argv) => Argv<{}>;
	export const handler: () => any;
	//# sourceMappingURL=init.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/compile.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/compile' {
	import { Argv } from 'yargs';
	export const command: string[];
	export const desc = "Creates a ready-to-use Xtrem package";
	export const builder: (yargs: Argv) => Argv<{
	    "skip-client": unknown;
	} & {
	    "skip-cop": unknown;
	} & {
	    "skip-server": unknown;
	} & {
	    "skip-dts": unknown;
	} & {
	    "skip-api-client": unknown;
	} & {
	    "only-api-client": boolean | undefined;
	} & {
	    "only-changed": boolean | undefined;
	} & {
	    "skip-table-schema": unknown;
	} & {
	    "skip-clean": unknown;
	} & {
	    force: unknown;
	} & {
	    references: boolean | undefined;
	} & {
	    binary: boolean | undefined;
	} & {
	    instrumented: boolean | undefined;
	} & {
	    prod: boolean | undefined;
	} & {
	    fast: unknown;
	}>;
	export const handler: (argv: any) => Promise<void>;
	//# sourceMappingURL=compile.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/compile-plugin.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/compile-plugin' {
	import { Argv } from 'yargs';
	export const command: string[];
	export const desc = "Compiles an Xtrem UI Plugin";
	export const builder: (yargs: Argv) => Argv<{}>;
	export const handler: () => void;
	//# sourceMappingURL=compile-plugin.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/xtrem-client-plugin.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/xtrem-client-plugin' {
	export {};
	//# sourceMappingURL=xtrem-client-plugin.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/workflow-tests-entry-point.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/workflow-tests-entry-point' {
	import { Dict, TestOptions, WorkflowMockOptions, WorkflowResult, WorkflowStartEvent } from '@sage/xtrem-core';
	type ExecutionModeType = 'only' | 'skip' | 'normal';
	export interface ScenarioOptions {
	    executionMode?: ExecutionModeType;
	    envConfigs?: TestOptions;
	    mocks?: WorkflowMockOptions[];
	}
	export interface Scenario extends ScenarioOptions {
	    name: string;
	    startEvent: WorkflowStartEvent;
	    expectedResult: WorkflowResult;
	}
	export interface Suite extends ScenarioOptions {
	    scenarios: Dict<Scenario>;
	}
	export function validateScenario(file: string, scenario: Scenario): void;
	/** Runs a test scenario */
	export function runScenario({ file, scenario, scenarioOptions, }: {
	    file: string;
	    scenario: Scenario;
	    scenarioOptions: ScenarioOptions;
	}): Promise<void>;
	export {};
	//# sourceMappingURL=workflow-tests-entry-point.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/unit-tests-entry-point.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/unit-tests-entry-point' {
	export {};
	//# sourceMappingURL=unit-tests-entry-point.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/transformers.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/transformers' {
	export {};
	//# sourceMappingURL=transformers.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/service.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/service' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	import { StartServicesOptions } from '@sage/xtrem-cli-main';
	import { Application } from '@sage/xtrem-core';
	export interface StartServerInput {
	    dir: string;
	    startScriptSource: string;
	    startScriptTarget: string;
	    debugging: boolean;
	    detached: boolean;
	}
	export interface TypescriptObserverInput extends StartServicesOptions {
	    dir: string;
	    deployedApp: {
	        app: Application | null;
	    };
	    executionMode: ExecutionMode;
	    autoReload: boolean;
	}
	export const unloadApplication: (dir: string, application: Application) => Promise<void>;
	export const reloadApplication: (deployedApp: {
	    app: Application | null;
	}, dir: string, options: StartServicesOptions, reload?: boolean) => Promise<void>;
	//# sourceMappingURL=service.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/server-compilation.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/server-compilation' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	import * as ts from 'typescript';
	export const getTsProgram: (dir: string, options?: {
	    configFileName?: string;
	    excludeOverride?: string[];
	    includeOverride?: string[];
	    tsconfigOverride?: Partial<ts.CompilerOptions>;
	}) => ts.Program;
	export const getFiles: (dir: string, options?: {
	    configFileName?: string;
	    excludeOverride?: string[];
	    includeOverride?: string[];
	}) => any;
	export const getCompilerOptions: (dir: string, configFileNme?: string, tsconfigOverride?: Partial<ts.CompilerOptions>) => ts.CompilerOptions;
	export const printCompilerError: (executionMode: ExecutionMode) => (diagnostic: ts.Diagnostic) => void;
	//# sourceMappingURL=server-compilation.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/page-metadata-transformer.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/page-metadata-transformer' {
	import { AccessBinding } from '@sage/xtrem-core';
	import { Maybe } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	interface ComponentAttributes extends AccessBinding {
	    access?: AccessBinding;
	    extensionAccess?: AccessBinding;
	    isTransient?: boolean;
	    valueField?: string;
	    tunnelPage?: string;
	    fragment?: string;
	    helperTextField?: string;
	}
	type LiteralValueType = string | number | boolean;
	export abstract class PageMetadataBuilder {
	    /**
	     * Determines whether the given file is a source file
	     * @param file the TS file to be checked
	     * @returns true if file is a source file
	     */
	    static isSourceFile(file: ts.SourceFile): boolean;
	    /**
	     * Retrieve a value from an typescript object literal
	     * @param root
	     * @param objectLiteralExp
	     * @param key
	     * @returns
	     */
	    static getValueFromObjectLiteralByKey: <T extends LiteralValueType>(root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => T | undefined;
	    /**
	     *
	     * @param root
	     * @param objectLiteralExp
	     * @param key
	     * @returns
	     */
	    static getStringValueFromObjectLiteralByKey: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => Maybe<string>;
	    /**
	     *
	     * @param root
	     * @param objectLiteralExp
	     * @param key
	     * @returns
	     */
	    static getBooleanValueFromObjectLiteralByKey: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => Maybe<boolean>;
	    /**
	     *
	     * @param root
	     * @param objectLiteralExp
	     * @param key
	     * @returns
	     */
	    static getNumberValueFromObjectLiteralByKey: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => Maybe<number>;
	    /**
	     * Get the text of a source file element
	     * @param root
	     * @param element
	     * @returns
	     */
	    static getTsNodeText: (root: ts.SourceFile, element: ts.Node) => string;
	    static getLineAndCharacterOfTsNode(root: ts.SourceFile, element: ts.Node): ts.LineAndCharacter;
	    static getLocation(root: ts.SourceFile, element: ts.Node): string;
	    /**
	     * get
	     * @param root
	     * @param objectLiteralExp
	     * @param defaultNodeName
	     * @returns
	     */
	    static getAccessBindingFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, defaultNodeName?: string) => Maybe<AccessBinding>;
	    static getComponentAttributes: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, extendedNode?: string) => ComponentAttributes;
	    static resolvedBinding: (component: ComponentAttributes, nodeName?: string, pageNode?: string) => AccessBinding;
	    static getAuthorizationCodeFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getCategoryFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getGroupFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getDescriptionFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getListIconFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getExtendsFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getPriorityFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => number | undefined;
	    static resolveMenuItem: (root: ts.SourceFile, packageRoot: string, buildDir: string, importPath: string, importedVariable: string) => any;
	    /**
	     * Typescript visitor
	     * @param ctx the transformation context
	     */
	    static visitor: (root: ts.SourceFile, pageNode: string, pageAttributes: ComponentAttributes, nodeName: string | undefined, plugins: string[], fragments: string[], nodes: string[], ctx: ts.TransformationContext) => ((node: ts.Node) => ts.Node);
	}
	/**
	 * This transformer is meant to be run AFTER the 'decorator-transformer' for pages/stickers &
	 * for every source file of an xtrem package
	 * @param ctx the transformation context
	 * @returns the transformed file
	 */
	export function pageMetadataTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	export {};
	//# sourceMappingURL=page-metadata-transformer.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/options.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/options' {
	export interface TestOptions {
	    unit: boolean;
	    integration: boolean;
	    graphql: boolean;
	    workflow: boolean;
	    ci: boolean;
	    browser: boolean;
	    serviceOptions?: string;
	    pattern?: string;
	    skipServerCompile?: boolean;
	}
	export interface LintOptions {
	    fix: boolean;
	    path: string;
	}
	//# sourceMappingURL=options.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/mocha.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/mocha' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export let mochaErrors: {
	    [key: string]: string[];
	};
	export const setupTestSuite: () => Promise<void>;
	export const createMochaRunner: (executionMode: ExecutionMode, dir: string, isCi: boolean) => any;
	//# sourceMappingURL=mocha.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/mocha-reporter.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/mocha-reporter' {
	import * as Mocha from 'mocha';
	/**
	 * Constructs a new `Spec` reporter instance.
	 *
	 * @public
	 * @class
	 * @memberof Mocha.reporters
	 * @extends Mocha.reporters.Base
	 * @param {Runner} runner - Instance triggers reporter actions.
	 * @param {Object} [options] - runner options
	 */
	export function MochaTestReporter(this: any, runner: Mocha.Runner): void;
	//# sourceMappingURL=mocha-reporter.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/index' {
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/application';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/client-compilation';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/config';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/decimal-transformer';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/mocha';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/notification-listener-routing/index';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/page-metadata-transformer';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/server-compilation';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/service';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/options';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/xtrem-client-plugin';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/graphql-tests-entry-point.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/graphql-tests-entry-point' {
	import { AnyValue, Dict, TestOptions } from '@sage/xtrem-core';
	import { GraphQLSchema } from 'graphql';
	type ExecutionModeType = 'only' | 'skip' | 'normal';
	interface Parameters {
	    [key: string]: {
	        input?: object;
	        output: object;
	        variables?: Dict<AnyValue>;
	        envConfigs?: TestOptions;
	        layers: string[];
	        mocks?: string[];
	        executionMode?: ExecutionModeType;
	    };
	}
	interface TestScenarioInput {
	    parameters: Parameters;
	    scenario: string;
	    requestHbs: string;
	    schema: GraphQLSchema;
	    responseHbs: string;
	    directory: string;
	}
	/**
	 * Runs a test scenario, i.e. any key defined in 'parameters.json'.
	 *
	 * @export
	 * @param {TestScenarioInput} {
	 *     parameters,
	 *     scenario,
	 *     applicationDir,
	 *     requestHbs,
	 *     schema,
	 *     responseHbs,
	 *     directory,
	 * }
	 */
	export function runScenario({ parameters, scenario, requestHbs, schema, responseHbs, directory, }: TestScenarioInput): Promise<void>;
	export {};
	//# sourceMappingURL=graphql-tests-entry-point.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/file.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/file' {
	export const getResourcesDir: () => string;
	//# sourceMappingURL=file.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/decimal-transformer.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/decimal-transformer' {
	import * as ts from 'typescript';
	export function decimalTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	export default decimalTransformer;
	//# sourceMappingURL=decimal-transformer.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/config.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/config' {
	export const targetUrlOrigin: string | undefined;
	export const targetBaseUrl: string | undefined;
	export const isLocalTargetUrl: () => boolean;
	export const isRemoteTargetUrl: () => boolean | "" | undefined;
	//# sourceMappingURL=config.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/client-compilation.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/client-compilation' {
	import { ExecutionMode, PackagingMode } from '@sage/xtrem-cli-lib';
	import { Observable } from 'rxjs';
	import * as webpack from 'webpack';
	export const compileClientAndSharedFunctions: (executionMode: ExecutionMode, dir: string) => void;
	export const checkTypesOnClientArtifactsAndBuildDeclarations: (executionMode: ExecutionMode, dir: string) => void;
	export const filterExternals: ({ request }: any) => Promise<string | void>;
	export const isCompilable: (filePath: string) => boolean;
	export const getWebpackEntry: (executionMode: ExecutionMode, dir: string, isOnlyChanged: boolean) => (() => webpack.Entry);
	interface CompileInput {
	    executionMode: ExecutionMode;
	    buildDir: string;
	    isProd: boolean;
	    isInstrumented: boolean;
	    isFast?: boolean;
	    isWatch?: boolean;
	    isOnlyChanged?: boolean;
	}
	export const compilePagesAndStickers: ({ executionMode, buildDir, isProd, isInstrumented, isWatch, isOnlyChanged, }: CompileInput) => Observable<WebpackResult>;
	interface WebpackInput {
	    buildDir: string;
	    entry: () => webpack.Entry;
	    output: webpack.Configuration['output'];
	    packagingMode?: PackagingMode;
	    isInstrumented: boolean;
	    options?: webpack.Configuration;
	}
	export const compileFiles: ({ buildDir, entry, output, packagingMode, isInstrumented, options, }: WebpackInput) => Observable<WebpackResult>;
	export type WebpackResult = {
	    stats: webpack.Stats | undefined | null;
	    error: Error | undefined | null;
	};
	export {};
	//# sourceMappingURL=client-compilation.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/application.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/application' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	import { Application } from '@sage/xtrem-core';
	export { activatesContainerHeartbeatMonitor } from '@sage/xtrem-cli-lib';
	export function loadTestDatabase(executionMode: ExecutionMode, application: Application, source: string, options?: {
	    layersAsString?: string;
	    serviceOptionsAsString?: string;
	    /**
	     * Should the schema be reset before loading data ?
	     */
	    noSchemaReset?: boolean;
	}): Promise<void>;
	//# sourceMappingURL=application.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/notification-listener-routing/routing.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/notification-listener-routing/routing' {
	import { Application, Dict } from '@sage/xtrem-core';
	export interface Route {
	    queue: string;
	    topic: string;
	    sourceFileName: string;
	}
	export interface Routing {
	    [packageName: string]: Route[];
	}
	export function mergeRoutings(routing1: Routing, routing2: Routing): Routing;
	export function sortRoutesByTopic(routing: Routing): Routing;
	export function getRoutingData(routingFile: string): any;
	export function getRoutingFilePath(packageDir: string): string;
	export interface QueueConfig {
	    deadLetterQueue?: {
	        name: string;
	        maxReceiveCount: number;
	    };
	    defaultVisibilityTimeout: string;
	    delay: string;
	    fifo?: string;
	    receiveMessageWait: string;
	}
	/**
	 * Retrieves all ElasticMQ configurations based on the provided application and routing.
	 * Optionally, a test package name can be specified to generate unit test queues.
	 *
	 * @param application - The application object.
	 * @param routing - The routing object.
	 * @param testPackageName - The name of the optional test package.
	 * @returns A dictionary of queue configurations.
	 */
	export function getAllElasticMqConfigs(application: Application, routing: Routing, testPackageName?: string, additionalQueues?: Dict<QueueConfig>): Dict<QueueConfig>;
	/**
	 * Updates the ElasticMQ configuration with the provided queues.
	 *
	 * @param {string} path - The path of the ElasticMq configuration file.
	 * @param {Dict<QueueConfig>} queues - The queues to be added or updated in the configuration.
	 * @returns {void}
	 */
	export function updateElasticMqConfigFile(path: string, queues: Dict<QueueConfig>): void;
	export const requiredQueues: Dict<QueueConfig>;
	export const defaultElasticMq: {
	    queues: {
	        [x: string]: QueueConfig;
	    };
	};
	//# sourceMappingURL=routing.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/notification-listener-routing/routing-builder.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/notification-listener-routing/routing-builder' {
	import { PackageJsonFile } from '@sage/xtrem-core';
	import * as ts from 'typescript';
	import { Routing } from '@sage/xtrem-cli-dev/lib/commands/utils/notification-listener-routing/routing';
	export interface Listener {
	    fileName: string;
	    packageName: string;
	    queue: string;
	    topic: string;
	}
	export class RoutingBuilder {
	    private readonly rootDir;
	    readonly routingFilename: string;
	    readonly packageJson: PackageJsonFile;
	    private readonly mutationNames;
	    constructor(rootDir: string | undefined);
	    get packageName(): string;
	    get queue(): string;
	    get routing(): Routing;
	    get filename(): string;
	    get filePath(): string;
	    setVisitingFile(filePath: string): void;
	    get nodeQueueName(): string | undefined;
	    set nodeQueueName(queueName: string | undefined);
	    get node(): ts.Decorator | undefined;
	    setVisitingNodeDecorator(node: ts.Decorator | undefined): void;
	    private static readRoutingData;
	    private getPackageQueueName;
	    private getPackageJson;
	    private static getPackageRootDir;
	    createListener(node: ts.CallExpression): Listener;
	    createAsyncMutationListener(node: ts.CallExpression): Listener;
	    createAsyncMutationListenerObject(classDeclaration: ts.ClassDeclaration, name: string, 
	    /**
	     * Override of the default queue name (by default, the queue name is based on the package name)
	     */
	    queueNameOverride?: string): Listener;
	    private static getQueue;
	    private static getTopic;
	    updateRouting(listener: Listener): void;
	    private static isRouteInList;
	    writeRoutingData(): void;
	    private static getAsyncMutationClassName;
	    /**
	     * Retrieve (if defined) the 'queue' parameter set in the decorator of the asyncMutation
	     */
	    private static getAsyncMutationQueueName;
	    createListeners(): void;
	    createStandardBulkMutationListener(name: string): Listener;
	    createAsyncExportMutationListener(): Listener | undefined;
	}
	//# sourceMappingURL=routing-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/notification-listener-routing/notification-listener-transformer.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/notification-listener-routing/notification-listener-transformer' {
	import * as ts from 'typescript';
	const notificationListenerTransformer: ts.TransformerFactory<ts.SourceFile>;
	export function isNodeLikeArtifactFile(file: ts.SourceFile): boolean;
	export { notificationListenerTransformer };
	//# sourceMappingURL=notification-listener-transformer.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/notification-listener-routing/logger.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/notification-listener-routing/logger' {
	function printInfoMessage(message: string): void;
	function printErrorMessage(message: string): void;
	export { printInfoMessage as info };
	export { printErrorMessage as error };
	//# sourceMappingURL=logger.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/utils/notification-listener-routing/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/notification-listener-routing/index' {
	export { notificationListenerTransformer } from '@sage/xtrem-cli-dev/lib/commands/utils/notification-listener-routing/notification-listener-transformer';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/notification-listener-routing/routing';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/test/xtrem-interface.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/test/xtrem-interface' {
	export {};
	//# sourceMappingURL=xtrem-interface.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/test/workflow-tests.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/test/workflow-tests' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	/**
	 * Execute Workflow unit tests
	 *
	 * @param executionMode STANDALONE or INTEGRATED
	 * @param dir the em-core package directory
	 * @param isCi wether tests are meant to be executed in ci mode or not
	 * @param pattern a string that matches a single folder under <em-core-package>/test/workflow
	 *              and temporary <em-core-package>/test/fixtures/workflow
	 */
	export const executeWorkflowTests: (executionMode: ExecutionMode, dir: string, isCi: boolean, pattern?: string) => Promise<void>;
	//# sourceMappingURL=workflow-tests.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/test/unit-tests.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/test/unit-tests' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const resolvePackageBin: (packageName: string) => string;
	/**
	 * Execute Mocha unit tests
	 *
	 * TODO:
	 * - Code instrumentation and coverage collection (Probably with an `after` transformer)
	 *
	 * @param executionMode
	 * @param dir
	 * @param isCi
	 * @param pattern
	 */
	export const executeUnitTest: (executionMode: ExecutionMode, dir: string, isCi: boolean, pattern?: string) => Promise<void>;
	//# sourceMappingURL=unit-tests.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/test/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/test/index' {
	import { TestOptions } from '@sage/xtrem-cli-dev/lib/commands/utils/index';
	export { executeGraphqlTests } from '@sage/xtrem-cli-dev/lib/commands/handlers/test/graphql-tests';
	export const test: (options: TestOptions) => Promise<void>;
	export const getHelp: () => string;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/test/graphql-tests.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/test/graphql-tests' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	/**
	 * Execute Graphql unit tests
	 *
	 * @param executionMode STANDALONE or INTEGRATED
	 * @param dir the em-core package directory
	 * @param isCi wether tests are meant to be executed in ci mode or not
	 * @param pattern a string that matches a single folder under <em-core-package>/test/graphql
	 *              and temporary <em-core-package>/test/fixtures/graphql
	 */
	export const executeGraphqlTests: (executionMode: ExecutionMode, dir: string, isCi: boolean, pattern?: string) => Promise<void>;
	//# sourceMappingURL=graphql-tests.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/lint/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/lint/index' {
	export const lint: (fix?: boolean, providedPath?: string) => Promise<void>;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/init/search-packages.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/init/search-packages' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export interface PackageInfo {
	    name: string;
	    description: string;
	    maintainers: string;
	    version: string;
	    date: string;
	}
	export const searchX3Dependencies: (executionMode: ExecutionMode) => Promise<any[]>;
	export const getLatestVersion: (packageName: string) => Promise<string>;
	//# sourceMappingURL=search-packages.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/init/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/init/index' {
	import { bootstrapPackage } from '@sage/xtrem-cli-dev/lib/commands/handlers/init/bootstrap-package';
	import { PackageInfo, searchX3Dependencies } from '@sage/xtrem-cli-dev/lib/commands/handlers/init/search-packages';
	export { bootstrapPackage, searchX3Dependencies, PackageInfo };
	export const init: () => void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/init/bootstrap-package.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/init/bootstrap-package' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export interface DependencyWithVersion {
	    name: string;
	    version: string;
	}
	export const bootstrapPackage: (executionMode: ExecutionMode, dir: string, vendorName: string, name: string, dependencies: DependencyWithVersion[]) => Promise<void>;
	//# sourceMappingURL=bootstrap-package.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/compile-plugin/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/compile-plugin/index' {
	export const compilePlugin: () => void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/compile/instrumenter.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/compile/instrumenter' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const instrumentCode: (executionMode: ExecutionMode, dir: string) => void;
	//# sourceMappingURL=instrumenter.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/compile/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/compile/index' {
	export interface CompileOptions {
	    skipClient: boolean;
	    skipCop: boolean;
	    skipServer: boolean;
	    skipClean: boolean;
	    skipDts: boolean;
	    skipApiClient: boolean;
	    force: boolean;
	    isInstrumented: boolean;
	    isBinary: boolean;
	    isProd: boolean;
	    isUsingReferences: boolean;
	    isOnlyApi: boolean;
	    isOnlyChanged: boolean;
	}
	export function compile(options: CompileOptions): Promise<void>;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/compile/dts-generator.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/compile/dts-generator' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const generateSingleDefinition: (executionMode: ExecutionMode, dir: string) => void;
	//# sourceMappingURL=dts-generator.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/compile/copy-dictionaries.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/compile/copy-dictionaries' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const copyDictionaries: (executionMode: ExecutionMode, dir: string) => void;
	//# sourceMappingURL=copy-dictionaries.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/compile/compile-ui.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/compile/compile-ui' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const compileUi: (executionMode: ExecutionMode, buildDir: string, isProd: boolean, isInstrumented: boolean, isOnlyChanged: boolean) => Promise<void>;
	//# sourceMappingURL=compile-ui.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/compile/compile-server.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/compile/compile-server' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export interface CompileServerOptions {
	    isUsingReferences?: boolean;
	    doNotGenerateRoutingFile?: boolean;
	}
	export const compileServer: (executionMode: ExecutionMode, dir: string, options?: CompileServerOptions) => void;
	//# sourceMappingURL=compile-server.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/compile/clean.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/compile/clean' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const clean: (executionMode: ExecutionMode, dir: string, options?: {
	    force: boolean;
	}) => void;
	//# sourceMappingURL=clean.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-dev/build/lib/commands/handlers/compile/binary.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/compile/binary' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const binaryEncoding: (executionMode: ExecutionMode, dir: string) => Promise<void>;
	//# sourceMappingURL=binary.d.ts.map
}
declare module '@sage/xtrem-cli-dev' {
	export * from '@sage/xtrem-cli-dev/index';
}
