/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.XtremClientPlugin=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),fs=require("fs"),glob=require("glob"),lodash_1=require("lodash"),path=require("path"),ts=require("typescript"),webpack=require("webpack"),globParent=require("glob-parent"),propertyNameRegex=/\.([A-Za-z]*)(<[\s\S]*>)?$/,artifactFolders=[xtrem_cli_lib_1.ArtifactTypes.Pages,xtrem_cli_lib_1.ArtifactTypes.Stickers,xtrem_cli_lib_1.ArtifactTypes.PageExtensions,xtrem_cli_lib_1.ArtifactTypes.PageFragments],directories=[];class XtremClientPlugin{constructor(e,t=xtrem_cli_lib_1.ExecutionMode.STANDALONE){this.appDir=e,this.executionMode=t}static getEntries(e,t,r,i,s){return()=>{if("string"!=typeof r&&!Array.isArray(r))throw new TypeError("globOptions must be a string or an array of strings");if(i&&"object"!=typeof i)throw new TypeError("globOptions must be an object");if(!Array.isArray(r))r=[r];let a={};if(r.forEach(e=>{const r=globParent(e);if(-1===directories.indexOf(r))directories.push(r);const n=XtremClientPlugin.getFiles(t,e,i,s);a={...n,...a}}),s)(0,xtrem_cli_lib_1.printInfo)(e,`Building the following files:\n${Object.keys(a).join("\n")}`);return a}}static getFiles(e,t,r,i){const s={},a=globParent(t);return glob.sync(t,r).filter(t=>{if(!i)return true;const r=(0,xtrem_cli_lib_1.getMetadataFilePathForClientFile)(e,t.toString());if(!fs.existsSync(r))return true;return(0,xtrem_cli_lib_1.hashFile)(t.toString())!==JSON.parse(fs.readFileSync(r,"utf-8")).md5}).forEach(e=>{const t=path.relative(a,e.toString()),r=path.basename(t.replace(path.extname(e.toString()),"").split(path.sep).join("/")),i=path.basename(a);s[`${i}/${r}`]=e.toString()}),s}apply(e){e.hooks.afterCompile.tapAsync(this.constructor.name,this.afterCompile.bind(this)),e.hooks.watchRun.tapAsync(`${this.constructor.name}watchRun`,this.afterChangesDetected.bind(this))}afterChangesDetected(e,t){(0,xtrem_cli_lib_1.printInfo)(this.executionMode,"Client changes detected!"),(0,xtrem_cli_lib_1.broadcastMessage)(xtrem_cli_lib_1.EventType.COMPILER_STARTED,"client"),t()}afterCompile(e,t){try{directories.forEach(t=>e.contextDependencies.add(t)),e.fileDependencies.forEach(t=>{if(!t.includes("package.json")){this.checkUiArtifacts(t).forEach(t=>{e.errors.push(new webpack.WebpackError(t))})}})}catch(t){e.errors.push(t)}finally{t()}}getArtifactsFolderName(e){let t;const r=fs.realpathSync(e),i=artifactFolders.filter(e=>fs.existsSync(path.resolve(this.appDir,`lib/${e}`))).map(e=>({folderName:e,folderPath:fs.realpathSync(path.resolve(this.appDir,`lib/${e}`))})).find(e=>r.startsWith(e.folderPath));if(i)t=i.folderName;return t}checkUiArtifacts(e){if(this.getArtifactsFolderName(e)&&"index.ts"!==path.basename(e)&&fs.lstatSync(e).isFile()){const t=fs.readFileSync(e,"utf-8"),r=ts.createSourceFile(path.basename(e),t,ts.ScriptTarget.ES2020),i=r.statements.filter(ts.isClassDeclaration).find(e=>Boolean(e&&e.heritageClauses&&e.heritageClauses.length>0));if(i)return XtremClientPlugin.checkDecoratorsAndTypes(e,r,i)}return[]}static checkDecoratorsAndTypes(e,t,r){const i=[],s=r.name;if(s&&path.basename(e).replace(".ts","")!==(0,lodash_1.kebabCase)(r.name.getText(t)))i.push(`Xtrem Page error: in '${e}' the class name must be the same as the filename with camel case naming conventions. Class name found: ${s.getText(t)}.`);const a=(ts.getDecorators(r)||[]).some(e=>{if(ts.isCallExpression(e.expression)){return e.expression.expression.getText(t).includes("pageFragment")}return false});return r.members.filter(ts.isPropertyDeclaration).forEach(r=>{const s=ts.getDecorators(r)?.[0];if(s&&ts.isCallExpression(s.expression)){const n=s.expression.expression.getText(t),o=r.type?`:${t.getLineAndCharacterOfPosition(r.type.pos).line+1}`:"",c=r.name.getText(t),l=n.replace("Field","").replace("extension","").replace("Extension","").replace("Override","").replace("override","").match(propertyNameRegex)[1].toLowerCase(),p=r.type.getText(t);if(l!==p.replace("Field","").match(propertyNameRegex)[1].toLowerCase())i.push(`Xtrem Page error: in '${e}${o}' the "${c}" property is misconfigured because the decorator type "${n}" doesn't match the "${p}" property type.`);if(a&&n&&!n.toLowerCase().includes("field"))i.push(`Xtrem Page error: in '${e}${o}' the "${c}" property is decorated but is not a field in a page fragment.`)}}),i}}exports.XtremClientPlugin=XtremClientPlugin;
//# sourceMappingURL=xtrem-client-plugin.js.map