import { Dict, TestOptions, WorkflowMockOptions, WorkflowResult, WorkflowStartEvent } from '@sage/xtrem-core';
type ExecutionModeType = 'only' | 'skip' | 'normal';
export interface ScenarioOptions {
    executionMode?: ExecutionModeType;
    envConfigs?: TestOptions;
    mocks?: WorkflowMockOptions[];
}
export interface Scenario extends ScenarioOptions {
    name: string;
    startEvent: WorkflowStartEvent;
    expectedResult: WorkflowResult;
}
export interface Suite extends ScenarioOptions {
    scenarios: Dict<Scenario>;
}
export declare function validateScenario(file: string, scenario: Scenario): void;
/** Runs a test scenario */
export declare function runScenario({ file, scenario, scenarioOptions, }: {
    file: string;
    scenario: Scenario;
    scenarioOptions: ScenarioOptions;
}): Promise<void>;
export {};
//# sourceMappingURL=workflow-tests-entry-point.d.ts.map